/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eoapplication.EOComponentController;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODisplayUtilities;
import com.webobjects.eoapplication.EODocumentController;
import com.webobjects.eoapplication.EOObjectDisplay;
import com.webobjects.eoapplication.EOObjectDisplayDocument;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOXMLUnarchiver;
import com.webobjects.eoapplication._EODebugUtilities;
import com.webobjects.eoapplication._EOValueConversion;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eogeneration._EOExtendedValueConversion;
import com.webobjects.eogeneration._EOKeyPathUtility;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSUtilities;

public class EOControllerFactory
implements NSDisposable,
EOController._DisposeCallback {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory");
    public static final String QuestionSpecification = "question";
    public static final String TaskSpecification = "task";
    public static final String EntitySpecification = "entity";
    public static final String LocalesSpecification = "locales";
    public static final String PlatformsSpecification = "platforms";
    public static final String _AssistantActionsQuestion = "assistantActions";
    public static final String UserInterfaceParametersQuestion = "userInterfaceParameters";
    public static final String ActionsQuestion = "actions";
    public static final String PropertyKeysQuestion = "propertyKeys";
    public static final String AvailableSpecificationsQuestion = "availableSpecifications";
    public static final String DefaultSpecificationsQuestion = "defaultSpecifications";
    public static final String ControllerQuestion = "controller";
    public static final String TopLevelWindowQuestion = "window";
    public static final String TopLevelModalDialogQuestion = "modalDialog";
    public static final String IdentifyTask = "identify";
    public static final String QueryTask = "query";
    public static final String ListTask = "list";
    public static final String FormTask = "form";
    public static final String SelectTask = "select";
    public static final String EditorTask = "editor";
    public static final String _SpecificationKey = "specification";
    public static final int NeverReuseController = 0;
    public static final int ReuseControllerIfNotEdited = 1;
    public static final int ReuseControllerAfterSave = 2;
    public static final int ReuseControllerIfInvisible = 3;
    public static final int AlwaysReuseController = 4;
    public static final String ReuseModeParameter = "reuseMode";
    public static final String CacheSizeParameter = "cacheSize";
    private static final String controllerFactoryWillEvaluateRules = "controllerFactoryWillEvaluateRules";
    private static final String controllerFactoryWillUseActions = "controllerFactoryWillUseActions";
    private static final String controllerFactoryShouldActivateDefaultControllers = "controllerFactoryShouldActivateDefaultControllers";
    private static final String controllerFactoryShouldCacheController = "controllerFactoryShouldCacheController";
    private static final String controllerFactoryWillReuseControllersForSpecificationWithMode = "controllerFactoryWillReuseControllersForSpecificationWithMode";
    private static final String controllerFactoryWillReturnPropertyKeysForEntityAndTaskName = "controllerFactoryWillReturnPropertyKeysForEntityAndTaskName";
    private static final String controllerFactoryWillReturnControllerForSpecification = "controllerFactoryWillReturnControllerForSpecification";
    private static final String controllerFactoryWillUseSpecificationForController = "controllerFactoryWillUseSpecificationForController";
    private static final String controllerFactoryWillUseSpecificationForWindowController = "controllerFactoryWillUseSpecificationForWindowController";
    private static final String controllerFactoryWillUseSpecificationForModalDialogController = "controllerFactoryWillUseSpecificationForModalDialogController";
    private static final String controllerFactoryWillUseSpecificationForModalDialogWithSelectController = "controllerFactoryWillUseSpecificationForModalDialogWithSelectController";
    private static final String controllerFactoryWillUseSpecificationForModalDialogWithSelectByInsertingController = "controllerFactoryWillUseSpecificationForModalDialogWithSelectByInsertingController";
    private static final String controllerFactoryWillUseSpecificationForWindowWithQueryController = "controllerFactoryWillUseSpecificationForWindowWithQueryController";
    private static final String controllerFactoryWillUseSpecificationForWindowWithInsertController = "controllerFactoryWillUseSpecificationForWindowWithInsertController";
    private static final String controllerFactoryWillUseSpecificationForWindowWithOpenController = "controllerFactoryWillUseSpecificationForWindowWithOpenController";
    private static final String controllerFactoryWillUseSpecificationForWindowWithListController = "controllerFactoryWillUseSpecificationForWindowWithListController";
    private static EOControllerFactory _sharedInstance = null;
    private static _XMLProvider _xmlProvider = null;
    private static EOAction _toggleXMLLoggingAction = null;
    protected _NSDelegate _delegate = new _NSDelegate(Delegate._CLASS);
    private NSArray _actions = null;
    private NSMutableDictionary _entityAndTaskIdentifierToKeysMapTable = null;
    private NSArray _availableSpecifications = null;
    private NSArray _defaultSpecifications = null;
    private NSMutableDictionary _specificationIdentifierToDatasMapTable = null;
    private boolean _cachesControllers = true;
    private boolean _logsXML = false;

    public static EOControllerFactory createSharedControllerFactoryWithClass(String className) {
        if (className != null) {
            Class controllerProviderClass = _NSUtilities.classWithName((String)className);
            if (controllerProviderClass == null) {
                throw new IllegalArgumentException("Can't find controller factory class with name " + (className != null ? className : "<NULL>"));
            }
            try {
                Object delegate = _sharedInstance == null ? null : _sharedInstance.delegate();
                _sharedInstance = (EOControllerFactory)controllerProviderClass.newInstance();
                _sharedInstance.setDelegate(delegate);
            }
            catch (Exception exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x100000L)) {
                    NSLog.debug.appendln((Object)("Could not instantiate controller factory: " + exception.getMessage()));
                    NSLog.debug.appendln((Throwable)exception);
                }
                throw new IllegalStateException("Could not instantiate controller factory (" + exception.toString() + ")");
            }
        }
        return EOControllerFactory.sharedControllerFactory();
    }

    public static EOControllerFactory sharedControllerFactory() {
        if (_sharedInstance == null) {
            _sharedInstance = new EOControllerFactory();
        }
        return _sharedInstance;
    }

    public static void _useXMLProviderIfNotSpecified(_XMLProvider xmlProvider) {
        if (_xmlProvider == null) {
            EOControllerFactory._setXMLProvider(xmlProvider);
        }
    }

    public static void _setXMLProvider(_XMLProvider xmlProvider) {
        _xmlProvider = xmlProvider;
    }

    public static _XMLProvider _xmlProvider() {
        if (_xmlProvider == null) {
            throw new IllegalStateException("XML Provider not initialized - please initialize principal classes correctly");
        }
        return _xmlProvider;
    }

    private void _disposeWithSpecificationData(_SpecificationData specificationData) {
        if (specificationData != null) {
            EOController controller;
            int i;
            int count;
            NSArray controllers = specificationData.providedControllers();
            if (controllers != null) {
                count = controllers.count();
                for (i = 0; i < count; ++i) {
                    controller = (EOController)controllers.objectAtIndex(i);
                    if (controller._disposeCallback() != this) continue;
                    controller._setDisposeCallback(null);
                }
            }
            if ((controllers = specificationData.cachedControllers()) != null) {
                count = controllers.count();
                for (i = 0; i < count; ++i) {
                    controller = (EOController)controllers.objectAtIndex(i);
                    controller._setDisposeCallback(null);
                    controller.dispose();
                }
            }
            specificationData.unregisterAllControllers();
        }
    }

    private void _disposeAllSpecificationDatas() {
        if (this._specificationIdentifierToDatasMapTable != null) {
            NSArray keys = this._specificationIdentifierToDatasMapTable.allKeys();
            int count = keys.count();
            for (int i = 0; i < count; ++i) {
                String key = (String)keys.objectAtIndex(i);
                this._disposeWithSpecificationData((_SpecificationData)this._specificationIdentifierToDatasMapTable.objectForKey((Object)key));
            }
            this._specificationIdentifierToDatasMapTable.removeAllObjects();
            this._specificationIdentifierToDatasMapTable = null;
        }
    }

    public void dispose() {
        this._disposeAllSpecificationDatas();
    }

    public void setDelegate(Object delegate) {
        this._delegate.setDelegate(delegate);
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void performTaskWithController(EOController controller, ControllerTaskCallback callback, Object[] parameters) {
        if (controller != null) {
            boolean success = callback.prepareTask(controller, parameters);
            if (success && (success = callback.performTask(controller, parameters))) {
                if (controller instanceof EOComponentController) {
                    ((EOComponentController)controller).makeVisible();
                }
                success = callback.finishTask(controller, parameters);
            }
            if (!success) {
                NSArray controllers = controller.controllersInEnumeration(0, null);
                for (int i = controllers.count() - 1; i >= 0; --i) {
                    ((EOController)controllers.objectAtIndex(i)).dispose();
                }
            }
        }
    }

    public void setCachesControllers(boolean flag) {
        this._cachesControllers = flag;
    }

    public boolean cachesControllers() {
        return this._cachesControllers;
    }

    public void invalidateRules() {
        this._actions = null;
        this._defaultSpecifications = null;
        this._availableSpecifications = null;
        this._disposeAllSpecificationDatas();
        EOApplication.sharedApplication().resetActions();
    }

    protected Object _concreteEvaluateRules(NSDictionary specification) {
        return EOControllerFactory._xmlProvider()._provideXML(specification);
    }

    protected Object[] _concreteEvaluateMultipleRules(NSArray specifications) {
        return EOControllerFactory._xmlProvider()._provideXMLs(specifications);
    }

    private NSDictionary _evaluationSpecification(NSDictionary specification) {
        NSDictionary evaluationSpecification = specification;
        if (specification != null) {
            NSArray platforms;
            NSArray locales;
            NSMutableDictionary extendedSpecification = null;
            if (specification.objectForKey((Object)LocalesSpecification) == null && (locales = EOApplication.sharedApplication().localeIndicators()) != null && locales.count() > 0) {
                if (extendedSpecification == null) {
                    extendedSpecification = new NSMutableDictionary(specification);
                }
                extendedSpecification.setObjectForKey((Object)locales, (Object)LocalesSpecification);
            }
            if (specification.objectForKey((Object)PlatformsSpecification) == null && (platforms = EOApplication.sharedApplication().platformIndicators()) != null && platforms.count() > 0) {
                if (extendedSpecification == null) {
                    extendedSpecification = new NSMutableDictionary(specification);
                }
                extendedSpecification.setObjectForKey((Object)platforms, (Object)PlatformsSpecification);
            }
            if (extendedSpecification != null) {
                evaluationSpecification = extendedSpecification;
            }
        }
        if (evaluationSpecification != null && this._delegate.respondsTo(controllerFactoryWillEvaluateRules)) {
            evaluationSpecification = (NSDictionary)this._delegate.perform(controllerFactoryWillEvaluateRules, (Object)this, (Object)evaluationSpecification);
        }
        return evaluationSpecification;
    }

    public Object evaluateRules(NSDictionary specification) {
        Object object;
        String timerID = _EODebugUtilities._measureTimes ? _EODebugUtilities._startMeasuringTime((String)("evaluate rules with specification " + this._uniqueDescriptionForSpecification(specification)), null, (String)"evaluating rules") : null;
        NSDictionary evaluationSpecification = this._evaluationSpecification(specification);
        Object object2 = object = evaluationSpecification != null ? this._concreteEvaluateRules(evaluationSpecification) : null;
        if (timerID != null) {
            _EODebugUtilities._stopMeasuringTime((String)timerID);
        }
        if (this._logsXML && NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)8L)) {
            NSLog.debug.appendln((Object)("XML for specification " + this._uniqueDescriptionForSpecification(specification) + ":" + (object == null ? " <NULL>" : "")));
            if (object != null) {
                NSLog.debug.appendln((Object)_EODebugUtilities.XMLDescription((Object)object));
            }
        }
        return object;
    }

    public Object[] _evaluateMultipleRules(NSArray specifications) {
        Object[] objects = null;
        if (specifications != null) {
            NSDictionary evaluationSpecification;
            int i;
            int numberOfSpecifications = specifications.count();
            String timerID = null;
            if (_EODebugUtilities._measureTimes) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("evaluate rules with specifications ");
                for (i = 0; i < numberOfSpecifications; ++i) {
                    if (i > 0) {
                        buffer.append("; ");
                    }
                    buffer.append(this._uniqueDescriptionForSpecification((NSDictionary)specifications.objectAtIndex(i)));
                }
                timerID = _EODebugUtilities._startMeasuringTime((String)buffer.toString(), null, (String)"evaluating rules");
            }
            objects = new Object[numberOfSpecifications];
            Object[] specificationIndexes = new Object[numberOfSpecifications];
            NSMutableArray evaluationSpecifications = new NSMutableArray(numberOfSpecifications);
            for (i = 0; i < numberOfSpecifications; ++i) {
                evaluationSpecification = this._evaluationSpecification((NSDictionary)specifications.objectAtIndex(i));
                if (evaluationSpecification == null) continue;
                specificationIndexes[i] = evaluationSpecification;
                evaluationSpecifications.addObject((Object)evaluationSpecification);
            }
            Object[] ruleResults = this._concreteEvaluateMultipleRules((NSArray)evaluationSpecifications);
            int numberOfRuleResults = evaluationSpecifications.count();
            block2: for (i = 0; i < numberOfRuleResults; ++i) {
                Object object = ruleResults[i];
                evaluationSpecification = (NSDictionary)evaluationSpecifications.objectAtIndex(i);
                for (int j = 0; j < numberOfSpecifications; ++j) {
                    if (specificationIndexes[j] != evaluationSpecification) continue;
                    objects[j] = object;
                    continue block2;
                }
            }
            if (timerID != null) {
                _EODebugUtilities._stopMeasuringTime((String)timerID);
            }
            if (this._logsXML && NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)8L)) {
                for (i = 0; i < numberOfSpecifications; ++i) {
                    NSLog.debug.appendln((Object)("XML for specification " + this._uniqueDescriptionForSpecification((NSDictionary)specifications.objectAtIndex(i)) + ":" + (objects[i] == null ? " <NULL>" : "")));
                    if (objects[i] == null) continue;
                    NSLog.debug.appendln((Object)_EODebugUtilities.XMLDescription((Object)objects[i]));
                }
            }
        }
        return objects;
    }

    public NSDictionary _specificationWithParameters(String questionName, String entityName, String taskName) {
        NSMutableDictionary specification = new NSMutableDictionary(3);
        if (entityName != null) {
            specification.setObjectForKey((Object)entityName, (Object)EntitySpecification);
        }
        specification.setObjectForKey((Object)questionName, (Object)QuestionSpecification);
        if (taskName != null) {
            specification.setObjectForKey((Object)taskName, (Object)TaskSpecification);
        }
        return specification;
    }

    protected void _concreteGenerateSpecificationsAndActions() {
        NSDictionary userInterfaceParameters;
        NSMutableArray actions;
        int i;
        NSMutableArray specifications = new NSMutableArray(4);
        specifications.addObject((Object)this._specificationWithParameters(DefaultSpecificationsQuestion, null, null));
        specifications.addObject((Object)this._specificationWithParameters(AvailableSpecificationsQuestion, null, null));
        specifications.addObject((Object)this._specificationWithParameters(ActionsQuestion, null, null));
        specifications.addObject((Object)this._specificationWithParameters(_AssistantActionsQuestion, null, null));
        specifications.addObject((Object)this._specificationWithParameters(UserInterfaceParametersQuestion, null, null));
        Object[] objects = this._evaluateMultipleRules((NSArray)specifications);
        this._defaultSpecifications = (NSArray)objects[0];
        if (this._defaultSpecifications == null) {
            this._defaultSpecifications = NSArray.EmptyArray;
        }
        this._availableSpecifications = (NSArray)objects[1];
        if (this._availableSpecifications == null) {
            this._availableSpecifications = NSArray.EmptyArray;
        }
        int count = this._availableSpecifications.count();
        this._specificationIdentifierToDatasMapTable = new NSMutableDictionary(count);
        for (i = 0; i < count; ++i) {
            NSDictionary specification = (NSDictionary)this._availableSpecifications.objectAtIndex(i);
            String specificationIdentifier = this._uniqueDescriptionForSpecification(specification);
            this._specificationIdentifierToDatasMapTable.setObjectForKey((Object)new _SpecificationData(), (Object)specificationIdentifier);
        }
        NSArray actionArchives = (NSArray)objects[2];
        NSArray assistantActionArchives = (NSArray)objects[3];
        if (actionArchives != null) {
            count = actionArchives.count();
            actions = new NSMutableArray(count);
            for (i = 0; i < count; ++i) {
                actions.addObject(EOXMLUnarchiver.decodeRootObject((NSDictionary)((NSDictionary)actionArchives.objectAtIndex(i))));
            }
        } else {
            actions = new NSMutableArray();
        }
        if (assistantActionArchives != null) {
            count = assistantActionArchives.count();
            for (i = 0; i < count; ++i) {
                actions.addObject(EOXMLUnarchiver.decodeRootObject((NSDictionary)((NSDictionary)assistantActionArchives.objectAtIndex(i))));
            }
        }
        if ((userInterfaceParameters = (NSDictionary)objects[4]) != null) {
            EOUserInterfaceParameters._populateValuesFromDictionary((NSDictionary)userInterfaceParameters);
        }
        if (EOUserInterfaceParameters._developerMode) {
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_printFactoryInformation", (Object)this));
            if (_toggleXMLLoggingAction == null) {
                _toggleXMLLoggingAction = EOAction._standardDeveloperAction((String)"_toggleXMLLogging", (Object)this);
                this._toggleXMLLogging();
                this._toggleXMLLogging();
            }
            actions.addObject((Object)_toggleXMLLoggingAction);
        }
        this._actions = actions;
        if (this._delegate.respondsTo(controllerFactoryWillUseActions)) {
            this._actions = (NSArray)this._delegate.perform(controllerFactoryWillUseActions, (Object)this, (Object)(this._actions != null ? this._actions : NSArray.EmptyArray));
        }
        if (this._actions == null) {
            this._actions = NSArray.EmptyArray;
        }
    }

    public NSArray _defaultSpecifications() {
        if (this._defaultSpecifications == null) {
            this._concreteGenerateSpecificationsAndActions();
        }
        return this._defaultSpecifications;
    }

    public NSArray _availableSpecifications() {
        if (this._availableSpecifications == null) {
            this._concreteGenerateSpecificationsAndActions();
        }
        return this._availableSpecifications;
    }

    public NSArray actions() {
        if (this._actions == null) {
            this._concreteGenerateSpecificationsAndActions();
        }
        return this._actions;
    }

    private NSMutableDictionary _specificationIdentifierToDatasMapTable() {
        if (this._specificationIdentifierToDatasMapTable == null) {
            this._concreteGenerateSpecificationsAndActions();
        }
        return this._specificationIdentifierToDatasMapTable;
    }

    public String _uniqueDescriptionForEntityAndTaskName(String entityName, String taskName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("entity = ");
        if (entityName != null) {
            buffer.append(entityName);
        }
        buffer.append(", task = ");
        if (taskName != null) {
            buffer.append(taskName);
        }
        return buffer.toString();
    }

    protected NSArray _concretePropertyKeysForEntityAndTaskName(String entityName, String taskName) {
        return (NSArray)this.evaluateRules(this._specificationWithParameters(PropertyKeysQuestion, entityName, taskName));
    }

    public NSArray propertyKeysForEntityAndTaskName(String entityName, String taskName) {
        NSArray keys = null;
        if (entityName != null && taskName != null) {
            String identifier = this._uniqueDescriptionForEntityAndTaskName(entityName, taskName);
            if (this._entityAndTaskIdentifierToKeysMapTable == null) {
                this._entityAndTaskIdentifierToKeysMapTable = new NSMutableDictionary(16);
            } else {
                keys = (NSArray)this._entityAndTaskIdentifierToKeysMapTable.objectForKey((Object)identifier);
            }
            if (keys == null) {
                keys = this._concretePropertyKeysForEntityAndTaskName(entityName, taskName);
                if (this._delegate.respondsTo(controllerFactoryWillReturnPropertyKeysForEntityAndTaskName)) {
                    keys = (NSArray)this._delegate.perform(controllerFactoryWillReturnPropertyKeysForEntityAndTaskName, new Object[]{this, keys != null ? keys : NSArray.EmptyArray, entityName, taskName});
                }
                if (keys == null) {
                    keys = NSArray.EmptyArray;
                }
                this._entityAndTaskIdentifierToKeysMapTable.setObjectForKey((Object)keys, (Object)identifier);
            }
        }
        return keys;
    }

    private NSArray _expandedKeyPathsForEntityName(String entityName, NSArray keys, NSMutableArray entityHierarchy) {
        if (entityName != null && keys != null) {
            _EOKeyPathUtility utility = _EOKeyPathUtility.utility();
            int numberOfKeys = keys.count();
            NSMutableArray keyPaths = new NSMutableArray(numberOfKeys);
            block4: for (int i = 0; i < numberOfKeys; ++i) {
                String key = (String)keys.objectAtIndex(i);
                String destinationEntityName = null;
                switch (utility.typeForKeyPath(entityName, key)) {
                    case 1: {
                        NSArray destinationKeys;
                        if (entityHierarchy == null) {
                            entityHierarchy = new NSMutableArray(16);
                        }
                        entityHierarchy.addObject((Object)entityName);
                        destinationEntityName = utility.destinationEntityNameForKeyPath(entityName, key);
                        if (destinationEntityName != null && entityHierarchy.indexOfObject((Object)destinationEntityName) < 0 && (destinationKeys = this.propertyKeysForEntityAndTaskName(destinationEntityName, IdentifyTask)) != null) {
                            NSArray expandedKeys = this._expandedKeyPathsForEntityName(destinationEntityName, destinationKeys, entityHierarchy);
                            int numberOfExpandedKeys = expandedKeys.count();
                            for (int j = 0; j < numberOfExpandedKeys; ++j) {
                                String expandedKey = key + "." + (String)expandedKeys.objectAtIndex(j);
                                String otherEntityName = utility.destinationEntityNameForKeyPath(entityName, expandedKey);
                                if (otherEntityName != null && otherEntityName.equals(entityName)) continue;
                                keyPaths.addObject((Object)expandedKey);
                            }
                        }
                        entityHierarchy.removeObject((Object)entityName);
                        continue block4;
                    }
                    case 0: {
                        keyPaths.addObject((Object)key);
                        continue block4;
                    }
                }
            }
            return keyPaths;
        }
        return NSArray.EmptyArray;
    }

    public NSArray expandedKeyPathsForEntityName(String entityName, String key) {
        return key != null ? this._expandedKeyPathsForEntityName(entityName, new NSArray((Object)key), null) : null;
    }

    public NSArray expandedKeyPathsForEntityName(String entityName, NSArray keys) {
        return this._expandedKeyPathsForEntityName(entityName, keys, null);
    }

    protected void _activateDefaultControllers() {
        NSArray specifications = this._defaultSpecifications();
        if (specifications != null) {
            int count = specifications.count();
            for (int i = 0; i < count; ++i) {
                NSDictionary specification = (NSDictionary)specifications.objectAtIndex(i);
                EOController controller = this.controllerWithSpecification(specification, true);
                if (controller == null) continue;
                this.performTaskWithController(controller, new ControllerTaskAdaptor(){}, null);
            }
        }
    }

    public void activateDefaultControllers() {
        if (this._delegate.respondsTo(controllerFactoryShouldActivateDefaultControllers) && !this._delegate.booleanPerform(controllerFactoryShouldActivateDefaultControllers, (Object)this)) {
            return;
        }
        this._activateDefaultControllers();
    }

    public String _uniqueDescriptionForSpecification(NSDictionary specification) {
        NSArray keys;
        if (specification != null && (keys = specification.allKeys()) != null && keys.count() > 0) {
            NSArray sortedKeys;
            try {
                sortedKeys = keys.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
            }
            catch (NSComparator.ComparisonException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
            StringBuffer buffer = new StringBuffer();
            int count = sortedKeys.count();
            for (int i = 0; i < count; ++i) {
                String key = (String)sortedKeys.objectAtIndex(i);
                String value = specification.objectForKey((Object)key).toString();
                if (value.equalsIgnoreCase("true")) {
                    value = "true";
                } else if (value.equalsIgnoreCase("false")) {
                    value = "false";
                }
                if (i > 0) {
                    buffer.append("_");
                }
                buffer.append(key);
                buffer.append("=");
                buffer.append(value);
            }
            return buffer.toString();
        }
        return null;
    }

    protected EOController _controllerWithSpecificationAndNonReusableControllers(NSDictionary specification, NSArray nonReusableControllers, boolean checkRulesIfUnknown) {
        _SpecificationData specificationData = this._specificationDataIfAvailable(specification, true, checkRulesIfUnknown);
        if (specificationData != null) {
            int count;
            EOController controller = null;
            boolean resetControllerUserInterface = false;
            NSArray providedControllers = specificationData.providedControllers();
            if (providedControllers != null && (count = providedControllers.count()) > 0) {
                switch (specificationData.reuseMode()) {
                    case 1: {
                        boolean checkVisibleControllers = false;
                        do {
                            checkVisibleControllers = !checkVisibleControllers;
                            for (int i = 0; i < count && controller == null; ++i) {
                                EOController providedController = (EOController)providedControllers.objectAtIndex(i);
                                if (nonReusableControllers != null && nonReusableControllers.containsObject((Object)providedController) || providedController instanceof EOComponentController && ((EOComponentController)providedController).isVisible() != checkVisibleControllers || providedController._canFindControllerWithBooleanValue(0, EOObjectDisplayDocument._CLASS, "isEdited", true)) continue;
                                controller = providedController;
                                specificationData.moveControllerToBackInRegistry(controller);
                                resetControllerUserInterface = !checkVisibleControllers;
                            }
                        } while (checkVisibleControllers && controller == null);
                        break;
                    }
                    case 2: {
                        boolean checkVisibleControllers = false;
                        do {
                            checkVisibleControllers = !checkVisibleControllers;
                            for (int i = 0; i < count && controller == null; ++i) {
                                EOController providedController = (EOController)providedControllers.objectAtIndex(i);
                                if (nonReusableControllers != null && nonReusableControllers.containsObject((Object)providedController) || providedController instanceof EOComponentController && ((EOComponentController)providedController).isVisible() != checkVisibleControllers) continue;
                                if (!EODocumentController._saveChangesIfEditedIfUserConfirms((EOController)providedController, null)) {
                                    return null;
                                }
                                controller = providedController;
                                specificationData.moveControllerToBackInRegistry(controller);
                                resetControllerUserInterface = !checkVisibleControllers;
                            }
                        } while (checkVisibleControllers && controller == null);
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < count && controller == null; ++i) {
                            EOController providedController = (EOController)providedControllers.objectAtIndex(i);
                            if (nonReusableControllers != null && nonReusableControllers.containsObject((Object)providedController) || !(providedController instanceof EOComponentController) || ((EOComponentController)providedController).isVisible()) continue;
                            controller = providedController;
                            resetControllerUserInterface = true;
                        }
                        break;
                    }
                    case 4: {
                        if (count <= 0) break;
                        controller = (EOController)providedControllers.objectAtIndex(0);
                        if (nonReusableControllers == null || !nonReusableControllers.containsObject((Object)controller)) break;
                        return null;
                    }
                }
            }
            if (controller == null) {
                EOController eOController = controller = this.cachesControllers() ? specificationData.provideCachedControllerIfAvailable() : null;
                if (controller == null) {
                    NSDictionary archive = specificationData.rootObjectArchive();
                    if (archive != null && (controller = (EOController)EOXMLUnarchiver.decodeRootObject((NSDictionary)archive)) != null) {
                        controller._setInfo((Object)specification, _SpecificationKey);
                        specificationData.registerControllerAsProvided(controller);
                    }
                } else {
                    resetControllerUserInterface = true;
                }
            }
            if (resetControllerUserInterface) {
                controller.invokeMethod(0, EOComponentController.ResetUserInterface._CLASS, "resetUserInterface", null, null);
            }
            if (controller != null) {
                String question;
                controller._setDisposeCallback((EOController._DisposeCallback)this);
                if (this._delegate.respondsTo(controllerFactoryWillReturnControllerForSpecification)) {
                    controller = (EOController)this._delegate.perform(controllerFactoryWillReturnControllerForSpecification, (Object)this, (Object)controller, (Object)specification);
                }
                if ((question = (String)specification.objectForKey((Object)QuestionSpecification)) != null && (question.equals(TopLevelWindowQuestion) || question.equals(TopLevelModalDialogQuestion))) {
                    EOApplication application = EOApplication.sharedApplication();
                    if (controller.supercontroller() != application) {
                        application.addSubcontroller(controller);
                    }
                }
                return controller;
            }
        }
        return this._delegate.respondsTo(controllerFactoryWillReturnControllerForSpecification) ? (EOController)this._delegate.perform(controllerFactoryWillReturnControllerForSpecification, (Object)this, null, (Object)specification) : null;
    }

    public EOController controllerWithSpecification(NSDictionary specification, boolean checkRulesIfUnknown) {
        return this._controllerWithSpecificationAndNonReusableControllers(specification, null, checkRulesIfUnknown);
    }

    protected int defaultReuseModeForSpecification(NSDictionary specification) {
        if (specification != null) {
            String questionName = (String)specification.objectForKey((Object)QuestionSpecification);
            String taskName = (String)specification.objectForKey((Object)TaskSpecification);
            if (questionName != null && taskName != null) {
                if (questionName.equals(TopLevelWindowQuestion)) {
                    if (taskName.equals(ListTask)) {
                        return 4;
                    }
                } else if (questionName.equals(TopLevelModalDialogQuestion) && taskName.equals(SelectTask)) {
                    return 3;
                }
            }
        }
        return 0;
    }

    private void _setRootObjectArchiveOfSpecificationData(_SpecificationData specificationData, NSDictionary specification, NSDictionary archive) {
        if (specificationData != null && archive != null) {
            specificationData.setRootObjectArchive(archive);
            if (archive != null) {
                int cacheSize;
                int reuseMode;
                Object value = archive.objectForKey((Object)ReuseModeParameter);
                int n = reuseMode = value != null ? _EOExtendedValueConversion.reuseModeFromValue(value) : this.defaultReuseModeForSpecification(specification);
                if (this._delegate.respondsTo(controllerFactoryWillReuseControllersForSpecificationWithMode)) {
                    reuseMode = (Integer)this._delegate.perform(controllerFactoryWillReuseControllersForSpecificationWithMode, (Object)this, (Object)_NSUtilities.IntegerForInt((int)reuseMode), (Object)specification);
                }
                specificationData.setReuseMode(reuseMode);
                value = archive.objectForKey((Object)CacheSizeParameter);
                if (value != null) {
                    cacheSize = _EOValueConversion.intFromValue((Object)value);
                } else {
                    switch (reuseMode) {
                        case 1: 
                        case 2: 
                        case 4: {
                            cacheSize = 1;
                            break;
                        }
                        case 0: {
                            cacheSize = 2;
                            break;
                        }
                        default: {
                            cacheSize = 0;
                        }
                    }
                }
                specificationData.setCacheSize(cacheSize);
            }
        }
    }

    protected NSDictionary _concreteControllerArchiveWithSpecification(NSDictionary specification) {
        return (NSDictionary)this.evaluateRules(specification);
    }

    private boolean _archivesAreIdentical(Object object1, Object object2) {
        if (object1 != null && object2 != null && object1.getClass() == object2.getClass()) {
            if (object1 instanceof NSDictionary) {
                NSDictionary dictionary1 = (NSDictionary)object1;
                NSDictionary dictionary2 = (NSDictionary)object2;
                NSArray keys = dictionary1.allKeys();
                int count = keys.count();
                if (count == dictionary2.allKeys().count()) {
                    for (int i = 0; i < count; ++i) {
                        String key = (String)keys.objectAtIndex(i);
                        if (this._archivesAreIdentical(dictionary1.objectForKey((Object)key), dictionary2.objectForKey((Object)key))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (object1 instanceof NSArray) {
                NSArray array1 = (NSArray)object1;
                NSArray array2 = (NSArray)object2;
                int count = array1.count();
                if (count == array2.count()) {
                    for (int i = 0; i < count; ++i) {
                        if (this._archivesAreIdentical(array1.objectAtIndex(i), array2.objectAtIndex(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return object1.equals(object2);
        }
        return object1 == object2;
    }

    private _SpecificationData _specificationDataWithIdenticalControllerArchive(NSDictionary archive) {
        NSMutableDictionary datas = this._specificationIdentifierToDatasMapTable();
        NSArray keys = datas.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            NSDictionary compareArchive;
            String key = (String)keys.objectAtIndex(i);
            _SpecificationData specificationData = (_SpecificationData)datas.objectForKey((Object)key);
            if (specificationData == _SpecificationData._unavailablePlaceholder || (compareArchive = specificationData.rootObjectArchive()) == null || !this._archivesAreIdentical(archive, compareArchive)) continue;
            return specificationData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public _SpecificationData _specificationDataIfAvailable(NSDictionary specification, boolean ensureControllerArchiveIsAvailable, boolean checkRulesIfUnknown) {
        String specificationIdentifier = this._uniqueDescriptionForSpecification(specification);
        if (specificationIdentifier == null) return null;
        NSMutableDictionary datas = this._specificationIdentifierToDatasMapTable();
        _SpecificationData specificationData = (_SpecificationData)datas.objectForKey((Object)specificationIdentifier);
        if (specificationData == _SpecificationData._unavailablePlaceholder) return null;
        if (specificationData != null) {
            if (!ensureControllerArchiveIsAvailable) return specificationData;
            NSDictionary archive = specificationData.rootObjectArchive();
            if (archive != null) return specificationData;
            archive = this._concreteControllerArchiveWithSpecification(specification);
            if (archive == null) {
                datas.setObjectForKey((Object)_SpecificationData._unavailablePlaceholder, (Object)specificationIdentifier);
                return null;
            }
            _SpecificationData identicalSpecificationData = this._specificationDataWithIdenticalControllerArchive(archive);
            if (identicalSpecificationData == null) {
                this._setRootObjectArchiveOfSpecificationData(specificationData, specification, archive);
                return specificationData;
            }
            datas.setObjectForKey((Object)identicalSpecificationData, (Object)specificationIdentifier);
            return identicalSpecificationData;
        }
        if (!checkRulesIfUnknown) return null;
        NSDictionary archive = this._concreteControllerArchiveWithSpecification(specification);
        if (archive != null) {
            specificationData = this._specificationDataWithIdenticalControllerArchive(archive);
            if (specificationData != null) return specificationData;
            specificationData = new _SpecificationData();
            datas.setObjectForKey((Object)specificationData, (Object)specificationIdentifier);
            this._setRootObjectArchiveOfSpecificationData(specificationData, specification, archive);
            return specificationData;
        }
        datas.setObjectForKey((Object)_SpecificationData._unavailablePlaceholder, (Object)specificationIdentifier);
        return null;
    }

    public boolean hasControllerWithSpecification(NSDictionary specification, boolean checkRulesIfUnknown) {
        return this._specificationDataIfAvailable(specification, false, checkRulesIfUnknown) != null;
    }

    public EOController controllerWithEntityName(EOController rootController, Class controllerInterface, String entityName) {
        EOController.Enumeration controllerEnumeration = rootController.controllerEnumeration(0, controllerInterface);
        if (entityName != null && controllerEnumeration != null) {
            while (controllerEnumeration.hasMoreElements()) {
                EOController controller = controllerEnumeration.nextController();
                String name = (String)controller.valueForKey("entityName");
                if (name == null || !entityName.equals(name)) continue;
                return controller;
            }
        }
        return null;
    }

    public boolean _shouldControllerBeDisposed(EOController controller) {
        if (this.cachesControllers()) {
            NSMutableDictionary datas = this._specificationIdentifierToDatasMapTable();
            NSArray keys = datas.allKeys();
            int count = keys.count();
            for (int i = 0; i < count; ++i) {
                String key = (String)keys.objectAtIndex(i);
                _SpecificationData specificationData = (_SpecificationData)datas.objectForKey((Object)key);
                if (!specificationData.isControllerRegisteredAsProvided(controller) || !specificationData.canCacheAnotherController() || this._delegate.respondsTo(controllerFactoryShouldCacheController) && !this._delegate.booleanPerform(controllerFactoryShouldCacheController, (Object)this, (Object)controller)) continue;
                controller.removeFromSupercontroller();
                controller.prepareForNewTask(true);
                specificationData.registerControllerAsCached(controller);
                return false;
            }
        }
        return true;
    }

    public void _controllerDisposed(EOController controller) {
        NSMutableDictionary datas = this._specificationIdentifierToDatasMapTable();
        NSArray keys = datas.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            String key = (String)keys.objectAtIndex(i);
            ((_SpecificationData)datas.objectForKey((Object)key)).unregisterController(controller);
        }
    }

    private EOController _controllerWithEntityAndTaskName(String entityName, String taskName) {
        NSDictionary specification = this._specificationWithParameters(ControllerQuestion, entityName, taskName);
        if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForController)) {
            specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForController, new Object[]{this, specification, entityName, taskName});
        }
        return this.controllerWithSpecification(specification, true);
    }

    public EOController queryControllerWithEntity(String entityName) {
        return this._controllerWithEntityAndTaskName(entityName, QueryTask);
    }

    public EOController listControllerWithEntity(String entityName) {
        return this._controllerWithEntityAndTaskName(entityName, ListTask);
    }

    public EOController formControllerWithEntity(String entityName) {
        return this._controllerWithEntityAndTaskName(entityName, FormTask);
    }

    public EOController selectControllerWithEntity(String entityName) {
        return this._controllerWithEntityAndTaskName(entityName, SelectTask);
    }

    public EOController editorControllerWithEntity(String entityName) {
        return this._controllerWithEntityAndTaskName(entityName, EditorTask);
    }

    public boolean _isMainEntity(String entityName) {
        return this.canOpenGlobalIDsWithEntityName(entityName);
    }

    public boolean _isEnumerationEntity(String entityName) {
        return !this._isMainEntity(entityName) && this.canSelectWithEntityName(entityName);
    }

    public boolean _isRootLevelEntity(String entityName) {
        return this._isMainEntity(entityName) || this._isEnumerationEntity(entityName);
    }

    private NSDictionary _specificationForWindowWithTaskName(String taskName) {
        NSDictionary specification = null;
        if (taskName != null) {
            specification = this._specificationWithParameters(TopLevelWindowQuestion, null, taskName);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForWindowController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForWindowController, (Object)this, (Object)specification, (Object)taskName);
            }
        }
        return specification;
    }

    public boolean canOpenWindowForTaskName(String taskName) {
        return this.hasControllerWithSpecification(this._specificationForWindowWithTaskName(taskName), true);
    }

    public EOController openWindowForTaskName(String taskName) {
        EOController controller = this.controllerWithSpecification(this._specificationForWindowWithTaskName(taskName), true);
        if (controller != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){}, null);
        }
        return controller;
    }

    private NSDictionary _specificationForModalDialogWithTaskName(String taskName) {
        NSDictionary specification = null;
        if (taskName != null) {
            specification = this._specificationWithParameters(TopLevelModalDialogQuestion, null, taskName);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForModalDialogController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForModalDialogController, (Object)this, (Object)specification, (Object)taskName);
            }
        }
        return specification;
    }

    public boolean canOpenModalDialogForTaskName(String taskName) {
        return this.hasControllerWithSpecification(this._specificationForModalDialogWithTaskName(taskName), false);
    }

    public EOController openModalDialogForTaskName(String taskName) {
        EOController controller = this.controllerWithSpecification(this._specificationForModalDialogWithTaskName(taskName), false);
        if (controller != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){}, null);
        }
        return controller;
    }

    private NSDictionary _specificationForModalSelectDialogWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelModalDialogQuestion, entityName, SelectTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForModalDialogWithSelectController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForModalDialogWithSelectController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canSelectWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForModalSelectDialogWithEntityName(entityName), false);
    }

    public NSArray selectWithEntityName(String entityName, boolean allowsMultipleGlobalIDs, boolean allowsInserting) {
        NSMutableArray globalIDs = new NSMutableArray();
        EOController controller = this.controllerWithSpecification(this._specificationForModalSelectDialogWithEntityName(entityName), false);
        if (controller != null && (controller = this.controllerWithEntityName(controller, Select._CLASS, entityName)) != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                public boolean prepareTask(EOController selectController, Object[] parameters) {
                    ((Select)selectController).prepareToSelect((Boolean)parameters[1], (Boolean)parameters[2]);
                    return true;
                }

                public boolean finishTask(EOController selectController, Object[] parameters) {
                    Select selectTaskController = (Select)selectController;
                    NSMutableArray globalIDsParameter = (NSMutableArray)parameters[0];
                    if (((Boolean)parameters[1]).booleanValue()) {
                        NSArray selectedGlobalIDs = selectTaskController.provideSelectedObjectsGlobalIDs();
                        if (selectedGlobalIDs != null) {
                            globalIDsParameter.addObjectsFromArray(selectedGlobalIDs);
                        }
                    } else {
                        EOGlobalID globalID = selectTaskController.provideSelectedObjectGlobalID();
                        if (globalID != null) {
                            globalIDsParameter.addObject((Object)globalID);
                        }
                    }
                    selectTaskController.finishSelecting();
                    return true;
                }
            }, new Object[]{globalIDs, allowsMultipleGlobalIDs ? Boolean.TRUE : Boolean.FALSE, allowsInserting ? Boolean.TRUE : Boolean.FALSE});
            if (globalIDs.count() == 0) {
                return null;
            }
        }
        return globalIDs;
    }

    private NSDictionary _specificationForModalSelectByInsertingDialogWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelModalDialogQuestion, entityName, FormTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForModalDialogWithSelectByInsertingController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForModalDialogWithSelectByInsertingController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canSelectByInsertingWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForModalSelectByInsertingDialogWithEntityName(entityName), false);
    }

    public EOGlobalID selectByInsertingWithEntityName(String entityName) {
        EOController controller = this.controllerWithSpecification(this._specificationForModalSelectByInsertingDialogWithEntityName(entityName), false);
        if (controller != null) {
            controller = this.controllerWithEntityName(controller, SelectByInserting._CLASS, entityName);
        }
        NSMutableArray globalIDs = new NSMutableArray();
        if (controller != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                public boolean prepareTask(EOController selectByInsertingController, Object[] parameters) {
                    ((SelectByInserting)selectByInsertingController).prepareToSelectByInserting();
                    return true;
                }

                public boolean performTask(EOController selectByInsertingController, Object[] parameters) {
                    return ((SelectByInserting)selectByInsertingController).insertNewObject();
                }

                public boolean finishTask(EOController controller3, Object[] parameters) {
                    SelectByInserting selectByInsertingController = (SelectByInserting)controller3;
                    EOGlobalID globalID = selectByInsertingController.provideSelectedObjectGlobalID();
                    if (globalID != null) {
                        NSMutableArray globalIDsParameter = (NSMutableArray)parameters[0];
                        globalIDsParameter.addObject((Object)globalID);
                    }
                    selectByInsertingController.finishSelecting();
                    return true;
                }
            }, new Object[]{globalIDs});
            if (globalIDs.count() == 1) {
                return (EOGlobalID)globalIDs.objectAtIndex(0);
            }
        }
        return null;
    }

    private NSDictionary _specificationForQueryWindowWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelWindowQuestion, entityName, QueryTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForWindowWithQueryController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForWindowWithQueryController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canQueryWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForQueryWindowWithEntityName(entityName), false);
    }

    public Query queryWithEntityName(String entityName) {
        EOController controller;
        EOController topLevelController = this.controllerWithSpecification(this._specificationForQueryWindowWithEntityName(entityName), false);
        EOController eOController = controller = topLevelController != null ? this.controllerWithEntityName(topLevelController, Query._CLASS, entityName) : null;
        if (controller != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                public boolean performTask(EOController queryController, Object[] parameters) {
                    ((Query)queryController).queryObjectsWithFetchSpecification(null);
                    return true;
                }
            }, null);
            return (Query)controller;
        }
        return null;
    }

    private NSDictionary _specificationForInsertWindowWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelWindowQuestion, entityName, FormTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForWindowWithInsertController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForWindowWithInsertController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canInsertWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForInsertWindowWithEntityName(entityName), false);
    }

    public Insert insertWithEntityName(String entityName) {
        EOController controller;
        EOController topLevelController = this.controllerWithSpecification(this._specificationForInsertWindowWithEntityName(entityName), false);
        EOController eOController = controller = topLevelController != null ? this.controllerWithEntityName(topLevelController, Insert._CLASS, entityName) : null;
        if (controller != null) {
            this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                public boolean performTask(EOController insertController, Object[] parameters) {
                    return ((Insert)insertController).insertNewObject();
                }
            }, null);
            return (Insert)controller;
        }
        return null;
    }

    protected boolean _makeDocumentsWithGlobalIDVisible(String entityName, EOGlobalID globalID) {
        boolean success = false;
        NSArray controllers = EOApplication.sharedApplication().documentsForGlobalID(globalID, entityName);
        if (controllers != null) {
            int count = controllers.count();
            for (int i = 0; i < count; ++i) {
                EOController controller = (EOController)controllers.objectAtIndex(i);
                if (!(controller instanceof EOComponentController) || !((EOComponentController)controller).makeVisible()) continue;
                success = true;
            }
        }
        return success;
    }

    private NSDictionary _specificationForOpenWindowWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelWindowQuestion, entityName, FormTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForWindowWithOpenController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForWindowWithOpenController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canOpenGlobalIDsWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForOpenWindowWithEntityName(entityName), false);
    }

    protected Open _openGlobalIDWithEntityName(String entityName, EOGlobalID globalID, NSMutableArray nonReusableTopLevelControllers) {
        if (entityName != null && globalID != null && !this._makeDocumentsWithGlobalIDVisible(entityName, globalID)) {
            EOController controller;
            EOController topLevelController = this._controllerWithSpecificationAndNonReusableControllers(this._specificationForOpenWindowWithEntityName(entityName), (NSArray)nonReusableTopLevelControllers, false);
            EOController eOController = controller = topLevelController != null ? this.controllerWithEntityName(topLevelController, Open._CLASS, entityName) : null;
            if (controller != null) {
                this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                    public boolean performTask(EOController openController, Object[] parameters) {
                        ((Open)openController).openObjectWithGlobalID((EOGlobalID)parameters[0]);
                        return true;
                    }
                }, new Object[]{globalID});
                if (nonReusableTopLevelControllers != null) {
                    nonReusableTopLevelControllers.addObject((Object)topLevelController);
                }
                return (Open)controller;
            }
        }
        return null;
    }

    public Open openGlobalIDWithEntityName(String entityName, EOGlobalID globalID) {
        return this._openGlobalIDWithEntityName(entityName, globalID, null);
    }

    public NSArray openGlobalIDsWithEntityName(String entityName, NSArray globalIDs) {
        if (entityName != null && globalIDs != null) {
            int i;
            NSMutableArray nonReusableTopLevelControllers = new NSMutableArray();
            int count = globalIDs.count();
            for (i = 0; i < count; ++i) {
                nonReusableTopLevelControllers.addObjectsFromArray(EOApplication.sharedApplication().documentsForGlobalID((EOGlobalID)globalIDs.objectAtIndex(i), entityName));
            }
            NSMutableArray controllers = new NSMutableArray(count);
            for (i = 0; i < count; ++i) {
                Open controller = this._openGlobalIDWithEntityName(entityName, (EOGlobalID)globalIDs.objectAtIndex(i), nonReusableTopLevelControllers);
                if (controller == null) continue;
                controllers.addObject((Object)controller);
            }
            return controllers;
        }
        return NSArray.EmptyArray;
    }

    public boolean canOpenWithEntityName(String entityName) {
        return this.canOpenGlobalIDsWithEntityName(entityName) && this.canSelectWithEntityName(entityName);
    }

    public Open openSingleWithEntityName(String entityName) {
        NSArray globalIDs;
        if (this.canOpenWithEntityName(entityName) && (globalIDs = this.selectWithEntityName(entityName, false, false)) != null && globalIDs.count() == 1) {
            return this.openGlobalIDWithEntityName(entityName, (EOGlobalID)globalIDs.objectAtIndex(0));
        }
        return null;
    }

    public NSArray openWithEntityName(String entityName) {
        if (this.canOpenWithEntityName(entityName)) {
            boolean allowMultiple;
            NSDictionary specification = this._specificationForOpenWindowWithEntityName(entityName);
            _SpecificationData specificationData = this._specificationDataIfAvailable(specification, true, false);
            int reuseMode = specificationData != null ? specificationData.reuseMode() : 0;
            switch (reuseMode) {
                case 2: 
                case 4: {
                    allowMultiple = false;
                    break;
                }
                default: {
                    allowMultiple = true;
                }
            }
            NSArray globalIDs = this.selectWithEntityName(entityName, allowMultiple, false);
            if (globalIDs != null && globalIDs.count() > 0) {
                return this.openGlobalIDsWithEntityName(entityName, globalIDs);
            }
        }
        return NSArray.EmptyArray;
    }

    private NSDictionary _specificationForListWindowWithEntityName(String entityName) {
        NSDictionary specification = null;
        if (entityName != null) {
            specification = this._specificationWithParameters(TopLevelWindowQuestion, entityName, ListTask);
            if (this._delegate.respondsTo(controllerFactoryWillUseSpecificationForWindowWithListController)) {
                specification = (NSDictionary)this._delegate.perform(controllerFactoryWillUseSpecificationForWindowWithListController, (Object)this, (Object)specification, (Object)entityName);
            }
        }
        return specification;
    }

    public boolean canListWithEntityName(String entityName) {
        return this.hasControllerWithSpecification(this._specificationForListWindowWithEntityName(entityName), false);
    }

    public List listWithEntityName(String entityName) {
        return this.listFetchSpecificationWithEntityName(entityName, new EOFetchSpecification(entityName, null, null, false, true, null));
    }

    public List listFetchSpecificationWithEntityName(String entityName, EOFetchSpecification fetchSpecification) {
        if (entityName != null) {
            EOController controller;
            EOController topLevelController = this.controllerWithSpecification(this._specificationForListWindowWithEntityName(entityName), false);
            EOController eOController = controller = topLevelController != null ? this.controllerWithEntityName(topLevelController, List._CLASS, entityName) : null;
            if (controller != null) {
                this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                    public boolean performTask(EOController listController, Object[] parameters) {
                        ((List)listController).listObjectsWithFetchSpecification((EOFetchSpecification)parameters[0]);
                        return true;
                    }
                }, new Object[]{fetchSpecification});
                return (List)controller;
            }
        }
        return null;
    }

    public List listGlobalIDsWithEntityName(String entityName, NSArray globalIDs) {
        if (entityName != null && globalIDs != null) {
            EOController controller;
            EOController topLevelController = this.controllerWithSpecification(this._specificationForListWindowWithEntityName(entityName), false);
            EOController eOController = controller = topLevelController != null ? this.controllerWithEntityName(topLevelController, List._CLASS, entityName) : null;
            if (controller != null) {
                this.performTaskWithController(controller, new ControllerTaskAdaptor(){

                    public boolean performTask(EOController listController, Object[] parameters) {
                        ((List)listController).listObjectsWithGlobalIDs((NSArray)parameters[0]);
                        return true;
                    }
                }, new Object[]{globalIDs});
                return (List)controller;
            }
        }
        return null;
    }

    public void _printFactoryInformation() {
        System.out.println(this);
    }

    public void _toggleXMLLogging() {
        boolean flag = !this._logsXML();
        this._setLogsXML(flag);
        if (_toggleXMLLoggingAction != null) {
            String title = EODisplayUtilities.localizedDisplayLabelForString((String)(flag ? "Deactivate XML Logging" : "Activate XML Logging"));
            _toggleXMLLoggingAction.setDescriptionPath(EOUserInterfaceParameters.localizedString((String)"Debug") + "/" + title);
            _toggleXMLLoggingAction.setShortDescription(title);
        }
    }

    public void _setLogsXML(boolean flag) {
        this._logsXML = flag;
    }

    public boolean _logsXML() {
        return this._logsXML;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(_EODebugUtilities._classAndIdentityDescription((Object)this) + " controller information:\n");
        NSMutableDictionary datas = this._specificationIdentifierToDatasMapTable();
        NSArray keys = datas.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            String key = (String)keys.objectAtIndex(i);
            _SpecificationData specificationData = (_SpecificationData)datas.objectForKey((Object)key);
            buffer.append("specification '" + key + "' -> ");
            if (specificationData == _SpecificationData._unavailablePlaceholder) {
                buffer.append("<not available>\n");
                continue;
            }
            if (specificationData.rootObjectArchive() == null) {
                buffer.append("<detail information not retrieved up to now>\n");
                continue;
            }
            buffer.append("reuse mode = " + _EOExtendedValueConversion.stringForReuseMode(specificationData.reuseMode()) + ", number of provided controllers = " + specificationData.numberOfProvidedControllers());
            if (this.cachesControllers()) {
                buffer.append(", cache size = " + specificationData.cacheSize() + ", number of cached controllers = " + specificationData.numberOfCachedControllers());
            }
            boolean explanationAppended = false;
            for (int j = 0; j < count; ++j) {
                String otherKey;
                _SpecificationData otherSpecificationData;
                if (i == j || specificationData != (otherSpecificationData = (_SpecificationData)datas.objectForKey((Object)(otherKey = (String)keys.objectAtIndex(j))))) continue;
                if (explanationAppended) {
                    buffer.append(" and '" + otherKey + "'");
                    continue;
                }
                buffer.append(", identical to other specifications: '" + otherKey + "'");
                explanationAppended = true;
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    static {
        String[] tagNames = new String[]{"COMPONENTCONTROLLER", "FRAMECONTROLLER", "DIALOGCONTROLLER", "MODALDIALOGCONTROLLER", "INSPECTORCONTROLLER", "TABSWITCHCONTROLLER", "MENUSWITCHCONTROLLER", "PROGRAMMATICSWITCHCONTROLLER", "SPLITCONTROLLER", "BOXCONTROLLER", "ACTIONTRIGGER", "ACTIONBUTTONSCONTROLLER", "ACTIONMENUCONTROLLER", "ENTITYCONTROLLER", "DOCUMENTCONTROLLER", "INTERFACECONTROLLER", "FORMCONTROLLER", "LISTCONTROLLER", "QUERYCONTROLLER", "QUICKTIMEVIEWCONTROLLER", "TABLECOLUMNCONTROLLER", "TEXTFIELDCONTROLLER", "STATICTEXTFIELDCONTROLLER", "IMAGEVIEWCONTROLLER", "TEXTAREACONTROLLER", "ACTIONCONTROLLER", "CHECKBOXCONTROLLER", "COMBOBOXCONTROLLER", "MULTIPLEVALUESENUMERATIONCONTROLLER", "ONEVALUEENUMERATIONCONTROLLER", "DETAILSELECTIONCONTROLLER", "RANGETEXTFIELDCONTROLLER", "TABLECONTROLLER", "TREECONTROLLER", "STATICICONCONTROLLER", "STATICLABELCONTROLLER", "DISPLAYSTATISTICSCONTROLLER", "CONTROLLERHIERARCHYACTION", "SUPERCONTROLLERSACTION", "APPLICATIONACTION", "WINDOWOBSERVERACTION", "QUERYACTION", "OPENACTION", "INSERTACTION", "LISTACTION", "WINDOWACTION", "TOOLWINDOWACTION", "HELPWINDOWACTION"};
        String[] classNames = new String[]{"eoapplication.EOComponentController", "eoapplication.EOFrameController", "eoapplication.EODialogController", "eoapplication.EOModalDialogController", "eoapplication.EOInspectorController", "eoapplication.EOTabSwitchController", "eoapplication.EOMenuSwitchController", "eoapplication.EOProgrammaticSwitchController", "eoapplication.EOSplitController", "eoapplication.EOBoxController", "eoapplication.EOActionTrigger", "eoapplication.EOActionButtonsController", "eoapplication.EOActionMenuController", "eoapplication.EOEntityController", "eoapplication.EODocumentController", "eoapplication.EOInterfaceController", "eogeneration.EOFormController", "eogeneration.EOListController", "eogeneration.EOQueryController", "eogeneration.EOQuickTimeViewController", "eogeneration.EOTableColumnController", "eogeneration.EOTextFieldController", "eogeneration.EOStaticTextFieldController", "eogeneration.EOImageViewController", "eogeneration.EOTextAreaController", "eogeneration.EOActionController", "eogeneration.EOCheckBoxController", "eogeneration.EOComboBoxController", "eogeneration.EOMultipleValuesEnumerationController", "eogeneration.EOOneValueEnumerationController", "eogeneration.EODetailSelectionController", "eogeneration.EORangeTextFieldController", "eogeneration.EOTableController", "eogeneration.EOTreeController", "eogeneration.EOStaticIconController", "eogeneration.EOStaticLabelController", "eogeneration.EODisplayStatisticsController", "eoapplication.EOAction$_ControllerHierarchy", "eoapplication.EOAction$_Supercontrollers", "eoapplication.EOAction$_Application", "eoapplication.EOAction$_WindowObserver", "eogeneration.EOEnterAction$_Query", "eogeneration.EOEnterAction$_Open", "eogeneration.EOEnterAction$_Insert", "eogeneration.EOEnterAction$_List", "eogeneration.EOEnterAction$_ActivateWindow", "eogeneration.EOEnterAction$_ActivateToolWindow", "eogeneration.EOEnterAction$_ActivateHelpWindow"};
        EOXMLUnarchiver._useTagToClassNameMapTable((String[])tagNames, (String[])classNames, (String)"com.webobjects.");
    }

    public static class _SpecificationData {
        private NSDictionary _rootObjectArchive = null;
        private int _reuseMode = 0;
        private int _cacheSize = 0;
        private NSMutableArray _providedControllers = null;
        private NSMutableArray _cachedControllers = null;
        public static _SpecificationData _unavailablePlaceholder = new _SpecificationData();

        public void setRootObjectArchive(NSDictionary archive) {
            this._rootObjectArchive = archive;
        }

        public NSDictionary rootObjectArchive() {
            return this._rootObjectArchive;
        }

        public void setReuseMode(int reuseMode) {
            this._reuseMode = reuseMode;
        }

        public int reuseMode() {
            return this._reuseMode;
        }

        public void setCacheSize(int cacheSize) {
            this._cacheSize = cacheSize;
        }

        public int cacheSize() {
            return this._cacheSize;
        }

        public int numberOfProvidedControllers() {
            return this._providedControllers != null ? this._providedControllers.count() : 0;
        }

        public int numberOfCachedControllers() {
            return this._cachedControllers != null ? this._cachedControllers.count() : 0;
        }

        public boolean canCacheAnotherController() {
            return this._cacheSize > 0 ? this._cachedControllers == null || this._cachedControllers.count() < this._cacheSize : false;
        }

        public EOController provideCachedControllerIfAvailable() {
            int count;
            if (this._cachedControllers != null && (count = this._cachedControllers.count()) > 0) {
                EOController controller = (EOController)this._cachedControllers.objectAtIndex(count - 1);
                this.registerControllerAsProvided(controller);
                return controller;
            }
            return null;
        }

        public void registerControllerAsProvided(EOController controller) {
            if (controller != null) {
                if (this._providedControllers == null) {
                    this._providedControllers = new NSMutableArray(32);
                }
                if (!this._providedControllers.containsObject((Object)controller)) {
                    this._providedControllers.addObject((Object)controller);
                }
                if (this._cachedControllers != null && this._cachedControllers.containsObject((Object)controller)) {
                    this._cachedControllers.removeObject((Object)controller);
                }
            }
        }

        public void registerControllerAsCached(EOController controller) {
            if (controller != null) {
                if (this._cachedControllers == null) {
                    this._cachedControllers = new NSMutableArray(32);
                }
                if (!this._cachedControllers.containsObject((Object)controller)) {
                    this._cachedControllers.addObject((Object)controller);
                }
                if (this._providedControllers != null && this._providedControllers.containsObject((Object)controller)) {
                    this._providedControllers.removeObject((Object)controller);
                }
            }
        }

        public void unregisterController(EOController controller) {
            if (controller != null) {
                if (this._providedControllers != null && this._providedControllers.containsObject((Object)controller)) {
                    this._providedControllers.removeObject((Object)controller);
                }
                if (this._cachedControllers != null && this._cachedControllers.containsObject((Object)controller)) {
                    this._cachedControllers.removeObject((Object)controller);
                }
            }
        }

        public void unregisterAllControllers() {
            if (this._providedControllers != null) {
                this._providedControllers.removeAllObjects();
            }
            if (this._cachedControllers != null) {
                this._cachedControllers.removeAllObjects();
            }
        }

        public NSArray providedControllers() {
            return this._providedControllers;
        }

        public NSArray cachedControllers() {
            return this._cachedControllers;
        }

        public boolean isControllerRegisteredAsProvided(EOController controller) {
            return controller != null && this._providedControllers != null ? this._providedControllers.containsObject((Object)controller) : false;
        }

        public void moveControllerToBackInRegistry(EOController controller) {
            if (this._providedControllers != null && this._providedControllers.count() > 1 && this._providedControllers.containsObject((Object)controller)) {
                this._providedControllers.removeObject((Object)controller);
                this._providedControllers.addObject((Object)controller);
            }
        }
    }

    public static class _XMLProvider {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$_XMLProvider");

        public Object _provideXML(NSDictionary specification) {
            return null;
        }

        public Object[] _provideXMLs(NSArray specifications) {
            Object[] objects = null;
            if (specifications != null) {
                int count = specifications.count();
                objects = new Object[count];
                for (int i = 0; i < count; ++i) {
                    objects[i] = this._provideXML((NSDictionary)specifications.objectAtIndex(i));
                }
            }
            return objects;
        }
    }

    public static class ControllerTaskAdaptor
    implements ControllerTaskCallback {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$ControllerTaskAdaptor");

        public boolean prepareTask(EOController controller, Object[] parameters) {
            return true;
        }

        public boolean performTask(EOController controller, Object[] parameters) {
            return true;
        }

        public boolean finishTask(EOController controller, Object[] parameters) {
            return true;
        }
    }

    public static interface ControllerTaskCallback {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$ControllerTaskCallback");

        public boolean prepareTask(EOController var1, Object[] var2);

        public boolean performTask(EOController var1, Object[] var2);

        public boolean finishTask(EOController var1, Object[] var2);
    }

    public static interface Delegate {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$Delegate");

        public NSDictionary controllerFactoryWillEvaluateRules(EOControllerFactory var1, NSDictionary var2);

        public NSArray controllerFactoryWillUseActions(EOControllerFactory var1, NSArray var2);

        public boolean controllerFactoryShouldActivateDefaultControllers(EOControllerFactory var1);

        public boolean controllerFactoryShouldCacheController(EOControllerFactory var1, EOController var2);

        public int controllerFactoryWillReuseControllersForSpecificationWithMode(EOControllerFactory var1, int var2, NSDictionary var3);

        public NSArray controllerFactoryWillReturnPropertyKeysForEntityAndTaskName(EOControllerFactory var1, NSArray var2, String var3, String var4);

        public EOController controllerFactoryWillReturnControllerForSpecification(EOControllerFactory var1, EOController var2, NSDictionary var3);

        public NSDictionary controllerFactoryWillUseSpecificationForController(EOControllerFactory var1, NSDictionary var2, String var3, String var4);

        public NSDictionary controllerFactoryWillUseSpecificationForWindowController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForModalDialogController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForModalDialogWithSelectController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForModalDialogWithSelectByInsertingController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForWindowWithQueryController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForWindowWithInsertController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForWindowWithOpenController(EOControllerFactory var1, NSDictionary var2, String var3);

        public NSDictionary controllerFactoryWillUseSpecificationForWindowWithListController(EOControllerFactory var1, NSDictionary var2, String var3);
    }

    public static interface List
    extends EOObjectDisplay {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$List");

        public void listObjectsWithFetchSpecification(EOFetchSpecification var1);

        public void listObjectsWithGlobalIDs(NSArray var1);
    }

    public static interface Select
    extends EOObjectDisplay {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$Select");

        public void prepareToSelect(boolean var1, boolean var2);

        public EOGlobalID provideSelectedObjectGlobalID();

        public NSArray provideSelectedObjectsGlobalIDs();

        public void finishSelecting();
    }

    public static interface Query
    extends EOObjectDisplay {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$Query");

        public void queryObjectsWithFetchSpecification(EOFetchSpecification var1);
    }

    public static interface SelectByInserting
    extends Insert {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$SelectByInserting");

        public void prepareToSelectByInserting();

        public EOGlobalID provideSelectedObjectGlobalID();

        public void finishSelecting();
    }

    public static interface Insert
    extends EOObjectDisplayDocument {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$Insert");

        public boolean insertNewObject();

        public boolean insertNewObjectWithRelationshipPathsFilled(NSDictionary var1);
    }

    public static interface Open
    extends EOObjectDisplayDocument {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EOControllerFactory$Open");

        public void openObjectWithGlobalID(EOGlobalID var1);
    }
}

