/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eogeneration;

import com.webobjects.eoapplication.EOAction;
import com.webobjects.eoapplication.EOApplication;
import com.webobjects.eoapplication.EOController;
import com.webobjects.eoapplication.EODefaults;
import com.webobjects.eoapplication.EODialogs;
import com.webobjects.eoapplication.EOObjectDisplay;
import com.webobjects.eoapplication.EOUserInterfaceParameters;
import com.webobjects.eoapplication.EOWindowObserver;
import com.webobjects.eoapplication._EODebugUtilities;
import com.webobjects.eoapplication._EOTimer;
import com.webobjects.eoapplication._EOValueConversion;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eogeneration.EOControllerFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.awt.Component;
import java.awt.Window;
import java.util.Date;

public class EODynamicApplication
extends EOApplication {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eogeneration.EODynamicApplication");
    public static final String _ControllerFactoryClassNameArgument = "controllerFactoryClassName";
    private static final String _ControllerCachingArgument = "controllerCaching";
    private static final String _XMLLoggingArgument = "XMLLogging";

    protected NSArray defaultActions() {
        EOControllerFactory factory = EOControllerFactory.sharedControllerFactory();
        NSArray factoryActions = factory != null ? factory.actions() : null;
        NSMutableArray actions = new NSMutableArray(64);
        if (factoryActions != null) {
            actions.addObjectsFromArray(factoryActions);
        }
        if (EOUserInterfaceParameters._developerMode) {
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_printActiveWindowComponentHierarchy", (Object)((Object)this)));
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_printActiveWindowEditingContexts", (Object)((Object)this)));
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_printControllerHierarchy", (Object)((Object)this)));
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_runGarbageCollector", (Object)((Object)this)));
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_restartApplication", (Object)((Object)this)));
            actions.addObject((Object)EOAction._standardDeveloperAction((String)"_resetCaches", (Object)((Object)this)));
        }
        return EOAction.mergedActions((NSArray)actions, (NSArray)super.defaultActions());
    }

    public boolean canPerformActionNamed(String actionName) {
        if (this.isActionNamedEnabled(actionName)) {
            if (actionName.equals("saveAll")) {
                return !EOUserInterfaceParameters._enableSaveOnlyIfEdited || this.hasEditedDocuments();
            }
            if (EOUserInterfaceParameters._developerMode) {
                if (actionName.equals("_printActiveWindowComponentHierarchy") || actionName.equals("_printActiveWindowEditingContexts")) {
                    EOWindowObserver windowObserver = this.windowObserver();
                    Window window = windowObserver != null ? windowObserver.activeWindow() : null;
                    return window != null;
                }
                if (actionName.equals("_printControllerHierarchy")) {
                    return true;
                }
            }
        }
        return super.canPerformActionNamed(actionName);
    }

    protected void finishInitialization() {
        EOUserInterfaceParameters.setUseSpecialFonts((boolean)true);
        EOUserInterfaceParameters.setUseSpecialColors((boolean)true);
        NSDictionary arguments = this.arguments();
        String factoryClassName = (String)arguments.objectForKey((Object)_ControllerFactoryClassNameArgument);
        EOControllerFactory factory = EOControllerFactory.createSharedControllerFactoryWithClass(factoryClassName);
        Object value = arguments.objectForKey((Object)_ControllerCachingArgument);
        if (value != null) {
            factory.setCachesControllers(_EOValueConversion.booleanFromValue((Object)value));
        }
        if ((value = arguments.objectForKey((Object)_XMLLoggingArgument)) != null) {
            boolean flag = _EOValueConversion.booleanFromValue((Object)value);
            factory._setLogsXML(flag);
            if (flag) {
                NSLog.allowDebugLoggingForGroups((long)8L);
                if (NSLog.allowedDebugLevel() < 3) {
                    NSLog.setAllowedDebugLevel((int)3);
                }
            }
        }
        factory.activateDefaultControllers();
        super.finishInitialization();
    }

    public void _printActiveWindowComponentHierarchy() {
        Window window;
        EOWindowObserver windowObserver = this.windowObserver();
        Window window2 = window = windowObserver != null ? windowObserver.activeWindow() : null;
        if (window != null) {
            System.out.println(_EODebugUtilities.hierarchicalComponentLayoutString((Component)window));
        } else {
            System.out.println("No active window...");
        }
    }

    public void _printActiveWindowEditingContexts() {
        EOController controller;
        EOWindowObserver windowObserver = this.windowObserver();
        EOController eOController = controller = windowObserver != null ? windowObserver.controllerForActiveWindow() : null;
        if (controller != null) {
            NSMutableArray editingContexts = new NSMutableArray();
            EOController.Enumeration controllerEnumeration = controller.controllerEnumeration(0, EOObjectDisplay._CLASS);
            while (controllerEnumeration.hasMoreElements()) {
                controller = controllerEnumeration.nextController();
                EOEditingContext editingContext = ((EOObjectDisplay)controller).editingContext();
                if (editingContext == null || editingContexts.containsObject((Object)editingContext)) continue;
                editingContexts.addObject((Object)editingContext);
                if (editingContexts.count() > 1) {
                    System.out.println("================================================================================");
                }
                System.out.println("Controller: " + controller);
                System.out.println("Editing Context: " + editingContext);
                System.out.println("Registered Objects: " + editingContext.registeredObjects());
                System.out.println("Updated Objects: " + editingContext.updatedObjects());
                System.out.println("Inserted Objects: " + editingContext.insertedObjects());
                System.out.println("Deleted Objects: " + editingContext.deletedObjects());
            }
            if (editingContexts.count() == 0) {
                System.out.println("No editing contexts found...");
            }
        } else {
            System.out.println("No active window...");
        }
    }

    public void _printControllerHierarchy() {
        System.out.println(_EODebugUtilities.hierarchicalControllerString((EOController)this));
    }

    public void _runGarbageCollector() {
        System.gc();
    }

    public void _restartApplication() {
        if (EODialogs.runConfirmOperationDialog((String)"Restart", (String)"Do you really want to restart the application?", (String)"Restart")) {
            new _EOTimer(100L, (_EOTimer.Callback)new _EOTimer.CallbackAdaptor(){

                public void timerFired(_EOTimer timer, Date date, Date lastFireDate) {
                    EOApplication application = EOApplication.sharedApplication();
                    NSArray subcontrollers = application.subcontrollers();
                    int count = subcontrollers.count();
                    for (int i = count - 1; i >= 0; --i) {
                        EOController._disposeController((EOController)((EOController)subcontrollers.objectAtIndex(i)));
                    }
                    EODefaults defaults = application.defaults();
                    if (defaults != null) {
                        defaults.clearAllValues();
                    }
                    EOControllerFactory factory = EOControllerFactory.sharedControllerFactory();
                    factory.invalidateRules();
                    factory.setCachesControllers(false);
                    boolean canQuit = application.canQuit();
                    application.setCanQuit(false);
                    EOControllerFactory.sharedControllerFactory().activateDefaultControllers();
                    application.setCanQuit(canQuit);
                }
            }, false, true, true, true);
        }
    }

    public void _resetCaches() {
        EOControllerFactory factory;
        EODefaults defaults = this.defaults();
        if (defaults != null) {
            defaults.clearAllValues();
        }
        if ((factory = EOControllerFactory.sharedControllerFactory()) != null) {
            factory.invalidateRules();
            factory.setCachesControllers(false);
        }
    }
}

