/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCColumn;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCFetchPrivate;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCChannel
extends EOAdaptorChannel {
    protected boolean _isOpen;
    protected Statement _statement;
    protected NSArray _attributes;
    protected NSArray _selectedColumns;
    protected int _rowsProcessedCount;
    protected NSArray _storedProcedureBindings;
    protected ResultSet _resultSet;
    protected int _rowsUpdateCount = 0;
    protected int _fetchColumnCount;
    private JDBCColumn _inputColumn = new JDBCColumn(this);
    private boolean _errorEvaluateExpression = false;
    private JDBCFetchPrivate _fetchAssociation;
    private boolean _fetchInProgress = false;
    private boolean _beganTransaction = false;
    private boolean _isFetchingStoredProc = false;
    private DatabaseMetaData _dbMetaData;

    public JDBCChannel(JDBCContext jDBCContext) {
        super((EOAdaptorContext)jDBCContext);
    }

    private JDBCPlugIn _plugIn() {
        JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this.adaptorContext().adaptor();
        return jDBCAdaptor.plugIn();
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void openChannel() {
        if (this.isOpen()) {
            return;
        }
        JDBCContext jDBCContext = (JDBCContext)this.adaptorContext();
        jDBCContext._channelWillOpen();
        Connection connection = jDBCContext.connection();
        if (connection == null) {
            throw new JDBCAdaptorException("No connection", null);
        }
        try {
            Statement statement = connection.createStatement();
            statement.close();
        }
        catch (SQLException sQLException) {
            jDBCContext._channelDidClose();
            throw new JDBCAdaptorException(sQLException);
        }
        this._isOpen = true;
    }

    private void _resetUpdateCount() {
        this._rowsUpdateCount = 0;
    }

    public void closeChannel() {
        if (!this._isOpen) {
            this._dbMetaData = null;
            return;
        }
        try {
            if (this._fetchInProgress) {
                this.cancelFetch();
            }
            if (this._statement != null) {
                this._statement.close();
                this._statement = null;
            }
        }
        catch (JDBCAdaptorException jDBCAdaptorException) {
            throw jDBCAdaptorException;
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        finally {
            this._dbMetaData = null;
            this._isOpen = false;
        }
        ((JDBCContext)this.adaptorContext())._channelDidClose();
    }

    private EOSQLExpressionFactory _expressionFactory() {
        return ((JDBCAdaptor)this.adaptorContext().adaptor()).expressionFactory();
    }

    public void insertRow(NSDictionary nSDictionary, EOEntity eOEntity) {
        JDBCExpression jDBCExpression = (JDBCExpression)this._expressionFactory().insertStatementForRow(nSDictionary, eOEntity);
        this.evaluateExpression(jDBCExpression);
        this._plugIn().updateLOBs(this, jDBCExpression, nSDictionary, eOEntity);
    }

    public int updateValuesInRowsDescribedByQualifier(NSDictionary nSDictionary, EOQualifier eOQualifier, EOEntity eOEntity) {
        JDBCExpression jDBCExpression = (JDBCExpression)this._expressionFactory().updateStatementForRow(nSDictionary, eOQualifier, eOEntity);
        this._evaluateExpression(jDBCExpression, false, true);
        if (!this._errorEvaluateExpression) {
            this._rowsProcessedCount = this._rowsUpdateCount;
            this._resetUpdateCount();
        } else {
            this._rowsProcessedCount = 0;
        }
        this._plugIn().updateLOBs(this, jDBCExpression, nSDictionary, eOEntity);
        return this._rowsProcessedCount;
    }

    public int deleteRowsDescribedByQualifier(EOQualifier eOQualifier, EOEntity eOEntity) {
        this._evaluateExpression(this._expressionFactory().deleteStatementWithQualifier(eOQualifier, eOEntity), false, true);
        if (!this._errorEvaluateExpression) {
            this._rowsProcessedCount = this._rowsUpdateCount;
            this._resetUpdateCount();
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)(this._rowsProcessedCount + " row(s) deleted"));
            }
        } else {
            this._rowsProcessedCount = 0;
        }
        return this._rowsProcessedCount;
    }

    public void selectAttributes(NSArray nSArray, EOFetchSpecification eOFetchSpecification, boolean bl, EOEntity eOEntity) {
        if (this._delegateRespondsTo_shouldSelectAttributes && !this._delegate.booleanPerform("adaptorChannelShouldSelectAttributes", new Object[]{this, nSArray, eOFetchSpecification, bl ? Boolean.TRUE : Boolean.FALSE, eOEntity})) {
            return;
        }
        String string = eOEntity.externalQuery();
        EOSQLExpression eOSQLExpression = string == null || eOFetchSpecification.qualifier() != null ? this._expressionFactory().selectStatementForAttributes(nSArray, bl, eOFetchSpecification, eOEntity) : this._expressionFactory().expressionForString(string);
        if (eOSQLExpression == null) {
            return;
        }
        this.evaluateExpression(eOSQLExpression);
        this.setAttributesToFetch(nSArray);
        if (this._delegateRespondsTo_didSelectAttributes) {
            this._delegate.perform("adaptorChannelDidSelectAttributes", new Object[]{this, nSArray, eOFetchSpecification, bl ? Boolean.TRUE : Boolean.FALSE, eOEntity});
        }
    }

    private ResultSet _bindInputVariablesWithBindingsAndExecute(NSArray nSArray, String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        NSDictionary nSDictionary;
        PreparedStatement preparedStatement;
        int n;
        if (this._statement != null) {
            this._statement.close();
            this._statement = null;
        }
        if (nSArray == null) {
            nSArray = NSArray.EmptyArray;
        }
        if ((n = nSArray.count()) > 0 || bl) {
            preparedStatement = bl ? connection.prepareCall(string) : connection.prepareStatement(string);
            this._statement = preparedStatement;
            this._inputColumn.setStatement(preparedStatement);
            for (int i = 0; i < n; ++i) {
                NSDictionary nSDictionary2 = (NSDictionary)nSArray.objectAtIndex(i);
                EOAttribute eOAttribute = (EOAttribute)nSDictionary2.objectForKey((Object)"BindVariableAttribute");
                this._inputColumn.setAttribute(eOAttribute);
                this._inputColumn.takeInputValue(nSDictionary2.objectForKey((Object)"BindVariableValue"), i + 1, bl);
            }
            if (bl2) {
                this._rowsUpdateCount = preparedStatement.executeUpdate();
            } else {
                preparedStatement.execute();
            }
        } else {
            this._statement = connection.createStatement();
            if (bl2) {
                this._rowsUpdateCount = this._statement.executeUpdate(string);
            } else {
                this._statement.execute(string);
            }
        }
        ResultSet resultSet = this._statement.getResultSet();
        if (resultSet == null && this._statement.getMoreResults()) {
            resultSet = this._statement.getResultSet();
        }
        if (bl && resultSet == null && n > 0 && (preparedStatement = (EOAttribute)(nSDictionary = (NSDictionary)nSArray.objectAtIndex(0)).objectForKey((Object)"BindVariableAttribute")).externalType().equalsIgnoreCase("REF CURSOR")) {
            resultSet = (ResultSet)((CallableStatement)this._statement).getObject(1);
            this._storedProcedureBindings = null;
        }
        return resultSet;
    }

    public void evaluateExpression(EOSQLExpression eOSQLExpression) {
        this._evaluateExpression(eOSQLExpression, false, false);
    }

    private void _evaluateExpression(EOSQLExpression eOSQLExpression, boolean bl, boolean bl2) {
        int n;
        ResultSet resultSet;
        this._errorEvaluateExpression = false;
        if (!this.isOpen()) {
            throw new JDBCAdaptorException("evaluateExpression: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + ": illegal attempt to evaluateExpression without opening the channel", null);
        }
        if (this._fetchInProgress) {
            throw new JDBCAdaptorException("evaluateExpression: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + ": illegal attempt to evaluateExpression while a fetch is in progress", null);
        }
        if (this._delegateRespondsTo_shouldEvaluateExpression && !this._delegate.booleanPerform("adaptorChannelShouldEvaluateExpression", (Object)this, (Object)eOSQLExpression)) {
            return;
        }
        String string = eOSQLExpression.statement();
        JDBCContext jDBCContext = (JDBCContext)this.adaptorContext();
        if (!jDBCContext.hasOpenTransaction()) {
            jDBCContext.beginTransaction();
            this._beganTransaction = true;
        } else {
            this._beganTransaction = false;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)(" evaluateExpression: " + eOSQLExpression.toString()));
        }
        this._rowsProcessedCount = 0;
        try {
            resultSet = this._bindInputVariablesWithBindingsAndExecute(eOSQLExpression.bindVariableDictionaries(), string, jDBCContext._jdbcConnection, bl, bl2);
        }
        catch (SQLException sQLException) {
            if (this._beganTransaction) {
                jDBCContext.rollbackTransaction();
                this._beganTransaction = false;
            }
            this._errorEvaluateExpression = true;
            jDBCContext._jdbcErrorWithChannel(this, sQLException, true, "EvaluateExpression failed: " + eOSQLExpression.toString());
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData;
            n = resultSet != null ? ((resultSetMetaData = resultSet.getMetaData()) != null ? resultSetMetaData.getColumnCount() : 0) : 0;
        }
        catch (SQLException sQLException) {
            if (this._beganTransaction) {
                jDBCContext.rollbackTransaction();
                this._beganTransaction = false;
            }
            this._errorEvaluateExpression = true;
            jDBCContext._jdbcErrorWithChannel(this, sQLException, true, "Unable to determine the number of column returned");
            return;
        }
        if (n > 0) {
            this._beginFetch(jDBCContext);
        } else if (this._beganTransaction) {
            jDBCContext.commitTransaction();
            this._beganTransaction = false;
        }
        if (this._delegateRespondsTo_didEvaluateExpression) {
            this._delegate.perform("adaptorChannelDidEvaluateExpression", (Object)this, (Object)eOSQLExpression);
        }
        if (!this._fetchInProgress && this._beganTransaction) {
            jDBCContext.commitTransaction();
            this._beganTransaction = false;
        }
        this._resultSet = resultSet;
        this._errorEvaluateExpression = false;
    }

    boolean _errorEvaluateExpression() {
        return this._errorEvaluateExpression;
    }

    void _setErrorEvaluateExpression(boolean bl) {
        this._errorEvaluateExpression = bl;
    }

    private void _beginFetch(JDBCContext jDBCContext) {
        jDBCContext._channelWillBeginFetching();
        this._fetchInProgress = true;
        this._rowsProcessedCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _endFetch() {
        if (this._fetchInProgress) {
            JDBCContext jDBCContext = (JDBCContext)this.adaptorContext();
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)(this._rowsProcessedCount + " row(s) processed"));
            }
            this._fetchInProgress = false;
            jDBCContext._channelDidEndFetching();
            if (this._delegateRespondsTo_didFinishFetching) {
                this._delegate.perform("adaptorChannelDidFinishFetching", (Object)this);
            }
            if (this._beganTransaction) {
                jDBCContext.commitTransaction();
                this._beganTransaction = false;
            }
        }
        this.setAttributesToFetch(null);
        this._isFetchingStoredProc = false;
        try {
            if (this._statement != null) {
                this._statement.close();
                this._statement = null;
            }
            if (this._resultSet != null) {
                this._resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            ((JDBCContext)this.adaptorContext())._jdbcErrorWithChannel(this, sQLException, true, "Unable to close ResultSet after completing fetch");
        }
        finally {
            this._resultSet = null;
        }
    }

    public boolean isFetchInProgress() {
        return this._fetchInProgress;
    }

    public NSArray describeResults() {
        int n;
        ResultSetMetaData resultSetMetaData;
        if (this._resultSet == null) {
            return NSArray.EmptyArray;
        }
        ResultSet resultSet = this._resultSet;
        NSMutableArray nSMutableArray = new NSMutableArray();
        try {
            resultSetMetaData = resultSet.getMetaData();
            n = resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            ((JDBCContext)this.adaptorContext())._jdbcErrorWithChannel(this, sQLException, true, "Unable to describe results");
            return NSArray.EmptyArray;
        }
        try {
            JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this.adaptorContext().adaptor();
            for (int i = 1; i <= n; ++i) {
                int n2;
                String string = this._modelObjectNameForDatabaseName(resultSetMetaData.getColumnName(i));
                try {
                    n2 = resultSetMetaData.getPrecision(i);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                EOAttribute eOAttribute = jDBCAdaptor.createAttribute(string, string, (short)resultSetMetaData.getColumnType(i), resultSetMetaData.getColumnTypeName(i), n2, resultSetMetaData.getScale(i), resultSetMetaData.isNullable(i));
                nSMutableArray.addObject((Object)eOAttribute);
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "Forwarding " + exception.toString();
            }
            throw new JDBCAdaptorException(string, null);
        }
        return nSMutableArray;
    }

    public void setAttributesToFetch(NSArray nSArray) {
        int n;
        this._attributes = nSArray;
        if (this._attributes == null || (n = this._attributes.count()) == 0) {
            return;
        }
        Object[] objectArray = new JDBCColumn[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new JDBCColumn((EOAttribute)this._attributes.objectAtIndex(i), this, i + 1, this._resultSet);
        }
        this._selectedColumns = new NSArray(objectArray);
    }

    public NSArray attributesToFetch() {
        return this._attributes;
    }

    public void cancelFetch() {
        if (this._fetchInProgress) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)"fetch canceled");
            }
            this._endFetch();
        }
        this._fetchAssociation = null;
    }

    NSArray _entityGroupForEntity(EOEntity eOEntity) {
        NSMutableArray nSMutableArray = new NSMutableArray();
        NSMutableArray nSMutableArray2 = new NSMutableArray();
        NSArray nSArray = eOEntity.subEntities();
        if (!eOEntity.isAbstractEntity() && eOEntity.externalName() != null) {
            nSMutableArray.addObject((Object)eOEntity);
            nSMutableArray2.addObject((Object)eOEntity.externalName());
        }
        if (nSArray != null) {
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                EOEntity eOEntity2 = (EOEntity)nSArray.objectAtIndex(i);
                NSArray nSArray2 = this._entityGroupForEntity(eOEntity2);
                int n2 = nSArray2.count();
                for (int j = 0; j < n2; ++j) {
                    EOEntity eOEntity3 = (EOEntity)nSArray2.objectAtIndex(j);
                    int n3 = nSMutableArray2.indexOfObject((Object)eOEntity3.externalName());
                    if (n3 != -1) continue;
                    nSMutableArray.addObject((Object)eOEntity3);
                    nSMutableArray2.addObject((Object)eOEntity3.externalName());
                }
            }
        }
        return nSMutableArray;
    }

    NSArray _fetchRowsForSQLExpressionAndAttributes(EOSQLExpression eOSQLExpression, NSArray nSArray) {
        NSMutableDictionary nSMutableDictionary;
        NSMutableArray nSMutableArray = new NSMutableArray();
        this.adaptorContext().transactionDidBegin();
        this.evaluateExpression(eOSQLExpression);
        if (this._errorEvaluateExpression) {
            this.adaptorContext().transactionDidRollback();
            this._errorEvaluateExpression = false;
            return null;
        }
        this.setAttributesToFetch(nSArray);
        do {
            if ((nSMutableDictionary = this.fetchRow()) == null) continue;
            nSMutableArray.addObject((Object)nSMutableDictionary);
        } while (nSMutableDictionary != null);
        this.cancelFetch();
        this.adaptorContext().transactionDidCommit();
        return nSMutableArray;
    }

    public NSDictionary primaryKeyForNewRowWithEntity(EOEntity eOEntity) {
        return (NSDictionary)this.primaryKeysForNewRowsWithEntity(1, eOEntity).lastObject();
    }

    public NSArray primaryKeysForNewRowsWithEntity(int n, EOEntity eOEntity) {
        return this._plugIn().newPrimaryKeys(n, eOEntity, this);
    }

    public NSArray describeTableNames() {
        Object object;
        String string;
        boolean bl = true;
        NSMutableArray nSMutableArray = new NSMutableArray();
        String string2 = this._plugIn().sqlStatementForGettingTableNames();
        if (string2 != null) {
            string = null;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)("using an SQL statement for getting table info [" + string2 + "]"));
            }
            this.evaluateExpression(this._expressionFactory().expressionForString(string2));
            if (!this._errorEvaluateExpression) {
                do {
                    if ((object = this._fetchOrderedRow(false)) == null || object.count() <= 0) continue;
                    nSMutableArray.addObject((Object)((String)object.objectAtIndex(0)).trim());
                } while (object != null);
                bl = false;
            } else {
                bl = true;
            }
        }
        if (bl) {
            try {
                String[] stringArray = this._plugIn().tableTypes();
                DatabaseMetaData databaseMetaData = this._dbMetaData();
                String string3 = this._plugIn().wildcardPatternForTables();
                String string4 = this._plugIn().wildcardPatternForSchema();
                String string5 = this._plugIn().primaryKeyTableName();
                ResultSet resultSet = databaseMetaData.getTables(null, string4, string3, stringArray);
                while (resultSet.next()) {
                    object = resultSet.getString(3);
                    if (((String)object).equals(string5)) continue;
                    string = resultSet.getString(2);
                    String string6 = resultSet.getString(4);
                    if (string != null && string.length() > 0 && !string.equals(string4)) {
                        object = string + "." + (String)object;
                    }
                    nSMutableArray.addObject(object);
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
        return nSMutableArray;
    }

    private DatabaseMetaData _dbMetaData() throws SQLException {
        if (this._dbMetaData == null) {
            this._dbMetaData = ((JDBCContext)this.adaptorContext()).connection().getMetaData();
        }
        return this._dbMetaData;
    }

    public NSArray describeStoredProcedureNames() {
        String string;
        String string2;
        boolean bl = true;
        NSMutableArray nSMutableArray = new NSMutableArray();
        String string3 = this._plugIn().sqlStatementForGettingProcedureNames();
        if (string3 != null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)("using an SQL statement for getting stored procedure info [" + string3 + "]"));
            }
            this.evaluateExpression(this._expressionFactory().expressionForString(string3));
            if (!this._errorEvaluateExpression) {
                do {
                    if ((string2 = this.fetchRow()) == null || string2.count() <= 0) continue;
                    string = (String)string2.objectForKey((Object)"name");
                    if (string != null) {
                        nSMutableArray.addObject((Object)string);
                        continue;
                    }
                    throw new RuntimeException("describeStoredProcedureNames failed: did not find a column named 'name' in the returned rows : " + string2);
                } while (string2 != null);
                bl = false;
            } else {
                bl = true;
            }
        }
        if (bl) {
            try {
                DatabaseMetaData databaseMetaData = this._dbMetaData();
                if (databaseMetaData.supportsStoredProcedures()) {
                    string2 = this._plugIn().storedProcedureCatalogPattern();
                    String string4 = this._plugIn().storedProcedureSchemaPattern();
                    ResultSet resultSet = databaseMetaData.getProcedures(string2, string4, null);
                    while (resultSet.next()) {
                        string = resultSet.getString("PROCEDURE_NAME");
                        String string5 = resultSet.getString("PROCEDURE_SCHEM");
                        if (string5 != null && string5.length() > 0) {
                            string = string5 + "." + string;
                        }
                        nSMutableArray.addObject((Object)string);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new JDBCAdaptorException(sQLException);
            }
        }
        return nSMutableArray;
    }

    private void _describeResultSet(ResultSet resultSet) {
        int n = 0;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            for (n = 1; n <= n2; ++n) {
                NSLog.debug.appendln((Object)("Column[" + n + "] name = " + resultSetMetaData.getColumnName(n) + " - Type = " + resultSetMetaData.getColumnTypeName(n)));
            }
        }
        catch (SQLException sQLException) {
            NSLog.debug.appendln((Object)("Error when trying to describe column : " + n));
        }
    }

    private void _jdbcGetAttributesForEntity(EOEntity eOEntity) {
        EOAttribute eOAttribute;
        String string;
        String string2;
        Object object;
        ResultSet resultSet;
        JDBCPlugIn jDBCPlugIn = this._plugIn();
        String string3 = jDBCPlugIn._tableNameForEntity(eOEntity);
        String string4 = jDBCPlugIn.schemaNameForEntity(eOEntity);
        String string5 = jDBCPlugIn.wildcardPatternForAttributes();
        try {
            resultSet = this._dbMetaData().getColumns(null, string4, string3, string5);
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            object = jDBCPlugIn.adaptor();
            while (resultSet.next()) {
                int n;
                string2 = resultSet.getString(4);
                if (jDBCPlugIn.isPseudoColumnName(string2)) continue;
                string = this._modelObjectNameForDatabaseName(string2);
                String string6 = resultSet.getString(6);
                int n2 = resultSet.getInt(7);
                int n3 = resultSet.getInt(9);
                short s = resultSet.getShort(5);
                int n4 = n = resultSet.getShort(11) == 1 ? 1 : 0;
                if (eOEntity.anyAttributeNamed(string) != null) continue;
                eOAttribute = ((JDBCAdaptor)((Object)object)).createAttribute(string, string2, s, string6, n2, n3, n);
                eOEntity.addAttribute(eOAttribute);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        try {
            resultSet = this._dbMetaData().getPrimaryKeys(null, string4, string3);
            while (resultSet.next()) {
                object = resultSet.getString(4);
                eOAttribute = eOEntity.attributeNamed(this._modelObjectNameForDatabaseName((String)object));
                if (eOAttribute == null) continue;
                string2 = eOEntity.primaryKeyAttributes();
                string = new NSMutableArray((Object)eOAttribute);
                if (string2 != null) {
                    string.addObjectsFromArray((NSArray)string2);
                }
                eOEntity.setPrimaryKeyAttributes((NSArray)string);
            }
            string2 = eOEntity.classProperties();
            string = eOEntity.primaryKeyAttributes();
            string2 = _NSArrayUtilities.arrayExcludingObjectsFromArray((NSArray)string2, (NSArray)string);
            eOEntity.setClassProperties((NSArray)string2);
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
    }

    private String _modelObjectNameForDatabaseName(String string) {
        if (string == null) {
            return null;
        }
        int n = (string = string.toUpperCase()).lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            if (Character.isJavaIdentifierPart(cArray[n])) continue;
            cArray[n] = 95;
        }
        return new String(cArray);
    }

    private void _getToOneRelationshipsForEntity(EOEntity eOEntity) {
        ResultSet resultSet;
        JDBCAdaptor jDBCAdaptor = (JDBCAdaptor)this.adaptorContext().adaptor();
        JDBCPlugIn jDBCPlugIn = this._plugIn();
        String string = jDBCPlugIn._tableNameForEntity(eOEntity);
        String string2 = jDBCPlugIn.schemaNameForEntity(eOEntity);
        try {
            resultSet = this._dbMetaData().getImportedKeys(null, string2, string);
        }
        catch (SQLException sQLException) {
            return;
        }
        if (resultSet == null) {
            return;
        }
        try {
            EORelationship eORelationship = null;
            while (resultSet.next()) {
                EOAttribute eOAttribute;
                String string3 = this._modelObjectNameForDatabaseName(resultSet.getString("FKCOLUMN_NAME"));
                String string4 = this._modelObjectNameForDatabaseName(resultSet.getString("PKTABLE_NAME"));
                String string5 = this._modelObjectNameForDatabaseName(resultSet.getString("PKCOLUMN_NAME"));
                EOAttribute eOAttribute2 = string3 != null ? eOEntity.attributeNamed(string3) : null;
                EOEntity eOEntity2 = string4 != null ? eOEntity.model().entityNamed(string4) : null;
                EOAttribute eOAttribute3 = eOAttribute = string5 != null && eOEntity2 != null ? eOEntity2.attributeNamed(string5) : null;
                if (eOAttribute2 == null || eOAttribute == null) continue;
                String string6 = eOEntity.name();
                EOJoin eOJoin = new EOJoin(eOAttribute2, eOAttribute);
                if (resultSet.getShort("KEY_SEQ") == 1) {
                    eORelationship = new EORelationship();
                    String string7 = string4;
                    int n = 0;
                    while (eOEntity.relationshipNamed(string7) != null) {
                        string7 = string4 + n;
                        ++n;
                    }
                    eORelationship.setName(string7);
                    eORelationship.setToMany(false);
                    eORelationship.setJoinSemantic(0);
                    eOEntity.addRelationship(eORelationship);
                }
                if (eORelationship == null) continue;
                eORelationship.addJoin(eOJoin);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOModel describeModelWithTableNames(NSArray nSArray) {
        EOModel eOModel = new EOModel();
        EOAdaptor eOAdaptor = this.adaptorContext().adaptor();
        ((JDBCContext)this.adaptorContext())._setAutoCommit(true);
        try {
            EOAttribute eOAttribute;
            int n;
            NSArray nSArray2;
            String string;
            NSArray nSArray3;
            int n2;
            eOModel.setAdaptorName(eOAdaptor.name());
            eOModel.setConnectionDictionary(eOAdaptor.connectionDictionary());
            int n3 = nSArray.count();
            for (n2 = 0; n2 < n3; ++n2) {
                nSArray3 = new EOEntity();
                string = (String)nSArray.objectAtIndex(n2);
                nSArray3.setName(this._modelObjectNameForDatabaseName(string));
                nSArray3.setExternalName(string);
                eOModel.addEntity((EOEntity)nSArray3);
                this._jdbcGetAttributesForEntity((EOEntity)nSArray3);
            }
            nSArray3 = eOModel.entities();
            n3 = nSArray3 == null ? 0 : nSArray3.count();
            for (n2 = 0; n2 < n3; ++n2) {
                string = (EOEntity)nSArray3.objectAtIndex(n2);
                this._getToOneRelationshipsForEntity((EOEntity)string);
                nSArray2 = string.attributesUsedForLocking();
                NSMutableArray nSMutableArray = null;
                n = nSArray2.count();
                for (int i = 0; i < n; ++i) {
                    eOAttribute = (EOAttribute)nSArray2.objectAtIndex(i);
                    if (eOAdaptor.isValidQualifierType(eOAttribute.externalType(), eOModel)) continue;
                    if (nSMutableArray == null) {
                        nSMutableArray = new NSMutableArray(nSArray2);
                    }
                    nSMutableArray.removeObject((Object)eOAttribute);
                }
                if (nSMutableArray == null) continue;
                string.setAttributesUsedForLocking(nSMutableArray);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = (EOEntity)nSArray3.objectAtIndex(n2);
                nSArray2 = string.relationships();
                int n4 = nSArray2 == null ? 0 : nSArray2.count();
                for (n = 0; n < n4; ++n) {
                    EORelationship eORelationship = (EORelationship)nSArray2.objectAtIndex(n);
                    if (eORelationship.isToMany() || (eOAttribute = eORelationship.inverseRelationship()) != null) continue;
                    this._addInverseToManyRelationship(eORelationship);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                string = (EOEntity)nSArray3.objectAtIndex(n2);
                nSArray2 = string.classProperties();
                int n5 = nSArray2.count();
                NSArray nSArray4 = string.relationships();
                int n6 = nSArray4 == null ? 0 : nSArray4.count();
                for (int i = 0; i < n6; ++i) {
                    EORelationship eORelationship = (EORelationship)nSArray4.objectAtIndex(i);
                    if (eORelationship.isToMany()) continue;
                    nSArray2 = _NSArrayUtilities.arrayExcludingObjectsFromArray((NSArray)nSArray2, (NSArray)eORelationship.sourceAttributes());
                }
                if (nSArray2.count() == n5) continue;
                string.setClassProperties(nSArray2);
            }
        }
        finally {
            ((JDBCContext)this.adaptorContext())._setAutoCommit(false);
        }
        return eOModel;
    }

    private void _addInverseToManyRelationship(EORelationship eORelationship) {
        EOEntity eOEntity = eORelationship.entity();
        EOEntity eOEntity2 = eORelationship.destinationEntity();
        if (eOEntity2 == null) {
            return;
        }
        NSArray nSArray = eORelationship.joins();
        EORelationship eORelationship2 = new EORelationship();
        String string = eOEntity.name();
        String string2 = string + "S";
        int n = 1;
        while (eOEntity2.relationshipNamed(string2) != null) {
            string2 = string + "S" + n;
            ++n;
        }
        eORelationship2.setToMany(true);
        eORelationship2.setName(string2);
        eORelationship2.setEntity(eOEntity2);
        int n2 = nSArray.count();
        for (n = 0; n < n2; ++n) {
            EOJoin eOJoin = (EOJoin)nSArray.objectAtIndex(n);
            EOJoin eOJoin2 = new EOJoin(eOJoin.destinationAttribute(), eOJoin.sourceAttribute());
            eORelationship2.addJoin(eOJoin2);
        }
        eOEntity2.addRelationship(eORelationship2);
    }

    public void addStoredProceduresNamed(NSArray nSArray, EOModel eOModel) {
        JDBCPlugIn jDBCPlugIn = this._plugIn();
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = (String)nSArray.objectAtIndex(i);
            if (string2.indexOf(46) >= 0) {
                string = string2.substring(0, string2.indexOf(46));
                string2 = string2.substring(string2.indexOf(46) + 1);
            } else {
                string = null;
            }
            EOStoredProcedure eOStoredProcedure = null;
            if (jDBCPlugIn.canDescribeStoredProcedure(string2)) {
                eOStoredProcedure = jDBCPlugIn.storedProcedureNamed(string2, this, null);
            }
            if (eOStoredProcedure == null) {
                eOStoredProcedure = new EOStoredProcedure(this._modelObjectNameForDatabaseName(string2));
                NSMutableArray nSMutableArray = new NSMutableArray();
                eOStoredProcedure.setExternalName(string2);
                try {
                    JDBCAdaptor jDBCAdaptor = jDBCPlugIn.adaptor();
                    ResultSet resultSet = this._dbMetaData().getProcedureColumns(null, string, string2, null);
                    int n2 = 0;
                    while (resultSet.next()) {
                        int n3;
                        ++n2;
                        String string3 = resultSet.getString("COLUMN_NAME");
                        if (string3 == null) {
                            string3 = "Param" + Integer.toString(n2);
                        } else if (string3.startsWith("@")) {
                            string3 = string3.substring(1);
                        }
                        String string4 = resultSet.getString("TYPE_NAME");
                        short s = resultSet.getShort("DATA_TYPE");
                        int n4 = resultSet.getInt("PRECISION");
                        int n5 = resultSet.getInt("SCALE");
                        int n6 = resultSet.getInt("LENGTH");
                        if (n6 > n4) {
                            n4 = n6;
                        }
                        int n7 = n3 = resultSet.getShort("NULLABLE") == 1 ? 1 : 0;
                        String string5 = n2 < 10 ? "00" + String.valueOf(n2) : (n2 < 100 ? "0" + String.valueOf(n2) : String.valueOf(n2));
                        EOAttribute eOAttribute = jDBCAdaptor.createAttribute(string3, string5, s, string4, n4, n5, n3);
                        switch (resultSet.getShort("COLUMN_TYPE")) {
                            case 0: 
                            case 1: {
                                eOAttribute.setParameterDirection(1);
                                break;
                            }
                            case 4: {
                                eOAttribute.setParameterDirection(2);
                                break;
                            }
                            case 2: {
                                eOAttribute.setParameterDirection(3);
                                break;
                            }
                            case 5: {
                                eOAttribute.setParameterDirection(2);
                                eOAttribute.setColumnName("000");
                                eOAttribute.setName("returnValue");
                                --n2;
                                break;
                            }
                        }
                        nSMutableArray.addObject((Object)eOAttribute);
                    }
                    eOStoredProcedure.setArguments((NSArray)nSMutableArray);
                    eOModel.addStoredProcedure(eOStoredProcedure);
                    continue;
                }
                catch (SQLException sQLException) {
                    throw new JDBCAdaptorException(sQLException);
                }
            }
            eOModel.addStoredProcedure(eOStoredProcedure);
        }
    }

    public void executeStoredProcedure(EOStoredProcedure eOStoredProcedure, NSDictionary nSDictionary) {
        int n;
        Object object;
        EOAttribute eOAttribute = null;
        NSArray nSArray = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)eOStoredProcedure.arguments(), (NSArray)new NSArray((Object)new EOSortOrdering("columnName", EOSortOrdering.CompareAscending)));
        if (this._delegateRespondsTo_shouldExecuteStoredProcedure && (object = (NSDictionary)this._delegate.perform("adaptorChannelShouldExecuteStoredProcedure", (Object)this, (Object)eOStoredProcedure, (Object)nSDictionary)) != null) {
            nSDictionary = object;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
            NSLog.debug.appendln((Object)("executeStoredProcedure: " + eOStoredProcedure.name() + " withValues:" + nSDictionary));
        }
        NSMutableArray nSMutableArray = new NSMutableArray();
        StringBuffer stringBuffer = new StringBuffer(128);
        int n2 = nSArray.count();
        for (n = 0; n < n2; ++n) {
            int n3 = -1;
            EOAttribute eOAttribute2 = (EOAttribute)nSArray.objectAtIndex(n);
            if (eOAttribute == null) {
                try {
                    n3 = Integer.parseInt(eOAttribute2.columnName());
                    if (n3 == 0) {
                        eOAttribute = eOAttribute2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = -1;
                }
            } else {
                n3 = -1;
            }
            if (n3 == -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(' ');
                }
                stringBuffer.append('?');
            }
            String string = eOAttribute2.name();
            if (nSDictionary == null || (object = nSDictionary.objectForKey((Object)string)) == null) {
                object = NSKeyValueCoding.NullValue;
            }
            NSMutableDictionary nSMutableDictionary = new NSMutableDictionary();
            nSMutableDictionary.setObjectForKey((Object)string, (Object)"BindVariableName");
            nSMutableDictionary.setObjectForKey((Object)eOAttribute2, (Object)"BindVariableAttribute");
            nSMutableDictionary.setObjectForKey(object, (Object)"BindVariableValue");
            nSMutableArray.addObject((Object)nSMutableDictionary);
        }
        StringBuffer stringBuffer2 = eOAttribute != null ? new StringBuffer("? = ") : null;
        int n4 = stringBuffer.length();
        if (n4 > 0) {
            stringBuffer.insert(0, '(');
            stringBuffer.append(')');
            n4 += 2;
        }
        String string = eOStoredProcedure.externalName();
        int n5 = (stringBuffer2 != null ? stringBuffer2.length() : 0) + string.length() + n4 + 8;
        StringBuffer stringBuffer3 = new StringBuffer(n5);
        stringBuffer3.append("{ ");
        if (stringBuffer2 != null) {
            stringBuffer3.append(new String(stringBuffer2));
        }
        stringBuffer3.append("call ");
        stringBuffer3.append(string);
        if (n4 > 0) {
            stringBuffer3.append(' ');
            stringBuffer3.append(new String(stringBuffer));
        }
        stringBuffer3.append('}');
        JDBCExpression jDBCExpression = (JDBCExpression)this._expressionFactory().expressionForString(new String(stringBuffer3));
        n2 = nSMutableArray.count();
        for (n = 0; n < n2; ++n) {
            jDBCExpression.addBindVariableDictionary((NSDictionary)((NSMutableDictionary)nSMutableArray.objectAtIndex(n)));
        }
        this._storedProcedureBindings = jDBCExpression.bindVariableDictionaries();
        this._evaluateExpression(jDBCExpression, true, false);
        if (this._errorEvaluateExpression) {
            throw new JDBCAdaptorException(" ** Error when executing storedProcedure " + eOStoredProcedure.externalName(), null);
        }
        if (this.isFetchInProgress()) {
            this._isFetchingStoredProc = true;
        }
        if (this._delegateRespondsTo_didExecuteStoredProcedure) {
            this._delegate.perform("adaptorChannelDidExecuteStoredProcedure", (Object)this, (Object)eOStoredProcedure, (Object)nSDictionary);
        }
    }

    public NSDictionary returnValuesForLastStoredProcedureInvocation() {
        NSMutableDictionary nSMutableDictionary;
        NSDictionary nSDictionary;
        if (this._isFetchingStoredProc) {
            return null;
        }
        if (this._delegateRespondsTo_shouldConstructStoredProcedureReturnValues && (nSDictionary = (NSDictionary)this._delegate.perform("adaptorChannelShouldConstructStoredProcedureReturnValues", (Object)this)) != null) {
            return nSDictionary;
        }
        if (this._storedProcedureBindings == null) {
            nSMutableDictionary = null;
        } else {
            try {
                if (this._statement.getMoreResults()) {
                    ((JDBCContext)this.adaptorContext())._jdbcErrorWithChannel(this, null, true, "More results pending in returnValuesForLastStoredProcedureInvocation()");
                    return null;
                }
            }
            catch (SQLException sQLException) {
                ((JDBCContext)this.adaptorContext())._jdbcErrorWithChannel(this, sQLException, true, "Exception raised when getting more results in returnValuesForLastStoredProcedureInvocation()");
                return null;
            }
            nSMutableDictionary = new NSMutableDictionary();
            int n = this._storedProcedureBindings.count();
            CallableStatement callableStatement = (CallableStatement)this._statement;
            for (int i = 0; i < n; ++i) {
                NSDictionary nSDictionary2 = (NSDictionary)this._storedProcedureBindings.objectAtIndex(i);
                EOAttribute eOAttribute = (EOAttribute)nSDictionary2.objectForKey((Object)"BindVariableAttribute");
                int n2 = eOAttribute.parameterDirection();
                if (n2 != 2 && n2 != 3) continue;
                String string = eOAttribute.name();
                Object object = this._inputColumn.getStoredProcedureValue(eOAttribute, i + 1, callableStatement);
                nSMutableDictionary.setObjectForKey(object, (Object)string);
            }
        }
        if (this.delegate() != null && this._delegateRespondsTo_shouldReturnValuesForStoredProcedure && (nSDictionary = (NSDictionary)this._delegate.perform("adaptorChannelShouldReturnValuesForStoredProcedure", (Object)this, (Object)nSMutableDictionary)) != null) {
            return nSDictionary;
        }
        this._storedProcedureBindings = null;
        return nSMutableDictionary;
    }

    public NSMutableDictionary fetchRow() {
        NSMutableDictionary nSMutableDictionary;
        if (!this._fetchInProgress) {
            return null;
        }
        if (this._rowsProcessedCount == 0) {
            if (this._attributes == null) {
                this.setAttributesToFetch(this.describeResults());
            }
            this._fetchColumnCount = this._attributes.count();
            this._fetchAssociation = new JDBCFetchPrivate(this._fetchColumnCount);
        }
        if (this._delegateRespondsTo_willFetchRow) {
            this._delegate.perform("adaptorChannelWillFetchRow", (Object)this);
        }
        try {
            if (this._resultSet == null) {
                return null;
            }
            boolean bl = this._resultSet.next();
            if (!bl) {
                this._resultSet.clearWarnings();
                this._endFetch();
                return null;
            }
            for (int i = 0; i < this._fetchColumnCount; ++i) {
                this._fetchAssociation.setValueForColumn(((JDBCColumn)this._selectedColumns.objectAtIndex(i)).fetchValue(), i);
            }
            nSMutableDictionary = this.dictionaryWithObjectsForAttributes(this._fetchAssociation.values, this._attributes);
            if (nSMutableDictionary != null) {
                ++this._rowsProcessedCount;
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        if (this._delegateRespondsTo_didFetchRow) {
            this._delegate.perform("adaptorChannelDidFetchRow", (Object)this, (Object)nSMutableDictionary);
        }
        return nSMutableDictionary;
    }

    public int rowsProcessedCount() {
        return this._rowsProcessedCount;
    }

    NSArray _fetchOrderedRow(boolean bl) {
        NSMutableArray nSMutableArray = new NSMutableArray();
        if (!this._fetchInProgress) {
            return null;
        }
        if (this._rowsProcessedCount == 0) {
            if (this._attributes == null) {
                this.setAttributesToFetch(this.describeResults());
            }
            this._fetchColumnCount = this._attributes.count();
        }
        try {
            if (this._resultSet == null) {
                return null;
            }
            boolean bl2 = this._resultSet.next();
            if (!bl2) {
                this._resultSet.clearWarnings();
                this._endFetch();
                return null;
            }
            for (int i = 0; i < this._fetchColumnCount; ++i) {
                nSMutableArray.addObject(((JDBCColumn)this._selectedColumns.objectAtIndex(i))._fetchValue(bl));
            }
            if (nSMutableArray.count() != 0) {
                ++this._rowsProcessedCount;
            }
        }
        catch (SQLException sQLException) {
            throw new JDBCAdaptorException(sQLException);
        }
        return nSMutableArray;
    }
}

