/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.jdbcadaptor;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCExpression;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySQLPlugIn
extends JDBCPlugIn {
    private static final String DriverClassName = "org.gjt.mm.mysql.Driver";
    private static final String DriverProductName = "MySQL";

    public MySQLPlugIn(JDBCAdaptor jDBCAdaptor) {
        super(jDBCAdaptor);
    }

    public String defaultDriverName() {
        return DriverClassName;
    }

    public String databaseProductName() {
        return DriverProductName;
    }

    public Class defaultExpressionClass() {
        return MySQLExpression.class;
    }

    public EOSynchronizationFactory createSynchronizationFactory() {
        return new MySQLSynchronizationFactory(this._adaptor);
    }

    public NSDictionary jdbcInfo() {
        boolean bl = NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L);
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(super.jdbcInfo());
        NSMutableDictionary nSMutableDictionary2 = new NSMutableDictionary((NSDictionary)nSMutableDictionary.objectForKey((Object)"typeInfo"));
        JDBCPlugIn._takeValueForKeyPath(nSMutableDictionary2, "0", "BLOB", "createParams");
        JDBCPlugIn._takeValueForKeyPath(nSMutableDictionary2, "0", "LONGBLOB", "createParams");
        JDBCPlugIn._takeValueForKeyPath(nSMutableDictionary2, "0", "MEDIUMBLOB", "createParams");
        JDBCPlugIn._takeValueForKeyPath(nSMutableDictionary2, "0", "TINYBLOB", "createParams");
        nSMutableDictionary.setObjectForKey((Object)nSMutableDictionary2, (Object)"typeInfo");
        if (bl) {
            NSLog.debug.appendln((Object)("fetched MySQL (" + this.databaseProductName() + ") JDBC Info = " + nSMutableDictionary));
        }
        return nSMutableDictionary;
    }

    public Object fetchBLOB(ResultSet resultSet, int n, EOAttribute eOAttribute, boolean bl) throws SQLException {
        NSData nSData = null;
        Blob blob = resultSet.getBlob(n);
        if (blob == null) {
            return null;
        }
        if (!bl) {
            return blob;
        }
        try {
            InputStream inputStream = blob.getBinaryStream();
            int n2 = (int)blob.length();
            nSData = n2 == 0 ? NSData.EmptyData : new NSData(inputStream, n2);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new JDBCAdaptorException(iOException.getMessage(), null);
        }
        return nSData;
    }

    public static class MySQLExpression
    extends JDBCExpression {
        public MySQLExpression(EOEntity eOEntity) {
            super(eOEntity);
        }

        public char sqlEscapeChar() {
            return '|';
        }
    }

    public static class MySQLSynchronizationFactory
    extends EOSynchronizationFactory {
        public MySQLSynchronizationFactory(EOAdaptor eOAdaptor) {
            super(eOAdaptor);
        }

        public NSArray primaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            String string = ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName();
            NSMutableArray nSMutableArray = new NSMutableArray();
            nSMutableArray.addObject((Object)this._expressionForString("CREATE TABLE " + string + " (NAME CHAR(40) PRIMARY KEY, PK INT)"));
            return nSMutableArray;
        }

        public NSArray dropPrimaryKeySupportStatementsForEntityGroups(NSArray nSArray) {
            return new NSArray((Object)this._expressionForString("DROP TABLE " + ((JDBCAdaptor)this.adaptor()).plugIn().primaryKeyTableName() + " CASCADE"));
        }

        public NSArray _statementsToDropPrimaryKeyConstraintsOnTableNamed(String string) {
            return new NSArray((Object)this._expressionForString("alter table " + string + " drop primary key"));
        }

        public NSArray foreignKeyConstraintStatementsForRelationship(EORelationship eORelationship) {
            return null;
        }

        public NSArray statementsToRenameTableNamed(String string, String string2, NSDictionary nSDictionary) {
            return new NSArray((Object)this._expressionForString("rename table " + string + " to " + string2));
        }

        public boolean supportsSchemaSynchronization() {
            return true;
        }
    }
}

