/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSDelegate;

public abstract class EOAdaptorContext {
    public static final String AdaptorContextBeginTransactionNotification = "EOAdaptorContextBeginTransactionNotification";
    public static final String AdaptorContextCommitTransactionNotification = "EOAdaptorContextCommitTransactionNotification";
    public static final String AdaptorContextRollbackTransactionNotification = "EOAdaptorContextRollbackTransactionNotification";
    private static final NSSelector _defaultDelegateSelector = new NSSelector("defaultDelegate", null);
    protected EOAdaptor _adaptor;
    protected NSMutableArray _channels;
    protected _NSDelegate _delegate = new _NSDelegate(Delegate.class);
    protected boolean _hasOpenTransaction;
    protected boolean _delegateRespondsTo_shouldConnect;
    protected boolean _delegateRespondsTo_shouldBegin;
    protected boolean _delegateRespondsTo_didBegin;
    protected boolean _delegateRespondsTo_shouldCommit;
    protected boolean _delegateRespondsTo_didCommit;
    protected boolean _delegateRespondsTo_shouldRollback;
    protected boolean _delegateRespondsTo_didRollback;
    private static volatile Object defaultAdaptorContextDelegate = null;
    private static volatile Object _defaultAdaptorContextDelegate = null;

    public static void setDefaultDelegate(Object delegate) {
        _defaultAdaptorContextDelegate = delegate;
    }

    public static Object defaultDelegate() {
        return _defaultAdaptorContextDelegate;
    }

    public EOAdaptorContext(EOAdaptor adaptor) {
        adaptor._registerAdaptorContext(this);
        this._adaptor = adaptor;
        this._channels = new NSMutableArray();
        Object delegate = NSSelector._safeInvokeSelector((NSSelector)_defaultDelegateSelector, this.getClass(), null);
        if (delegate != null) {
            this.setDelegate(delegate);
        }
    }

    public abstract void handleDroppedConnection();

    public abstract void beginTransaction();

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public int transactionNestingLevel() {
        return this._hasOpenTransaction ? 1 : 0;
    }

    public boolean hasOpenTransaction() {
        return this._hasOpenTransaction;
    }

    public void transactionDidBegin() {
        if (!this._hasOpenTransaction) {
            this._hasOpenTransaction = true;
            NSNotificationCenter.defaultCenter().postNotification(AdaptorContextBeginTransactionNotification, (Object)this);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)" === Begin Internal Transaction");
            }
        }
    }

    public void transactionDidCommit() {
        if (this._hasOpenTransaction) {
            this._hasOpenTransaction = false;
            NSNotificationCenter.defaultCenter().postNotification(AdaptorContextCommitTransactionNotification, (Object)this);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)" === Commit Internal Transaction");
            }
        }
    }

    public void transactionDidRollback() {
        if (this._hasOpenTransaction) {
            this._hasOpenTransaction = false;
            NSNotificationCenter.defaultCenter().postNotification(AdaptorContextRollbackTransactionNotification, (Object)this);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65536L)) {
                NSLog.debug.appendln((Object)" === Rollback Internal Transaction");
            }
        }
    }

    public boolean hasBusyChannels() {
        for (int i = 0; i < this._channels.count(); ++i) {
            EOAdaptorChannel channel = (EOAdaptorChannel)this._channels.objectAtIndex(i);
            if (!channel.isFetchInProgress()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOpenChannels() {
        for (int i = 0; i < this._channels.count(); ++i) {
            EOAdaptorChannel channel = (EOAdaptorChannel)this._channels.objectAtIndex(i);
            if (!channel.isOpen()) continue;
            return true;
        }
        return false;
    }

    public NSArray channels() {
        NSMutableArray channels = null;
        if (this._channels != null) {
            int cnt = this._channels.count();
            channels = new NSMutableArray(cnt);
            for (int i = cnt - 1; i >= 0; --i) {
                channels.addObject(this._channels.objectAtIndex(i));
            }
        }
        return channels;
    }

    public EOAdaptor adaptor() {
        return this._adaptor;
    }

    public abstract EOAdaptorChannel createAdaptorChannel();

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setDelegate(Object delegate) {
        if (this._delegate != delegate) {
            boolean b;
            this._delegate.setDelegate(delegate);
            this._delegateRespondsTo_shouldConnect = b = this._delegate.respondsTo("adaptorContextShouldConnect");
            this._delegateRespondsTo_shouldBegin = b = this._delegate.respondsTo("adaptorContextShouldBegin");
            this._delegateRespondsTo_didBegin = b = this._delegate.respondsTo("adaptorContextDidBegin");
            this._delegateRespondsTo_shouldCommit = b = this._delegate.respondsTo("adaptorContextShouldCommit");
            this._delegateRespondsTo_didCommit = b = this._delegate.respondsTo("adaptorContextDidCommit");
            this._delegateRespondsTo_shouldRollback = b = this._delegate.respondsTo("adaptorContextShouldRollback");
            this._delegateRespondsTo_didRollback = b = this._delegate.respondsTo("adaptorContextDidRollback");
            for (int i = this._channels.count() - 1; i >= 0; --i) {
                ((EOAdaptorChannel)this._channels.objectAtIndex(i)).setDelegate(delegate);
            }
        }
    }

    public void _registerAdaptorChannel(EOAdaptorChannel channel) {
        this._channels.addObject((Object)channel);
        channel.setDelegate(this.delegate());
    }

    public void _unregisterAdaptorChannel(EOAdaptorChannel channel) {
        for (int i = this._channels.count() - 1; i >= 0; --i) {
            if (channel != this._channels.objectAtIndex(i)) continue;
            this._channels.removeObjectAtIndex(i);
        }
    }

    public boolean canNestTransactions() {
        return false;
    }

    public NSDictionary _newPrimaryKey(EOEnterpriseObject object, EOEntity entity) {
        return null;
    }

    public static interface Delegate {
        public boolean adaptorContextShouldConnect(EOAdaptorContext var1);

        public boolean adaptorContextShouldBegin(EOAdaptorContext var1);

        public void adaptorContextDidBegin(EOAdaptorContext var1);

        public boolean adaptorContextShouldCommit(EOAdaptorContext var1);

        public void adaptorContextDidCommit(EOAdaptorContext var1);

        public boolean adaptorContextShouldRollback(EOAdaptorContext var1);

        public void adaptorContextDidRollback(EOAdaptorContext var1);
    }
}

