/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAccessArrayFaultHandler;
import com.webobjects.eoaccess.EOAccessFaultHandler;
import com.webobjects.eoaccess.EOAccessGenericFaultHandler;
import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAdaptorOpComparator;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseOperation;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess._EODBCtxEntityInfo;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eoaccess._EOStringUtil;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOCustomObject;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOEvent;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFaulting;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueCodingAdditions;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOObserverCenter;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.eocontrol._EOCheapCopyMutableArray;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLocking;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakValueMutableDictionary;
import java.lang.ref.ReferenceQueue;
import java.util.Enumeration;

public class EODatabaseContext
extends EOCooperatingObjectStore
implements NSLocking {
    protected EODatabase _database;
    protected EOAdaptorContext _adaptorContext;
    protected int _updateStrategy;
    protected NSMutableDictionary _uniqueTable;
    protected NSMutableSet _deleteTable;
    protected NSMutableArray _registeredChannels;
    protected NSMutableDictionary _dbOperationsByGlobalID;
    private NSRecursiveLock _dbcLock;
    protected EOEditingContext _editingContext;
    protected NSMutableSet _lockedObjects;
    protected int _currentGeneration;
    protected int _concurrentFetches;
    protected _NSWeakValueMutableDictionary _batchFaultBuffer;
    protected _NSWeakValueMutableDictionary _batchToManyFaultBuffer;
    protected EOEntity _lastEntity;
    protected EOGlobalID _currentGlobalID;
    protected NSDictionary _currentSnapshot;
    protected Object _currentBatch;
    protected NSMutableDictionary _uniqueArrayTable;
    protected NSMutableSet _nonPrimaryKeyGenerators;
    protected NSMutableSet _missingObjectGIDs;
    protected NSMutableArray _checkPropagatedPKs;
    protected boolean _flags_willPrepareForSave;
    protected boolean _flags_preparingForSave;
    protected boolean _flags_beganTransaction;
    protected boolean _flags_ignoreEntityCaching;
    protected boolean _flags_hasPreloadedShared;
    protected _NSDelegate _delegate;
    private static final String _databaseContextWillRunLoginPanelToOpenDatabaseChannel = "databaseContextWillRunLoginPanelToOpenDatabaseChannel";
    private static final String _databaseContextNewPrimaryKey = "databaseContextNewPrimaryKey";
    private static final String _databaseContextWillPerformAdaptorOperations = "databaseContextWillPerformAdaptorOperations";
    private static final String _databaseContextShouldInvalidateObjectWithGlobalID = "databaseContextShouldInvalidateObjectWithGlobalID";
    private static final String _databaseContextWillOrderAdaptorOperations = "databaseContextWillOrderAdaptorOperations";
    private static final String _databaseContextShouldLockObjectWithGlobalID = "databaseContextShouldLockObjectWithGlobalID";
    private static final String _databaseContextShouldRaiseExceptionForLockFailure = "databaseContextShouldRaiseExceptionForLockFailure";
    private static final String _databaseContextShouldFetchObjects = "databaseContextShouldFetchObjects";
    private static final String _databaseContextDidFetchObjects = "databaseContextDidFetchObjects";
    private static final String _databaseContextShouldFetchObjectFault = "databaseContextShouldFetchObjectFault";
    private static final String _databaseContextShouldFetchArrayFault = "databaseContextShouldFetchArrayFault";
    private static final String _databaseContextWillFireObjectFaultForGlobalID = "databaseContextWillFireObjectFaultForGlobalID";
    private static final String _databaseContextWillFireArrayFaultForGlobalID = "databaseContextWillFireArrayFaultForGlobalID";
    private static final String _databaseContextShouldHandleDatabaseException = "databaseContextShouldHandleDatabaseException";
    private static final String _databaseContextShouldUsePessimisticLock = "databaseContextShouldUsePessimisticLock";
    private static final String _databaseContextShouldSelectObjects = "databaseContextShouldSelectObjects";
    private static final String _databaseContextDidSelectObjects = "databaseContextDidSelectObjects";
    private static final String _databaseContextShouldUpdateCurrentSnapshot = "databaseContextShouldUpdateCurrentSnapshot";
    private static final String _databaseContextFailedToFetchObject = "databaseContextFailedToFetchObject";
    protected boolean _delegateRespondsTo_shouldUpdateCurrentSnapshot = false;
    public static final int UpdateWithOptimisticLocking = 0;
    public static final int UpdateWithPessimisticLocking = 1;
    public static final int UpdateWithNoLocking = 2;
    private static final int DefaultIntermediateRowCount = 64;
    private static volatile boolean _useToManyCaching = true;
    protected static volatile int _lazyFaultDebugLevel = 0;
    private static volatile boolean _autoLoadSharedObjects = true;
    private static final NSMutableArray _sharedObjectsLoadedInModels = new NSMutableArray();
    private final ReferenceQueue _refQueueForHandlers = new ReferenceQueue();
    public static final String DatabaseChannelNeededNotification = "EODatabaseChannelNeededNotification";
    public static final String CustomQueryExpressionHintKey = "EOCustomQueryExpressionHintKey";
    public static final String StoredProcedureNameHintKey = "EOStoredProcedureNameHintKey";
    private static final NSSelector _beginTransactionSelector = new NSSelector("_beginTransaction", _NSUtilities._NotificationClassArray);
    private static final NSSelector _commitTransactionSelector = new NSSelector("_commitTransaction", _NSUtilities._NotificationClassArray);
    private static final NSSelector _rollbackTransactionSelector = new NSSelector("_rollbackTransaction", _NSUtilities._NotificationClassArray);
    private static final NSSelector _defaultDelegateSelector = new NSSelector("defaultDelegate", null);
    private static final NSSelector _snapshotsChangedInDatabaseSelector = new NSSelector("_snapshotsChangedInDatabase", _NSUtilities._NotificationClassArray);
    private static final NSSelector _objectsChangedSelector = new NSSelector("_objectsChanged", _NSUtilities._NotificationClassArray);
    private static final NSSelector _cooperatingObjectStoreNeededSelector = new NSSelector("_cooperatingObjectStoreNeeded", _NSUtilities._NotificationClassArray);
    private static final NSSelector _registeredDatabaseContextForModelSelector = new NSSelector("registeredDatabaseContextForModel", new Class[]{EOModel.class, EOObjectStoreCoordinator.class});
    private static final NSSelector _editingContextShouldContinueFetchingSelector = new NSSelector("editingContextShouldContinueFetching", new Class[]{EOEditingContext.class, Integer.TYPE, Integer.TYPE, EOObjectStore.class});
    private static final NSSelector _entityNamedSelector = new NSSelector("entityNamed", _NSUtilities._StringClassArray);
    private static final NSSelector _recordChangesInEditingContextSelector = new NSSelector("recordChangesInEditingContext", null);
    private static final NSSelector _recordUpdateForObjectChangesSelector = new NSSelector("recordUpdateForObjectChanges", null);
    private static final NSSelector _performChangesSelector = new NSSelector("performChanges", null);
    private static final NSSelector _commitChangesSelector = new NSSelector("commitChanges", null);
    private static volatile Object _defaultDatabaseContextDelegate = null;
    protected static volatile boolean _IsEventLoggingEnabled = false;
    protected static Class _contextClassToRegister = null;
    protected static boolean _suppressRedundantEODatabaseChangeNotification = true;
    private static boolean warnedOnce;
    public static final String DatabaseContextKey = "EODatabaseContextKey";
    public static final String DatabaseOperationsKey = "EODatabaseOperationsKey";
    public static final String FailedDatabaseOperationKey = "EOFailedDatabaseOperationKey";
    private static final String _EOFRootEntityString_ = "__EOF_root__";
    private static final String entityOrderingKey = "EOEntityOrdering";

    public static void setDefaultDelegate(Object defaultDelegate) {
        _defaultDatabaseContextDelegate = defaultDelegate;
    }

    public static Object defaultDelegate() {
        return _defaultDatabaseContextDelegate;
    }

    public static void setSharedObjectLoadingEnabled(boolean bool) {
        _autoLoadSharedObjects = bool;
    }

    public static boolean isSharedObjectLoadingEnabled() {
        return _autoLoadSharedObjects;
    }

    public static void _setUseToManyCaching(boolean bool) {
        _useToManyCaching = bool;
    }

    public void _registerForAdaptorContextNotifications(EOAdaptorContext adaptorContext) {
        NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
        notificationCenter.addObserver((Object)this, _beginTransactionSelector, "EOAdaptorContextBeginTransactionNotification", (Object)adaptorContext);
        notificationCenter.addObserver((Object)this, _commitTransactionSelector, "EOAdaptorContextCommitTransactionNotification", (Object)adaptorContext);
        notificationCenter.addObserver((Object)this, _rollbackTransactionSelector, "EOAdaptorContextRollbackTransactionNotification", (Object)adaptorContext);
    }

    public void _unregisterForAdaptorContextNotifications(EOAdaptorContext adaptorContext) {
        NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
        notificationCenter.removeObserver((Object)this, "EOAdaptorContextBeginTransactionNotification", (Object)adaptorContext);
        notificationCenter.removeObserver((Object)this, "EOAdaptorContextCommitTransactionNotification", (Object)adaptorContext);
        notificationCenter.removeObserver((Object)this, "EOAdaptorContextRollbackTransactionNotification", (Object)adaptorContext);
    }

    public EODatabaseContext(EODatabase database) {
        if (database == null) {
            throw new IllegalArgumentException("An EODatabaseContext can only be created with a valid EODatabase parameter.");
        }
        this._delegate = new _NSDelegate(Delegate.class);
        EOAdaptor adaptor = database.adaptor();
        this._adaptorContext = adaptor.createAdaptorContext();
        if (this._adaptorContext == null) {
            throw new IllegalStateException("EODatabaseContext: " + database.getClass().getName() + " " + database + " is unable to obtain new context from " + adaptor.getClass().getName() + " " + adaptor);
        }
        this._database = database;
        this._dbcLock = null;
        database.registerContext(this);
        this.setUpdateStrategy(0);
        this._registeredChannels = new NSMutableArray();
        this._currentGeneration = 1;
        this._concurrentFetches = 0;
        this._flags_hasPreloadedShared = false;
        this._batchFaultBuffer = new _NSWeakValueMutableDictionary(10);
        this._batchToManyFaultBuffer = new _NSWeakValueMutableDictionary(10);
        this._missingObjectGIDs = new NSMutableSet();
        Object delegate = NSSelector._safeInvokeSelector((NSSelector)_defaultDelegateSelector, ((Object)((Object)this)).getClass(), null);
        if (delegate != null) {
            this._setDelegate(delegate);
        }
        NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
        notificationCenter.addObserver((Object)this, _snapshotsChangedInDatabaseSelector, "EOObjectsChangedInStoreNotification", (Object)this._database);
        notificationCenter.addObserver((Object)this, _objectsChangedSelector, "EOObjectsChangedInStoreNotification", (Object)this);
        this._registerForAdaptorContextNotifications(this._adaptorContext);
    }

    public void dispose() {
        super.dispose();
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
    }

    public static void _setSuppressRedundantEODatabaseChangeNotification(boolean bool) {
        _suppressRedundantEODatabaseChangeNotification = bool;
    }

    public static Class contextClassToRegister() {
        return _contextClassToRegister;
    }

    public static void setContextClassToRegister(Class contextClass) {
        _contextClassToRegister = contextClass;
    }

    ReferenceQueue _referenceQueueForHandlers() {
        return this._refQueueForHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EODatabaseContext registeredDatabaseContextForModel(EOModel model, EOObjectStoreCoordinator coordinator) {
        EODatabaseContext dbc = null;
        coordinator.lock();
        try {
            NSArray objectStores = coordinator.cooperatingObjectStores();
            int c = objectStores.count();
            for (int i = 0; i < c; ++i) {
                Object objectStore = objectStores.objectAtIndex(i);
                if (!(objectStore instanceof EODatabaseContext) || !((EODatabaseContext)((Object)objectStore)).database().addModelIfCompatible(model)) continue;
                dbc = (EODatabaseContext)((Object)objectStore);
            }
            if (dbc == null) {
                dbc = (EODatabaseContext)((Object)_NSUtilities.instantiateObject((Class)EODatabaseContext.contextClassToRegister(), (Class[])new Class[]{EODatabase.class}, (Object[])new Object[]{new EODatabase(model)}, (boolean)true, (boolean)false));
                coordinator.addCooperatingObjectStore((EOCooperatingObjectStore)dbc);
            }
            EODatabaseContext._preloadSharedObjectsWithModel(model);
            EODatabaseContext eODatabaseContext = dbc;
            return eODatabaseContext;
        }
        finally {
            coordinator.unlock();
        }
    }

    public static EODatabaseContext registeredDatabaseContextForModel(EOModel model, EOEditingContext editingContext) {
        EOObjectStore root;
        EOObjectStore eOObjectStore = root = editingContext != null ? editingContext.rootObjectStore() : null;
        if (root instanceof EOObjectStoreCoordinator) {
            return EODatabaseContext.registeredDatabaseContextForModel(model, (EOObjectStoreCoordinator)root);
        }
        if (root instanceof EODatabaseContext && ((EODatabaseContext)root).database().addModelIfCompatible(model)) {
            return (EODatabaseContext)root;
        }
        throw new IllegalStateException("registeredDatabaseContextForModel() Cannot register the database context for the model " + model.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EODatabaseContext forceConnectionWithModel(EOModel model, NSDictionary overrides, EOEditingContext editingContext) {
        NSDictionary connDict;
        EOAdaptor adaptor = null;
        EODatabase db = null;
        EODatabaseContext dbContext = null;
        NSDictionary modelConnDict = model.connectionDictionary();
        EOObjectStore rootObjectStore = editingContext.rootObjectStore();
        if (model == null) {
            throw new IllegalArgumentException("forceConnectionWithModel -- EODatabaseContext: model should not be null.");
        }
        if (overrides != null) {
            NSMutableDictionary tempDict = new NSMutableDictionary(modelConnDict);
            EOKeyValueCodingAdditions.Utility.takeValuesFromDictionary((Object)tempDict, (NSDictionary)overrides);
            connDict = tempDict;
        } else {
            connDict = modelConnDict;
        }
        NSArray objectStores = null;
        EOObjectStoreCoordinator coordinator = null;
        if (!(rootObjectStore instanceof EOObjectStoreCoordinator)) {
            throw new IllegalStateException("forceConnectionWithModel: " + editingContext + " has a rootObjectStore " + rootObjectStore + " which is not an EOObjectStoreCoordinator");
        }
        coordinator = (EOObjectStoreCoordinator)rootObjectStore;
        objectStores = coordinator.cooperatingObjectStores();
        coordinator.lock();
        try {
            EODatabaseChannel dbChannel;
            int i;
            int c = objectStores.count();
            for (i = 0; i < c; ++i) {
                Object objectStore = objectStores.objectAtIndex(i);
                if (!(objectStore instanceof EODatabaseContext) || ((EODatabaseContext)((Object)objectStore)).database().models().indexOfObject((Object)model) == -1) continue;
                dbContext = (EODatabaseContext)((Object)objectStore);
                break;
            }
            if (dbContext != null) {
                NSDictionary adaptorConnDict = dbContext.adaptorContext().adaptor().connectionDictionary();
                if (adaptorConnDict.equals((Object)connDict)) {
                    EODatabaseContext eODatabaseContext = dbContext;
                    return eODatabaseContext;
                }
                dbContext._forceDisconnect();
                db = dbContext.database();
            } else {
                db = new EODatabase(model);
                dbContext = (EODatabaseContext)((Object)_NSUtilities.instantiateObject((Class)EODatabaseContext.contextClassToRegister(), (Class[])new Class[]{EODatabase.class}, (Object[])new Object[]{db}, (boolean)true, (boolean)false));
                coordinator.addCooperatingObjectStore((EOCooperatingObjectStore)dbContext);
            }
            adaptor = db.adaptor();
            if (overrides != null) {
                adaptor.setConnectionDictionary(connDict);
            }
            if ((dbChannel = dbContext.availableChannel()) == null) {
                throw new EOGeneralAdaptorException("forceConnectionWithModel -- EODatabaseContext: Unable to find available channel.");
            }
            dbChannel.adaptorChannel().openChannel();
            EOModelGroup group = model.modelGroup();
            NSArray models = group != null ? group.models() : NSArray.EmptyArray;
            c = models.count();
            for (i = 0; i < c; ++i) {
                EOModel peerModel = (EOModel)models.objectAtIndex(i);
                if (peerModel == model || !peerModel.connectionDictionary().equals((Object)modelConnDict) || !adaptor.name().equals(peerModel.adaptorName())) continue;
                db.addModel(peerModel);
            }
            EODatabaseContext eODatabaseContext = dbContext;
            return eODatabaseContext;
        }
        finally {
            coordinator.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _cooperatingObjectStoreNeeded(NSNotification notification) {
        if (_contextClassToRegister != null) {
            EOObjectStoreCoordinator coordinator = (EOObjectStoreCoordinator)notification.object();
            coordinator.lock();
            try {
                EOEntity entity;
                EOCustomObject object;
                EOModelGroup group = EOModelGroup.modelGroupForObjectStoreCoordinator(coordinator);
                NSDictionary dict = notification.userInfo();
                String entityName = null;
                EOModel model = null;
                EOFetchSpecification fetchSpec = (EOFetchSpecification)dict.objectForKey((Object)"fetchSpecification");
                if (fetchSpec != null) {
                    entityName = fetchSpec.entityName();
                } else {
                    EOGlobalID globalID = (EOGlobalID)dict.objectForKey((Object)"globalID");
                    if (globalID != null && globalID instanceof EOKeyGlobalID) {
                        entityName = ((EOKeyGlobalID)globalID).entityName();
                    }
                }
                if ((entityName == null || group.entityNamed(entityName) == null || (model = group.entityNamed(entityName).model()) == null) && (object = (EOCustomObject)dict.objectForKey((Object)"object")) != null && (entity = group.entityForObject((EOEnterpriseObject)object)) != null) {
                    model = entity.model();
                }
                if (model != null) {
                    EODatabaseContext dc = (EODatabaseContext)((Object)NSSelector._safeInvokeSelector((NSSelector)_registeredDatabaseContextForModelSelector, (Object)_contextClassToRegister, (Object[])new Object[]{model, coordinator}));
                    EODatabaseContext._preloadSharedObjectsWithModel(model);
                }
            }
            finally {
                coordinator.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _preloadSharedObjectsWithModel(EOModel model) {
        boolean isNewModel = false;
        NSMutableArray nSMutableArray = _sharedObjectsLoadedInModels;
        synchronized (nSMutableArray) {
            NSArray entities;
            if (_autoLoadSharedObjects && !_sharedObjectsLoadedInModels.containsObject((Object)model)) {
                _sharedObjectsLoadedInModels.addObject((Object)model);
                isNewModel = true;
            }
            if (isNewModel && (entities = model.entitiesWithSharedObjects()) != null && entities.count() != 0) {
                EOSharedEditingContext dsec = EOSharedEditingContext.defaultSharedEditingContext();
                for (int i = entities.count() - 1; i >= 0; --i) {
                    EOEntity entity = (EOEntity)entities.objectAtIndex(i);
                    NSArray fsNames = entity.sharedObjectFetchSpecificationNames();
                    for (int j = fsNames.count() - 1; j >= 0; --j) {
                        String fsName = (String)fsNames.objectAtIndex(j);
                        EOFetchSpecification fs = entity.fetchSpecificationNamed(fsName);
                        if (fs == null) continue;
                        dsec.bindObjectsWithFetchSpecification(fs, fsName);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoordinator(EOObjectStoreCoordinator coord) {
        super.setCoordinator(coord);
        long rc = 0L;
        EODatabaseContext eODatabaseContext = this;
        synchronized (eODatabaseContext) {
            if (this._dbcLock != null) {
                rc = this._dbcLock.recursionCount();
                this._dbcLock.unlock(rc);
            }
            this._dbcLock = coord != null ? coord._lock() : new NSRecursiveLock();
        }
        while (rc > 0L) {
            this._dbcLock.lock();
            --rc;
        }
    }

    public NSArray registeredChannels() {
        return this._registeredChannels;
    }

    public void registerChannel(EODatabaseChannel channel) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (channel.databaseContext() != this) {
            throw new IllegalStateException("registerChannel: databaseChannel:" + channel + " attempted to register with databaseContext:" + (Object)((Object)this) + " that is not its parent");
        }
        if (this._registeredChannels.indexOfObject((Object)channel) != -1) {
            throw new IllegalStateException("Attempt to register databaseChannel:" + channel + " twice with databaseContext:" + (Object)((Object)this));
        }
        this._registeredChannels.addObject((Object)channel);
    }

    public void unregisterChannel(EODatabaseChannel channel) {
        int i = this._registeredChannels.indexOfObject((Object)channel);
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (i == -1) {
            throw new IllegalStateException("Attempt to unregister unknown databaseChannel:" + channel + " with databaseContext:" + (Object)((Object)this));
        }
        this._registeredChannels.removeObjectAtIndex(i);
    }

    public EODatabaseChannel availableChannel() {
        EODatabaseChannel channel = this._availableChannel();
        if (channel != null) {
            channel._openChannel();
        }
        return channel;
    }

    public boolean hasBusyChannels() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        return this._adaptorContext.hasBusyChannels();
    }

    public EODatabase database() {
        return this._database;
    }

    public EOAdaptorContext adaptorContext() {
        return this._adaptorContext;
    }

    private void beginTransaction() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        try {
            this._adaptorContext.beginTransaction();
        }
        catch (Exception localException) {
            if (this._delegateHandledDatabaseException(localException)) {
                this._adaptorContext.beginTransaction();
            } else if (this._isDroppedConnectionException(localException)) {
                this._database.handleDroppedConnection();
                this._adaptorContext.beginTransaction();
            } else {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
    }

    private void commitTransaction() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._adaptorContext.hasOpenTransaction()) {
            this._adaptorContext.commitTransaction();
        }
    }

    private void rollbackTransaction() {
        if (this._adaptorContext.hasOpenTransaction()) {
            this._adaptorContext.rollbackTransaction();
        }
    }

    public int updateStrategy() {
        return this._updateStrategy;
    }

    public void setUpdateStrategy(int strategy) {
        if (strategy == 1 && this._database.snapshots().count() != 0) {
            throw new IllegalArgumentException("setUpdateStrategy -- " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + ": Unable to change update strategy to 'Pessimistic' once objects have been fetched." + " Invoke -invalidateAllObjects before calling this method or set strategy before fetching.");
        }
        this._updateStrategy = strategy;
    }

    public void recordSnapshotForGlobalID(NSDictionary snapshot, EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable == null) {
            throw new IllegalStateException("recordSnapshotForGlobalID: cannot record objects in a context when no transaction is in progress");
        }
        if (gid == null) {
            throw new IllegalArgumentException("recordSnapshotForGlobalID: Global ID may not be null when uniquing");
        }
        if (snapshot == null) {
            throw new IllegalArgumentException("recordSnapshot: snapshot may not be null when snapshotting");
        }
        this._uniqueTable.setObjectForKey((Object)snapshot, (Object)gid);
    }

    public void recordSnapshotForSourceGlobalID(NSArray gids, EOGlobalID gid, String name) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!_useToManyCaching) {
            return;
        }
        if (this._uniqueArrayTable == null) {
            throw new IllegalStateException("recordSnapshotForSourceGlobalID: cannot record objects in a context when no transaction is in progress");
        }
        if (gid == null) {
            throw new IllegalArgumentException("recordSnapshotForSourceGlobalID: Global ID may not be null when uniquing");
        }
        if (gids == null) {
            throw new IllegalArgumentException("recordSnapshotForSourceGlobalID: snapshot may not be null when snapshotting\n");
        }
        NSMutableDictionary perGid = (NSMutableDictionary)this._uniqueArrayTable.objectForKey((Object)gid);
        if (perGid == null) {
            perGid = new NSMutableDictionary();
            this._uniqueArrayTable.setObjectForKey((Object)perGid, (Object)gid);
        }
        perGid.setObjectForKey((Object)gids, (Object)name);
    }

    public void recordSnapshots(NSDictionary snapshots) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable == null) {
            throw new IllegalStateException("recordSnapshots: cannot record objects in a context when no transaction is in progress");
        }
        this._uniqueTable.addEntriesFromDictionary(snapshots);
    }

    public void recordToManySnapshots(NSDictionary snapshots) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!_useToManyCaching) {
            return;
        }
        if (this._uniqueArrayTable == null) {
            throw new IllegalStateException("recordToManySnapshots: cannot record objects in a context when no transaction is in progress");
        }
        NSArray gids = snapshots.allKeys();
        int c = gids.count();
        for (int i = 0; i < c; ++i) {
            Object key = gids.objectAtIndex(i);
            NSDictionary newDic = (NSDictionary)snapshots.objectForKey(key);
            NSMutableDictionary old = (NSMutableDictionary)this._uniqueArrayTable.objectForKey(key);
            if (old == null) {
                old = new NSMutableDictionary();
                this._uniqueArrayTable.setObjectForKey((Object)old, key);
            }
            old.addEntriesFromDictionary(newDic);
        }
    }

    public void forgetSnapshotForGlobalID(EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable == null) {
            throw new IllegalStateException("forgetSnapshotForGlobalID: cannot forget objects in a context when no transaction is in progress");
        }
        if (gid == null) {
            throw new IllegalArgumentException("forgetSnapshotForGlobalID: global ID cannot be null");
        }
        this._deleteTable.addObject((Object)gid);
        this._uniqueTable.removeObjectForKey((Object)gid);
        if (_useToManyCaching) {
            this._uniqueArrayTable.removeObjectForKey((Object)gid);
        }
    }

    public NSDictionary snapshotForGlobalID(EOGlobalID gid) {
        return this.snapshotForGlobalID(gid, EODatabase.DistantPastTimeInterval);
    }

    public NSDictionary snapshotForGlobalID(EOGlobalID gid, long timestamp) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        NSDictionary snapshot = this.localSnapshotForGlobalID(gid);
        return snapshot != null ? snapshot : this._database.snapshotForGlobalID(gid, timestamp);
    }

    public NSArray snapshotForSourceGlobalID(EOGlobalID gid, String name) {
        return this.snapshotForSourceGlobalID(gid, name, EODatabase.DistantPastTimeInterval);
    }

    public NSArray snapshotForSourceGlobalID(EOGlobalID gid, String name, long timestamp) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!_useToManyCaching) {
            return null;
        }
        NSArray snapshot = this.localSnapshotForSourceGlobalID(gid, name);
        if (snapshot == null) {
            return this._database.snapshotForSourceGlobalID(gid, name, timestamp);
        }
        return snapshot;
    }

    public NSArray missingObjectGlobalIDs() {
        return this._missingObjectGIDs.allObjects();
    }

    public Object delegate() {
        return this._delegate.delegate();
    }

    public void setDelegate(Object delegate) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._delegate.setDelegate(delegate);
        this._delegateRespondsTo_shouldUpdateCurrentSnapshot = this._delegate.respondsTo(_databaseContextShouldUpdateCurrentSnapshot);
    }

    private void _setDelegate(Object delegate) {
        this._delegate.setDelegate(delegate);
        this._delegateRespondsTo_shouldUpdateCurrentSnapshot = this._delegate.respondsTo(_databaseContextShouldUpdateCurrentSnapshot);
    }

    boolean _respondsTo_shouldUpdateCurrentSnapshot() {
        return this._delegateRespondsTo_shouldUpdateCurrentSnapshot;
    }

    NSDictionary _shouldUpdateCurrentSnapshot(NSDictionary snapshot, NSDictionary row, EOKeyGlobalID gid, EODatabaseChannel databaseChannel) {
        if (!this._delegateRespondsTo_shouldUpdateCurrentSnapshot) {
            return null;
        }
        return (NSDictionary)this._delegate.perform(_databaseContextShouldUpdateCurrentSnapshot, new Object[]{this, snapshot, row, gid, databaseChannel});
    }

    boolean _performShouldSelectObjects(EOFetchSpecification fetchSpec, EODatabaseChannel databaseChannel) {
        if (!this._delegate.respondsTo(_databaseContextShouldSelectObjects)) {
            return true;
        }
        return this._delegate.booleanPerform(_databaseContextShouldSelectObjects, (Object)this, (Object)fetchSpec, (Object)databaseChannel);
    }

    void _performDidSelectObjects(EOFetchSpecification fetchSpec, EODatabaseChannel databaseChannel) {
        if (this._delegate.respondsTo(_databaseContextDidSelectObjects)) {
            this._delegate.perform(_databaseContextDidSelectObjects, (Object)this, (Object)fetchSpec, (Object)databaseChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        EODatabaseContext eODatabaseContext = this;
        synchronized (eODatabaseContext) {
            if (this._dbcLock == null) {
                EOObjectStoreCoordinator osc = this.coordinator();
                this._dbcLock = osc != null ? osc._lock() : new NSRecursiveLock();
            }
        }
        this._dbcLock.lock();
    }

    public synchronized void unlock() {
        this._dbcLock.unlock();
    }

    synchronized boolean _verifyLock() {
        if (this._dbcLock == null) {
            return false;
        }
        return this._dbcLock._verifyLock();
    }

    public void handleDroppedConnection() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOAdaptorContext oldAdaptorContext = this._adaptorContext;
        EOAdaptor adaptor = this._database.adaptor();
        this._unregisterForAdaptorContextNotifications(oldAdaptorContext);
        this._registeredChannels = new NSMutableArray();
        this._adaptorContext = adaptor.createAdaptorContext();
        if (this._adaptorContext == null) {
            throw new IllegalStateException("handleDroppedConnection: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " is unable to obtain new context from " + adaptor.getClass().getName() + " " + adaptor);
        }
        this._adaptorContext.setDelegate(oldAdaptorContext.delegate());
        this._registerForAdaptorContextNotifications(this._adaptorContext);
    }

    public void _forceDisconnect() {
        int i;
        EOAdaptorContext adaptorContext = this.adaptorContext();
        NSArray adaptorChannels = adaptorContext.channels();
        NSArray dbChannels = this.registeredChannels();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        int max = adaptorChannels.count();
        for (i = 0; i < max; ++i) {
            try {
                ((EOAdaptorChannel)adaptorChannels.objectAtIndex(i)).closeChannel();
                continue;
            }
            catch (Exception e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
        max = dbChannels.count();
        for (i = 0; i < max; ++i) {
            try {
                this.unregisterChannel((EODatabaseChannel)dbChannels.objectAtIndex(i));
                continue;
            }
            catch (Exception e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
    }

    protected boolean _openChannelWithLoginPanel(EODatabaseChannel channel) {
        EOAdaptorChannel adaptorChannel = channel.adaptorChannel();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (adaptorChannel.isOpen()) {
            return true;
        }
        try {
            adaptorChannel.openChannel();
        }
        catch (Exception localException) {
            NSLog.err.appendln((Object)("An exception occurred while trying to open a channel: " + localException));
            return false;
        }
        return adaptorChannel.isOpen();
    }

    public EODatabaseChannel _availableChannelFromRegisteredChannels() {
        int i = this._registeredChannels.count();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        while (i-- != 0) {
            EODatabaseChannel channel = (EODatabaseChannel)this._registeredChannels.objectAtIndex(i);
            if (channel.isFetchInProgress()) continue;
            return channel;
        }
        return null;
    }

    protected EODatabaseChannel _availableChannel() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EODatabaseChannel channel = this._availableChannelFromRegisteredChannels();
        if (channel != null) {
            return channel;
        }
        NSNotificationCenter.defaultCenter().postNotification(DatabaseChannelNeededNotification, (Object)this);
        channel = this._availableChannelFromRegisteredChannels();
        if (channel == null && this._registeredChannels.count() == 0 && (channel = new EODatabaseChannel(this)) != null) {
            this.registerChannel(channel);
        }
        return channel;
    }

    protected EODatabaseChannel _obtainOpenChannel() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EODatabaseChannel dbChannel = this._availableChannel();
        if (dbChannel == null) {
            throw new IllegalStateException("_obtainOpenChannel -- " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + ": no database channel is available.");
        }
        if (!this._openChannelWithLoginPanel(dbChannel)) {
            throw new IllegalStateException("_obtainOpenChannel -- " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + ": failed to open database channel.  Check your connection dictionary, and ensure your database is correctly configured.");
        }
        return dbChannel;
    }

    public void _beginTransaction(NSNotification notification) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable != null) {
            if (this._adaptorContext.canNestTransactions()) {
                if (!warnedOnce) {
                    _EOStringUtil.debugCriticalPrintln("Nested transactions are not supported. " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " will ignore the nesting and continue to use the existing transaction.  This warning will appear only once.");
                }
                return;
            }
            throw new IllegalStateException("_beginTransaction(): " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " Transactions cannot be nested");
        }
        this._uniqueTable = new NSMutableDictionary();
        if (_useToManyCaching) {
            this._uniqueArrayTable = new NSMutableDictionary();
        }
        this._deleteTable = new NSMutableSet();
        this._database.setTimestampToNow();
    }

    public void _cleanUpAfterTransaction() {
        this.forgetAllLocks();
        this._uniqueTable = null;
        this._uniqueArrayTable = null;
        this._deleteTable = null;
        EODatabase db = this.database();
        if (db != null) {
            db._clearLastRecords();
        }
    }

    public void _commitTransaction(NSNotification notification) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable == null) {
            return;
        }
        Enumeration enumerator = this._deleteTable.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            EOGlobalID gid = (EOGlobalID)enumerator.nextElement();
            this._database.forgetSnapshotForGlobalID(gid);
        }
        this._database.recordSnapshots((NSDictionary)this._uniqueTable);
        if (_useToManyCaching) {
            this._database.recordToManySnapshots((NSDictionary)this._uniqueArrayTable);
        }
        this._cleanUpAfterTransaction();
    }

    public void _rollbackTransaction(NSNotification notification) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable == null) {
            return;
        }
        this._cleanUpAfterTransaction();
    }

    private EOEntity entityForGlobalID(EOGlobalID globalID) {
        String entityName = ((EOKeyGlobalID)globalID).entityName();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._lastEntity != null && entityName == this._lastEntity.name()) {
            return this._lastEntity;
        }
        this._lastEntity = this._database.entityNamed(entityName);
        return this._lastEntity;
    }

    public NSDictionary localSnapshotForGlobalID(EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (gid == null) {
            return null;
        }
        if (this._uniqueTable != null) {
            return (NSDictionary)this._uniqueTable.objectForKey((Object)gid);
        }
        return null;
    }

    public NSArray localSnapshotForSourceGlobalID(EOGlobalID gid, String name) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!_useToManyCaching || this._uniqueArrayTable == null || gid == null || name == null) {
            return null;
        }
        NSDictionary snapshot = (NSDictionary)this._uniqueArrayTable.objectForKey((Object)gid);
        if (snapshot == null) {
            return null;
        }
        Object array = snapshot.objectForKey((Object)name);
        return array == NSKeyValueCoding.NullValue ? null : (NSArray)array;
    }

    public void registerLockedObjectWithGlobalID(EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._lockedObjects == null) {
            this._lockedObjects = new NSMutableSet();
        }
        this._lockedObjects.addObject((Object)gid);
    }

    public boolean isObjectLockedWithGlobalID(EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        return this._lockedObjects != null && this._lockedObjects.containsObject((Object)gid);
    }

    public void forgetLocksForObjectsWithGlobalIDs(NSArray gids) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._lockedObjects != null) {
            for (int i = gids.count() - 1; i >= 0; --i) {
                this._lockedObjects.removeObject(gids.objectAtIndex(i));
            }
        }
    }

    public void forgetAllLocks() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._lockedObjects != null) {
            if (this._lockedObjects.count() > 1000) {
                this._lockedObjects = null;
            } else {
                this._lockedObjects.removeAllObjects();
            }
        }
    }

    public void forgetSnapshotsForGlobalIDs(NSArray gids) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._uniqueTable != null) {
            for (int i = gids.count() - 1; i >= 0; --i) {
                Object gid = gids.objectAtIndex(i);
                this._uniqueTable.removeObjectForKey(gid);
                if (_useToManyCaching) {
                    this._uniqueArrayTable.removeObjectForKey(gid);
                }
                this._deleteTable.removeObject(gid);
            }
        }
        this._database.forgetSnapshotsForGlobalIDs(gids);
    }

    private void initializeObjectRowEntityEditingContext(EOEnterpriseObject object, NSDictionary row, EOEntity entity, EOEditingContext editContext) {
        Object value;
        int i;
        _EODBCtxEntityInfo info = _EODBCtxEntityInfo.infoForEntityObjectRow(entity, object, row);
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        Object[] vector = info._rowToObjectAttributeMap;
        int count = info._attributeCount;
        for (i = 0; i < count; ++i) {
            value = ((NSKeyValueCoding._KeyBinding)vector[i * 2]).valueInObject((Object)row);
            if (value == NSKeyValueCoding.NullValue) {
                value = null;
            }
            ((NSKeyValueCoding._KeyBinding)vector[i * 2 + 1]).setValueInObject(value, (Object)object);
        }
        vector = info._relValueToObjectMap;
        count = info._relValueCount;
        for (i = 0; i < count; ++i) {
            ((NSKeyValueCoding._KeyBinding)vector[i * 2 + 1]).setValueInObject(vector[i * 2], (Object)object);
        }
        vector = info._relationshipToObjectMap;
        count = info._relationshipCount;
        for (i = 0; i < count; ++i) {
            EORelationship relationship = (EORelationship)vector[i * 2];
            value = relationship.isToMany() ? this.arrayFaultWithSourceGlobalID(entity.globalIDForRow(row), relationship.name(), editContext) : this._objectFaultWithSnapshotRelationshipEditingContext(row, relationship, editContext);
            if (value == NSKeyValueCoding.NullValue) {
                value = null;
            }
            ((NSKeyValueCoding._KeyBinding)vector[i * 2 + 1]).setValueInObject(value, (Object)object);
        }
    }

    public NSArray _objectsFromEntityCacheWithFetchSpecEditingContext(EOFetchSpecification fetchSpec, EOEditingContext context) {
        NSArray sortOrderings;
        NSMutableArray eos = null;
        boolean previousIgnoreEntityCaching = this._flags_ignoreEntityCaching;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._flags_ignoreEntityCaching = true;
        NSArray gids = this._database.resultCacheForEntityNamed(fetchSpec.entityName());
        if (gids == null) {
            this._populateCacheForFetchSpecificationEditingContext(fetchSpec, context);
            gids = this._database.resultCacheForEntityNamed(fetchSpec.entityName());
        }
        int i = gids.count();
        NSMutableArray eos1 = new NSMutableArray(i);
        while (i-- != 0) {
            eos1.addObject((Object)context.faultForGlobalID((EOGlobalID)gids.objectAtIndex(i), context));
        }
        eos = eos1;
        EOQualifier qual = fetchSpec.qualifier();
        if (qual != null) {
            eos = EOQualifier.filteredArrayWithQualifier((NSArray)eos, (EOQualifier)qual);
        }
        if ((sortOrderings = fetchSpec.sortOrderings()) != null) {
            eos = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)eos, (NSArray)sortOrderings);
        }
        this._flags_ignoreEntityCaching = previousIgnoreEntityCaching;
        return eos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _populateCacheForFetchSpecificationEditingContext(EOFetchSpecification fetchSpec, EOEditingContext context) {
        NSArray array;
        String name = fetchSpec.entityName();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._database.resultCacheForEntityNamed(name) != null) {
            return;
        }
        EOFetchSpecification fs = new EOFetchSpecification(name, null, null);
        fs.setIsDeep(true);
        this._flags_ignoreEntityCaching = true;
        try {
            array = this.objectsWithFetchSpecification(fs, context);
        }
        finally {
            this._flags_ignoreEntityCaching = false;
        }
        int cnt = array.count();
        NSMutableArray cacheArray = new NSMutableArray(cnt);
        for (int i = cnt - 1; i >= 0; --i) {
            cacheArray.addObject((Object)context.globalIDForObject((EOEnterpriseObject)array.objectAtIndex(i)));
        }
        this._database.setResultCache((NSArray)cacheArray, name);
    }

    protected Object _objectFaultWithSnapshotRelationshipEditingContext(NSDictionary row, EORelationship relationship, EOEditingContext editContext) {
        NSMutableDictionary pkDictionary = relationship._foreignKeyForSourceRow(row);
        if (_NSDictionaryUtilities.containsAnyNullObject((NSDictionary)pkDictionary)) {
            return null;
        }
        EOEntity destinationEntity = relationship.destinationEntity();
        EOKeyGlobalID gid = (EOKeyGlobalID)destinationEntity.globalIDForRow((NSDictionary)pkDictionary);
        if (!gid._isFinal()) {
            return this._fetchSingleObject(destinationEntity, (EOGlobalID)gid, editContext);
        }
        return editContext.faultForGlobalID((EOGlobalID)gid, editContext);
    }

    protected Object _fireDeferredFaultWithSourceObject(EOEnterpriseObject eo, EORelationship relationship) {
        Object fault;
        EOEditingContext ec = eo.editingContext();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOGlobalID gid = ec.globalIDForObject(eo);
        if (gid == null) {
            return null;
        }
        if (relationship.isToMany()) {
            fault = this.arrayFaultWithSourceGlobalID(gid, relationship.name(), ec);
        } else {
            NSDictionary snap = this.snapshotForGlobalID(gid);
            if (snap == null) {
                EOFetchSpecification fs = new EOFetchSpecification();
                EOEntity entity = this.entityForGlobalID(gid);
                NSDictionary pk = entity.primaryKeyForGlobalID((EOGlobalID)((EOKeyGlobalID)gid));
                fs.setEntityName(entity.name());
                fs.setQualifier(entity.qualifierForPrimaryKey(pk));
                NSArray retainEOs = this._objectsWithFetchSpecificationEditingContext(fs, ec);
                snap = this.snapshotForGlobalID(gid);
                if (snap == null) {
                    return null;
                }
            }
            fault = this._objectFaultWithSnapshotRelationshipEditingContext(snap, relationship, ec);
        }
        if (_lazyFaultDebugLevel > 1) {
            String description;
            String arrow;
            String string = arrow = relationship.isToMany() ? "->>" : "->";
            description = EOFaultHandler.isFault((Object)fault) ? EOFaultHandler.handlerForFault((Object)fault).descriptionForObject(fault) : (fault != null && ((description = fault.toString()) == null || description.length() == 0) ? "<" + fault.getClass().getName() + ":" + fault + ">" : fault.toString());
        }
        return fault;
    }

    protected boolean _delegateHandledDatabaseException(Exception exception) {
        if (this._delegate.respondsTo(_databaseContextShouldHandleDatabaseException)) {
            return (Boolean)this._delegate.perform(_databaseContextShouldHandleDatabaseException, new Object[]{this, exception}) == false;
        }
        return false;
    }

    public boolean _isDroppedConnectionException(Exception exception) {
        return this._database.adaptor().isDroppedConnectionException(exception);
    }

    public NSArray _filterArrayWithQualifierEditingContext(NSArray array, EOQualifier qualifier, EOEditingContext ec) {
        if (qualifier._isEmpty()) {
            return array;
        }
        int cnt = array.count();
        NSMutableArray r = new NSMutableArray(cnt);
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        for (int i = 0; i < cnt; ++i) {
            EOEnterpriseObject obj = (EOEnterpriseObject)array.objectAtIndex(i);
            EOGlobalID gid = ec.globalIDForObject(obj);
            NSDictionary snap = this.snapshotForGlobalID(gid);
            if (!qualifier.evaluateWithObject((Object)snap)) continue;
            r.addObject((Object)obj);
        }
        return r;
    }

    public static void _setUseFastBatchAlgorithm(boolean flag) {
    }

    public void _followToManyRelationshipWithFetchSpecification(EORelationship relationship, EOFetchSpecification newFetchSpec, NSArray sourceObjects, EOEditingContext context) {
        EOGlobalID gid;
        int i;
        EORelationship inverse = relationship.anyInverseRelationship();
        NSMutableDictionary byFkResults = new NSMutableDictionary();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOQualifier qFetch = EOQualifierSQLGeneration.Support._qualifierMigratedFromEntityRelationshipPath(newFetchSpec.qualifier(), relationship.entity(), relationship.name());
        if (relationship.auxiliaryQualifier() != null) {
            qFetch = new EOAndQualifier(new NSArray(new Object[]{qFetch, relationship.auxiliaryQualifier()}));
        }
        newFetchSpec.setQualifier(qFetch);
        NSArray results = this.objectsWithFetchSpecification(newFetchSpec, context);
        if (!relationship._isToManyClassProperty()) {
            return;
        }
        int c = results.count();
        for (i = 0; i < c; ++i) {
            EOEnterpriseObject currentEO = (EOEnterpriseObject)results.objectAtIndex(i);
            gid = context.globalIDForObject(currentEO);
            NSDictionary sourceRow = this.snapshotForGlobalID(gid);
            NSMutableDictionary fkDictionary = inverse._foreignKeyForSourceRow(sourceRow);
            if (_NSDictionaryUtilities.containsOnlyNullObjects((NSDictionary)fkDictionary)) continue;
            EOEntity destinationEntity = inverse.destinationEntity();
            EOKeyGlobalID fk = (EOKeyGlobalID)destinationEntity.globalIDForRow((NSDictionary)fkDictionary);
            if (fk == null) {
                throw new IllegalStateException("While using an EOFetchSpecification, EODatabaseContext was unable to get an EOGlobalID for an Entity of type \"" + destinationEntity.name() + "\" with the primary key dictionary of " + fkDictionary);
            }
            NSMutableArray array = (NSMutableArray)byFkResults.objectForKey((Object)fk);
            if (array == null) {
                array = new NSMutableArray();
                byFkResults.setObjectForKey((Object)array, (Object)fk);
            }
            array.addObject((Object)currentEO);
        }
        c = sourceObjects.count();
        for (i = 0; i < c; ++i) {
            EOEnterpriseObject currentObject = (EOEnterpriseObject)sourceObjects.objectAtIndex(i);
            gid = context.globalIDForObject(currentObject);
            Object array = currentObject.storedValueForKey(relationship.name());
            if (!EOFaultHandler.isFault((Object)array)) continue;
            this._currentBatch = byFkResults.objectForKey((Object)gid);
            if (this._currentBatch == null) {
                this._currentBatch = NSArray.EmptyArray;
            }
            ((EOFaulting)array).willRead();
            this._currentBatch = null;
        }
    }

    public void _followFetchSpecification(EOFetchSpecification fetchSpec, String relationshipName, NSArray sourceObjects, EOEditingContext context) {
        EOEntity rootEntity = this._database.entityNamed(fetchSpec.entityName());
        EORelationship relationship = rootEntity.relationshipNamed(relationshipName);
        NSMutableArray newPrefetch = new NSMutableArray();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (relationship == null) {
            throw new IllegalStateException("Unknown relationship '" + relationshipName + "' in fetch specification " + fetchSpec);
        }
        NSArray prefetch = fetchSpec.prefetchingRelationshipKeyPaths();
        int c = prefetch.count();
        for (int i = 0; i < c; ++i) {
            String currentPrefetch = (String)prefetch.objectAtIndex(i);
            int range = currentPrefetch.indexOf(46);
            if (range < 0) continue;
            newPrefetch.addObject((Object)currentPrefetch.substring(range + 1));
        }
        EOFetchSpecification newFetchSpec = (EOFetchSpecification)fetchSpec.clone();
        newFetchSpec.setPrefetchingRelationshipKeyPaths((NSArray)newPrefetch);
        newFetchSpec.setEntityName(relationship.destinationEntity().name());
        if (rootEntity.restrictingQualifier() != null) {
            EOQualifier newQualifier = (EOQualifier)rootEntity.restrictingQualifier().clone();
            if (newFetchSpec.qualifier() != null) {
                newQualifier = new EOAndQualifier(new NSArray(new Object[]{newQualifier, newFetchSpec.qualifier()}));
            }
            newFetchSpec.setQualifier(newQualifier);
        }
        if (newFetchSpec.qualifier() == null) {
            EOAttribute attr = (EOAttribute)relationship.entity().primaryKeyAttributes().objectAtIndex(0);
            String name = attr.name();
            EOKeyComparisonQualifier q = new EOKeyComparisonQualifier(name, EOQualifier.QualifierOperatorEqual, name);
            newFetchSpec.setQualifier((EOQualifier)q);
        }
        if (!relationship.isToMany()) {
            EOQualifier qFetch = EOQualifierSQLGeneration.Support._qualifierMigratedFromEntityRelationshipPath(newFetchSpec.qualifier(), relationship.entity(), relationship.name());
            if (relationship.auxiliaryQualifier() != null) {
                qFetch = new EOAndQualifier(new NSArray(new Object[]{qFetch, relationship.auxiliaryQualifier()}));
            }
            newFetchSpec.setQualifier(qFetch);
            if (!relationship.foreignKeyInDestination()) {
                newFetchSpec.setUsesDistinct(true);
            }
            NSArray retainEOs = this.objectsWithFetchSpecification(newFetchSpec, context);
        } else {
            if (relationship.isToMany() && !relationship.isMultiHop()) {
                this._followToManyRelationshipWithFetchSpecification(relationship, newFetchSpec, sourceObjects, context);
                return;
            }
            if (relationship.isToManyToOne()) {
                NSMutableDictionary row;
                EOFetchSpecification adaptorFetchSpec = (EOFetchSpecification)newFetchSpec.clone();
                newFetchSpec.setUsesDistinct(true);
                EOQualifier qFetch = EOQualifierSQLGeneration.Support._qualifierMigratedFromEntityRelationshipPath(newFetchSpec.qualifier(), relationship.entity(), relationship.name());
                newFetchSpec.setQualifier(qFetch);
                NSArray results = this.objectsWithFetchSpecification(newFetchSpec, context);
                EORelationship firstHop = relationship.firstRelationship();
                EOEntity intermediateEntity = firstHop.destinationEntity();
                EOAdaptorChannel adaptorChannel = this.availableChannel().adaptorChannel();
                if (adaptorChannel == null) {
                    throw new IllegalStateException("No adaptor channel available.");
                }
                adaptorFetchSpec.setEntityName(intermediateEntity.name());
                qFetch = EOQualifierSQLGeneration.Support._qualifierMigratedFromEntityRelationshipPath(adaptorFetchSpec.qualifier(), firstHop.entity(), firstHop.name());
                adaptorFetchSpec.setQualifier(qFetch);
                adaptorChannel.selectAttributes(relationship._intermediateAttributes(), adaptorFetchSpec, false, intermediateEntity);
                NSMutableArray rows = new NSMutableArray(64);
                EORelationship inverseFirst = firstHop.anyInverseRelationship();
                EORelationship lastrel = relationship.lastRelationship();
                EOEntity srcEntity = relationship.entity();
                EOEntity dstEntity = relationship.destinationEntity();
                while ((row = adaptorChannel.fetchRow()) != null) {
                    rows.addObject((Object)row);
                }
                int c2 = sourceObjects.count();
                for (int i = 0; i < c2; ++i) {
                    EOCustomObject currentObject = (EOCustomObject)sourceObjects.objectAtIndex(i);
                    NSMutableArray fault = (NSMutableArray)currentObject.storedValueForKey(relationshipName);
                    if (fault == null || !EOFaultHandler.isFault((Object)fault)) continue;
                    this._currentBatch = fault;
                    ((EOFaulting)fault).willRead();
                    if (this._currentBatch != null) {
                        this._currentBatch = null;
                        continue;
                    }
                    EOGlobalID currentGID = context.globalIDForObject((EOEnterpriseObject)currentObject);
                    NSMutableArray result = new NSMutableArray(64);
                    int k = rows.count();
                    for (int j = 0; j < k; ++j) {
                        NSDictionary currentRow = (NSDictionary)rows.objectAtIndex(j);
                        EOKeyGlobalID srcgid = srcEntity._globalIDForRowIsFinal(inverseFirst.primaryKeyForTargetRowFromSourceDBSnapshot(currentRow), true);
                        if (!srcgid.equals(currentGID)) continue;
                        EOKeyGlobalID dstgid = dstEntity._globalIDForRowIsFinal(lastrel.primaryKeyForTargetRowFromSourceDBSnapshot(currentRow), true);
                        result.addObject((Object)context.faultForGlobalID((EOGlobalID)dstgid, context));
                    }
                    this._currentBatch = result;
                    ((EOFaulting)fault).willRead();
                    this._currentBatch = null;
                }
            } else if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)65538L)) {
                NSLog.debug.appendln((Object)("Warning: Prefetching relationships and batch faulting cannot be optimized for multihop relationships.  Ignoring '" + relationshipName + "'."));
                String definition = relationship.definition();
                if (definition != null) {
                    NSLog.debug.appendln((Object)("Try substituting '" + definition + "' for '" + relationshipName + "' in the prefetchingRelationshipKeyPaths of the EOFetchSpecification."));
                }
            }
        }
    }

    public void _performPrefetchForFetchSpecification(EOFetchSpecification fetchSpec, EOEditingContext context, NSArray array, NSArray prefetchingHints) {
        EOFetchSpecification newFetchSpec;
        String currentComponent = null;
        NSMutableArray currentList = null;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (fetchSpec.isDeep()) {
            EOEntity entity = this._database.entityNamed(fetchSpec.entityName());
            if (entity.isAbstractEntity()) {
                return;
            }
            NSArray subs = entity.subEntities();
            if (subs != null && subs.count() != 0) {
                return;
            }
        }
        try {
            prefetchingHints = prefetchingHints.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        int c = prefetchingHints.count();
        for (int i = 0; i < c; ++i) {
            String componentString = (String)prefetchingHints.objectAtIndex(i);
            String firstComponent = (String)NSArray.componentsSeparatedByString((String)componentString, (String)".").objectAtIndex(0);
            if (currentComponent == null || !currentComponent.equals(firstComponent)) {
                if (currentComponent != null) {
                    newFetchSpec = new EOFetchSpecification();
                    newFetchSpec.setEntityName(fetchSpec.entityName());
                    newFetchSpec.setQualifier(fetchSpec.qualifier());
                    newFetchSpec.setLocksObjects(fetchSpec.locksObjects());
                    newFetchSpec.setRefreshesRefetchedObjects(fetchSpec.refreshesRefetchedObjects());
                    newFetchSpec.setPrefetchingRelationshipKeyPaths((NSArray)currentList);
                    this._followFetchSpecification(newFetchSpec, currentComponent, array, context);
                }
                currentList = new NSMutableArray();
                currentComponent = firstComponent;
            }
            currentList.addObject(prefetchingHints.objectAtIndex(i));
        }
        if (currentComponent != null) {
            newFetchSpec = new EOFetchSpecification();
            newFetchSpec.setEntityName(fetchSpec.entityName());
            newFetchSpec.setQualifier(fetchSpec.qualifier());
            newFetchSpec.setLocksObjects(fetchSpec.locksObjects());
            newFetchSpec.setRefreshesRefetchedObjects(fetchSpec.refreshesRefetchedObjects());
            newFetchSpec.setPrefetchingRelationshipKeyPaths((NSArray)currentList);
            this._followFetchSpecification(newFetchSpec, currentComponent, array, context);
        }
    }

    public EOEnterpriseObject faultForRawRow(NSDictionary row, String entityName, EOEditingContext editingContext) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOGlobalID gid = this._database.entityNamed(entityName).globalIDForRow(row);
        if (gid == null) {
            throw new IllegalArgumentException("Raw row " + row + " does not contain primary key information for entity " + entityName);
        }
        EOEnterpriseObject fault = editingContext.faultForGlobalID(gid, editingContext);
        return fault;
    }

    public NSArray _fetchRawRowKeyPaths(NSArray rawKeyPaths, EOFetchSpecification fetchSpec, EOEntity entity, EOEditingContext context) {
        NSMutableDictionary row;
        NSArray attributes;
        EOAdaptorChannel adaptorChannel = this.availableChannel().adaptorChannel();
        NSMutableArray results = new NSMutableArray(64);
        int resultCount = 0;
        int rawKeyPathCount = rawKeyPaths.count();
        Object fetchMessageHandler = null;
        Object customQuery = null;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (rawKeyPathCount == 0) {
            attributes = entity.attributesToFetch();
        } else {
            NSMutableArray attrs = new NSMutableArray(rawKeyPathCount);
            boolean foundSimpleAttribute = false;
            for (int i = 0; i < rawKeyPathCount; ++i) {
                String attrKey = (String)rawKeyPaths.objectAtIndex(i);
                EOAttribute attr = entity.attributeNamed(attrKey);
                if (attr == null) {
                    attr = new EOAttribute(entity, attrKey);
                } else if (!foundSimpleAttribute && !attr.isFlattened()) {
                    foundSimpleAttribute = true;
                }
                attrs.addObject((Object)attr);
            }
            if (!foundSimpleAttribute) {
                EORelationship rel;
                EOAttribute attr = (EOAttribute)attrs.lastObject();
                if (attr.isFlattened()) {
                    rel = (EORelationship)attr._definitionArray().objectAtIndex(0);
                } else {
                    String attrKeyPath = (String)rawKeyPaths.lastObject();
                    String relKey = _EOStringUtil.firstComponentFromRelationshipPath(attrKeyPath);
                    rel = entity.relationshipNamed(relKey);
                    if (rel.isFlattened()) {
                        rel = (EORelationship)rel._definitionArray().objectAtIndex(0);
                    }
                }
                EOJoin join = (EOJoin)rel.joins().lastObject();
                EOAttribute sourceAttr = join.sourceAttribute();
                attrs.addObject((Object)sourceAttr);
            }
            attributes = attrs;
            adaptorChannel._setRawDictionaryInitializerForAttributes(attributes);
        }
        customQuery = fetchSpec.hints().objectForKey((Object)CustomQueryExpressionHintKey);
        if (customQuery != null) {
            if (customQuery instanceof String) {
                customQuery = this.adaptorContext().adaptor().expressionFactory().expressionForString((String)customQuery);
            }
        } else {
            EOQualifier qual = EOQualifierSQLGeneration.Support._schemaBasedQualifierWithRootEntity(fetchSpec.qualifier(), entity);
            if (qual != fetchSpec.qualifier()) {
                fetchSpec = (EOFetchSpecification)fetchSpec.clone();
                fetchSpec.setQualifier(qual);
            }
        }
        if (!adaptorChannel.isOpen()) {
            adaptorChannel.openChannel();
        }
        if (customQuery != null) {
            adaptorChannel.evaluateExpression((EOSQLExpression)customQuery);
            adaptorChannel.setAttributesToFetch(attributes);
        } else {
            adaptorChannel.selectAttributes(attributes, fetchSpec, false, entity);
        }
        int fetchLimit = fetchSpec.fetchLimit();
        if (fetchSpec.promptsAfterFetchLimit() && _editingContextShouldContinueFetchingSelector.implementedByObject(context.messageHandler())) {
            fetchMessageHandler = context.messageHandler();
        }
        while ((row = adaptorChannel.fetchRow()) != null) {
            Object[] newObjectArray;
            boolean shouldContinueFetching;
            results.addObject((Object)row);
            if (fetchLimit == 0 || ++resultCount < fetchLimit || fetchMessageHandler != null && (shouldContinueFetching = ((Boolean)NSSelector._safeInvokeSelector((NSSelector)_editingContextShouldContinueFetchingSelector, (Object)fetchMessageHandler, (Object[])(newObjectArray = new Object[]{context, _NSUtilities.IntegerForInt((int)resultCount), _NSUtilities.IntegerForInt((int)fetchLimit), this}))).booleanValue())) continue;
            break;
        }
        adaptorChannel.cancelFetch();
        if (this._delegate.respondsTo(_databaseContextDidFetchObjects)) {
            this._delegate.perform(_databaseContextDidFetchObjects, new Object[]{this, results, fetchSpec, context});
        }
        return results;
    }

    public NSArray _objectsWithFetchSpecificationEditingContext(EOFetchSpecification fetchSpec, EOEditingContext context) {
        NSArray substituteArray;
        Object fetchMessageHandler = null;
        if (this._delegate.respondsTo(_databaseContextShouldFetchObjects) && (substituteArray = (NSArray)this._delegate.perform(_databaseContextShouldFetchObjects, (Object)this, (Object)fetchSpec, (Object)context)) != null) {
            return substituteArray;
        }
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOAccessGenericFaultHandler.processQueue(this._refQueueForHandlers);
        EOEntity entity = this._database.entityNamed(fetchSpec.entityName());
        if (entity == null) {
            return NSArray.EmptyArray;
        }
        if (entity.isAbstractEntity() && !fetchSpec.isDeep()) {
            throw new IllegalStateException("A FetchSpecification for an abstract entity must be 'deep'! Entity: " + entity.name());
        }
        NSArray rawRowKeyPaths = fetchSpec.rawRowKeyPaths();
        if (rawRowKeyPaths != null) {
            NSArray rawResults = this._fetchRawRowKeyPaths(rawRowKeyPaths, fetchSpec, entity, context);
            return rawResults;
        }
        if (!this._flags_ignoreEntityCaching && entity.cachesObjects()) {
            this._populateCacheForFetchSpecificationEditingContext(fetchSpec, context);
        }
        if (!this._flags_ignoreEntityCaching && entity.cachesObjects() && fetchSpec.isDeep() && this._validateQualifierForEvaluationInMemory(fetchSpec.qualifier(), entity)) {
            return this._objectsFromEntityCacheWithFetchSpecEditingContext(fetchSpec, context);
        }
        EODatabaseChannel channel = this._obtainOpenChannel();
        channel.selectObjectsWithFetchSpecification(fetchSpec, context);
        ++this._currentGeneration;
        NSMutableArray array = new NSMutableArray(64);
        int fetchLimit = fetchSpec.fetchLimit();
        if (fetchSpec.promptsAfterFetchLimit() && _editingContextShouldContinueFetchingSelector.implementedByObject(context.messageHandler())) {
            fetchMessageHandler = context.messageHandler();
        }
        int fetchCount = 0;
        boolean cont = true;
        while (cont) {
            EODatabaseChannel._EODatabaseChannelFetchResult object = channel._fetchObject();
            if (object != null) {
                array.addObject((Object)object);
                if (fetchLimit == 0 || ++fetchCount < fetchLimit || fetchMessageHandler != null && ((Boolean)NSSelector._safeInvokeSelector((NSSelector)_editingContextShouldContinueFetchingSelector, (Object)fetchMessageHandler, (Object[])new Object[]{context, _NSUtilities.IntegerForInt((int)fetchCount), _NSUtilities.IntegerForInt((int)fetchLimit), this})).booleanValue()) continue;
                cont = false;
                continue;
            }
            cont = false;
        }
        channel.cancelFetch();
        NSArray newArray = EODatabaseChannel._EODatabaseChannelFetchResult.initializeObjects((NSArray)array, context, this);
        NSArray prefetchingHints = fetchSpec.prefetchingRelationshipKeyPaths();
        if (prefetchingHints.count() > 0) {
            this._performPrefetchForFetchSpecification(fetchSpec, context, newArray, prefetchingHints);
        }
        if (this._delegate.respondsTo(_databaseContextDidFetchObjects)) {
            this._delegate.perform(_databaseContextDidFetchObjects, new Object[]{this, newArray, fetchSpec, context});
        }
        channel.setCurrentEditingContext(null);
        return newArray;
    }

    public boolean _validateKeyForEvaluationInMemory(String key, EOEntity entity) {
        if (key == null) {
            throw new IllegalStateException("Null-valued key found in qualifier");
        }
        boolean error = false;
        NSArray components = NSArray.componentsSeparatedByString((String)key, (String)".");
        int count = components.count();
        for (int i = 0; i < count && !error; ++i) {
            String component = (String)components.objectAtIndex(i);
            NSArray keys = entity.classPropertyAttributeNames();
            if (keys.containsObject((Object)component)) {
                if (i == count - 1) continue;
                return false;
            }
            EORelationship rel = entity.relationshipNamed(component);
            if (rel == null || rel.isToMany()) {
                return false;
            }
            entity = rel.destinationEntity();
            if (entity != null) continue;
            return false;
        }
        return true;
    }

    public boolean _validateQualifierForEvaluationInMemory(EOQualifier qual, EOEntity entity) {
        if (qual == null) {
            return true;
        }
        if (qual instanceof EOAndQualifier || qual instanceof EOOrQualifier) {
            NSArray qualifiers = qual instanceof EOAndQualifier ? ((EOAndQualifier)qual).qualifiers() : ((EOOrQualifier)qual).qualifiers();
            int count = qualifiers.count();
            for (int i = 0; i < count; ++i) {
                if (this._validateQualifierForEvaluationInMemory((EOQualifier)qualifiers.objectAtIndex(i), entity)) continue;
                return false;
            }
            return true;
        }
        if (qual instanceof EONotQualifier) {
            return this._validateQualifierForEvaluationInMemory(((EONotQualifier)qual).qualifier(), entity);
        }
        if (qual instanceof EOKeyValueQualifier) {
            return this._validateKeyForEvaluationInMemory(((EOKeyValueQualifier)qual).key(), entity);
        }
        if (qual instanceof EOKeyComparisonQualifier) {
            EOKeyComparisonQualifier kqual = (EOKeyComparisonQualifier)qual;
            return this._validateKeyForEvaluationInMemory(kqual.leftKey(), entity) && this._validateKeyForEvaluationInMemory(kqual.rightKey(), entity);
        }
        try {
            qual.validateKeysWithRootClassDescription(entity.classDescriptionForInstances());
        }
        catch (RuntimeException e) {
            NSLog._conditionallyLogPrivateException((Throwable)e);
            return false;
        }
        return true;
    }

    public NSArray objectsWithFetchSpecification(EOFetchSpecification fetchSpec, EOEditingContext context) {
        NSArray result = null;
        DatabaseContextEvent e = null;
        if (_IsEventLoggingEnabled) {
            e = new DatabaseContextEvent(DatabaseContextEvent.ObjectsWithFetchSpecification);
            EOEventCenter.markStartOfEvent((EOEvent)e, (Object)"objectsWithFetchSpecification()");
        }
        try {
            result = this._objectsWithFetchSpecificationEditingContext(fetchSpec, context);
        }
        catch (Exception localException) {
            if (this._delegateHandledDatabaseException(localException)) {
                result = this._objectsWithFetchSpecificationEditingContext(fetchSpec, context);
            } else if (this._isDroppedConnectionException(localException)) {
                try {
                    this._database.handleDroppedConnection();
                    result = this._objectsWithFetchSpecificationEditingContext(fetchSpec, context);
                }
                catch (Exception ex) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
            } else {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
        if (e != null) {
            EOEventCenter.markEndOfEvent((EOEvent)e);
        }
        return result;
    }

    public boolean isObjectLockedWithGlobalID(EOGlobalID gid, EOEditingContext ec) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        boolean result = this.isObjectLockedWithGlobalID(gid);
        return result;
    }

    public void lockObjectWithGlobalID(EOGlobalID gid, EOEditingContext ec) {
        block5: {
            EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
            try {
                NSDictionary snapshot = this.snapshotForGlobalID(gid);
                if (snapshot == null) {
                    return;
                }
                if (this._delegate.respondsTo(_databaseContextShouldLockObjectWithGlobalID) && !((Boolean)this._delegate.perform(_databaseContextShouldLockObjectWithGlobalID, (Object)this, (Object)gid, (Object)snapshot)).booleanValue()) {
                    return;
                }
                EOEntity entity = this._database.entityNamed(((EOKeyGlobalID)gid).entityName());
                EOQualifier qualifier = entity.qualifierForPrimaryKey(snapshot);
                EOFetchSpecification fs = new EOFetchSpecification(entity.name(), qualifier, null);
                fs.setLocksObjects(true);
                NSArray array = this.objectsWithFetchSpecification(fs, ec);
                if (array.count() != 1) {
                    throw new IllegalStateException("Failed to lock object:" + (Object)((Object)this) + " with gid:" + gid);
                }
            }
            catch (Exception e) {
                if (this._delegate.respondsTo(_databaseContextShouldRaiseExceptionForLockFailure) && !((Boolean)this._delegate.perform(_databaseContextShouldRaiseExceptionForLockFailure, (Object)this, (Object)e)).booleanValue()) break block5;
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
    }

    public void saveChangesInEditingContext(EOEditingContext context) {
        DatabaseContextEvent e = null;
        if (_IsEventLoggingEnabled) {
            e = new DatabaseContextEvent(DatabaseContextEvent.SaveChangesInEditingContext);
            EOEventCenter.markStartOfEvent((EOEvent)e, (Object)"saveChangesInEditingContext()");
        }
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOAccessGenericFaultHandler.processQueue(this._refQueueForHandlers);
        this.prepareForSaveWithCoordinator(null, context);
        this.recordChangesInEditingContext();
        try {
            this.performChanges();
        }
        catch (Exception localException) {
            if (this._delegateHandledDatabaseException(localException)) {
                try {
                    this.performChanges();
                }
                catch (Exception e2) {
                    this.rollbackChanges();
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e2);
                }
            }
            if (this._isDroppedConnectionException(localException)) {
                try {
                    this._database.handleDroppedConnection();
                    this.performChanges();
                }
                catch (Exception ex) {
                    this.rollbackChanges();
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
            }
            this.rollbackChanges();
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
        }
        this.commitChanges();
        if (e != null) {
            EOEventCenter.markEndOfEvent((EOEvent)e);
        }
    }

    public void _turnToFaultGidEditingContextIsComplete(Object obj, EOKeyGlobalID gid, EOEditingContext context, boolean complete) {
        String entityName = gid.entityName();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOAccessFaultHandler handler = new EOAccessFaultHandler(gid, this, context);
        EOAccessGenericFaultHandler head = (EOAccessGenericFaultHandler)((Object)this._batchFaultBuffer.objectForKey((Object)entityName));
        if (head == null) {
            head = new EOAccessFaultHandler(gid, this, context);
            this._batchFaultBuffer.setObjectForKey((Object)head, (Object)entityName);
        }
        handler.linkAfterHandler(head, this._currentGeneration);
        EOFaultHandler.makeObjectIntoFault((Object)obj, (EOFaultHandler)handler);
    }

    public EOEnterpriseObject faultForGlobalID(EOGlobalID globalID, EOEditingContext context) {
        EOEntity entity = null;
        EOEnterpriseObject obj = null;
        EOKeyGlobalID gid = null;
        if (!(globalID instanceof EOKeyGlobalID)) {
            throw new IllegalArgumentException("faultForGlobalID: The globalID " + globalID + " must be an EOKeyGlobalID to be able to construct a fault.");
        }
        gid = (EOKeyGlobalID)globalID;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        entity = this.entityForGlobalID((EOGlobalID)gid);
        if (gid._isFinal()) {
            obj = entity.classDescriptionForInstances().createInstanceWithEditingContext(context, (EOGlobalID)gid);
            this._turnToFaultGidEditingContextIsComplete(obj, gid, context, true);
            context.recordObject(obj, (EOGlobalID)gid);
        } else {
            obj = this._fetchSingleObject(entity, (EOGlobalID)gid, context);
        }
        return obj;
    }

    EOEnterpriseObject _fetchSingleObject(EOEntity entity, EOGlobalID gid, EOEditingContext context) {
        EOKeyGlobalID gidForSnapshot = (EOKeyGlobalID)this.database()._recordedGIDForSnapshotWithGid(gid);
        if (gidForSnapshot != null && gidForSnapshot._isFinal()) {
            return context.faultForGlobalID((EOGlobalID)gidForSnapshot, context);
        }
        NSDictionary priKey = entity.primaryKeyForGlobalID(gid);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(entity.name(), entity.qualifierForPrimaryKey(priKey), null, false, true, null);
        fetchSpec.setFetchLimit(1);
        NSArray objects = this.objectsWithFetchSpecification(fetchSpec, context);
        if (objects.count() == 0) {
            throw new IllegalStateException("The object with globalID " + gid + " could not be found in the database. This could be result of a referential integrity problem with the database. An empty fault could not be created because the object's class could not be determined (e.g. the GID is temporary or it is for an abstract entity).");
        }
        return (EOEnterpriseObject)objects.objectAtIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refaultObject(EOEnterpriseObject object, EOGlobalID globalID, EOEditingContext context) {
        EOKeyGlobalID gid = null;
        if (!(globalID instanceof EOKeyGlobalID)) {
            throw new IllegalArgumentException("refaultObject: The globalID " + globalID + " must be an EOKeyGlobalID to be able to construct a fault.");
        }
        gid = (EOKeyGlobalID)globalID;
        if (!EOFaultHandler.isFault((Object)object)) {
            EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
            EOObserverCenter.suppressObserverNotification();
            try {
                object.clearProperties();
            }
            finally {
                EOObserverCenter.enableObserverNotification();
            }
            this._turnToFaultGidEditingContextIsComplete(object, gid, context, true);
            if (context instanceof EOSharedEditingContext) {
                ((EOSharedEditingContext)context)._completeRefaultingOfGID((EOGlobalID)gid, object);
            }
        }
    }

    public NSArray arrayFaultWithSourceGlobalID(EOGlobalID globalID, String name, EOEditingContext context) {
        EOKeyGlobalID gid = null;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!(globalID instanceof EOKeyGlobalID)) {
            throw new IllegalArgumentException("arrayFaultWithSourceGlobalID: The globalID " + globalID + " must be an EOKeyGlobalID to be able to construct a fault.");
        }
        gid = (EOKeyGlobalID)globalID;
        EOAccessArrayFaultHandler handler = new EOAccessArrayFaultHandler(gid, name, this, context);
        _EOCheapCopyMutableArray array = new _EOCheapCopyMutableArray((EOFaultHandler)handler);
        EOAccessGenericFaultHandler head = (EOAccessGenericFaultHandler)((Object)this._batchToManyFaultBuffer.objectForKey((Object)this.entityForGlobalID((EOGlobalID)gid).relationshipNamed(name).destinationEntity().name()));
        if (head == null) {
            head = new EOAccessArrayFaultHandler(gid, name, this, context);
            this._batchToManyFaultBuffer.setObjectForKey((Object)head, (Object)this.entityForGlobalID((EOGlobalID)gid).relationshipNamed(name).destinationEntity().name());
        }
        handler.linkAfterHandler(head, this._currentGeneration);
        return array;
    }

    public void initializeObject(EOEnterpriseObject object, EOGlobalID gid, EOEditingContext context) {
        EOEntity entity;
        NSDictionary row;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (gid == this._currentGlobalID) {
            row = this._currentSnapshot;
            entity = this._lastEntity;
        } else {
            if (gid.isTemporary()) {
                return;
            }
            row = this.snapshotForGlobalID(gid);
            if (((EOKeyGlobalID)gid)._isFinal()) {
                entity = this.entityForGlobalID(gid);
            } else {
                object = context.objectForGlobalID(gid);
                if (object == null) {
                    throw new IllegalStateException("initializeObject: No object for gid " + gid + " in " + context);
                }
                entity = this._database.entityForObject(object);
            }
        }
        if (row == null) {
            throw new IllegalStateException("initializeObject: No snapshot for gid " + gid);
        }
        this.initializeObjectRowEntityEditingContext(object, row, entity, context);
        this._database.incrementSnapshotCountForGlobalID(gid);
    }

    public void editingContextDidForgetObjectWithGlobalID(EOEditingContext context, EOGlobalID gid) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._database.decrementSnapshotCountForGlobalID(gid);
    }

    public void invalidateObjectsWithGlobalIDs(NSArray gids) {
        NSMutableArray gidsToRevert = null;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._delegate.respondsTo(_databaseContextShouldInvalidateObjectWithGlobalID)) {
            for (int i = gids.count() - 1; i >= 0; --i) {
                EOGlobalID gid = (EOGlobalID)gids.objectAtIndex(i);
                NSDictionary snapshot = this.snapshotForGlobalID(gid);
                if (snapshot == null || !((Boolean)this._delegate.perform(_databaseContextShouldInvalidateObjectWithGlobalID, (Object)this, (Object)gid, (Object)snapshot)).booleanValue()) continue;
                if (gidsToRevert == null) {
                    gidsToRevert = new NSMutableArray();
                }
                gidsToRevert.addObject((Object)gid);
            }
            if (gidsToRevert.count() != 0) {
                this.forgetSnapshotsForGlobalIDs((NSArray)gidsToRevert);
                this.forgetLocksForObjectsWithGlobalIDs((NSArray)gidsToRevert);
            }
        } else {
            this.forgetSnapshotsForGlobalIDs(gids);
            this.forgetLocksForObjectsWithGlobalIDs(gids);
        }
    }

    public void invalidateAllObjects() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._database.invalidateResultCache();
        this.invalidateObjectsWithGlobalIDs(this._database.snapshots().allKeys());
        NSNotificationCenter.defaultCenter().postNotification("EOInvalidatedAllObjectsInStoreNotification", (Object)this, null);
    }

    public void _snapshotsChangedInDatabase(NSNotification notification) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._dbOperationsByGlobalID == null || !_suppressRedundantEODatabaseChangeNotification) {
            NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this, notification.userInfo());
        }
    }

    public void _objectsChanged(NSNotification notification) {
        NSArray invalidated;
        NSArray deleted;
        NSArray inserted;
        int cnt = 0;
        NSDictionary userInfo = notification.userInfo();
        NSArray updated = (NSArray)userInfo.objectForKey((Object)"updated");
        if (updated != null) {
            cnt += updated.count();
        }
        if ((inserted = (NSArray)userInfo.objectForKey((Object)"inserted")) != null) {
            cnt += inserted.count();
        }
        if ((deleted = (NSArray)userInfo.objectForKey((Object)"deleted")) != null) {
            cnt += deleted.count();
        }
        if ((invalidated = (NSArray)userInfo.objectForKey((Object)"invalidated")) != null) {
            cnt += invalidated.count();
        }
        NSMutableArray big = new NSMutableArray(cnt);
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (updated != null) {
            big.addObjectsFromArray(updated);
        }
        if (inserted != null) {
            big.addObjectsFromArray(inserted);
        }
        if (deleted != null) {
            big.addObjectsFromArray(deleted);
        }
        if (invalidated != null) {
            big.addObjectsFromArray(invalidated);
        }
        int c = big.count();
        for (int i = 0; i < c; ++i) {
            Object gid = big.objectAtIndex(i);
            if (!(gid instanceof EOKeyGlobalID)) continue;
            this._database.invalidateResultCacheForEntityNamed(((EOKeyGlobalID)gid).entityName());
        }
    }

    private NSDictionary _primaryKeyForRelatedObject(EOEnterpriseObject srcObj, EORelationship relationship, EOEditingContext editingContext) {
        if (relationship._isToOneClassProperty()) {
            EOEnterpriseObject dest = (EOEnterpriseObject)srcObj.storedValueForKey(relationship.name());
            EOGlobalID gid = null;
            if (dest != null && dest.isFault()) {
                gid = editingContext.globalIDForObject(dest);
            }
            if (gid == null || gid.isTemporary()) {
                return null;
            }
            return relationship.destinationEntity().primaryKeyForGlobalID(gid);
        }
        NSDictionary keyMap = relationship._sourceToDestinationKeyMap();
        NSArray srcKeys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
        NSArray dstKeys = (NSArray)keyMap.objectForKey((Object)"destinationKeys");
        NSMutableDictionary pk = this._mutableValuesForKeys(srcKeys, srcObj);
        _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)pk, (NSArray)srcKeys, (NSArray)dstKeys);
        return pk;
    }

    public void _batchFetchRelationshipForSourceObjectsEditingContext(EORelationship relationship, NSArray objects, EOEditingContext editingContext) {
        EOFetchSpecification fetchSpecification = new EOFetchSpecification();
        EOEntity sourceEntity = relationship.entity();
        int cnt = objects.count();
        NSMutableArray qualifiers = new NSMutableArray(cnt);
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (relationship.isToMany() || !sourceEntity.classProperties().containsObject((Object)relationship)) {
            for (int i = 0; i < cnt; ++i) {
                EOEnterpriseObject src = (EOEnterpriseObject)objects.objectAtIndex(i);
                EOGlobalID gid = editingContext.globalIDForObject(src);
                NSDictionary pk = sourceEntity.primaryKeyForGlobalID(gid);
                if (pk == null) continue;
                qualifiers.addObject((Object)sourceEntity.qualifierForDBSnapshot(pk));
            }
            if (qualifiers.count() == 0) {
                return;
            }
            fetchSpecification.setEntityName(sourceEntity.name());
            fetchSpecification.setQualifier((EOQualifier)new EOOrQualifier((NSArray)qualifiers));
            fetchSpecification.setPrefetchingRelationshipKeyPaths(new NSArray((Object)relationship.name()));
            this._followFetchSpecification(fetchSpecification, relationship.name(), objects, editingContext);
        } else {
            String key = relationship.name();
            EOEntity destinationEntity = relationship.destinationEntity();
            NSMutableSet qualifiedGids = new NSMutableSet(cnt);
            for (int i = 0; i < cnt; ++i) {
                EOEnterpriseObject src = (EOEnterpriseObject)objects.objectAtIndex(i);
                EOEnterpriseObject dest = (EOEnterpriseObject)src.storedValueForKey(key);
                EOGlobalID gid = null;
                if (dest != null && dest.isFault()) {
                    gid = editingContext.globalIDForObject(dest);
                }
                if (gid == null || gid.isTemporary() || qualifiedGids.containsObject((Object)gid)) continue;
                NSDictionary pk = destinationEntity.primaryKeyForGlobalID(gid);
                if (pk != null) {
                    qualifiers.addObject((Object)destinationEntity.qualifierForDBSnapshot(pk));
                }
                qualifiedGids.addObject((Object)gid);
            }
            if (qualifiers.count() == 0) {
                return;
            }
            fetchSpecification.setEntityName(destinationEntity.name());
            EOOrQualifier qFetch = new EOOrQualifier((NSArray)qualifiers);
            if (relationship.auxiliaryQualifier() != null) {
                qFetch = new EOAndQualifier(new NSArray(new Object[]{qFetch, relationship.auxiliaryQualifier()}));
            }
            fetchSpecification.setQualifier((EOQualifier)qFetch);
            fetchSpecification.setIsDeep(true);
            this.objectsWithFetchSpecification(fetchSpecification, editingContext);
        }
    }

    boolean _usesPessimisticLocking(EOFetchSpecification fetchSpecification, EODatabaseChannel databaseChannel) {
        if (this._delegate.respondsTo(_databaseContextShouldUsePessimisticLock)) {
            return this._delegate.booleanPerform(_databaseContextShouldUsePessimisticLock, (Object)this, (Object)fetchSpecification, (Object)databaseChannel);
        }
        if (this.updateStrategy() == 1) {
            return true;
        }
        if (fetchSpecification != null) {
            return fetchSpecification.locksObjects();
        }
        return false;
    }

    public void batchFetchRelationship(EORelationship relationship, NSArray objects, EOEditingContext editingContext) {
        EOClassDescription cd = relationship.entity().classDescriptionForInstances();
        int c = objects.count();
        for (int i = 0; i < c; ++i) {
            if (((EOCustomObject)objects.objectAtIndex(i)).classDescription() == cd) continue;
            throw new IllegalStateException("batchFetchRelationship(): Object " + objects.objectAtIndex(i) + " is not originating from the entity " + relationship.entity() + " source of the relationship " + relationship);
        }
        if (!this._usesPessimisticLocking(null, null)) {
            EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
            this._batchFetchRelationshipForSourceObjectsEditingContext(relationship, objects, editingContext);
        }
    }

    public void _registersnapshotForSourceGlobalIDEditingContext(NSArray results, EOGlobalID gid, String name, EOEditingContext context) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!_useToManyCaching) {
            return;
        }
        int cnt = results.count();
        NSMutableArray gids = new NSMutableArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            gids.addObject((Object)context.globalIDForObject((EOEnterpriseObject)results.objectAtIndex(i)));
        }
        this._database.recordSnapshotForSourceGlobalID((NSArray)gids, gid, name);
    }

    public NSArray objectsForSourceGlobalID(EOGlobalID gid, String name, EOEditingContext context) {
        EOFetchSpecification fetchSpec;
        NSArray arraySnap;
        EOAccessArrayFaultHandler handler = null;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOEnterpriseObject sourceObject = context.faultForGlobalID(gid, context);
        if (sourceObject == null) {
            throw new IllegalStateException("Unable to fetch the relationship " + name + " for GlobalID " + gid + ". Source object not availaible.");
        }
        NSMutableArray fault = (NSMutableArray)sourceObject.storedValueForKey(name);
        if (fault != null && EOFaultHandler.isFault((Object)fault)) {
            handler = (EOAccessArrayFaultHandler)EOFaultHandler.handlerForFault((Object)fault);
        }
        if (this._currentBatch == fault) {
            this._currentBatch = null;
            return null;
        }
        if (this._currentBatch != null) {
            this._registersnapshotForSourceGlobalIDEditingContext((NSArray)this._currentBatch, gid, name, context);
            return (NSArray)this._currentBatch;
        }
        if (_useToManyCaching && (arraySnap = this.snapshotForSourceGlobalID(gid, name, context.fetchTimestamp())) != null) {
            NSMutableArray result;
            int c = arraySnap.count();
            if (fault != null && EOFaultHandler.isFault((Object)fault)) {
                EOFaultHandler.clearFault((Object)fault);
                result = fault;
            } else {
                result = new NSMutableArray(c);
            }
            for (int i = 0; i < c; ++i) {
                result.addObject((Object)context.faultForGlobalID((EOGlobalID)arraySnap.objectAtIndex(i), context));
            }
            return result;
        }
        EORelationship relationship = this.entityForGlobalID(gid).relationshipNamed(name);
        if (relationship == null) {
            throw new IllegalStateException("Unable to fetch the relationship " + name + " for GlobalID " + gid + ". The relationship is not availaible in the model.");
        }
        int batchCount = relationship.numberOfToManyFaultsToBatchFetch();
        if (batchCount == 0) {
            if (relationship.isToManyToOne()) {
                batchCount = relationship.firstRelationship().numberOfToManyFaultsToBatchFetch();
            }
            if (batchCount == 0) {
                batchCount = 1;
            }
        }
        if (this._database.models().indexOfObject((Object)relationship.destinationEntity().model()) != -1 && !this._usesPessimisticLocking(null, null) && batchCount > 1 && handler != null) {
            EOEnterpriseObject obj;
            EOAccessArrayFaultHandler currentHandler;
            NSMutableArray sourceObjects = new NSMutableArray(batchCount);
            int generationNumber = handler.generation();
            String entityName = handler.sourceGlobalID().entityName();
            String relName = relationship.name();
            sourceObjects.addObject((Object)sourceObject);
            --batchCount;
            for (currentHandler = (EOAccessArrayFaultHandler)handler.previous(); batchCount != 0 && currentHandler != null && currentHandler.previous() != null && generationNumber == currentHandler.generation() && context == currentHandler.editingContext(); currentHandler = (EOAccessArrayFaultHandler)currentHandler.previous()) {
                if (!entityName.equals(currentHandler.sourceGlobalID().entityName()) || !relName.equals(currentHandler.relationshipName()) || (obj = context.objectForGlobalID((EOGlobalID)currentHandler.sourceGlobalID())) == null) continue;
                --batchCount;
                sourceObjects.addObject((Object)obj);
            }
            for (currentHandler = (EOAccessArrayFaultHandler)handler.next(); batchCount != 0 && currentHandler != null && generationNumber == currentHandler.generation() && context == currentHandler.editingContext(); currentHandler = (EOAccessArrayFaultHandler)currentHandler.next()) {
                if (!entityName.equals(currentHandler.sourceGlobalID().entityName()) || !relName.equals(currentHandler.relationshipName()) || (obj = context.objectForGlobalID((EOGlobalID)currentHandler.sourceGlobalID())) == null) continue;
                --batchCount;
                sourceObjects.addObject((Object)obj);
            }
            this._batchFetchRelationshipForSourceObjectsEditingContext(relationship, (NSArray)sourceObjects, context);
            return fault;
        }
        EOQualifier auxiliaryQualifier = relationship.auxiliaryQualifier();
        NSDictionary snapshot = this.snapshotForGlobalID(gid);
        if (snapshot == null) {
            fetchSpec = new EOFetchSpecification();
            EOEntity entity = this.entityForGlobalID(gid);
            NSDictionary primaryKey = entity.primaryKeyForGlobalID(gid);
            fetchSpec.setEntityName(entity.name());
            fetchSpec.setQualifier(entity.qualifierForPrimaryKey(primaryKey));
            NSArray retainEOs = this.objectsWithFetchSpecification(fetchSpec, context);
            fetchSpec = null;
            snapshot = this.snapshotForGlobalID(gid);
            if (snapshot == null) {
                throw new IllegalStateException("There is no database snapshot available for the object " + sourceObject + " with GlobalID " + gid);
            }
        }
        EOQualifier qualifier = null;
        EOEnterpriseObject objectForObjectQualifier = context.objectForGlobalID(gid);
        if (objectForObjectQualifier != null) {
            EORelationship inverse = null;
            inverse = relationship.inverseRelationship();
            if (inverse != null && inverse.entity().classProperties().containsObject((Object)inverse)) {
                qualifier = new EOKeyValueQualifier(inverse.name(), EOQualifier.QualifierOperatorEqual, (Object)objectForObjectQualifier);
            }
        }
        if (qualifier == null) {
            qualifier = relationship.qualifierForDBSnapshot(snapshot);
        }
        if (auxiliaryQualifier != null) {
            qualifier = new EOAndQualifier(new NSArray(new Object[]{qualifier, auxiliaryQualifier}));
        }
        fetchSpec = new EOFetchSpecification();
        fetchSpec.setQualifier(qualifier);
        fetchSpec.setEntityName(relationship.destinationEntity().name());
        if (this._delegate.respondsTo(_databaseContextWillFireArrayFaultForGlobalID)) {
            this._delegate.perform(_databaseContextWillFireArrayFaultForGlobalID, new Object[]{this, gid, relationship, fetchSpec, context});
        }
        NSArray result = context.objectsWithFetchSpecification(fetchSpec, context);
        this._registersnapshotForSourceGlobalIDEditingContext(result, gid, name, context);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _fireFault(EOEnterpriseObject fault) {
        EOAccessFaultHandler handler = (EOAccessFaultHandler)EOFaultHandler.handlerForFault((Object)fault);
        EOEditingContext ec = handler.editingContext();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!EOFaultHandler.isFault((Object)fault)) {
            return;
        }
        EOEnterpriseObject obj = fault;
        handler = (EOAccessFaultHandler)EOFaultHandler.handlerForFault((Object)fault);
        ec = handler.editingContext();
        EOKeyGlobalID gid = handler.globalID();
        NSDictionary row = this.snapshotForGlobalID((EOGlobalID)gid, ec.fetchTimestamp());
        if (row != null && handler.globalID()._isFinal()) {
            EOObserverCenter.suppressObserverNotification();
            try {
                EOFaultHandler.clearFault((Object)fault);
                ec.initializeObject(obj, (EOGlobalID)gid, ec);
            }
            finally {
                EOObserverCenter.enableObserverNotification();
            }
            obj.awakeFromFetch(ec);
            return;
        }
        EOEntity entity = this.entityForGlobalID((EOGlobalID)gid);
        if (!this._flags_ignoreEntityCaching && entity.cachesObjects()) {
            EOFetchSpecification fs = new EOFetchSpecification(entity.name(), null, null);
            this._populateCacheForFetchSpecificationEditingContext(fs, ec);
        } else if (!this._delegate.respondsTo(_databaseContextShouldFetchObjectFault) || ((Boolean)this._delegate.perform(_databaseContextShouldFetchObjectFault, (Object)this, (Object)fault)).booleanValue()) {
            NSDictionary primaryKey;
            int gen = handler.generation();
            int batchCount = entity.maxNumberOfInstancesToBatchFetch();
            if (batchCount == 0) {
                batchCount = 1;
            }
            NSMutableArray qualifiers = new NSMutableArray(batchCount);
            EOAccessGenericFaultHandler currentHandler = handler;
            EOAccessFaultHandler castedHandler = currentHandler;
            do {
                if (this.snapshotForGlobalID((EOGlobalID)castedHandler.globalID(), ec.fetchTimestamp()) == null || !castedHandler.globalID()._isFinal()) {
                    primaryKey = entity.primaryKeyForGlobalID((EOGlobalID)castedHandler.globalID());
                    qualifiers.addObject((Object)entity.qualifierForPrimaryKey(primaryKey));
                }
                currentHandler = currentHandler.previous();
                castedHandler = currentHandler;
            } while (--batchCount != 0 && currentHandler != null && currentHandler.previous() != null && gen == currentHandler.generation() && ec == currentHandler.editingContext());
            for (currentHandler = handler.next(); currentHandler != null && batchCount-- != 0 && gen == currentHandler.generation() && ec == currentHandler.editingContext(); currentHandler = currentHandler.next()) {
                if (this.snapshotForGlobalID((EOGlobalID)((EOAccessFaultHandler)currentHandler).globalID(), ec.fetchTimestamp()) != null && ((EOAccessFaultHandler)currentHandler).globalID()._isFinal()) continue;
                primaryKey = entity.primaryKeyForGlobalID((EOGlobalID)((EOAccessFaultHandler)currentHandler).globalID());
                qualifiers.addObject((Object)entity.qualifierForPrimaryKey(primaryKey));
            }
            EOFetchSpecification fetchSpec = new EOFetchSpecification();
            fetchSpec.setEntityName(entity.name());
            fetchSpec.setQualifier((EOQualifier)new EOOrQualifier((NSArray)qualifiers));
            if (this._delegate.respondsTo(_databaseContextWillFireObjectFaultForGlobalID)) {
                this._delegate.perform(_databaseContextWillFireObjectFaultForGlobalID, new Object[]{this, gid, fetchSpec, ec});
            }
            NSArray nSArray = this.objectsWithFetchSpecification(fetchSpec, ec);
        }
        if (EOFaultHandler.isFault((Object)obj)) {
            EOFaultHandler.clearFault((Object)obj);
            if (this._delegate == null || !this._delegate.respondsTo(_databaseContextFailedToFetchObject) || !((Boolean)this._delegate.perform(_databaseContextFailedToFetchObject, (Object)this, (Object)obj, (Object)gid)).booleanValue()) {
                this._missingObjectGIDs.addObject((Object)gid);
            }
        }
    }

    public void _fireArrayFault(Object fault) {
        EOAccessArrayFaultHandler handler = (EOAccessArrayFaultHandler)EOFaultHandler.handlerForFault((Object)fault);
        if (handler == null) {
            throw new IllegalStateException("Cannot fire array fault with a null handler.");
        }
        EOEditingContext editingContext = handler.editingContext();
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (!EOFaultHandler.isFault((Object)fault)) {
            return;
        }
        handler = (EOAccessArrayFaultHandler)EOFaultHandler.handlerForFault((Object)fault);
        if (this._delegate.respondsTo(_databaseContextShouldFetchArrayFault) && !((Boolean)this._delegate.perform(_databaseContextShouldFetchArrayFault, (Object)this, fault)).booleanValue()) {
            if (EOFaultHandler.isFault((Object)fault)) {
                throw new IllegalStateException("_fireArrayFault: Failed to fetch the array fault " + fault + ".  Your delegate must clear the fault if it answers NO to databaseContextShouldFetchArrayFault().");
            }
            return;
        }
        NSArray result = editingContext.objectsForSourceGlobalID((EOGlobalID)handler.sourceGlobalID(), handler.relationshipName(), editingContext);
        if (result != null && EOFaultHandler.isFault((Object)fault)) {
            EOFaultHandler.clearFault((Object)fault);
            ((NSMutableArray)fault).addObjectsFromArray(result);
        }
    }

    public static void _EOAssertSafeMultiThreadedAccess(EODatabaseContext dbc) {
        if (!_doAssertLock) {
            return;
        }
        if (!_doAssertLockInitialized) {
            EODatabaseContext._checkAssertLock();
            if (!_doAssertLock) {
                return;
            }
        }
        if (!dbc._verifyLock() && NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)16L)) {
            NSLog.debug.appendln((Object)"*** EODatabaseContext: access without lock!");
            if (NSLog.allowedDebugLevel() >= 2) {
                NSLog.debug.appendln((Throwable)new Exception("This is not a real exception, just a stack trace of the location of the missing lock:"));
            }
        }
    }

    private void _buildPrimaryKeyGeneratorListForEditingContext(EOEditingContext ec) {
        NSMutableArray array = new NSMutableArray(3);
        if (this._nonPrimaryKeyGenerators == null) {
            this._nonPrimaryKeyGenerators = new NSMutableSet();
        }
        NSMutableSet processedEntities = new NSMutableSet(16);
        this._nonPrimaryKeyGenerators.removeAllObjects();
        array.addObject((Object)ec.updatedObjects());
        array.addObject((Object)ec.insertedObjects());
        array.addObject((Object)ec.deletedObjects());
        try {
            for (int i = array.count() - 1; i >= 0; --i) {
                NSArray objects = (NSArray)array.objectAtIndex(i);
                for (int j = objects.count() - 1; j >= 0; --j) {
                    EOObjectStore rootObjectStore;
                    EOModel rootParentModel;
                    EOEnterpriseObject obj = (EOEnterpriseObject)objects.objectAtIndex(j);
                    EOEntity entity = this._entityForObject(obj);
                    String entityName = entity.name();
                    if (processedEntities.member((Object)entityName) != null) continue;
                    processedEntities.addObject((Object)entityName);
                    NSArray rels = entity.relationships();
                    int iCount = rels.count();
                    for (int k = iCount - 1; k >= 0; --k) {
                        EORelationship rel = (EORelationship)rels.objectAtIndex(k);
                        if (!rel.propagatesPrimaryKey()) continue;
                        EOEntity destEntity = rel.destinationEntity();
                        NSMutableArray array1 = new NSMutableArray(8);
                        array1.addObject((Object)entity);
                        NSMutableArray array2 = new NSMutableArray(8);
                        EOEntity._assertNoPropagateKeyCycleWithEntitiesRelationships(array1, array2);
                        this._nonPrimaryKeyGenerators.addObject((Object)destEntity.name());
                    }
                    EOEntity rootParent = entity.rootParent();
                    if (rootParent == entity || (rootParentModel = rootParent.model()) == null || this._database.models().indexOfIdenticalObject((Object)rootParentModel) != -1 || !((rootObjectStore = ec.rootObjectStore()) instanceof EOObjectStoreCoordinator)) continue;
                    EOObjectStoreCoordinator coord = (EOObjectStoreCoordinator)rootObjectStore;
                    EOCooperatingObjectStore objStore = coord.objectStoreForFetchSpecification(new EOFetchSpecification(rootParent.name(), null, null, false, false, null));
                    if (objStore == null) {
                        throw new IllegalStateException("Unable to find an EOObjectStore for root parent entity '" + rootParent.name() + "' of entity '" + entityName + "'.");
                    }
                    if (this._database.models().indexOfIdenticalObject((Object)rootParentModel) != -1) continue;
                    this._nonPrimaryKeyGenerators.addObject((Object)entityName);
                }
            }
        }
        catch (Exception localException) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
        }
    }

    private EOEntity _entityForObject(EOEnterpriseObject enterpriseObject) {
        if (enterpriseObject == null) {
            throw new IllegalArgumentException("Enterprise object cannot be null");
        }
        EOEntity domesticEntity = this._database.entityForObject(enterpriseObject);
        if (domesticEntity != null) {
            return domesticEntity;
        }
        EOObjectStoreCoordinator coordinator = this.coordinator();
        if (coordinator == null) {
            throw new IllegalStateException("Object store coordinator cannot be null");
        }
        NSArray objectStores = coordinator.cooperatingObjectStores();
        int c = objectStores.count();
        for (int i = 0; i < c; ++i) {
            EOEntity foreignEntity;
            Object objectStore = objectStores.objectAtIndex(i);
            if (!(objectStore instanceof EODatabaseContext) || (foreignEntity = ((EODatabaseContext)((Object)objectStore)).database().entityForObject(enterpriseObject)) == null) continue;
            return foreignEntity;
        }
        throw new IllegalStateException("Unable to find entity for object " + enterpriseObject);
    }

    public boolean _shouldGeneratePrimaryKeyForEntityName(String entityName) {
        return !this._nonPrimaryKeyGenerators.containsObject((Object)entityName);
    }

    public void _assertValidStateWithSelector(NSSelector sel) {
        if (!this._flags_willPrepareForSave && !this._flags_preparingForSave) {
            throw new IllegalStateException("_assertValidStateWithSelector: " + sel + " " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " is in invalid state, call prepareForSaveWithCoordinator() before calling this method.");
        }
    }

    public void _cleanUpAfterSave() {
        this._editingContext = null;
        this._dbOperationsByGlobalID = null;
        this._flags_beganTransaction = false;
        this._flags_willPrepareForSave = false;
        this._flags_preparingForSave = false;
        EODatabase db = this.database();
        if (db != null) {
            db._clearLastRecords();
        }
    }

    public NSDictionary _databaseContextState() {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.setObjectForKey((Object)this, (Object)"databaseContext");
        dict.setObjectForKey((Object)this.coordinator(), (Object)"coordinator");
        dict.setObjectForKey((Object)this._editingContext, (Object)"editingContext");
        dict.setObjectForKey((Object)this._dbOperationsByGlobalID.allValues(), (Object)"databaseOperations");
        return dict;
    }

    public RuntimeException _exceptionWithDatabaseContextInformationAdded(Exception exception) {
        NSMutableDictionary info = exception instanceof EOGeneralAdaptorException ? ((EOGeneralAdaptorException)exception).userInfo().mutableClone() : new NSMutableDictionary();
        info.setObjectForKey((Object)this._databaseContextState(), (Object)DatabaseContextKey);
        NSArray dbOps = this._dbOperationsByGlobalID.allValues();
        info.setObjectForKey((Object)dbOps, (Object)DatabaseOperationsKey);
        EOAdaptorOperation failedAdaptorOp = (EOAdaptorOperation)info.objectForKey((Object)"EOFailedAdaptorOperationKey");
        if (failedAdaptorOp != null) {
            for (int i = dbOps.count() - 1; i >= 0; --i) {
                EODatabaseOperation dbOp = (EODatabaseOperation)dbOps.objectAtIndex(i);
                NSArray adOps = dbOp.adaptorOperations();
                if (!adOps.containsObject((Object)failedAdaptorOp)) continue;
                info.setObjectForKey((Object)dbOp, (Object)FailedDatabaseOperationKey);
                break;
            }
        }
        return new EOGeneralAdaptorException(exception.getMessage(), (NSDictionary)info);
    }

    public NSDictionary _currentCommittedSnapshotForObject(EOEnterpriseObject object) {
        EOGlobalID gid = this._editingContext.globalIDForObject(object);
        EODatabaseOperation dbOp = (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
        if (dbOp != null && dbOp.databaseOperator() == 1) {
            return NSDictionary.EmptyDictionary;
        }
        return this._editingContext.committedSnapshotForObject(object);
    }

    private NSDictionary _primaryKeyForObject(EOEnterpriseObject object) {
        EOAttribute pkAttr;
        NSArray pkAttrs;
        EOStoredProcedure sp;
        NSDictionary pkDict = null;
        EOEntity entity = this._database.entityForObject(object);
        pkDict = entity.primaryKeyForGlobalID(this._globalIDForObject(object));
        NSDictionary classPropPKValues = this.valuesForKeys(entity.primaryKeyAttributeNames(), object);
        if (classPropPKValues.count() > 0) {
            if (pkDict != null) {
                Enumeration enumerator = classPropPKValues.keyEnumerator();
                NSMutableDictionary newDict = pkDict.mutableClone();
                while (enumerator.hasMoreElements()) {
                    String key = (String)enumerator.nextElement();
                    Object value = classPropPKValues.objectForKey((Object)key);
                    if (value == null || value == NSKeyValueCoding.NullValue || value instanceof Number && ((Number)value).intValue() == 0) continue;
                    newDict.setObjectForKey(value, (Object)key);
                }
                pkDict = newDict;
            } else {
                pkDict = classPropPKValues;
            }
        }
        if (!entity.isPrimaryKeyValidInObject((NSKeyValueCoding)pkDict)) {
            pkDict = null;
        }
        if (pkDict == null && this._delegate.respondsTo(_databaseContextNewPrimaryKey)) {
            pkDict = (NSDictionary)this._delegate.perform(_databaseContextNewPrimaryKey, (Object)this, (Object)object, (Object)entity);
        }
        if (pkDict == null && (sp = entity.storedProcedureForOperation("EONextPrimaryKeyProcedure")) != null) {
            try {
                EOAdaptorChannel adaptorChannel = this._obtainOpenChannel().adaptorChannel();
                adaptorChannel.executeStoredProcedure(sp, null);
                pkDict = adaptorChannel.returnValuesForLastStoredProcedureInvocation();
            }
            catch (Exception localException) {
                if (this._delegateHandledDatabaseException(localException)) {
                    EOAdaptorChannel adaptorChannel = this._obtainOpenChannel().adaptorChannel();
                    adaptorChannel.executeStoredProcedure(sp, null);
                    pkDict = adaptorChannel.returnValuesForLastStoredProcedureInvocation();
                } else if (this._isDroppedConnectionException(localException)) {
                    this._database.handleDroppedConnection();
                    EOAdaptorChannel adaptorChannel = this._obtainOpenChannel().adaptorChannel();
                    adaptorChannel.executeStoredProcedure(sp, null);
                    pkDict = adaptorChannel.returnValuesForLastStoredProcedureInvocation();
                } else {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
                }
                NSLog._conditionallyLogPrivateException((Throwable)localException);
            }
            if (pkDict != null) {
                pkDict = entity.primaryKeyForRow(pkDict);
            }
        }
        if (pkDict == null && (pkAttrs = entity.primaryKeyAttributes()).count() == 1 && (pkAttr = (EOAttribute)pkAttrs.objectAtIndex(0)) != null && pkAttr.adaptorValueType() == 2 && pkAttr.width() == 24) {
            byte[] buf = new byte[24];
            EOTemporaryGlobalID.assignGloballyUniqueBytes((byte[])buf);
            Object value = pkAttr.newValueForImmutableBytes(buf);
            pkDict = new NSDictionary(value, (Object)pkAttr.name());
        }
        if (pkDict == null) {
            try {
                pkDict = this.adaptorContext()._newPrimaryKey(object, entity);
            }
            catch (Exception e) {
                if (this._delegateHandledDatabaseException(e)) {
                    pkDict = this.adaptorContext()._newPrimaryKey(object, entity);
                } else if (this._isDroppedConnectionException(e)) {
                    this._database.handleDroppedConnection();
                    pkDict = this.adaptorContext()._newPrimaryKey(object, entity);
                } else {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
        return pkDict;
    }

    public EOGlobalID _globalIDForObject(EOEnterpriseObject object) {
        EOEditingContext ec;
        EOEditingContext eOEditingContext = ec = this._editingContext != null ? this._editingContext : object.editingContext();
        if (ec == null) {
            throw new IllegalStateException("Cannot obtain globalId for an object without editingContext, object: " + object + ", databaseContext: " + (Object)((Object)this));
        }
        EOGlobalID gid = ec.globalIDForObject(object);
        if (gid == null) {
            EOEditingContext objectEC = object.editingContext();
            String registeredMsg = "";
            registeredMsg = objectEC != null ? (this._editingContext == null ? "registered in its editingContext" : (this._editingContext != objectEC ? "registered in an other than the databaseContext's active editingContext" : "registered in the same as the databaseContext's active editingContext")) : "not registered in any editingContext";
            throw new IllegalStateException("Cannot obtain globalId for an object which is " + registeredMsg + ", object: " + object + ", databaseContext: " + (Object)((Object)this) + ", object's editingContext: " + objectEC + ", databaseContext's active editingContext: " + this._editingContext);
        }
        return gid;
    }

    public void _verifyNoChangesToReadonlyEntity(EODatabaseOperation dbOp) {
        EOEntity entity = dbOp.entity();
        if (entity.isReadOnly()) {
            switch (dbOp.databaseOperator()) {
                case 0: {
                    return;
                }
                case 1: {
                    throw new IllegalStateException("cannot insert object:" + dbOp.object() + " that corresponds to read-only entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                case 3: {
                    throw new IllegalStateException("cannot delete object:" + dbOp.object() + " that corresponds to read-only entity:" + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                case 2: {
                    if (!dbOp.dbSnapshot().equals((Object)dbOp.newRow())) {
                        throw new IllegalStateException("cannot update '" + dbOp.rowDiffsForAttributes(entity.attributes()).allKeys() + "' keys on object:" + dbOp.object() + " that corresponds to read-only entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                    }
                    return;
                }
            }
        }
        if (dbOp.databaseOperator() == 2 && entity._hasNonUpdateableAttributes()) {
            NSArray keys = entity.dbSnapshotKeys();
            NSDictionary dbSnapshot = dbOp.dbSnapshot();
            NSMutableDictionary newRow = dbOp.newRow();
            for (int i = keys.count() - 1; i >= 0; --i) {
                String key = (String)keys.objectAtIndex(i);
                EOAttribute att = entity.attributeNamed(key);
                if (!att._isNonUpdateable() || dbSnapshot.objectForKey((Object)key).equals(newRow.objectForKey((Object)key))) continue;
                if (att.isReadOnly()) {
                    throw new IllegalStateException("cannot update read-only key '" + key + "' on object:" + dbOp.object() + " of entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
                }
                throw new IllegalStateException("cannot update primary-key '" + key + "' from '" + dbSnapshot.objectForKey((Object)key) + "' to '" + newRow.objectForKey((Object)key) + "' on object:" + dbOp.object() + " of entity: " + entity.name() + " in databaseContext " + (Object)((Object)this));
            }
        }
    }

    private void recordInsertForObject(EOEnterpriseObject object) {
        EODatabaseOperation dbOp = this.databaseOperationForObject(object);
        dbOp.setDatabaseOperator(1);
        if (dbOp.dbSnapshot().count() != 0) {
            throw new IllegalStateException("recordInsertForObject: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " found a snapshot for EO with Global ID:" + dbOp.globalID() + " that has been inserted into " + this._editingContext.getClass().getName() + "" + this._editingContext + ". Cannot insert an object that is already in the database");
        }
    }

    private void recordDeleteForObject(EOEnterpriseObject object) {
        EODatabaseOperation dbOp = this.databaseOperationForObject(object);
        dbOp.setDatabaseOperator(3);
        if (dbOp.dbSnapshot().count() == 0) {
            throw new IllegalStateException("recordDeleteForObject: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " failed to find a snapshot for EO with Global ID:" + dbOp.globalID() + " that has been deleted from " + this._editingContext.getClass().getName() + "" + this._editingContext + ". Cannot delete an object that has not been fetched from the database");
        }
    }

    private void recordDatabaseOperation(EODatabaseOperation dbOp) {
        if (this._editingContext != null && this._dbOperationsByGlobalID != null && this._dbOperationsByGlobalID.objectForKey((Object)dbOp) == null) {
            this._dbOperationsByGlobalID.setObjectForKey((Object)dbOp, (Object)dbOp.globalID());
        }
    }

    private EODatabaseOperation databaseOperationForGlobalID(EOGlobalID gid) {
        if (this._dbOperationsByGlobalID == null) {
            return null;
        }
        return (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
    }

    private EODatabaseOperation databaseOperationForObject(EOEnterpriseObject object) {
        EOGlobalID gid = this._globalIDForObject(object);
        EODatabaseOperation dbOp = this.databaseOperationForGlobalID(gid);
        if (dbOp != null) {
            return dbOp;
        }
        EOEntity entity = this._database.entityForObject(object);
        if (entity == null) {
            return null;
        }
        if (entity.primaryKeyAttributes().count() == 0) {
            throw new IllegalStateException("databaseOperationForObject: " + ((Object)((Object)this)).getClass().getName() + " " + (Object)((Object)this) + " attempted to process an EO mapped to entity '" + entity.name() + "' which has no primary key defined. All entities must have a primary key specified. You should run the EOModeler consistency checker on the model containing this entity and perform whatever actions are necessary to ensure that the model is in a consistent state.");
        }
        dbOp = new EODatabaseOperation(gid, object, entity);
        NSDictionary dbSnapshot = this.snapshotForGlobalID(gid);
        if (dbSnapshot == null) {
            dbSnapshot = NSDictionary.EmptyDictionary;
        }
        dbOp.setDBSnapshot(dbSnapshot);
        NSArray keys = entity.classPropertyNames();
        int nkeys = keys.count();
        NSMutableDictionary objectValues = new NSMutableDictionary(nkeys);
        for (int i = 0; i < nkeys; ++i) {
            String key = (String)keys.objectAtIndex(i);
            Object value = object.storedValueForKey(key);
            objectValues.setObjectForKey(value != null ? value : NSKeyValueCoding.NullValue, (Object)key);
        }
        NSMutableDictionary newRow = dbSnapshot.mutableClone();
        _NSDictionaryUtilities.overrideEntriesWithObjectsFromDictionaryKeys((NSMutableDictionary)newRow, (NSDictionary)objectValues, (NSArray)entity.dbSnapshotKeys());
        dbOp.setNewRow(newRow);
        this.recordDatabaseOperation(dbOp);
        return dbOp;
    }

    private NSDictionary primaryKeyForIntermediateRowFromSourceObject(EOEnterpriseObject sourceObject, EORelationship rel, EOEnterpriseObject destObject) {
        NSDictionary keyMap = rel._leftSideKeyMap();
        EODatabaseOperation dbOp = this.databaseOperationForObject(sourceObject);
        NSArray keys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
        NSMutableDictionary pkDict1 = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)dbOp.newRow(), (NSArray)keys);
        if (_NSDictionaryUtilities.containsAnyNullObject((NSDictionary)pkDict1)) {
            NSDictionary sourcePK = this._entityForObject(sourceObject).primaryKeyForGlobalID(dbOp.globalID());
            pkDict1 = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)sourcePK, (NSArray)keys);
        }
        _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)pkDict1, (NSArray)keys, (NSArray)((NSArray)keyMap.objectForKey((Object)"destinationKeys")));
        keyMap = rel._rightSideKeyMap();
        dbOp = this.databaseOperationForObject(destObject);
        keys = (NSArray)keyMap.objectForKey((Object)"destinationKeys");
        NSMutableDictionary pkDict2 = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)dbOp.newRow(), (NSArray)keys);
        if (_NSDictionaryUtilities.containsAnyNullObject((NSDictionary)pkDict2)) {
            NSDictionary destPK = this._entityForObject(destObject).primaryKeyForGlobalID(dbOp.globalID());
            pkDict2 = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)destPK, (NSArray)keys);
        }
        _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)pkDict2, (NSArray)keys, (NSArray)((NSArray)keyMap.objectForKey((Object)"sourceKeys")));
        pkDict1.addEntriesFromDictionary((NSDictionary)pkDict2);
        return pkDict1;
    }

    private EODatabaseOperation databaseOperationForIntermediateRowFromSourceObject(EOEnterpriseObject sourceObject, EORelationship rel, EOEnterpriseObject destObject) {
        NSDictionary pkDict = this.primaryKeyForIntermediateRowFromSourceObject(sourceObject, rel, destObject);
        EOEntity entity = rel.intermediateEntity();
        EOGlobalID gid = entity.globalIDForRow(pkDict);
        if (gid == null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32768L)) {
                NSLog.debug.appendln((Object)("Attempt to obtain globalID failed for entity:" + entity + "\n     relationship: " + rel + "\n     source object: " + sourceObject + "\n     destination object: " + destObject));
            }
            throw new IllegalStateException("A valid global ID could not be obtained for entity named " + entity.name() + ", relationship named " + rel.name() + ", primary key dictionary " + pkDict + ".");
        }
        EODatabaseOperation dbOp = this.databaseOperationForGlobalID(gid);
        if (dbOp == null) {
            dbOp = new EODatabaseOperation(gid, null, entity);
            dbOp.setDBSnapshot(pkDict);
            dbOp.setNewRow(pkDict.mutableClone());
            this.recordDatabaseOperation(dbOp);
        }
        return dbOp;
    }

    private void recordInsertForIntermediateRowFromSourceObject(EOEnterpriseObject sourceObject, EORelationship rel, EOEnterpriseObject destObject) {
        EODatabaseOperation dbOp = this.databaseOperationForIntermediateRowFromSourceObject(sourceObject, rel, destObject);
        dbOp.setDatabaseOperator(1);
    }

    private void recordDeleteForIntermediateRowFromSourceObjectRelationshipDestinationObject(EOEnterpriseObject sourceObject, EORelationship rel, EOEnterpriseObject destObject) {
        EODatabaseOperation dbOp = this.databaseOperationForIntermediateRowFromSourceObject(sourceObject, rel, destObject);
        dbOp.setDatabaseOperator(3);
    }

    private NSDictionary relayAttributesInRelationshipSourceObjectDestinationObject(EORelationship rel, EOEnterpriseObject sourceObject, EOEnterpriseObject destObject) {
        NSMutableDictionary changes = null;
        if (destObject == null) {
            return null;
        }
        EODatabaseOperation sourceDBOp = this.databaseOperationForObject(sourceObject);
        if (rel.isToManyToOne()) {
            this.recordInsertForIntermediateRowFromSourceObject(sourceObject, rel, destObject);
        } else {
            NSDictionary keyMap = rel._sourceToDestinationKeyMap();
            NSArray sourceKeys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
            NSArray destKeys = (NSArray)keyMap.objectForKey((Object)"destinationKeys");
            if (rel.foreignKeyInDestination()) {
                changes = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)sourceDBOp.newRow(), (NSArray)sourceKeys);
                _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)changes, (NSArray)sourceKeys, (NSArray)destKeys);
                this.recordUpdateForObject(destObject, (NSDictionary)changes);
            } else {
                changes = this._mutableValuesForKeys(destKeys, destObject);
                _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)changes, (NSArray)destKeys, (NSArray)sourceKeys);
                sourceDBOp.newRow().addEntriesFromDictionary((NSDictionary)changes);
            }
        }
        return changes;
    }

    private void nullifyAttributesInRelationshipSourceObjectDestinationObject(EORelationship rel, EOEnterpriseObject sourceObject, EOEnterpriseObject destObject) {
        if (destObject == null) {
            return;
        }
        EODatabaseOperation sourceDBOp = this.databaseOperationForObject(sourceObject);
        if (rel.isToManyToOne()) {
            this.recordDeleteForIntermediateRowFromSourceObjectRelationshipDestinationObject(sourceObject, rel, destObject);
        } else {
            NSDictionary keyMap = rel._sourceToDestinationKeyMap();
            if (rel.foreignKeyInDestination()) {
                NSArray destKeys = (NSArray)keyMap.objectForKey((Object)"destinationKeys");
                NSDictionary changes = _NSDictionaryUtilities.dictionaryWithNullValuesForKeys((NSArray)destKeys);
                this.recordUpdateForObject(destObject, changes);
            } else {
                NSArray sourceKeys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
                NSDictionary changes = _NSDictionaryUtilities.dictionaryWithNullValuesForKeys((NSArray)sourceKeys);
                sourceDBOp.newRow().addEntriesFromDictionary(changes);
            }
        }
    }

    private void relayAttributesInRelationshipSourceObjectDestinationObjects(EORelationship rel, EOEnterpriseObject sourceObject, NSArray destObjects) {
        for (int i = destObjects.count() - 1; i >= 0; --i) {
            this.relayAttributesInRelationshipSourceObjectDestinationObject(rel, sourceObject, (EOEnterpriseObject)destObjects.objectAtIndex(i));
        }
    }

    private void nullifyAttributesInRelationshipSourceObjectDestinationObjects(EORelationship rel, EOEnterpriseObject sourceObject, NSArray destObjects) {
        for (int i = (destObjects != null ? destObjects.count() : 0) - 1; i >= 0; --i) {
            this.nullifyAttributesInRelationshipSourceObjectDestinationObject(rel, sourceObject, (EOEnterpriseObject)destObjects.objectAtIndex(i));
        }
    }

    private boolean isValidQualifierTypeForAttribute(EOAttribute att) {
        EOModel model = att.entity().model();
        EOAdaptor adaptor = this.database().adaptor();
        return adaptor.isValidQualifierType(att.externalType(), model);
    }

    private NSArray lockingNonQualifiableAttributes(NSArray atts) {
        NSMutableArray blobs = null;
        NSArray lockingAtts = null;
        for (int i = atts.count() - 1; i >= 0; --i) {
            EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
            if (lockingAtts == null) {
                lockingAtts = att.entity().attributesUsedForLocking();
            }
            if (this.isValidQualifierTypeForAttribute(att) || !lockingAtts.containsObject((Object)att)) continue;
            if (blobs == null) {
                blobs = new NSMutableArray();
            }
            blobs.addObject((Object)att);
        }
        return blobs == null ? NSArray.EmptyArray : blobs;
    }

    private NSArray lockingAttributesForAttributesEntity(NSArray atts, EOEntity entity) {
        NSMutableArray result = null;
        NSArray lockingAtts = entity.attributesUsedForLocking();
        for (int i = atts.count() - 1; i >= 0; --i) {
            EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
            if (!att.isFlattened()) {
                return entity.rootAttributesUsedForLocking();
            }
            if (!lockingAtts.containsObject((Object)att)) continue;
            if (result == null) {
                result = new NSMutableArray(atts.count());
            }
            result.addObject((Object)att);
        }
        return result == null ? NSArray.EmptyArray : result;
    }

    private NSArray primaryKeyAttributesForAttributesEntity(NSArray atts, EOEntity entity) {
        NSArray pkAtts = null;
        NSMutableArray result = null;
        for (int i = atts.count() - 1; i >= 0; --i) {
            EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
            if (!att.isFlattened()) {
                return entity.primaryKeyAttributes();
            }
            EOAttribute targetAtt = att.targetAttribute();
            if (pkAtts == null) {
                pkAtts = targetAtt.entity().primaryKeyAttributes();
            }
            if (!pkAtts.containsObject((Object)targetAtt)) continue;
            if (result == null) {
                result = new NSMutableArray();
            }
            result.addObject((Object)att);
        }
        if (result == null) {
            throw new IllegalStateException("primaryKeyAttributesForAttributesEntity: " + ((Object)((Object)this)).getClass().getName() + " Entity named: " + entity.name() + " has no primary key specified");
        }
        return result;
    }

    private EOQualifier qualifierForLockingAttributesPrimaryKeyAttributesEntitySnapshot(NSArray lockingAtts, NSArray pkAtts, EOEntity entity, NSDictionary snapshot) {
        EOQualifier qualifier;
        NSMutableArray qualifiers = new NSMutableArray(lockingAtts.count() + pkAtts.count());
        for (int j = 1; j <= 2; ++j) {
            NSArray atts = j == 1 ? pkAtts : lockingAtts;
            for (int i = atts.count() - 1; i >= 0; --i) {
                String key;
                Object value;
                EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
                if (!this.isValidQualifierTypeForAttribute(att) || atts == lockingAtts && pkAtts.containsObject((Object)att) || (value = snapshot.objectForKey((Object)(key = entity.snapshotKeyForAttributeName(att.name())))) == null) continue;
                qualifier = new EOKeyValueQualifier(att.name(), EOQualifier.QualifierOperatorEqual, value);
                qualifiers.addObject((Object)qualifier);
            }
        }
        switch (qualifiers.count()) {
            case 0: {
                qualifier = null;
                break;
            }
            case 1: {
                qualifier = (EOQualifier)qualifiers.objectAtIndex(0);
                break;
            }
            default: {
                qualifier = new EOAndQualifier((NSArray)qualifiers);
            }
        }
        return qualifier;
    }

    private NSDictionary valuesToWriteForAttributesEntityChangedValues(NSArray atts, EOEntity entity, NSDictionary changedValues) {
        NSMutableDictionary valuesToWrite = null;
        if (entity.isReadOnly()) {
            return null;
        }
        for (int i = atts.count() - 1; i >= 0; --i) {
            String key;
            Object value;
            EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
            if (att.isReadOnly() || (value = changedValues.objectForKey((Object)(key = entity.snapshotKeyForAttributeName(att.name())))) == null) continue;
            if (valuesToWrite == null) {
                valuesToWrite = new NSMutableDictionary();
            }
            valuesToWrite.setObjectForKey(value, (Object)att.name());
        }
        return valuesToWrite == null ? NSDictionary.EmptyDictionary : valuesToWrite;
    }

    private void processSnapshotForDatabaseOperation(EODatabaseOperation dbOp) {
        EOAdaptor adaptor = this._database.adaptor();
        EOEntity entity = dbOp.entity();
        NSMutableDictionary newRow = dbOp.newRow();
        Enumeration enumerator = newRow.keyEnumerator();
        NSDictionary dbSnapshot = dbOp.dbSnapshot();
        while (enumerator.hasMoreElements()) {
            Object value1;
            String key = (String)enumerator.nextElement();
            EOAttribute att = entity.attributeNamed(key);
            Object value = newRow.objectForKey((Object)key);
            if (value == dbSnapshot.objectForKey((Object)key) || (value1 = adaptor.fetchedValueForValue(value, att)) != null && (value1 == value || value1.equals(value))) continue;
            if (value1 == null) {
                value1 = NSKeyValueCoding.NullValue;
            }
            newRow.setObjectForKey(value1, (Object)key);
        }
    }

    private void createAdaptorOperationsForDatabaseOperationAttributes(EODatabaseOperation dbOp, NSArray atts) {
        EOEntity entity = dbOp.entity();
        switch (dbOp.databaseOperator()) {
            case 0: {
                break;
            }
            case 2: {
                NSDictionary valuesToWrite;
                EOAdaptorOperation adaptorOp;
                NSDictionary changedValues = dbOp.rowDiffsForAttributes(atts);
                NSArray blobs = this.lockingNonQualifiableAttributes(atts);
                NSArray lockingAtts = this.lockingAttributesForAttributesEntity(atts, entity);
                int changedValuesCount = changedValues.count();
                int blobsCount = blobs.count();
                int lockingAttsCount = lockingAtts.count();
                if (lockingAttsCount == 0 && blobsCount == 0 && changedValuesCount == 0) {
                    return;
                }
                NSArray pkAtts = this.primaryKeyAttributesForAttributesEntity(atts, entity);
                EOQualifier lockingQualifier = this.qualifierForLockingAttributesPrimaryKeyAttributesEntitySnapshot(lockingAtts, pkAtts, entity, dbOp.dbSnapshot());
                if (changedValuesCount == 0 || blobsCount > 0) {
                    adaptorOp = new EOAdaptorOperation(entity);
                    adaptorOp.setAdaptorOperator(0);
                    adaptorOp.setQualifier(lockingQualifier);
                    adaptorOp.setChangedValues(dbOp.dbSnapshot());
                    if (blobsCount > 0) {
                        adaptorOp.setAttributes(blobs);
                    } else {
                        adaptorOp.setAttributes(pkAtts);
                    }
                    dbOp.addAdaptorOperation(adaptorOp);
                }
                if (changedValuesCount <= 0 || (valuesToWrite = this.valuesToWriteForAttributesEntityChangedValues(atts, entity, changedValues)).count() <= 0) break;
                adaptorOp = new EOAdaptorOperation(entity);
                adaptorOp.setAdaptorOperator(2);
                adaptorOp.setChangedValues(valuesToWrite);
                adaptorOp.setQualifier(lockingQualifier);
                dbOp.addAdaptorOperation(adaptorOp);
                break;
            }
            case 1: {
                NSDictionary valuesToWrite = this.valuesToWriteForAttributesEntityChangedValues(atts, entity, (NSDictionary)dbOp.newRow());
                if (valuesToWrite.count() <= 0) break;
                EOAdaptorOperation adaptorOp = new EOAdaptorOperation(entity);
                EOStoredProcedure sp = entity.storedProcedureForOperation("EOInsertProcedure");
                if (sp != null) {
                    adaptorOp.setAdaptorOperator(4);
                    adaptorOp.setStoredProcedure(sp);
                } else {
                    adaptorOp.setAdaptorOperator(1);
                }
                adaptorOp.setChangedValues(valuesToWrite);
                dbOp.addAdaptorOperation(adaptorOp);
                break;
            }
            case 3: {
                EOAdaptorOperation adaptorOp;
                NSArray pkAtts = this.primaryKeyAttributesForAttributesEntity(atts, entity);
                NSArray lockingAtts = this.lockingAttributesForAttributesEntity(atts, entity);
                EOQualifier lockingQualifier = this.qualifierForLockingAttributesPrimaryKeyAttributesEntitySnapshot(lockingAtts, pkAtts, entity, dbOp.dbSnapshot());
                NSArray blobs = this.lockingNonQualifiableAttributes(atts);
                if (blobs.count() > 0) {
                    adaptorOp = new EOAdaptorOperation(entity);
                    adaptorOp.setAdaptorOperator(0);
                    adaptorOp.setQualifier(lockingQualifier);
                    adaptorOp.setAttributes(blobs);
                    adaptorOp.setChangedValues(dbOp.dbSnapshot());
                    dbOp.addAdaptorOperation(adaptorOp);
                }
                adaptorOp = new EOAdaptorOperation(entity);
                EOStoredProcedure sp = entity.storedProcedureForOperation("EODeleteProcedure");
                if (sp != null) {
                    adaptorOp.setAdaptorOperator(4);
                    adaptorOp.setStoredProcedure(sp);
                    adaptorOp.setChangedValues(dbOp.dbSnapshot());
                } else {
                    adaptorOp.setAdaptorOperator(3);
                    adaptorOp.setQualifier(lockingQualifier);
                }
                dbOp.addAdaptorOperation(adaptorOp);
            }
        }
    }

    private void createAdaptorOperationsForDatabaseOperation(EODatabaseOperation dbOp) {
        NSMutableArray array;
        String key;
        EOAttribute att;
        int i;
        NSDictionary changedValues;
        EOEntity entity = dbOp.entity();
        this.processSnapshotForDatabaseOperation(dbOp);
        if (dbOp.databaseOperator() == 2 && ((changedValues = dbOp.rowDiffs()) == null || changedValues.count() == 0)) {
            return;
        }
        NSArray atts = entity._attributesToSave();
        NSMutableDictionary attGroups = new NSMutableDictionary();
        for (i = atts.count() - 1; i >= 0; --i) {
            att = (EOAttribute)atts.objectAtIndex(i);
            if (att.isFlattened()) {
                key = att.relationshipPath();
            } else {
                if (att.isDerived()) continue;
                key = _EOFRootEntityString_;
            }
            array = (NSMutableArray)attGroups.objectForKey((Object)key);
            if (array == null) {
                array = new NSMutableArray();
                attGroups.setObjectForKey((Object)array, (Object)key);
            }
            array.addObject((Object)att);
        }
        Enumeration enumerator = attGroups.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            key = (String)enumerator.nextElement();
            boolean isMandatory = true;
            boolean createAdaptorOp = false;
            if (key != _EOFRootEntityString_) {
                String relPath = key;
                while (relPath != null) {
                    EORelationship relationship = entity.relationshipForPath(relPath);
                    if (!relationship.isMandatory() && !relationship.isParentRelationship()) {
                        isMandatory = false;
                        break;
                    }
                    relPath = _EOStringUtil.relationshipPathByDeletingLastComponent(relPath);
                }
            }
            array = (NSMutableArray)attGroups.objectForKey((Object)key);
            for (i = array.count() - 1; i >= 0; --i) {
                att = (EOAttribute)array.objectAtIndex(i);
                if (!(isMandatory || att.isReadOnly() || dbOp.newRow().objectForKey((Object)att.name()) == NSKeyValueCoding.NullValue || att.name().startsWith("NeededByEOF"))) {
                    createAdaptorOp = true;
                    break;
                }
                if (!isMandatory || att.isReadOnly() || att.name().startsWith("NeededByEOF")) continue;
                createAdaptorOp = true;
                break;
            }
            if (!createAdaptorOp) continue;
            this.createAdaptorOperationsForDatabaseOperationAttributes(dbOp, (NSArray)array);
        }
    }

    private void insertEntityIntoOrderingArray(EOEntity entity, NSMutableArray entityNames, NSDictionary dependencies, NSMutableSet processingSet) {
        String entityName = entity.name();
        if (entityNames.indexOfObject((Object)entityName) == -1 && !processingSet.containsObject((Object)entityName)) {
            NSArray otherRequiredEntities = (NSArray)dependencies.objectForKey((Object)entityName);
            processingSet.addObject((Object)entityName);
            int iCount = otherRequiredEntities != null ? otherRequiredEntities.count() : 0;
            for (int i = 0; i < iCount; ++i) {
                this.insertEntityIntoOrderingArray((EOEntity)otherRequiredEntities.objectAtIndex(i), entityNames, dependencies, processingSet);
            }
            entityNames.addObject((Object)entityName);
        }
    }

    private NSArray entitiesOnWhichThisEntityDepends(EOEntity entity) {
        NSArray relationships = entity.relationships();
        NSMutableArray returnArray = null;
        int relCount = relationships != null ? relationships.count() : 0;
        for (int relIndex = 0; relIndex < relCount; ++relIndex) {
            EORelationship inverse;
            EORelationship rel = (EORelationship)relationships.objectAtIndex(relIndex);
            if (rel.isToMany() || rel.isFlattened() || rel.destinationEntity() == entity || !(inverse = rel.anyInverseRelationship()).isToMany() && !inverse.propagatesPrimaryKey() && !inverse.ownsDestination()) continue;
            if (returnArray == null) {
                returnArray = new NSMutableArray();
            }
            returnArray.addObject((Object)rel.destinationEntity());
        }
        return returnArray == null ? NSArray.EmptyArray : returnArray;
    }

    private NSArray entityNameOrderingArrayForEntities(NSArray entitiesInOps) {
        EOModelGroup modelGroup;
        int entityIndex;
        int entityCount;
        int modelIndex;
        NSMutableArray orderedEntities = null;
        EODatabase database = this.database();
        NSArray models = database.models();
        int modelCount = models.count();
        for (modelIndex = 0; modelIndex < modelCount; ++modelIndex) {
            boolean missingEntity = false;
            NSDictionary userInfo = ((EOModel)models.objectAtIndex(modelIndex)).userInfo();
            NSMutableArray nSMutableArray = orderedEntities = userInfo != null ? (NSMutableArray)userInfo.objectForKey((Object)entityOrderingKey) : null;
            if (orderedEntities == null) continue;
            entityCount = entitiesInOps.count();
            for (entityIndex = 0; entityIndex < entityCount && !missingEntity; ++entityIndex) {
                if (orderedEntities.indexOfObject((Object)((EOEntity)entitiesInOps.objectAtIndex(entityIndex)).name()) != -1) continue;
                missingEntity = true;
            }
            if (missingEntity) continue;
            return orderedEntities;
        }
        if (orderedEntities != null && (modelGroup = ((EOModel)models.lastObject()).modelGroup()) != null) {
            NSMutableArray newEntitiesInOps = entitiesInOps.mutableClone();
            NSArray results = _NSArrayUtilities.resultsOfPerformingSelectorWithEachObjectInArray((Object)modelGroup, (NSSelector)_entityNamedSelector, (NSArray)orderedEntities);
            newEntitiesInOps.addObjectsFromArray(results);
            entitiesInOps = newEntitiesInOps;
        }
        NSMutableDictionary dependencies = new NSMutableDictionary();
        entityCount = entitiesInOps.count();
        for (entityIndex = 0; entityIndex < entityCount; ++entityIndex) {
            EOEntity entity = (EOEntity)entitiesInOps.objectAtIndex(entityIndex);
            NSArray depends = this.entitiesOnWhichThisEntityDepends(entity);
            if (depends.count() == 0) continue;
            dependencies.setObjectForKey((Object)depends, (Object)entity.name());
        }
        entityCount = entitiesInOps.count();
        orderedEntities = new NSMutableArray(entityCount);
        for (entityIndex = 0; entityIndex < entityCount; ++entityIndex) {
            NSMutableSet mutableSet = new NSMutableSet(entityCount);
            this.insertEntityIntoOrderingArray((EOEntity)entitiesInOps.objectAtIndex(entityIndex), orderedEntities, (NSDictionary)dependencies, mutableSet);
        }
        modelCount = models.count();
        for (modelIndex = 0; modelIndex < modelCount; ++modelIndex) {
            EOModel model = (EOModel)models.objectAtIndex(modelIndex);
            NSDictionary existingUserInfo = model.userInfo();
            NSMutableDictionary newDictionary = existingUserInfo != null ? new NSMutableDictionary(existingUserInfo) : new NSMutableDictionary();
            newDictionary.setObjectForKey((Object)orderedEntities, (Object)entityOrderingKey);
            model.setUserInfo((NSDictionary)newDictionary);
        }
        return orderedEntities;
    }

    private NSArray orderAdaptorOperations() {
        NSMutableArray orderedOps = new NSMutableArray(this._dbOperationsByGlobalID.count());
        Enumeration mapEnumerator = this._dbOperationsByGlobalID.keyEnumerator();
        NSMutableArray entitiesInOps = new NSMutableArray(8);
        while (mapEnumerator.hasMoreElements()) {
            int count;
            EOGlobalID gid = (EOGlobalID)mapEnumerator.nextElement();
            EODatabaseOperation dbOp = (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
            NSArray adaptorOps = dbOp.adaptorOperations();
            if (adaptorOps != null) {
                orderedOps.addObjectsFromArray(adaptorOps);
                count = adaptorOps.count();
            } else {
                count = 0;
            }
            for (int i = 0; i < count; ++i) {
                EOEntity entity = ((EOAdaptorOperation)adaptorOps.objectAtIndex(i)).entity();
                if (entitiesInOps.indexOfObject((Object)entity) != -1) continue;
                entitiesInOps.addObject((Object)entity);
            }
        }
        NSArray entityOrdering = this.entityNameOrderingArrayForEntities((NSArray)entitiesInOps);
        try {
            orderedOps.sortUsingComparator((NSComparator)new EOAdaptorOpComparator(entityOrdering));
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return orderedOps;
    }

    public boolean ownsGlobalID(EOGlobalID globalID) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._currentGlobalID == globalID) {
            return true;
        }
        return globalID instanceof EOKeyGlobalID && this._database.entityNamed(((EOKeyGlobalID)globalID).entityName()) != null;
    }

    public boolean ownsObject(EOEnterpriseObject object) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        return this._database.entityNamed(object.entityName()) != null;
    }

    public boolean handlesFetchSpecification(EOFetchSpecification fetchSpecification) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        return this._database.entityNamed(fetchSpecification.entityName()) != null;
    }

    protected void _willPrepareForSave() {
        this._flags_willPrepareForSave = true;
    }

    public void prepareForSaveWithCoordinator(EOObjectStoreCoordinator coordinator, EOEditingContext editingContext) {
        NSMutableArray insertedForEntity;
        String rootEntityName;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        if (this._flags_preparingForSave) {
            throw new IllegalStateException("prepareForSaveWithCoordinator: " + (Object)((Object)this) + " is currently saving for " + this._editingContext + " so it cannot prepare to save for " + editingContext + ".  " + (coordinator == null ? "Coordinator is null." : coordinator + " has sources " + coordinator.cooperatingObjectStores()));
        }
        if (coordinator != null) {
            EOObjectStoreCoordinator current = this.coordinator();
            if (current == null) {
                this.setCoordinator(coordinator);
            } else if (current != coordinator) {
                throw new IllegalStateException("prepareForSaveWithCoordinator: " + (Object)((Object)this) + " already has an EOObjectStoreCoordinator.  The database context needs to be removed from the cooperating object stores before it can be assigned to a different coordinator.");
            }
        }
        this._editingContext = editingContext;
        this._dbOperationsByGlobalID = new NSMutableDictionary(100);
        this._flags_willPrepareForSave = false;
        this._flags_preparingForSave = true;
        if (this._missingObjectGIDs.count() != 0) {
            NSArray updatedObjs = editingContext.updatedObjects();
            for (int i = updatedObjs.count() - 1; i >= 0; --i) {
                EOGlobalID gid = editingContext.globalIDForObject((EOEnterpriseObject)updatedObjs.objectAtIndex(i));
                if (this._missingObjectGIDs.member((Object)gid) == null) continue;
                throw new EOObjectNotAvailableException("prepareForSaveWithCoordinator: Cannot save the object with globalID " + gid + ". The row referenced by this globalID was missing from the database at the time a fetch was attempted. Either it was removed from the database after this application got a pointer to it, or there is a referential integrity problem with your database. To be notified when fetches fail, implement a delegate on EODatabaseContext that responds to databaseContextFailedToFetchObject().");
            }
        }
        this._buildPrimaryKeyGeneratorListForEditingContext(editingContext);
        NSArray insertedObjects = editingContext.insertedObjects();
        int cnt = insertedObjects.count();
        NSMutableDictionary pkNeededByEntityName = new NSMutableDictionary();
        this._checkPropagatedPKs = new NSMutableArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            EOEnterpriseObject o = (EOEnterpriseObject)insertedObjects.objectAtIndex(i);
            EOEntity entity = this._database.entityForObject(o);
            if (entity == null) continue;
            this.recordInsertForObject(o);
            if (this._shouldGeneratePrimaryKeyForEntityName(entity.name())) {
                NSDictionary pkDict = this._primaryKeyForObject(o);
                if (pkDict == null) {
                    rootEntityName = entity.rootParent().name();
                    insertedForEntity = (NSMutableArray)pkNeededByEntityName.objectForKey((Object)rootEntityName);
                    if (insertedForEntity == null) {
                        insertedForEntity = new NSMutableArray(cnt);
                        pkNeededByEntityName.setObjectForKey((Object)insertedForEntity, (Object)rootEntityName);
                    }
                    insertedForEntity.addObject((Object)o);
                    continue;
                }
                this.databaseOperationForObject(o).newRow().addEntriesFromDictionary(pkDict);
                this.relayPrimaryKeyObjectEntity(pkDict, o, entity);
                continue;
            }
            this._checkPropagatedPKs.addObject((Object)o);
        }
        Enumeration enumerator = pkNeededByEntityName.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            rootEntityName = (String)enumerator.nextElement();
            insertedForEntity = (NSMutableArray)pkNeededByEntityName.objectForKey((Object)rootEntityName);
            int pkCount = insertedForEntity.count();
            NSArray newPKs = this._batchNewPrimaryKeysWithEntity(pkCount, this._database.entityNamed(rootEntityName));
            if (newPKs == null || newPKs.count() != pkCount) {
                throw new IllegalStateException("Adaptor " + this._database.adaptor() + " failed to provide new primary keys for entity '" + rootEntityName + "'");
            }
            for (int j = 0; j < pkCount; ++j) {
                NSDictionary pk = (NSDictionary)newPKs.objectAtIndex(j);
                EOEnterpriseObject eo = (EOEnterpriseObject)insertedForEntity.objectAtIndex(j);
                this.databaseOperationForObject(eo).newRow().addEntriesFromDictionary(pk);
                this.relayPrimaryKeyObjectEntity(pk, eo, this._database.entityForObject(eo));
            }
        }
    }

    private NSArray _batchNewPrimaryKeysWithEntity(int cnt, EOEntity rootEntity) {
        NSArray pks = null;
        try {
            pks = this._obtainOpenChannel().adaptorChannel().primaryKeysForNewRowsWithEntity(cnt, rootEntity);
        }
        catch (Exception localException) {
            if (this._delegateHandledDatabaseException(localException)) {
                pks = this._obtainOpenChannel().adaptorChannel().primaryKeysForNewRowsWithEntity(cnt, rootEntity);
            }
            if (this._isDroppedConnectionException(localException)) {
                this._database.handleDroppedConnection();
                pks = this._obtainOpenChannel().adaptorChannel().primaryKeysForNewRowsWithEntity(cnt, rootEntity);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
        }
        return pks;
    }

    private void relayPrimaryKeySourceObjectDestObjectRelationship(NSDictionary pkDict, EOEnterpriseObject sourceObject, EOEnterpriseObject destObject, EORelationship rel) {
        boolean destinationNeedsValues = false;
        NSMutableArray destAttNames = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)rel.destinationAttributes(), (NSSelector)_NSArrayUtilities._nameSelector);
        NSDictionary values = this.valuesForKeys((NSArray)destAttNames, destObject);
        Enumeration enumerator = values.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            Object value = enumerator.nextElement();
            if (value != NSKeyValueCoding.NullValue) continue;
            destinationNeedsValues = true;
            break;
        }
        if (!destinationNeedsValues) {
            return;
        }
        NSDictionary newPKDict = this.relayAttributesInRelationshipSourceObjectDestinationObject(rel, sourceObject, destObject);
        this.relayPrimaryKeyObjectEntity(newPKDict, destObject, rel.destinationEntity());
    }

    private void relayPrimaryKeyObjectEntity(NSDictionary pkDict, EOEnterpriseObject sourceObject, EOEntity entity) {
        NSArray rels = entity.relationships();
        NSArray classPropNames = entity.classPropertyNames();
        EODatabaseOperation dbOp = this.databaseOperationForObject(sourceObject);
        NSDictionary snapshot = dbOp == null ? NSDictionary.EmptyDictionary : dbOp.dbSnapshot();
        rels = entity.relationships();
        int iCount = rels != null ? rels.count() : 0;
        for (int i = iCount - 1; i >= 0; --i) {
            NSDictionary objectSnapshot;
            Object snapshotDestObject;
            Object destObject;
            EORelationship rel = ((EORelationship)rels.objectAtIndex(i))._substitutionRelationshipForRow(snapshot);
            if (rel == null || !rel.propagatesPrimaryKey() || !classPropNames.containsObject((Object)rel.name()) || (destObject = sourceObject.storedValueForKey(rel.name())) == null || destObject == (snapshotDestObject = (objectSnapshot = this._currentCommittedSnapshotForObject(sourceObject)).objectForKey((Object)rel.name()))) continue;
            if (rel.isToMany()) {
                NSArray cheapCopy = ((NSArray)destObject).immutableClone();
                if (snapshotDestObject != cheapCopy) {
                    NSArray destObjects = (NSArray)destObject;
                    for (int j = destObjects.count() - 1; j >= 0; --j) {
                        destObject = destObjects.objectAtIndex(j);
                        this.relayPrimaryKeySourceObjectDestObjectRelationship(pkDict, sourceObject, (EOEnterpriseObject)destObject, rel);
                    }
                }
                cheapCopy = null;
                continue;
            }
            this.relayPrimaryKeySourceObjectDestObjectRelationship(pkDict, sourceObject, (EOEnterpriseObject)destObject, rel);
        }
    }

    public void recordChangesInEditingContext() {
        NSArray origValues;
        NSArray newValues;
        Object origValue;
        Object newValue;
        NSArray properties;
        EORelationship currentRel;
        int jCount;
        NSDictionary origOSS;
        NSDictionary newOSS;
        EORelationship rel;
        int j;
        NSArray rels;
        EOEntity entity;
        EOEnterpriseObject o;
        int i;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOEditingContext ec = this._editingContext;
        NSDictionary dbSnapshot = null;
        this._assertValidStateWithSelector(_recordChangesInEditingContextSelector);
        NSArray insertedObjects = ec.insertedObjects();
        NSArray deletedObjects = ec.deletedObjects();
        for (i = deletedObjects.count() - 1; i >= 0; --i) {
            o = (EOEnterpriseObject)deletedObjects.objectAtIndex(i);
            entity = this._database.entityForObject(o);
            if (entity == null) continue;
            rels = entity.relationships();
            int iCount = rels.count();
            for (j = iCount - 1; j >= 0; --j) {
                NSDictionary oldSS;
                rel = (EORelationship)rels.objectAtIndex(j);
                if (!rel.isToManyToOne() || (oldSS = this._currentCommittedSnapshotForObject(o)) == null) continue;
                NSArray destObjects = (NSArray)_NSDictionaryUtilities.nullEnabledValueForKey((NSDictionary)oldSS, (String)rel.name());
                this.nullifyAttributesInRelationshipSourceObjectDestinationObjects(rel, o, destObjects);
            }
            this.recordDeleteForObject(o);
        }
        NSArray updatedObjects = ec.updatedObjects().arrayByAddingObjectsFromArray(insertedObjects);
        for (i = updatedObjects.count() - 1; i >= 0; --i) {
            NSDictionary pkDict;
            o = (EOEnterpriseObject)updatedObjects.objectAtIndex(i);
            entity = this._database.entityForObject(o);
            if (entity == null) continue;
            this.recordUpdateForObject(o, null);
            newOSS = o.snapshot();
            if (newOSS == null) {
                newOSS = NSDictionary.EmptyDictionary;
            }
            if ((origOSS = this._currentCommittedSnapshotForObject(o)) == null) {
                origOSS = NSDictionary.EmptyDictionary;
            }
            if (this._shouldGeneratePrimaryKeyForEntityName(entity.name()) && (pkDict = this._primaryKeyForObject(o)) != null) {
                this.databaseOperationForObject(o).newRow().addEntriesFromDictionary(pkDict);
            }
            rels = entity.relationships();
            dbSnapshot = null;
            jCount = rels.count();
            for (j = 0; j < jCount; ++j) {
                if (dbSnapshot == null) {
                    dbSnapshot = this.databaseOperationForObject(o).dbSnapshot();
                }
                if ((rel = (currentRel = (EORelationship)rels.objectAtIndex(j))._substitutionRelationshipForRow(dbSnapshot)) == null || (properties = entity.classProperties()).indexOfObject((Object)rel) == -1) continue;
                newValue = _NSDictionaryUtilities.nullEnabledValueForKey((NSDictionary)newOSS, (String)rel.name());
                origValue = _NSDictionaryUtilities.nullEnabledValueForKey((NSDictionary)origOSS, (String)rel.name());
                if (rel.isToMany()) {
                    NSArray oldROs;
                    newValues = (NSArray)newValue;
                    origValues = (NSArray)origValue;
                    if (newValues == origValues || origValues == newValues.immutableClone()) continue;
                    Object object = newValues != null ? (origValues != null ? _NSArrayUtilities.arrayExcludingObjectsFromArray((NSArray)origValues, (NSArray)newValues) : null) : (oldROs = origValues);
                    if (_useToManyCaching && oldROs != null && oldROs.count() != 0) {
                        EODatabaseOperation dbOp = this.databaseOperationForObject(o);
                        int newValuesCount = newValues.count();
                        NSMutableArray gids = new NSMutableArray(newValuesCount);
                        for (int w = 0; w < newValuesCount; ++w) {
                            EOEnterpriseObject tempEO = (EOEnterpriseObject)newValues.objectAtIndex(w);
                            EOGlobalID currGid = ec.globalIDForObject(tempEO);
                            if (currGid == null || currGid.isTemporary()) {
                                gids = null;
                                break;
                            }
                            gids.addObject((Object)currGid);
                        }
                        dbOp.recordToManySnapshot((NSArray)gids, currentRel.name());
                    }
                    this.nullifyAttributesInRelationshipSourceObjectDestinationObjects(rel, o, oldROs);
                    continue;
                }
                if (newValue == origValue) continue;
                this.nullifyAttributesInRelationshipSourceObjectDestinationObject(rel, o, (EOEnterpriseObject)origValue);
            }
        }
        for (i = updatedObjects.count() - 1; i >= 0; --i) {
            o = (EOEnterpriseObject)updatedObjects.objectAtIndex(i);
            entity = this._database.entityForObject(o);
            if (entity == null) continue;
            this.recordUpdateForObject(o, null);
            newOSS = o.snapshot();
            if (newOSS == null) {
                newOSS = NSDictionary.EmptyDictionary;
            }
            if ((origOSS = this._currentCommittedSnapshotForObject(o)) == null) {
                origOSS = NSDictionary.EmptyDictionary;
            }
            rels = entity.relationships();
            dbSnapshot = null;
            jCount = rels.count();
            for (j = 0; j < jCount; ++j) {
                if (dbSnapshot == null) {
                    dbSnapshot = this.databaseOperationForObject(o).dbSnapshot();
                }
                if ((rel = (currentRel = (EORelationship)rels.objectAtIndex(j))._substitutionRelationshipForRow(dbSnapshot)) == null || (properties = entity.classProperties()).indexOfObject((Object)rel) == -1) continue;
                newValue = _NSDictionaryUtilities.nullEnabledValueForKey((NSDictionary)newOSS, (String)rel.name());
                origValue = _NSDictionaryUtilities.nullEnabledValueForKey((NSDictionary)origOSS, (String)rel.name());
                if (rel.isToMany()) {
                    NSArray newROs;
                    newValues = (NSArray)newValue;
                    origValues = (NSArray)origValue;
                    if (newValues == origValues || origValues == newValues.immutableClone()) continue;
                    NSArray nSArray = newROs = origValues != null ? _NSArrayUtilities.arrayExcludingObjectsFromArray((NSArray)newValues, (NSArray)origValues) : newValues;
                    if (_useToManyCaching && newROs != null && newROs.count() != 0) {
                        EODatabaseOperation dbOp = this.databaseOperationForObject(o);
                        int newValuesCount = newValues.count();
                        NSMutableArray gids = new NSMutableArray(newValuesCount);
                        for (int w = 0; w < newValuesCount; ++w) {
                            EOGlobalID currGid = ec.globalIDForObject((EOEnterpriseObject)newValues.objectAtIndex(w));
                            if (currGid == null || currGid.isTemporary()) {
                                gids = null;
                                break;
                            }
                            gids.addObject((Object)currGid);
                        }
                        dbOp.recordToManySnapshot((NSArray)gids, currentRel.name());
                    }
                    this.relayAttributesInRelationshipSourceObjectDestinationObjects(rel, o, newROs);
                    continue;
                }
                if (newValue == origValue) continue;
                this.relayAttributesInRelationshipSourceObjectDestinationObject(rel, o, (EOEnterpriseObject)newValue);
            }
        }
        if (this._checkPropagatedPKs != null) {
            int kcnt = this._checkPropagatedPKs.count();
            for (int k = 0; k < kcnt; ++k) {
                EOEnterpriseObject checkEO = (EOEnterpriseObject)this._checkPropagatedPKs.objectAtIndex(k);
                this._patchUpPK(this.databaseOperationForObject(checkEO));
            }
        }
        this._checkPropagatedPKs = null;
    }

    public void recordUpdateForObject(EOEnterpriseObject object, NSDictionary changes) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._assertValidStateWithSelector(_recordUpdateForObjectChangesSelector);
        EODatabaseOperation dbOp = this.databaseOperationForObject(object);
        if (dbOp != null) {
            dbOp.setDatabaseOperator(2);
            if (changes != null && changes.count() > 0) {
                NSMutableDictionary newDBSS = dbOp.newRow();
                newDBSS.addEntriesFromDictionary(changes);
            }
        } else {
            this.coordinator().forwardUpdateForObject(object, changes);
        }
    }

    protected void _performChangesWithAdaptorOps(NSArray adaptorOps) {
        NSArray ops = adaptorOps;
        EODatabaseChannel dbChannel = this._obtainOpenChannel();
        if (this._delegate.respondsTo(_databaseContextWillPerformAdaptorOperations)) {
            ops = (NSArray)this._delegate.perform(_databaseContextWillPerformAdaptorOperations, (Object)this, (Object)ops, (Object)dbChannel.adaptorChannel());
        }
        this._adaptorContext.beginTransaction();
        dbChannel.adaptorChannel().performAdaptorOperations(ops);
    }

    protected void _patchUpPK(EODatabaseOperation op) {
        if (op == null) {
            return;
        }
        if (op.databaseOperator() == 1) {
            NSMutableDictionary row = op.newRow();
            EOEntity ent = op.entity();
            EOEnterpriseObject eo = (EOEnterpriseObject)op.object();
            NSArray pkeys = ent.primaryKeyAttributeNames();
            boolean needsPatch = false;
            int c = pkeys.count();
            for (int i = 0; i < c; ++i) {
                if (row.objectForKey(pkeys.objectAtIndex(i)) != NSKeyValueCoding.NullValue) continue;
                needsPatch = true;
                break;
            }
            if (needsPatch) {
                NSArray rels = ent.relationships();
                int jc = rels.count();
                for (int j = 0; j < jc; ++j) {
                    EOEnterpriseObject dest;
                    EORelationship rel = (EORelationship)rels.objectAtIndex(j);
                    EORelationship inv = rel.inverseRelationship();
                    if (inv == null || !inv.propagatesPrimaryKey() || (dest = (EOEnterpriseObject)eo.valueForKey(rel.name())) == null) continue;
                    NSDictionary pk = this.relayAttributesInRelationshipSourceObjectDestinationObject(inv, dest, eo);
                }
            }
        }
    }

    public void performChanges() {
        EODatabaseOperation dbOp;
        EOGlobalID gid;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        this._assertValidStateWithSelector(_performChangesSelector);
        Enumeration mapEnumerator = this._dbOperationsByGlobalID.keyEnumerator();
        while (mapEnumerator.hasMoreElements()) {
            gid = (EOGlobalID)mapEnumerator.nextElement();
            dbOp = (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
            this._verifyNoChangesToReadonlyEntity(dbOp);
            this.createAdaptorOperationsForDatabaseOperation(dbOp);
        }
        NSArray adaptorOps = this._delegate.respondsTo(_databaseContextWillOrderAdaptorOperations) ? (NSArray)this._delegate.perform(_databaseContextWillOrderAdaptorOperations, (Object)this, (Object)this._dbOperationsByGlobalID.allValues()) : this.orderAdaptorOperations();
        if (adaptorOps.count() != 0) {
            try {
                this._performChangesWithAdaptorOps(adaptorOps);
            }
            catch (Exception localException) {
                if (this._delegateHandledDatabaseException(localException)) {
                    try {
                        this._performChangesWithAdaptorOps(adaptorOps);
                    }
                    catch (Exception e2) {
                        throw this._exceptionWithDatabaseContextInformationAdded(e2);
                    }
                }
                if (this._isDroppedConnectionException(localException)) {
                    this._database.handleDroppedConnection();
                    try {
                        this._performChangesWithAdaptorOps(adaptorOps);
                    }
                    catch (Exception localException2) {
                        throw this._exceptionWithDatabaseContextInformationAdded(localException2);
                    }
                }
                throw this._exceptionWithDatabaseContextInformationAdded(localException);
            }
        }
        mapEnumerator = this._dbOperationsByGlobalID.keyEnumerator();
        while (mapEnumerator.hasMoreElements()) {
            NSDictionary toManySnapshots;
            gid = (EOGlobalID)mapEnumerator.nextElement();
            dbOp = (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
            if (dbOp.object() == null) continue;
            NSArray adaptorOperations = dbOp.adaptorOperations();
            if (adaptorOperations != null && adaptorOperations.count() > 0) {
                switch (dbOp.databaseOperator()) {
                    case 1: 
                    case 2: {
                        NSDictionary dbSnapshot = EOKeyValueCodingAdditions.Utility.valuesForKeys((Object)dbOp.newRow(), (NSArray)dbOp.entity().dbSnapshotKeys());
                        this.recordSnapshotForGlobalID(dbSnapshot, gid);
                        break;
                    }
                    case 3: {
                        this.forgetSnapshotForGlobalID(gid);
                        break;
                    }
                }
            }
            if (!_useToManyCaching || dbOp.databaseOperator() != 2 || (toManySnapshots = dbOp.toManySnapshots()) == null) continue;
            if (this._uniqueArrayTable == null) {
                this._uniqueArrayTable = new NSMutableDictionary();
            }
            this.recordToManySnapshots(new NSDictionary((Object)toManySnapshots, (Object)dbOp.globalID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() {
        EODatabaseOperation dbOp;
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        Exception exception = null;
        NSMutableDictionary gidMap = null;
        boolean mustCleanUp = false;
        this._assertValidStateWithSelector(_commitChangesSelector);
        try {
            if (this._adaptorContext.hasOpenTransaction()) {
                this._adaptorContext.commitTransaction();
            } else {
                mustCleanUp = true;
            }
        }
        catch (Exception localException) {
            exception = localException;
        }
        if (exception != null) {
            this.rollbackChanges();
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        if (_useToManyCaching && mustCleanUp) {
            this._database.recordToManySnapshots((NSDictionary)this._uniqueArrayTable);
            this._uniqueArrayTable = null;
        }
        Enumeration mapEnumerator = this._dbOperationsByGlobalID.keyEnumerator();
        EOObserverCenter.suppressObserverNotification();
        try {
            while (mapEnumerator.hasMoreElements()) {
                Object dbOpObj;
                EOGlobalID gid = (EOGlobalID)mapEnumerator.nextElement();
                dbOp = (EODatabaseOperation)this._dbOperationsByGlobalID.objectForKey((Object)gid);
                int dbOperator = dbOp.databaseOperator();
                EOEntity entity = dbOp.entity();
                if (gid.isTemporary() || dbOp.primaryKeyDiffs().count() > 0) {
                    EOKeyGlobalID newGid = entity._globalIDForRowIsFinal((NSDictionary)dbOp.newRow(), true);
                    if (gidMap == null) {
                        gidMap = new NSMutableDictionary(64);
                    }
                    gidMap.setObjectForKey((Object)newGid, (Object)gid);
                }
                NSDictionary dict = null;
                switch (dbOperator) {
                    case 1: {
                        dict = EOKeyValueCodingAdditions.Utility.valuesForKeys((Object)dbOp.newRow(), (NSArray)entity.classPropertyAttributeNames());
                        break;
                    }
                    case 2: {
                        dict = dbOp.rowDiffsForAttributes(entity._classPropertyAttributes());
                        break;
                    }
                }
                if ((dbOpObj = dbOp.object()) == null) continue;
                if (dict != null && dict.count() > 0) {
                    EOKeyValueCodingAdditions.DefaultImplementation._takeStoredValuesFromDictionary((Object)dbOpObj, (NSDictionary)dict);
                }
                if (dbOperator != 1) continue;
                this._database.incrementSnapshotCountForGlobalID(gid);
            }
        }
        finally {
            EOObserverCenter.enableObserverNotification();
        }
        if (gidMap != null) {
            NSNotificationCenter.defaultCenter().postNotification("EOGlobalIDChangedNotification", (Object)this, gidMap);
        }
        NSArray dbOps = this._dbOperationsByGlobalID.allValues();
        NSMutableDictionary changeInfo = new NSMutableDictionary();
        int dbOpsCount = dbOps.count();
        NSMutableArray updateGIDs = new NSMutableArray(dbOpsCount);
        NSMutableArray insertGIDs = new NSMutableArray(dbOpsCount);
        NSMutableArray deleteGIDs = new NSMutableArray(dbOpsCount);
        block15: for (int i = dbOpsCount - 1; i >= 0; --i) {
            dbOp = (EODatabaseOperation)dbOps.objectAtIndex(i);
            switch (dbOp.databaseOperator()) {
                case 1: {
                    Object permanentGID = gidMap == null ? null : gidMap.objectForKey((Object)dbOp.globalID());
                    insertGIDs.addObject(permanentGID != null ? permanentGID : dbOp.globalID());
                    continue block15;
                }
                case 3: {
                    deleteGIDs.addObject((Object)dbOp.globalID());
                    continue block15;
                }
                case 2: {
                    updateGIDs.addObject((Object)dbOp.globalID());
                    continue block15;
                }
            }
        }
        changeInfo.setObjectForKey((Object)updateGIDs, (Object)"updated");
        changeInfo.setObjectForKey((Object)insertGIDs, (Object)"inserted");
        changeInfo.setObjectForKey((Object)deleteGIDs, (Object)"deleted");
        this._cleanUpAfterSave();
        NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this._database, (NSDictionary)changeInfo);
    }

    public void rollbackChanges() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        Exception exception = null;
        try {
            if (this._adaptorContext.hasOpenTransaction()) {
                this._adaptorContext.rollbackTransaction();
            }
        }
        catch (Exception localException) {
            exception = localException;
        }
        this._cleanUpAfterSave();
        if (exception != null) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
    }

    private boolean isObjectStoreForObject(EOEnterpriseObject object) {
        EOEntity entity = this._database.entityNamed(this._database.entityForObject(object).name());
        return entity != null;
    }

    private NSMutableDictionary _mutableValuesForKeys(NSArray keys, EOEnterpriseObject object) {
        return (NSMutableDictionary)this.valuesForKeys(keys, object);
    }

    public NSDictionary valuesForKeys(NSArray keys, EOEnterpriseObject object) {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this);
        EOEntity entity = this._database.entityForObject(object);
        if (entity == null) {
            return this.coordinator().valuesForKeys(keys, object).mutableClone();
        }
        int keyCount = keys.count();
        if (EOFaultHandler.isFault((Object)object) && keyCount <= 16) {
            int keyIndex = -1;
            NSArray pkNames = entity.primaryKeyAttributeNames();
            keyCount = keys.count();
            if (pkNames.count() >= keyCount) {
                String key;
                EOKeyGlobalID gid = (EOKeyGlobalID)this._globalIDForObject(object);
                Object[] keyValues = gid._keyValuesNoCopy();
                Object[] keysP = new Object[keyCount];
                Object[] valuesP = new Object[keyCount];
                for (int i = 0; i < keyCount && (keyIndex = pkNames.indexOfObject((Object)(key = (String)keys.objectAtIndex(i)))) != -1; ++i) {
                    keysP[i] = key;
                    valuesP[i] = keyValues[keyIndex];
                }
                if (keyIndex != -1) {
                    return new NSMutableDictionary(valuesP, keysP);
                }
            }
        }
        EODatabaseOperation dbOp = this.databaseOperationForObject(object);
        NSMutableDictionary newRow = dbOp.newRow();
        return _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)newRow, (NSArray)keys);
    }

    static {
        Class aClass = _EOPrivate.class;
        _contextClassToRegister = EODatabaseContext.class;
        NSNotificationCenter.defaultCenter().addObserver((Object)EODatabaseContext.class, _cooperatingObjectStoreNeededSelector, "EOCooperatingObjectStoreNeededNotification", null);
        EOEventCenter.registerEventClass((Class)DatabaseContextEvent.class, (EOEventCenter.EventRecordingHandler)new _EventLoggingEnabler());
        warnedOnce = false;
    }

    public static interface Delegate {
        public boolean databaseContextWillRunLoginPanelToOpenDatabaseChannel(EODatabaseContext var1, EODatabaseChannel var2);

        public NSDictionary databaseContextNewPrimaryKey(EODatabaseContext var1, Object var2, EOEntity var3);

        public boolean databaseContextFailedToFetchObject(EODatabaseContext var1, Object var2, EOGlobalID var3);

        public NSArray databaseContextWillOrderAdaptorOperations(EODatabaseContext var1, NSArray var2);

        public NSArray databaseContextWillPerformAdaptorOperations(EODatabaseContext var1, NSArray var2, EOAdaptorChannel var3);

        public boolean databaseContextShouldInvalidateObjectWithGlobalID(EODatabaseContext var1, EOGlobalID var2, NSDictionary var3);

        public NSArray databaseContextShouldFetchObjects(EODatabaseContext var1, EOFetchSpecification var2, EOEditingContext var3);

        public void databaseContextDidFetchObjects(EODatabaseContext var1, NSArray var2, EOFetchSpecification var3, EOEditingContext var4);

        public boolean databaseContextShouldSelectObjects(EODatabaseContext var1, EOFetchSpecification var2, EODatabaseChannel var3);

        public boolean databaseContextShouldUsePessimisticLock(EODatabaseContext var1, EOFetchSpecification var2, EODatabaseChannel var3);

        public void databaseContextDidSelectObjects(EODatabaseContext var1, EOFetchSpecification var2, EODatabaseChannel var3);

        public NSDictionary databaseContextShouldUpdateCurrentSnapshot(EODatabaseContext var1, NSDictionary var2, NSDictionary var3, EOGlobalID var4, EODatabaseChannel var5);

        public boolean databaseContextShouldLockObjectWithGlobalID(EODatabaseContext var1, EOGlobalID var2, NSDictionary var3);

        public boolean databaseContextShouldRaiseExceptionForLockFailure(EODatabaseContext var1, Throwable var2);

        public boolean databaseContextShouldFetchObjectFault(EODatabaseContext var1, Object var2);

        public boolean databaseContextShouldFetchArrayFault(EODatabaseContext var1, Object var2);

        public void databaseContextWillFireObjectFaultForGlobalID(EODatabaseContext var1, EOGlobalID var2, EOFetchSpecification var3, EOEditingContext var4);

        public void databaseContextWillFireArrayFaultForGlobalID(EODatabaseContext var1, EOGlobalID var2, EORelationship var3, EOFetchSpecification var4, EOEditingContext var5);

        public boolean databaseContextShouldHandleDatabaseException(EODatabaseContext var1, Throwable var2);
    }

    public static class DatabaseContextEvent
    extends EOEvent {
        public static String ObjectsWithFetchSpecification = "objectsWithFetchSpecification";
        public static String SaveChangesInEditingContext = "saveChangesInEditingContext";

        public DatabaseContextEvent() {
        }

        public DatabaseContextEvent(String type) {
            this.setType(type);
        }
    }

    public static class _EventLoggingEnabler
    implements EOEventCenter.EventRecordingHandler {
        public void setLoggingEnabled(boolean isLogging, Class aClass) {
            _IsEventLoggingEnabled = isLogging;
        }
    }
}

