/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOProperty;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class EOModel
implements NSDisposable {
    protected EOModelGroup _group;
    protected String _name;
    protected URL _url;
    protected NSDictionary _userInfo;
    protected NSDictionary _internalInfo;
    protected NSDictionary _connectionDictionary;
    protected String _adaptorName;
    protected NSMutableDictionary _entitiesByName;
    protected NSMutableDictionary _entitiesByClass;
    protected NSMutableArray _storedProcedures;
    protected NSArray _entities;
    protected NSArray _sharedObjectEntities;
    protected NSMutableDictionary _subEntitiesCache;
    protected NSMutableDictionary _prototypesByName;
    protected int _extraRefCount;
    static final String CURRENT_EOMODEL_VERSION = "2.1";
    public static final String EntityLoadedNotification = "EOEntityLoadedNotification";
    static final String ModelExtension = "eomodeld";
    static final String IndexFilename = "index.eomodeld";
    private static final NSSelector _classDescriptionNeededForClassSelector;
    private static final NSSelector _classDescriptionNeededForEntityNameSelector;
    private static final NSSelector _storedProcedureNamedSelector;
    private static final NSSelector _classDescriptionNeededSelector;
    protected static NSRecursiveLock _EOGlobalModelLock;
    static final String prototypesKeyPrefix = "EO";
    static final String prototypesKeySuffix = "Prototypes";
    static final String prototypesToHideKey = "EOPrototypesToHide";

    public void dispose() {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
    }

    public EOModel() {
        this.init();
    }

    void init() {
        this._name = null;
        this._group = null;
        this._url = null;
        this._userInfo = null;
        this._internalInfo = null;
        this._connectionDictionary = null;
        this._adaptorName = null;
        this._entities = null;
        this._extraRefCount = 0;
        this._storedProcedures = null;
        this._entitiesByName = new NSMutableDictionary(64);
        this._entitiesByClass = new NSMutableDictionary(64);
        NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
        notificationCenter.addObserver((Object)this, _classDescriptionNeededForClassSelector, "EOClassDescriptionNeededNotification", null);
        notificationCenter.addObserver((Object)this, _classDescriptionNeededForEntityNameSelector, "EOClassDescriptionNeededForEntityNameNotification", null);
        _DefaultModelCreator._unregisterDefaultModelCreator();
        EOClassDescription.invalidateClassDescriptionCache();
    }

    public String toString() {
        NSMutableDictionary d;
        block2: {
            d = new NSMutableDictionary(128);
            try {
                this.encodeTableOfContentsIntoPropertyList(d);
            }
            catch (Exception e) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32770L)) break block2;
                NSLog.err.appendln((Object)("<EOModel>: Exception occurred during toString():" + e.getMessage()));
                if (NSLog.allowedDebugLevel() <= 1) break block2;
                NSLog.err.appendln((Throwable)e);
            }
        }
        return d.toString();
    }

    public String name() {
        return this._name;
    }

    public String path() {
        return this._url.getPath();
    }

    public URL pathURL() {
        return this._url;
    }

    public NSArray entityNames() {
        try {
            return this._entitiesByName.allKeys().sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEntity entityNamed(String name) {
        Object entity;
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            entity = this._entitiesByName.objectForKey((Object)name);
            if (entity instanceof NSDictionary) {
                if (((NSDictionary)entity).objectForKey((Object)"__fullPlist") == null) {
                    NSDictionary propertyList;
                    String filename = NSPathUtilities.stringByAppendingPathComponent((String)this._url.toString(), (String)name);
                    filename = NSPathUtilities.stringByAppendingPathExtension((String)filename, (String)"plist");
                    try {
                        URL fileURL = new URL(filename);
                        propertyList = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)fileURL);
                    }
                    catch (MalformedURLException mue) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)mue);
                    }
                    entity = new NSMutableDictionary((NSDictionary)entity);
                    ((NSMutableDictionary)entity).addEntriesFromDictionary(propertyList);
                }
                this._removeEntity(entity);
                try {
                    entity = this._addEntityWithPropertyList(entity);
                }
                catch (IllegalAccessException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
        return (EOEntity)entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray entities() {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._entities == null) {
                NSArray entitiesName = this.entityNames();
                int c = entitiesName.count();
                NSMutableArray entities = new NSMutableArray(c);
                for (int i = 0; i < c; ++i) {
                    entities.addObject((Object)this.entityNamed((String)entitiesName.objectAtIndex(i)));
                }
                this._entities = entities;
            }
        }
        return this._entities;
    }

    public EOEntity entityForObject(EOEnterpriseObject object) {
        String entityName = object.entityName();
        return this.entityNamed(entityName);
    }

    public String adaptorName() {
        return this._adaptorName;
    }

    public NSDictionary connectionDictionary() {
        return this._connectionDictionary;
    }

    public NSDictionary userInfo() {
        return this._userInfo == null ? NSDictionary.EmptyDictionary : this._userInfo;
    }

    public NSArray entitiesWithSharedObjects() {
        if (this._sharedObjectEntities == null) {
            return NSArray.EmptyArray;
        }
        int count = this._sharedObjectEntities.count();
        NSMutableArray array = new NSMutableArray(count);
        for (int i = count - 1; i >= 0; --i) {
            String tmpEntity = (String)this._sharedObjectEntities.objectAtIndex(i);
            array.addObject((Object)this.entityNamed(tmpEntity));
        }
        return array;
    }

    public NSDictionary _internalInfo() {
        return this._internalInfo;
    }

    public EOModelGroup modelGroup() {
        return this._group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray storedProcedureNames() {
        NSMutableArray spNames;
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            int c = this._storedProcedures != null ? this._storedProcedures.count() : 0;
            spNames = new NSMutableArray(c);
            for (int i = 0; i < c; ++i) {
                Object object = this._storedProcedures.objectAtIndex(i);
                if (object instanceof EOStoredProcedure) {
                    spNames.addObject((Object)((EOStoredProcedure)object).name());
                    continue;
                }
                spNames.addObject(object);
            }
        }
        try {
            return spNames.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOStoredProcedure storedProcedureNamed(String name) {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            int c = this._storedProcedures == null ? 0 : this._storedProcedures.count();
            for (int i = 0; i < c; ++i) {
                Object storedProcedure = this._storedProcedures.objectAtIndex(i);
                if (storedProcedure instanceof EOStoredProcedure) {
                    if (!((EOStoredProcedure)storedProcedure).name().equals(name)) continue;
                    return (EOStoredProcedure)storedProcedure;
                }
                if (!((String)storedProcedure).equals(name)) continue;
                NSDictionary propertyList = null;
                String filename = NSPathUtilities.stringByAppendingPathComponent((String)this._url.toString(), (String)name);
                filename = NSPathUtilities.stringByAppendingPathExtension((String)filename, (String)"storedProcedure");
                try {
                    URL fileURL = new URL(filename);
                    propertyList = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)fileURL);
                }
                catch (MalformedURLException mue) {
                    NSLog._conditionallyLogPrivateException((Throwable)mue);
                }
                catch (RuntimeException e) {
                    if (!(NSForwardException._originalThrowable((Throwable)e) instanceof FileNotFoundException)) {
                        throw e;
                    }
                    propertyList = null;
                    NSLog._conditionallyLogPrivateException((Throwable)e);
                }
                if (propertyList == null) {
                    throw new IllegalArgumentException("Corrupted model file. The table of contents includes a stored procedure \"" + name + "\" that is not in the emodeld directory!");
                }
                storedProcedure = new EOStoredProcedure(propertyList, this);
                this._storedProcedures.replaceObjectAtIndex(storedProcedure, i);
                return (EOStoredProcedure)storedProcedure;
            }
        }
        return null;
    }

    public NSArray storedProcedures() {
        if (this._storedProcedures == null) {
            return NSArray.EmptyArray;
        }
        _NSArrayUtilities.performSelectorWithEachObjectInArray((Object)this, (NSSelector)_storedProcedureNamedSelector, (NSArray)this.storedProcedureNames());
        return this._storedProcedures;
    }

    private void addAttributesToPrototypesCache(NSArray attributes) {
        NSMutableArray keys = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)attributes, (NSSelector)_NSArrayUtilities._nameSelector);
        NSDictionary temp = new NSDictionary(attributes, (NSArray)keys);
        this._prototypesByName.addEntriesFromDictionary(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPrototypeCache() {
        NSArray locallyDefined = null;
        NSArray localAdaptorSpecific = null;
        NSArray adaptorPrototypes = null;
        NSArray prototypesToHide = null;
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            EOEntity ent;
            this._prototypesByName = new NSMutableDictionary();
            try {
                ent = this._group.entityNamed("EOPrototypes");
                if (ent != null) {
                    locallyDefined = ent.attributes();
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            try {
                ent = this._group.entityNamed(prototypesKeyPrefix + this.adaptorName() + prototypesKeySuffix);
                if (ent != null) {
                    localAdaptorSpecific = ent.attributes();
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            try {
                adaptorPrototypes = EOAdaptor.adaptorWithModel(this).prototypeAttributes();
            }
            catch (Exception e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
                adaptorPrototypes = null;
            }
            try {
                ent = this._group.entityNamed(prototypesToHideKey);
                if (ent != null) {
                    prototypesToHide = ent.attributes();
                }
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            if (adaptorPrototypes != null) {
                this.addAttributesToPrototypesCache(adaptorPrototypes);
            }
            if (prototypesToHide != null) {
                NSMutableArray attributeNamesToRemove = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)prototypesToHide, (NSSelector)_NSArrayUtilities._nameSelector);
                this._prototypesByName.removeObjectsForKeys((NSArray)attributeNamesToRemove);
            }
            if (locallyDefined != null) {
                this.addAttributesToPrototypesCache(locallyDefined);
            }
            if (localAdaptorSpecific != null) {
                this.addAttributesToPrototypesCache(localAdaptorSpecific);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOAttribute prototypeAttributeNamed(String name) {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._prototypesByName == null) {
                this.createPrototypeCache();
            }
        }
        return (EOAttribute)this._prototypesByName.objectForKey((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray availablePrototypeAttributeNames() {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._prototypesByName == null) {
                this.createPrototypeCache();
            }
        }
        try {
            return this._prototypesByName.allKeys().sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public EOModel(String path) {
        this(NSPathUtilities._URLWithPath((String)path));
    }

    public EOModel(URL url) {
        NSMutableDictionary propertyList = null;
        if (url == null) {
            throw new IllegalArgumentException("empty url");
        }
        if (!NSPathUtilities.fileExistsAtPathURL((URL)url)) {
            throw new IllegalArgumentException("File not found " + url);
        }
        String path = url.toString();
        boolean isDirectory = NSPathUtilities._isDirectoryAtPathURL((URL)url);
        if (!isDirectory && NSPathUtilities.pathExtension((String)path).equals(ModelExtension)) {
            path = NSPathUtilities.stringByDeletingLastPathComponent((String)path);
            isDirectory = true;
        }
        if (!isDirectory) {
            try {
                url = new URL(path);
                propertyList = ((NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)url)).mutableClone();
            }
            catch (MalformedURLException mue) {
                throw new IllegalStateException("Malformed URL: " + path);
            }
            catch (RuntimeException e) {
                if (NSForwardException._originalThrowable((Throwable)e) instanceof FileNotFoundException) {
                    throw new IllegalArgumentException("Unable to read " + path);
                }
                throw e;
            }
            this._initWithPropertyListOwner((NSDictionary)propertyList, null);
            this.setName(NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)path)));
            this._setPathURL(url);
            this.awakeWithPropertyList((NSDictionary)propertyList);
        } else {
            block19: {
                URL indexURL;
                block18: {
                    block17: {
                        indexURL = null;
                        try {
                            url = new URL(path);
                        }
                        catch (Exception e) {
                            if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)32768L)) break block17;
                            NSLog.out.appendln((Object)("Unable to find " + url + " because " + e + ". This model may not be loaded correctly."));
                        }
                    }
                    try {
                        indexURL = new URL(path + "/" + IndexFilename);
                        propertyList = ((NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)indexURL)).mutableClone();
                    }
                    catch (Exception e) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)32768L)) break block18;
                        NSLog.out.appendln((Object)("Unable to read " + indexURL + " because " + e));
                    }
                }
                if (indexURL == null) {
                    try {
                        indexURL = new URL(path + "/" + "eomodel.plist");
                        propertyList = ((NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)indexURL)).mutableClone();
                    }
                    catch (Exception e) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)32768L)) break block19;
                        NSLog.out.appendln((Object)("Unable to read " + indexURL + " because " + e));
                    }
                }
            }
            if (propertyList == null) {
                throw new IllegalArgumentException("Unable to read either '" + path + "/" + IndexFilename + "' or '" + path + "/" + "eomodel.plist");
            }
            this._initWithTableOfContentsPropertyListPathURL((NSDictionary)propertyList, url);
        }
    }

    public String _filenameForFetchSpecificationDictionaryForEntityNamedWithModelPath(String entityName, String modelPath) {
        return NSPathUtilities.stringByAppendingPathExtension((String)NSPathUtilities.stringByAppendingPathComponent((String)modelPath, (String)entityName), (String)"fspec");
    }

    public boolean _writeFetchSpecificationDictionaryForEntityNamedToModelPath(NSDictionary fetchSpecDict, String entityName, String modelPath) {
        String filename = this._filenameForFetchSpecificationDictionaryForEntityNamedWithModelPath(entityName, modelPath);
        boolean returnValue = _NSDictionaryUtilities.writeToFile((NSDictionary)fetchSpecDict, (String)filename);
        return returnValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write() {
        int i;
        boolean writeOldStyle = false;
        if (!"file".equals(this._url.getProtocol())) throw new IllegalArgumentException("Cannot write EOModel to path " + this._url);
        String urlPath = this._url.getPath();
        String extension = NSPathUtilities.pathExtension((String)urlPath);
        if (extension != null && extension.equals("eomodel")) {
            writeOldStyle = true;
        }
        String writePath = EOModel._canonicalPath(urlPath);
        if (writeOldStyle) {
            NSMutableDictionary d = new NSMutableDictionary(8);
            this.encodeIntoPropertyList(d);
            if (_NSDictionaryUtilities.writeToFile((NSDictionary)d, (String)writePath)) return;
            throw new IllegalArgumentException("Unable to save file " + writePath);
        }
        this.loadAllModelObjects();
        if (NSPathUtilities.fileExistsAtPath((String)urlPath) && !NSPathUtilities._fileAtPathIsWritable((String)urlPath)) {
            throw new IllegalStateException("Model is not writable: the following path contains a read only file: " + urlPath);
        }
        NSArray paths = NSPathUtilities._directoryContentsAtPath((String)urlPath);
        int c = paths.count();
        for (i = 0; i < c; ++i) {
            String path = NSPathUtilities.stringByAppendingPathComponent((String)urlPath, (String)((String)paths.objectAtIndex(i)));
            if (!NSPathUtilities.fileExistsAtPath((String)path) || NSPathUtilities._fileAtPathIsWritable((String)path)) continue;
            throw new IllegalStateException("Model is not writable: the following path contains a read only file: " + path);
        }
        String backup = writePath + "~";
        if (NSPathUtilities.fileExistsAtPath((String)writePath)) {
            if (NSPathUtilities.fileExistsAtPath((String)backup)) {
                NSPathUtilities._removeFileAtPath((String)backup);
            }
            NSPathUtilities._movePath((String)writePath, (String)backup);
        }
        try {
            NSMutableDictionary d;
            String name;
            if (!NSPathUtilities._createDirectory((String)writePath)) {
                throw new IllegalArgumentException("write: Cannot create directory " + writePath);
            }
            NSMutableDictionary d2 = new NSMutableDictionary(8);
            this.encodeTableOfContentsIntoPropertyList(d2);
            if (!_NSDictionaryUtilities.writeToFile((NSDictionary)d2, (String)NSPathUtilities.stringByAppendingPathComponent((String)writePath, (String)IndexFilename))) {
                throw new IllegalArgumentException("Unable to save file " + NSPathUtilities.stringByAppendingPathComponent((String)writePath, (String)IndexFilename));
            }
            c = this._entities.count();
            for (i = 0; i < c; ++i) {
                EOEntity ent = (EOEntity)this._entities.objectAtIndex(i);
                String entName = ent.name();
                name = NSPathUtilities.stringByAppendingPathExtension((String)NSPathUtilities.stringByAppendingPathComponent((String)writePath, (String)entName), (String)"plist");
                d = new NSMutableDictionary(8);
                ent.encodeIntoPropertyList(d);
                NSDictionary fetchSpecDict = (NSDictionary)d.objectForKey((Object)"fetchSpecificationDictionary");
                if (fetchSpecDict != null && fetchSpecDict.count() == 0) {
                    fetchSpecDict = null;
                } else {
                    d.removeObjectForKey((Object)"fetchSpecificationDictionary");
                }
                if (!_NSDictionaryUtilities.writeToFile((NSDictionary)d, (String)name)) {
                    throw new IllegalArgumentException("Unable to save file " + name);
                }
                if (fetchSpecDict == null) continue;
                this._writeFetchSpecificationDictionaryForEntityNamedToModelPath(fetchSpecDict, entName, writePath);
            }
            NSArray storedProcedureNames = this.storedProcedureNames();
            c = storedProcedureNames.count();
            for (i = 0; i < c; ++i) {
                String storedProcedureName = (String)storedProcedureNames.objectAtIndex(i);
                EOStoredProcedure sp = this.storedProcedureNamed(storedProcedureName);
                name = NSPathUtilities.stringByAppendingPathComponent((String)writePath, (String)storedProcedureName);
                d = new NSMutableDictionary(8);
                name = NSPathUtilities.stringByAppendingPathExtension((String)name, (String)"storedProcedure");
                sp.encodeIntoPropertyList(d);
                if (_NSDictionaryUtilities.writeToFile((NSDictionary)d, (String)name)) continue;
                throw new IllegalArgumentException("Unable to save file " + name);
            }
            if (backup == null || !NSPathUtilities.fileExistsAtPath((String)backup) || NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)"EOMWriteOnlyModelObjects"))) return;
            c = paths.count();
            for (i = 0; i < c; ++i) {
                String base = (String)paths.objectAtIndex(i);
                if (base.startsWith("plist") || base.startsWith("fspec") || base.startsWith(ModelExtension) || base.startsWith("~") || base.startsWith(".") || base.equals("DiagramLayout")) continue;
                String origPath = NSPathUtilities.stringByAppendingPathComponent((String)backup, (String)base);
                String newPath = NSPathUtilities.stringByAppendingPathComponent((String)urlPath, (String)base);
                if (NSPathUtilities.fileExistsAtPath((String)newPath)) continue;
                NSPathUtilities._copyPath((String)origPath, (String)newPath, (Object)this);
            }
            return;
        }
        catch (IllegalArgumentException exception) {
            if (!NSPathUtilities.fileExistsAtPath((String)backup)) throw exception;
            if (NSPathUtilities.fileExistsAtPath((String)writePath)) {
                String corruptPath = writePath + "#";
                if (NSPathUtilities.fileExistsAtPath((String)corruptPath)) {
                    NSPathUtilities._removeFileAtPath((String)corruptPath);
                }
                NSPathUtilities._movePath((String)writePath, (String)corruptPath);
            }
            NSPathUtilities._movePath((String)backup, (String)writePath);
            throw exception;
        }
    }

    public void writeToFile(String path) {
        this._setPathURL(NSPathUtilities._URLWithPath((String)path));
        this.write();
    }

    public NSMutableDictionary _loadFetchSpecificationDictionaryForEntityNamed(String entityName) {
        NSMutableDictionary fetchSpecDict;
        NSDictionary archivedDict = null;
        String filename = this._filenameForFetchSpecificationDictionaryForEntityNamedWithModelPath(entityName, this._url != null ? this._url.toString() : null);
        try {
            URL fileURL = new URL(filename);
            archivedDict = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL((URL)fileURL);
        }
        catch (MalformedURLException mue) {
            NSLog._conditionallyLogPrivateException((Throwable)mue);
        }
        catch (RuntimeException e) {
            if (!(NSForwardException._originalThrowable((Throwable)e) instanceof FileNotFoundException)) {
                throw e;
            }
            archivedDict = null;
            NSLog._conditionallyLogPrivateException((Throwable)e);
        }
        if (archivedDict != null) {
            EOKeyValueUnarchiver unarchiver = new EOKeyValueUnarchiver(archivedDict);
            Enumeration enumerator = archivedDict.keyEnumerator();
            fetchSpecDict = new NSMutableDictionary(archivedDict.count());
            while (enumerator.hasMoreElements()) {
                String name = (String)enumerator.nextElement();
                fetchSpecDict.setObjectForKey(unarchiver.decodeObjectForKey(name), (Object)name);
            }
        } else {
            fetchSpecDict = new NSMutableDictionary();
        }
        return fetchSpecDict;
    }

    protected EOModel(NSDictionary propertyList, String path) {
        this._initWithTableOfContentsPropertyListPathURL(propertyList, NSPathUtilities._URLWithPath((String)path));
    }

    protected EOModel(NSDictionary propertyList, URL url) {
        this._initWithTableOfContentsPropertyListPathURL(propertyList, url);
    }

    protected void _initWithTableOfContentsPropertyListPathURL(NSDictionary propertyList, URL url) {
        NSArray array;
        String path = url.toString();
        this.init();
        this._setPathURL(url);
        this.setName(NSPathUtilities.lastPathComponent((String)NSPathUtilities.stringByDeletingPathExtension((String)path)));
        NSDictionary dict = (NSDictionary)propertyList.objectForKey((Object)"connectionDictionary");
        this._connectionDictionary = dict == null ? null : (NSDictionary)dict.clone();
        this._adaptorName = (String)propertyList.objectForKey((Object)"adaptorName");
        this._initializeInfo(propertyList);
        NSArray storedProcedureArray = (NSArray)propertyList.objectForKey((Object)"storedProcedures");
        if (storedProcedureArray != null) {
            this._storedProcedures = new NSMutableArray(storedProcedureArray);
        }
        if ((array = (NSArray)propertyList.objectForKey((Object)"entities")) != null) {
            int c = array.count();
            for (int i = 0; i < c; ++i) {
                this._addFakeEntityWithPropertyList((NSDictionary)array.objectAtIndex(i));
            }
        }
        this._sharedObjectEntities = (NSArray)propertyList.objectForKey((Object)"entitiesWithSharedObjects");
        if (this._sharedObjectEntities != null) {
            this._sharedObjectEntities = (NSArray)this._sharedObjectEntities.clone();
        }
    }

    public void encodeTableOfContentsIntoPropertyList(NSMutableDictionary result) {
        Object current;
        int i;
        if (this._userInfo != null) {
            result.setObjectForKey((Object)this._userInfo, (Object)"userInfo");
        }
        if (this._internalInfo != null) {
            result.setObjectForKey((Object)this._internalInfo, (Object)"internalInfo");
        }
        if (this._connectionDictionary != null) {
            result.setObjectForKey((Object)this._connectionDictionary, (Object)"connectionDictionary");
        }
        if (this._adaptorName != null) {
            result.setObjectForKey((Object)this._adaptorName, (Object)"adaptorName");
        }
        if (this._storedProcedures != null && this._storedProcedures.count() != 0) {
            result.setObjectForKey((Object)this.storedProcedureNames(), (Object)"storedProcedures");
        }
        NSArray names = this.entityNames();
        int namesCount = names.count();
        NSMutableArray sharedList = new NSMutableArray(8);
        for (i = 0; i < namesCount; ++i) {
            current = this._entitiesByName.objectForKey(names.objectAtIndex(i));
            if (!(current instanceof EOEntity) || ((EOEntity)current).sharedObjectFetchSpecificationNames().count() <= 0) continue;
            sharedList.addObject(names.objectAtIndex(i));
        }
        if (sharedList.count() > 0) {
            result.setObjectForKey((Object)sharedList, (Object)"entitiesWithSharedObjects");
        }
        NSMutableArray entities = new NSMutableArray(namesCount);
        for (i = 0; i < namesCount; ++i) {
            current = this._entitiesByName.objectForKey(names.objectAtIndex(i));
            if (current instanceof NSDictionary) {
                entities.addObject(current);
                continue;
            }
            NSMutableDictionary d = new NSMutableDictionary();
            EOEntity currentEntity = (EOEntity)current;
            EOEntity theParentEntity = currentEntity.parentEntity();
            d.setObjectForKey((Object)currentEntity.name(), (Object)"name");
            d.setObjectForKey((Object)currentEntity.className(), (Object)"className");
            if (theParentEntity != null) {
                d.setObjectForKey((Object)theParentEntity.name(), (Object)"parent");
            }
            entities.addObject((Object)d);
        }
        result.setObjectForKey((Object)entities, (Object)"entities");
        result.setObjectForKey((Object)CURRENT_EOMODEL_VERSION, (Object)"EOModelVersion");
    }

    EOModel(NSDictionary propertyList, Object owner) {
        this._initWithPropertyListOwner(propertyList, owner);
    }

    void _initializeInfo(NSDictionary propertyList) {
        this._userInfo = (NSDictionary)propertyList.objectForKey((Object)"userInfo");
        if (this._userInfo != null) {
            this._userInfo = (NSDictionary)this._userInfo.clone();
        } else {
            this._userInfo = (NSDictionary)propertyList.objectForKey((Object)"userDictionary");
            if (this._userInfo != null) {
                this._userInfo = (NSDictionary)this._userInfo.clone();
            }
        }
        this._internalInfo = (NSDictionary)propertyList.objectForKey((Object)"internalInfo");
        if (this._internalInfo != null) {
            this._internalInfo = (NSDictionary)this._internalInfo.clone();
        }
    }

    public void _initWithPropertyListOwner(NSDictionary propertyList, Object owner) {
        this.init();
        this._connectionDictionary = (NSDictionary)((NSDictionary)propertyList.objectForKey((Object)"connectionDictionary")).clone();
        this._adaptorName = (String)propertyList.objectForKey((Object)"adaptorName");
        this._initializeInfo(propertyList);
        NSArray array = (NSArray)propertyList.objectForKey((Object)"entities");
        if (array != null) {
            int c = array.count();
            for (int i = 0; i < c; ++i) {
                NSMutableDictionary d = new NSMutableDictionary((NSDictionary)array.objectAtIndex(i));
                d.setObjectForKey((Object)"Y", (Object)"__fullPlist");
                this._addFakeEntityWithPropertyList((NSDictionary)d);
            }
        }
        this._setInheritanceLinks((NSDictionary)propertyList.objectForKey((Object)"inheritance"));
    }

    void awakeWithPropertyList(NSDictionary propertyList) {
    }

    void encodeIntoPropertyList(NSMutableDictionary result) {
        if (this._userInfo != null) {
            result.setObjectForKey((Object)this._userInfo, (Object)"userInfo");
        }
        if (this._internalInfo != null) {
            result.setObjectForKey((Object)this._internalInfo, (Object)"internalInfo");
        }
        if (this._connectionDictionary != null) {
            result.setObjectForKey((Object)this._connectionDictionary, (Object)"connectionDictionary");
        }
        if (this._adaptorName != null) {
            result.setObjectForKey((Object)this._adaptorName, (Object)"adaptorName");
        }
        NSArray entities = this.entities();
        int entitiesCount = entities.count();
        NSMutableArray entityPlists = new NSMutableArray(entitiesCount);
        for (int i = 0; i < entitiesCount; ++i) {
            EOEntity current = (EOEntity)entities.objectAtIndex(i);
            NSMutableDictionary d = new NSMutableDictionary(8);
            current.encodeIntoPropertyList(d);
            entityPlists.addObject((Object)d);
        }
        result.setObjectForKey((Object)entityPlists, (Object)"entities");
        result.setObjectForKey((Object)CURRENT_EOMODEL_VERSION, (Object)"EOModelVersion");
    }

    public void _setEntityForEntityNameClassName(Object entity, String entityName, String className) {
        Class aClass = null;
        if (className != null && (aClass = _NSUtilities.classWithName((String)className)) == null) {
            Class clazz = aClass = EOGenericRecord.class;
        }
        if (aClass != null && aClass != EOGenericRecord.class) {
            this._entitiesByClass.setObjectForKey((Object)entityName, (Object)aClass);
        }
        this._entitiesByName.setObjectForKey(entity, (Object)entityName);
    }

    public EOEntity _addEntity(EOEntity anEntity) {
        this._setEntityForEntityNameClassName(anEntity, anEntity.name(), anEntity.className());
        anEntity._setModel(this);
        if (this._entities != null) {
            this._entities = null;
        }
        return anEntity;
    }

    public void _addFakeEntityWithPropertyList(NSDictionary propertyList) {
        String parent;
        this._setEntityForEntityNameClassName(propertyList, (String)propertyList.objectForKey((Object)"name"), (String)propertyList.objectForKey((Object)"className"));
        if (this._entities != null) {
            this._entities = null;
        }
        if ((parent = (String)propertyList.objectForKey((Object)"parent")) != null) {
            this._registerChildForParent((String)propertyList.objectForKey((Object)"name"), parent);
        }
    }

    public Object _addEntityWithPropertyList(Object propertyList) throws InstantiationException, IllegalAccessException {
        String name;
        EOEntity entity;
        String entityClassName = (String)((NSDictionary)propertyList).objectForKey((Object)"entityClass");
        EOEntity current = null;
        if (entityClassName != null) {
            Class entityClass = null;
            entityClass = _NSUtilities.classWithName((String)entityClassName);
            if (entityClass == null) {
                throw new IllegalArgumentException(entityClassName + ": Unknown class.(_addEntityWithPropertyList)");
            }
            entity = (EOEntity)entityClass.newInstance();
        } else {
            entity = new EOEntity();
        }
        entity = entity._initWithPropertyListOwner((NSDictionary)propertyList, this);
        this._addEntity(entity);
        NSArray subEntities = this._childrenForEntityNamed(entity.name());
        int c = subEntities != null ? subEntities.count() : 0;
        for (int i = 0; i < c; ++i) {
            name = (String)subEntities.objectAtIndex(i);
            current = this._group != null ? this._group.entityNamed(name) : this.entityNamed(name);
            if (current == null) {
                throw new IllegalArgumentException("Unable to locate subentity named " + name);
            }
            entity.addSubEntity(current);
        }
        name = (String)((NSDictionary)propertyList).objectForKey((Object)"parent");
        if (name != null) {
            if (this._group != null) {
                this._group.entityNamed(name);
            } else {
                this.entityNamed(name);
            }
        }
        NSNotificationCenter.defaultCenter().postNotification(EntityLoadedNotification, (Object)entity);
        return entity;
    }

    public void _removeEntity(Object entity) {
        Class aClass;
        String name;
        String className;
        if (entity instanceof EOEntity) {
            EOEntity eoEntity = (EOEntity)entity;
            className = eoEntity.className();
            name = eoEntity.name();
        } else {
            NSDictionary dictEntity = (NSDictionary)entity;
            className = (String)dictEntity.objectForKey((Object)"className");
            name = (String)dictEntity.objectForKey((Object)"name");
            entity = null;
        }
        this._entitiesByName.removeObjectForKey((Object)name);
        if (className != null && (aClass = _NSUtilities.classWithName((String)className)) != null) {
            this._entitiesByClass.removeObjectForKey((Object)aClass);
        }
        if (this._entities != null) {
            this._entities = null;
        }
        if (entity != null) {
            ((EOEntity)entity)._setModel(null);
        }
        EOClassDescription.invalidateClassDescriptionCache();
    }

    public void _setInheritanceLinks(NSDictionary pl) {
        Enumeration en = pl.keyEnumerator();
        while (en.hasMoreElements()) {
            String entity = (String)en.nextElement();
            EOEntity ent = this.entityNamed(entity);
            NSArray ch = (NSArray)pl.objectForKey((Object)entity);
            int c = ch.count();
            for (int i = 0; i < c; ++i) {
                ent.addSubEntity(this.entityNamed((String)ch.objectAtIndex(i)));
            }
        }
    }

    public void _registerChildForParent(String child, String parent) {
        NSMutableArray current;
        if (this._group != null) {
            this._group._registerChildForParent(child, parent);
            return;
        }
        if (this._subEntitiesCache == null) {
            this._subEntitiesCache = new NSMutableDictionary();
        }
        if ((current = (NSMutableArray)this._subEntitiesCache.objectForKey((Object)parent)) == null) {
            this._subEntitiesCache.setObjectForKey((Object)new NSMutableArray((Object)child), (Object)parent);
        } else {
            current.addObject((Object)child);
        }
    }

    public NSArray _childrenForEntityNamed(String entity) {
        if (this._group != null) {
            return this._group._childrenForEntityNamed(entity);
        }
        return this._subEntitiesCache != null ? (NSArray)this._subEntitiesCache.objectForKey((Object)entity) : null;
    }

    protected EOEntity _entityForClass(Class aClass) {
        String entityName = null;
        while (aClass != null && entityName == null) {
            entityName = (String)this._entitiesByClass.objectForKey((Object)aClass);
            aClass = aClass.getSuperclass();
        }
        if (entityName == null) {
            return null;
        }
        return this.entityNamed(entityName);
    }

    protected void _setPathURL(URL url) {
        if (this._url == null || !this._url.equals(url)) {
            String path = url.getPath();
            String extension = NSPathUtilities.pathExtension((String)path);
            if (extension != null && !extension.equals("eomodel") && !extension.equals(ModelExtension)) {
                path = NSPathUtilities.stringByAppendingPathExtension((String)path, (String)ModelExtension);
            }
            if ("file".equals(url.getProtocol()) && !NSPathUtilities.pathIsAbsolute((String)path)) {
                path = NSPathUtilities.stringByAppendingPathComponent((String)NSPathUtilities._currentDirectoryPath(), (String)path);
            }
            try {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
            String name = NSPathUtilities.stringByDeletingPathExtension((String)NSPathUtilities.lastPathComponent((String)path));
            this.loadAllModelObjects();
            this._url = url;
            this.setName(name);
        }
    }

    static String _canonicalPath(String path) {
        String normalized = NSPathUtilities.stringByNormalizingExistingPath((String)path);
        if (normalized.length() > 0) {
            return normalized;
        }
        return NSPathUtilities.stringByStandardizingPath((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray _instantiatedEntities() {
        NSMutableArray result = new NSMutableArray(this._entitiesByName.count());
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            Enumeration e = this._entitiesByName.objectEnumerator();
            while (e.hasMoreElements()) {
                Object item = e.nextElement();
                if (!(item instanceof EOEntity)) continue;
                result.addObject(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _classDescriptionNeededForEntityName(NSNotification notification) {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            EOEntity entity = this.entityNamed((String)notification.object());
            if (entity != null) {
                Class aClass = _NSUtilities.classWithName((String)entity.className());
                if (aClass == EOGenericRecord.class) {
                    aClass = null;
                }
                EOClassDescription.registerClassDescription((EOClassDescription)entity._classDescriptionForInstances(), (Class)aClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _classDescriptionNeededForClass(NSNotification notification) {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            EOClassDescription exisingClassDesc;
            Class targetClass = (Class)notification.object();
            EOEntity entity = this._entityForClass(targetClass);
            if (entity != null && ((exisingClassDesc = EOClassDescription.classDescriptionForClass((Class)targetClass)) == null || exisingClassDesc instanceof EOEntityClassDescription && entity.isSubEntityOf(((EOEntityClassDescription)exisingClassDesc).entity()))) {
                EOClassDescription.registerClassDescription((EOClassDescription)entity._classDescriptionForInstances(), (Class)targetClass);
            }
        }
    }

    public static boolean _isPrototypesEntity(EOEntity entity) {
        String entityName = entity.name();
        return entityName != null && entityName.startsWith(prototypesKeyPrefix) && entityName.indexOf(prototypesKeySuffix) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _resetPrototypeCache() {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            this._prototypesByName = null;
        }
    }

    public void setName(String newName) {
        if (newName == null && this._name == null || newName.equals(this._name)) {
            return;
        }
        EOModelGroup group = this.modelGroup();
        if (group != null) {
            group.removeModel(this);
        }
        this._name = newName;
        if (group != null) {
            group.addModel(this);
        }
    }

    public void setAdaptorName(String adaptorName) {
        this._adaptorName = adaptorName;
        this._prototypesByName = null;
    }

    public void setConnectionDictionary(NSDictionary connectionDictionary) {
        this._connectionDictionary = connectionDictionary != null ? connectionDictionary.immutableClone() : null;
    }

    public void setUserInfo(NSDictionary dictionary) {
        this._userInfo = dictionary != null ? dictionary.immutableClone() : null;
    }

    public void _setEntitiesWithSharedObjects(NSArray entities) {
        this._sharedObjectEntities = entities != null ? entities.immutableClone() : null;
    }

    public void _setInternalInfo(NSDictionary dictionary) {
        this._internalInfo = dictionary != null ? dictionary.immutableClone() : null;
    }

    public void addEntity(EOEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("addEntity: entity is null !");
        }
        EOModel model = entity.model();
        if (model != null && model != this) {
            throw new IllegalArgumentException("addEntity: entity has a different model");
        }
        if (this._entitiesByName.objectForKey((Object)entity.name()) != null) {
            throw new IllegalArgumentException("addEntity: Cannot register two entities with the same name");
        }
        this._addEntity(entity);
    }

    protected void _removePropertiesReferencingEntity(EOEntity entity) {
        for (int i = 0; i < 2; ++i) {
            NSArray props = i == 0 ? entity.attributes() : entity.relationships();
            NSMutableArray propNames = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)props, (NSSelector)_NSArrayUtilities._nameSelector);
            int jcount = propNames.count();
            for (int j = 0; j < jcount; ++j) {
                EOProperty propertyOfDisappearingEntity = i == 0 ? entity.attributeNamed((String)propNames.objectAtIndex(j)) : entity.relationshipNamed((String)propNames.objectAtIndex(j));
                NSArray nrefs = propertyOfDisappearingEntity != null ? this.referencesToProperty(propertyOfDisappearingEntity) : null;
                int kcount = nrefs.count();
                for (int k = 0; k < kcount; ++k) {
                    Object referencingProp = nrefs.objectAtIndex(k);
                    if (referencingProp instanceof EOAttribute) {
                        ((EOAttribute)referencingProp).entity().removeAttribute((EOAttribute)referencingProp);
                        continue;
                    }
                    ((EORelationship)referencingProp).entity().removeRelationship((EORelationship)referencingProp);
                }
            }
        }
    }

    public void removeEntity(EOEntity entity) {
        this._removeEntity(entity);
    }

    public void removeEntityAndReferences(EOEntity entity) {
        this._removePropertiesReferencingEntity(entity);
        NSArray children = new NSArray(entity.subEntities());
        int c = children.count();
        for (int i = 0; i < c; ++i) {
            entity.removeSubEntity((EOEntity)children.objectAtIndex(i));
        }
        this.removeEntity(entity);
    }

    public void addStoredProcedure(EOStoredProcedure storedProcedure) {
        if (storedProcedure == null) {
            throw new IllegalArgumentException("addStoredProcedure storedProcedure is null !");
        }
        if (storedProcedure.name() == null || storedProcedure.name().length() == 0) {
            throw new IllegalArgumentException("addStoredProcedure storedProcedure doesn't have a valid name: " + storedProcedure.name());
        }
        EOModel model = storedProcedure.model();
        if (model != null && model != this) {
            throw new IllegalArgumentException("addStoredProcedure storedProcedure has a different model");
        }
        if (this._storedProcedures != null && this.storedProcedureNames().indexOfObject((Object)storedProcedure.name()) != -1) {
            throw new IllegalArgumentException("addStoredProcedure Cannot register two stored procedures with the name \"" + storedProcedure.name() + "\"");
        }
        if (this._storedProcedures == null) {
            this._storedProcedures = new NSMutableArray();
        }
        this._storedProcedures.addObject((Object)storedProcedure);
        storedProcedure._setModel(this);
    }

    public void removeStoredProcedure(EOStoredProcedure storedProcedure) {
        String[] spKeys = new String[]{"EOFetchAllProcedure", "EOFetchWithPrimaryKeyProcedure", "EOInsertProcedure", "EODeleteProcedure", "EONextPrimaryKeyProcedure"};
        int count = this.entities().count();
        for (int i = 0; i < count; ++i) {
            EOEntity entity = (EOEntity)this.entities().objectAtIndex(i);
            for (int j = 0; j < spKeys.length; ++j) {
                String keyIndex = spKeys[j];
                if (entity.storedProcedureForOperation(keyIndex) != storedProcedure) continue;
                entity.setStoredProcedure(null, keyIndex);
            }
        }
        this._storedProcedures.removeIdenticalObject((Object)storedProcedure);
        storedProcedure._setModel(null);
    }

    public void setModelGroup(EOModelGroup group) {
        this._group = group;
        this._group._addSubEntitiesCache((NSDictionary)this._subEntitiesCache);
        this._subEntitiesCache = null;
    }

    public void loadAllModelObjects() {
        this.storedProcedures();
        NSArray entities = this.entities();
        int c = entities.count();
        for (int i = 0; i < c; ++i) {
            EOEntity entity = (EOEntity)entities.objectAtIndex(i);
            entity._loadEntity();
        }
    }

    public NSArray referencesToProperty(Object property) {
        NSArray entities = this.entities();
        NSMutableArray array = new NSMutableArray();
        int c = entities.count();
        for (int i = 0; i < c; ++i) {
            NSArray recursiveArray;
            int j;
            EOEntity entity = (EOEntity)entities.objectAtIndex(i);
            NSArray props = entity.attributes();
            int d = props.count();
            for (j = 0; j < d; ++j) {
                EOAttribute attribute = (EOAttribute)props.objectAtIndex(j);
                if (!attribute.referencesProperty(property)) continue;
                array.addObject((Object)attribute);
                recursiveArray = this.referencesToProperty(attribute);
                if (recursiveArray.count() == 0) continue;
                array.addObjectsFromArray(recursiveArray);
            }
            props = entity.relationships();
            for (j = 0; j < props.count(); ++j) {
                EORelationship relationship = (EORelationship)props.objectAtIndex(j);
                if (!relationship.referencesProperty(property)) continue;
                array.addObject((Object)relationship);
                recursiveArray = this.referencesToProperty(relationship);
                if (recursiveArray.count() == 0) continue;
                array.addObjectsFromArray(recursiveArray);
            }
        }
        if (array.count() == 0) {
            return null;
        }
        return array;
    }

    public NSArray externalModelsReferenced() {
        return this._externalModelsReferencedByEntities(this.entities());
    }

    public void beautifyNames() {
        NSArray entities = this.entities();
        int i = entities.count();
        while (i-- != 0) {
            ((EOEntity)entities.objectAtIndex(i)).beautifyName();
        }
        NSArray storedProcedures = this.storedProcedures();
        i = storedProcedures.count();
        while (i-- != 0) {
            ((EOStoredProcedure)storedProcedures.objectAtIndex(i)).beautifyName();
        }
    }

    protected NSArray _externalModelsReferencedByEntities(NSArray entities) {
        NSMutableArray result = new NSMutableArray();
        int i = entities.count();
        while (i-- != 0) {
            int ir;
            NSArray referencedByEntity = ((EOEntity)entities.objectAtIndex(i)).externalModelsReferenced();
            int n = ir = referencedByEntity != null ? referencedByEntity.count() : 0;
            while (ir-- != 0) {
                EOModel model = (EOModel)referencedByEntity.objectAtIndex(ir);
                if (result.indexOfIdenticalObject((Object)model) != -1) continue;
                result.addObject((Object)model);
            }
        }
        return result;
    }

    NSArray externalModelsCurrentlyReferenced() {
        return this._externalModelsReferencedByEntities(this._instantiatedEntities());
    }

    void unbindFromExternalReferences() {
        NSDictionary copyOfEntitiesByName = new NSDictionary((NSDictionary)this._entitiesByName);
        Enumeration e = copyOfEntitiesByName.objectEnumerator();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (!(item instanceof EOEntity)) continue;
            EOEntity entity = (EOEntity)item;
            NSMutableDictionary entityPlist = new NSMutableDictionary();
            entity.encodeIntoPropertyList(entityPlist);
            entityPlist.setObjectForKey((Object)"Y", (Object)"__fullPlist");
            this._removeEntity(entity);
            this._addFakeEntityWithPropertyList((NSDictionary)entityPlist);
        }
    }

    static {
        Class aClass = _EOPrivate.class;
        _classDescriptionNeededForClassSelector = new NSSelector("_classDescriptionNeededForClass", _NSUtilities._NotificationClassArray);
        _classDescriptionNeededForEntityNameSelector = new NSSelector("_classDescriptionNeededForEntityName", _NSUtilities._NotificationClassArray);
        _storedProcedureNamedSelector = new NSSelector("storedProcedureNamed", _NSUtilities._StringClassArray);
        _classDescriptionNeededSelector = new NSSelector("_classDescriptionNeeded", _NSUtilities._NotificationClassArray);
        _EOGlobalModelLock = new NSRecursiveLock();
        try {
            aClass = _EOPrivate.class;
            _DefaultModelCreator._registerDefaultModelCreator();
        }
        catch (Throwable throwable) {
            NSLog.err.appendln((Object)"Exception occurred in initializer");
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.debug.appendln(throwable);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)throwable);
        }
    }

    public static class _DefaultModelCreator {
        private static _DefaultModelCreator _defaultModelCreator = null;

        static void _registerDefaultModelCreator() {
            _defaultModelCreator = new _DefaultModelCreator();
            NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
            notificationCenter.addObserver((Object)_defaultModelCreator, _classDescriptionNeededSelector, "EOClassDescriptionNeededNotification", null);
            notificationCenter.addObserver((Object)_defaultModelCreator, _classDescriptionNeededSelector, "EOClassDescriptionNeededForEntityNameNotification", null);
        }

        static void _unregisterDefaultModelCreator() {
            if (_defaultModelCreator != null) {
                NSNotificationCenter.defaultCenter().removeObserver((Object)_defaultModelCreator);
                _defaultModelCreator = null;
            }
        }

        _DefaultModelCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void _classDescriptionNeeded(NSNotification notification) {
            NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
            synchronized (nSRecursiveLock) {
                _DefaultModelCreator._unregisterDefaultModelCreator();
            }
            EOModelGroup.defaultGroup();
            NSNotificationCenter.defaultCenter().postNotification(notification);
        }
    }
}

