/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess._EOStringUtil;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;

public interface EOQualifierSQLGeneration {
    public String sqlStringForSQLExpression(EOSQLExpression var1);

    public EOQualifier schemaBasedQualifierWithRootEntity(EOEntity var1);

    public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOEntity var1, String var2);

    public static class _NotQualifierSupport
    extends Support {
        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            EONotQualifier notQualifier = (EONotQualifier)qualifier;
            EOQualifier embeddedQualifier = notQualifier.qualifier();
            EOQualifier schemaBasedQualifier = Support._schemaBasedQualifierWithRootEntity(embeddedQualifier, entity);
            return schemaBasedQualifier != embeddedQualifier ? new EONotQualifier(schemaBasedQualifier) : notQualifier;
        }

        public String sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            return sqlExpression.sqlStringForNegatedQualifier(((EONotQualifier)qualifier).qualifier());
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            return new EONotQualifier(Support._qualifierMigratedFromEntityRelationshipPath(((EONotQualifier)qualifier).qualifier(), entity, relationshipPath));
        }
    }

    public static class _OrQualifierSupport
    extends Support {
        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            boolean createNewQualifier = false;
            EOOrQualifier orQualifier = (EOOrQualifier)qualifier;
            NSArray embeddedQualifiers = orQualifier.qualifiers();
            int count = embeddedQualifiers.count();
            NSMutableArray schemaBasedQualifiers = new NSMutableArray(count);
            for (int i = count - 1; i >= 0; --i) {
                EOQualifier embeddedQualifier = (EOQualifier)embeddedQualifiers.objectAtIndex(i);
                EOQualifier schemaBasedQualifier = Support._schemaBasedQualifierWithRootEntity(embeddedQualifier, entity);
                if (schemaBasedQualifier != embeddedQualifier) {
                    createNewQualifier = true;
                }
                schemaBasedQualifiers.addObject((Object)schemaBasedQualifier);
            }
            return createNewQualifier ? new EOOrQualifier((NSArray)schemaBasedQualifiers) : orQualifier;
        }

        public String sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            return sqlExpression.sqlStringForDisjoinedQualifiers(((EOOrQualifier)qualifier).qualifiers());
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            NSArray qualifiers = ((EOOrQualifier)qualifier).qualifiers();
            int qualifiersCount = qualifiers.count();
            NSMutableArray newQualifiers = new NSMutableArray(qualifiersCount);
            for (int i = qualifiersCount - 1; i >= 0; --i) {
                newQualifiers.addObject((Object)Support._qualifierMigratedFromEntityRelationshipPath((EOQualifier)qualifiers.objectAtIndex(i), entity, relationshipPath));
            }
            return new EOOrQualifier((NSArray)newQualifiers);
        }
    }

    public static class _AndQualifierSupport
    extends Support {
        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            boolean createNewQualifier = false;
            EOAndQualifier andQualifier = (EOAndQualifier)qualifier;
            NSArray embeddedQualifiers = andQualifier.qualifiers();
            int count = embeddedQualifiers.count();
            NSMutableArray schemaBasedQualifiers = new NSMutableArray(count);
            for (int i = count - 1; i >= 0; --i) {
                EOQualifier embeddedQualifier = (EOQualifier)embeddedQualifiers.objectAtIndex(i);
                EOQualifier schemaBasedQualifier = Support._schemaBasedQualifierWithRootEntity(embeddedQualifier, entity);
                if (schemaBasedQualifier != embeddedQualifier) {
                    createNewQualifier = true;
                }
                schemaBasedQualifiers.addObject((Object)schemaBasedQualifier);
            }
            return createNewQualifier ? new EOAndQualifier((NSArray)schemaBasedQualifiers) : andQualifier;
        }

        public String sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            return sqlExpression.sqlStringForConjoinedQualifiers(((EOAndQualifier)qualifier).qualifiers());
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            NSArray qualifiers = ((EOAndQualifier)qualifier).qualifiers();
            int qualifiersCount = qualifiers.count();
            NSMutableArray newQualifiers = new NSMutableArray(qualifiersCount);
            for (int i = qualifiersCount - 1; i >= 0; --i) {
                newQualifiers.addObject((Object)Support._qualifierMigratedFromEntityRelationshipPath((EOQualifier)qualifiers.objectAtIndex(i), entity, relationshipPath));
            }
            return new EOAndQualifier((NSArray)newQualifiers);
        }
    }

    public static class _KeyComparisonQualifierSupport
    extends Support {
        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            EOKeyComparisonQualifier keyComparisonQualifier = (EOKeyComparisonQualifier)qualifier;
            String leftRelationshipPath = _KeyComparisonQualifierSupport._flattenRelationshipPath(keyComparisonQualifier.leftKey(), entity);
            EORelationship leftRelationship = entity.relationshipForPath(leftRelationshipPath);
            if (leftRelationship == null) {
                return keyComparisonQualifier;
            }
            String rightRelationshipPath = _KeyComparisonQualifierSupport._flattenRelationshipPath(keyComparisonQualifier.rightKey(), entity);
            NSMutableArray qualifiers = null;
            EOAndQualifier schemaBasedQualifier = null;
            NSArray leftJoins = leftRelationship.joins();
            int count = leftJoins.count();
            for (int i = 0; i < count; ++i) {
                String name = ((EOJoin)leftJoins.objectAtIndex(i)).destinationAttribute().name();
                String rightKey = _KeyComparisonQualifierSupport._optimizeQualifierKeyPath(entity, rightRelationshipPath, name);
                String leftKey = _KeyComparisonQualifierSupport._optimizeQualifierKeyPath(entity, rightRelationshipPath, name);
                schemaBasedQualifier = new EOKeyComparisonQualifier(leftKey, keyComparisonQualifier.selector(), rightKey);
                if (count <= 1) continue;
                if (qualifiers == null) {
                    qualifiers = new NSMutableArray();
                }
                qualifiers.addObject((Object)schemaBasedQualifier);
            }
            return qualifiers != null ? new EOAndQualifier(qualifiers) : schemaBasedQualifier;
        }

        public String sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            return sqlExpression.sqlStringForKeyComparisonQualifier((EOKeyComparisonQualifier)qualifier);
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            EOKeyComparisonQualifier keyComparisonQualifier = (EOKeyComparisonQualifier)qualifier;
            String newLeftKey = Support._translateKeyAcrossRelationshipPath(keyComparisonQualifier.leftKey(), relationshipPath, entity);
            String newRightKey = Support._translateKeyAcrossRelationshipPath(keyComparisonQualifier.rightKey(), relationshipPath, entity);
            return new EOKeyComparisonQualifier(newLeftKey, keyComparisonQualifier.selector(), newRightKey);
        }
    }

    public static class _KeyValueQualifierSupport
    extends Support {
        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            NSMutableDictionary values;
            int i;
            EOKeyValueQualifier keyValueQualifier = (EOKeyValueQualifier)qualifier;
            String relationshipPath = keyValueQualifier.key();
            EORelationship relationship = entity.relationshipForPath(relationshipPath);
            if (relationship == null) {
                return keyValueQualifier;
            }
            if (relationship.isFlattened()) {
                relationship = relationship.lastRelationship();
            }
            NSArray joins = relationship.joins();
            int count = joins.count();
            NSMutableArray names = new NSMutableArray(count);
            for (i = count - 1; i >= 0; --i) {
                names.addObject((Object)((EOJoin)joins.objectAtIndex(i)).destinationAttribute().name());
            }
            Object _value = keyValueQualifier.value();
            if (_value == NSKeyValueCoding.NullValue || _value instanceof EOQualifierVariable) {
                NSMutableDictionary junkValues = new NSMutableDictionary(count);
                for (i = 0; i < count; ++i) {
                    junkValues.setObjectForKey(_value, names.objectAtIndex(i));
                }
                values = junkValues;
            } else {
                EOEnterpriseObject object = (EOEnterpriseObject)_value;
                values = ((EOObjectStoreCoordinator)object.editingContext().rootObjectStore()).valuesForKeys((NSArray)names, object);
            }
            NSSelector selector = keyValueQualifier.selector();
            NSMutableArray qualifiers = null;
            EOAndQualifier schemaBasedQualifier = null;
            count = names.count();
            for (i = 0; i < count; ++i) {
                String keyName = (String)names.objectAtIndex(i);
                String key = _KeyValueQualifierSupport._optimizeQualifierKeyPath(entity, relationshipPath, keyName);
                schemaBasedQualifier = new EOKeyValueQualifier(key, selector, values.objectForKey((Object)keyName));
                if (count <= 1) continue;
                if (qualifiers == null) {
                    qualifiers = new NSMutableArray();
                }
                qualifiers.addObject((Object)schemaBasedQualifier);
            }
            return qualifiers != null ? new EOAndQualifier(qualifiers) : schemaBasedQualifier;
        }

        public String sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            return sqlExpression.sqlStringForKeyValueQualifier((EOKeyValueQualifier)qualifier);
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            EOKeyValueQualifier keyValueQualifier = (EOKeyValueQualifier)qualifier;
            return new EOKeyValueQualifier(Support._translateKeyAcrossRelationshipPath(keyValueQualifier.key(), relationshipPath, entity), keyValueQualifier.selector(), keyValueQualifier.value());
        }
    }

    public static abstract class Support {
        private static NSMutableDictionary _supportByClass = new NSMutableDictionary(8);
        private static final NSSelector _relationshipPathSelector;
        private static final NSSelector _nameSelector;

        public static Support supportForClass(Class aClass) {
            Support result = null;
            Class currentClass = aClass;
            while (result == null && currentClass != null) {
                result = (Support)_supportByClass.objectForKey((Object)currentClass);
                if (result == null) {
                    currentClass = currentClass.getSuperclass();
                    continue;
                }
                if (currentClass == aClass) continue;
                _supportByClass.setObjectForKey((Object)result, aClass);
            }
            return result;
        }

        public static void setSupportForClass(Support support, Class aClass) {
            _supportByClass.setObjectForKey((Object)support, (Object)aClass);
        }

        public abstract String sqlStringForSQLExpression(EOQualifier var1, EOSQLExpression var2);

        public abstract EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier var1, EOEntity var2);

        public abstract EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier var1, EOEntity var2, String var3);

        public static String _sqlStringForSQLExpression(EOQualifier qualifier, EOSQLExpression sqlExpression) {
            if (qualifier == null) {
                throw new IllegalArgumentException("Qualifier needs to be specified");
            }
            if (qualifier instanceof EOQualifierSQLGeneration) {
                return ((EOQualifierSQLGeneration)qualifier).sqlStringForSQLExpression(sqlExpression);
            }
            Support support = Support.supportForClass(qualifier.getClass());
            if (support == null) {
                throw new IllegalArgumentException("Qualifier " + qualifier + " (class " + qualifier.getClass().getName() + " (does not implement EOQualifierSQLGeneration");
            }
            return support.sqlStringForSQLExpression(qualifier, sqlExpression);
        }

        public static EOQualifier _schemaBasedQualifierWithRootEntity(EOQualifier qualifier, EOEntity entity) {
            if (qualifier == null) {
                return null;
            }
            if (qualifier instanceof EOQualifierSQLGeneration) {
                return ((EOQualifierSQLGeneration)qualifier).schemaBasedQualifierWithRootEntity(entity);
            }
            Support support = Support.supportForClass(qualifier.getClass());
            if (support == null) {
                throw new IllegalArgumentException("Qualifier " + qualifier + " (class " + qualifier.getClass().getName() + " (does not implement EOQualifierSQLGeneration");
            }
            return support.schemaBasedQualifierWithRootEntity(qualifier, entity);
        }

        public static EOQualifier _qualifierMigratedFromEntityRelationshipPath(EOQualifier qualifier, EOEntity entity, String relationshipPath) {
            if (qualifier == null) {
                throw new IllegalArgumentException("Qualifier needs to be specified");
            }
            if (qualifier instanceof EOQualifierSQLGeneration) {
                return ((EOQualifierSQLGeneration)qualifier).qualifierMigratedFromEntityRelationshipPath(entity, relationshipPath);
            }
            Support support = Support.supportForClass(qualifier.getClass());
            if (support == null) {
                throw new IllegalArgumentException("Qualifier " + qualifier + " (class " + qualifier.getClass().getName() + " (does not implement EOQualifierSQLGeneration");
            }
            return support.qualifierMigratedFromEntityRelationshipPath(qualifier, entity, relationshipPath);
        }

        public static String _flattenRelationshipPath(String relationshipPath, EOEntity entity) {
            String newRelationshipPath = null;
            if (relationshipPath.indexOf(46) >= 0) {
                NSArray comps = NSArray.componentsSeparatedByString((String)relationshipPath, (String)".");
                int count = comps.count();
                for (int i = 0; i < count; ++i) {
                    EORelationship rel = entity.anyRelationshipNamed((String)comps.objectAtIndex(i));
                    if (rel == null) {
                        if (i == count - 1) {
                            return _NSStringUtilities.dotifyPath(newRelationshipPath, (String)((String)comps.objectAtIndex(i)));
                        }
                        throw new IllegalArgumentException("No relationship '" + comps.objectAtIndex(i) + "' was found in entity '" + entity.name() + "' while evaluating relationship path '" + relationshipPath);
                    }
                    NSSelector sel = rel.isFlattened() ? _relationshipPathSelector : _nameSelector;
                    newRelationshipPath = newRelationshipPath != null ? _NSStringUtilities.dotifyPath((String)newRelationshipPath, (String)((String)NSSelector._safeInvokeSelector((NSSelector)sel, (Object)rel, null))) : (String)NSSelector._safeInvokeSelector((NSSelector)sel, (Object)rel, null);
                    entity = rel.destinationEntity();
                }
            } else {
                EORelationship rel = entity.anyRelationshipNamed(relationshipPath);
                if (rel == null) {
                    return relationshipPath;
                }
                if (rel.isFlattened()) {
                    return rel.relationshipPath();
                }
                return rel.name();
            }
            return newRelationshipPath;
        }

        public static String _optimizeQualifierKeyPath(EOEntity entity, String relationshipPath, String key) {
            EORelationship rel;
            if (relationshipPath == null || relationshipPath.length() == 0) {
                return key;
            }
            EORelationship eORelationship = rel = entity != null ? entity.relationshipForPath(relationshipPath) : null;
            if (rel != null) {
                NSArray joins = rel.joins();
                int count = joins != null ? joins.count() : 0;
                for (int i = count - 1; i >= 0; --i) {
                    EOJoin join = (EOJoin)joins.objectAtIndex(i);
                    if (!join.destinationAttribute().name().equals(key)) continue;
                    String newRelationshipPath = _EOStringUtil.relationshipPathByDeletingLastComponent(relationshipPath);
                    String newKey = join.sourceAttribute().name();
                    return Support._optimizeQualifierKeyPath(entity, newRelationshipPath, newKey);
                }
            }
            return _NSStringUtilities.dotifyPath((String)relationshipPath, (String)key);
        }

        public static EOQualifier _qualifierMigratedToSubEntityFromParentEntity(EOQualifier qualifier, EOEntity subEntity, EOEntity parentEntity) {
            String name;
            String relPath = null;
            if (subEntity == parentEntity) {
                return qualifier;
            }
            for (EOEntity entity = subEntity; entity != parentEntity && (name = entity.parentRelationship().name()) != null; entity = entity.parentEntity()) {
                relPath = relPath != null ? _NSStringUtilities.dotifyPath((String)relPath, (String)name) : name;
            }
            if (relPath == null) {
                return qualifier;
            }
            String invRelPath = subEntity._inverseRelationshipPathForPath(relPath);
            return Support._qualifierMigratedFromEntityRelationshipPath(qualifier, parentEntity, invRelPath);
        }

        public static String _translateKeyAcrossRelationshipPath(String sourceKey, String relPath, EOEntity entity) {
            String relPathPrefix;
            NSMutableArray newComps = null;
            int index = (sourceKey = Support._flattenRelationshipPath(sourceKey, entity)).indexOf(relPathPrefix = (relPath = Support._flattenRelationshipPath(relPath, entity)) + ".");
            if (index == 0) {
                index = (sourceKey = sourceKey.substring(relPathPrefix.length())).indexOf(46);
                if (index < 0) {
                    return sourceKey;
                }
                EOEntity relEntity = entity.relationshipForPath(relPath).destinationEntity();
                relPath = _EOStringUtil.relationshipPathByDeletingLastComponent(sourceKey);
                sourceKey = _EOStringUtil.lastComponentFromRelationshipPath(sourceKey);
                return Support._optimizeQualifierKeyPath(relEntity, relPath, sourceKey);
            }
            NSArray comps = NSArray.componentsSeparatedByString((String)relPath, (String)".");
            int iCount = comps.count();
            for (int i = 0; i < iCount; ++i) {
                EORelationship rel = entity.anyRelationshipNamed((String)comps.objectAtIndex(i));
                if (newComps == null) {
                    newComps = new NSMutableArray();
                }
                try {
                    newComps.insertObjectAtIndex((Object)rel.anyInverseRelationship().name(), 0);
                }
                catch (Exception e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                entity = rel.destinationEntity();
            }
            relPath = newComps.componentsJoinedByString(".");
            newComps = null;
            if (sourceKey.indexOf(46) >= 0) {
                String appendPath = _EOStringUtil.relationshipPathByDeletingLastComponent(sourceKey);
                relPath = _NSStringUtilities.concat((String)relPath, (String)".", (String)appendPath);
                sourceKey = _EOStringUtil.lastComponentFromRelationshipPath(sourceKey);
            }
            return Support._optimizeQualifierKeyPath(entity, relPath, sourceKey);
        }

        static {
            Support.setSupportForClass(new _KeyValueQualifierSupport(), EOKeyValueQualifier._CLASS);
            Support.setSupportForClass(new _KeyComparisonQualifierSupport(), EOKeyComparisonQualifier._CLASS);
            Support.setSupportForClass(new _AndQualifierSupport(), EOAndQualifier._CLASS);
            Support.setSupportForClass(new _OrQualifierSupport(), EOOrQualifier._CLASS);
            Support.setSupportForClass(new _NotQualifierSupport(), EONotQualifier._CLASS);
            _relationshipPathSelector = new NSSelector("relationshipPath", null);
            _nameSelector = new NSSelector("name", null);
        }
    }
}

