/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAccessDeferredFaultHandler;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOAttributeNameComparator;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOProperty;
import com.webobjects.eoaccess.EOPropertyListEncoding;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess._EOExpressionArray;
import com.webobjects.eoaccess._EOStringUtil;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol._EOCheapCopyMutableArray;
import com.webobjects.eocontrol._EOMutableKnownKeyDictionary;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSValidation;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;

public class EORelationship
extends EOProperty
implements EOPropertyListEncoding,
EOSQLExpression.SQLValue {
    protected String _name;
    protected EOEntity _entity;
    protected EOEntity _destination;
    protected EOQualifier _qualifier;
    protected _EOExpressionArray _definitionArray;
    protected NSMutableArray _joins;
    protected NSMutableDictionary _sourceNames;
    protected NSMutableDictionary _destinationNames;
    protected NSDictionary _userInfo;
    protected NSDictionary _internalInfo;
    protected _EOExpressionArray _expressionArray;
    protected NSDictionary _sourceToDestinationKeyMap;
    protected int _batchCount;
    protected int _joinSemantic;
    protected boolean _flags_isToMany;
    protected boolean _flags_useBatchFaulting;
    protected boolean _flags_isMandatory;
    protected boolean _flags_ownsDestination;
    protected boolean _flags_propagatesPrimaryKey;
    protected int _deleteRule;
    protected byte _toManyToOneCache;
    private volatile _EOMutableKnownKeyDictionary.SubsetMapping _sourceRowToForeignKeyMapping;
    private volatile EORelationship _inverseRelationship;
    private volatile EORelationship _hiddenInverseRelationship;
    protected Object _deferredFault;
    public static final int InnerJoin = 0;
    public static final int FullOuterJoin = 1;
    public static final int LeftOuterJoin = 2;
    public static final int RightOuterJoin = 3;
    private static final String DeleteRuleNullifyString = "EODeleteRuleNullify";
    private static final String DeleteRuleCascadeString = "EODeleteRuleCascade";
    private static final String DeleteRuleDenyString = "EODeleteRuleDeny";
    private static final String DeleteRuleNoActionString = "EODeleteRuleNoAction";
    private static final String _InverseRelationshipPrefix = "_eofInv_";
    private static NSMutableDictionary dictionary = null;
    protected static final NSSelector _selSourceAttribute = new NSSelector("sourceAttribute", null);
    protected static final NSSelector _selDesAttribute = new NSSelector("destinationAttribute", null);

    public void _joinsChanged() {
        if (this._joins == null || this._joins != null && this._joins.count() == 0) {
            this._destination = null;
        } else if (this._destination == null) {
            this._destination = ((EOJoin)this._joins.objectAtIndex(0)).destinationAttribute().entity();
        }
    }

    public String name() {
        return this._name;
    }

    public EOEntity entity() {
        return this._entity;
    }

    public EOEntity destinationEntity() {
        if (this.isFlattened()) {
            return ((EORelationship)this._definitionArray.lastObject()).destinationEntity();
        }
        return this._destination;
    }

    public String definition() {
        return this._definitionArray == null ? null : this._definitionArray.valueForSQLExpression(null);
    }

    public NSArray componentRelationships() {
        return this._definitionArray;
    }

    public boolean isFlattened() {
        return this._definitionArray != null;
    }

    public boolean isToMany() {
        if (this.isFlattened()) {
            int count = this._definitionArray.count();
            for (int i = 0; i < count; ++i) {
                if (!((EORelationship)this._definitionArray.objectAtIndex(i)).isToMany()) continue;
                return true;
            }
        }
        return this._flags_isToMany;
    }

    boolean isParentRelationship() {
        NSArray pkAtts;
        EOEntity destEntity = this.destinationEntity();
        if (destEntity == null || destEntity != this._entity.parentEntity()) {
            return false;
        }
        NSArray joinAtts = this.sourceAttributes();
        if (!_NSArrayUtilities.containsIdenticalObjectsInArray((NSArray)joinAtts, (NSArray)(pkAtts = this._entity.primaryKeyAttributes()))) {
            return false;
        }
        joinAtts = this.destinationAttributes();
        return _NSArrayUtilities.containsIdenticalObjectsInArray((NSArray)joinAtts, (NSArray)(pkAtts = this.destinationEntity().primaryKeyAttributes()));
    }

    public boolean isCompound() {
        return this._joins != null && this._joins.count() > 1;
    }

    public boolean _isToOneClassProperty() {
        return this.entity().classPropertyToOneRelationshipNames().containsObject((Object)this.name());
    }

    public boolean _isToManyClassProperty() {
        return this.entity().classPropertyToManyRelationshipNames().containsObject((Object)this.name());
    }

    public NSArray sourceAttributes() {
        int joinCount;
        int n = joinCount = this._joins == null ? 0 : this._joins.count();
        if (joinCount == 0) {
            return NSArray.EmptyArray;
        }
        NSMutableArray sourceAttributes = new NSMutableArray(joinCount);
        for (int i = 0; i < joinCount; ++i) {
            EOJoin join = (EOJoin)this._joins.objectAtIndex(i);
            EOAttribute sourceAttr = join.sourceAttribute();
            if (sourceAttr == null) continue;
            sourceAttributes.addObject((Object)sourceAttr);
        }
        return sourceAttributes;
    }

    public NSArray destinationAttributes() {
        int joinCount;
        int n = joinCount = this._joins == null ? 0 : this._joins.count();
        if (joinCount == 0) {
            return NSArray.EmptyArray;
        }
        NSMutableArray destinationAttributes = new NSMutableArray(joinCount);
        for (int i = 0; i < joinCount; ++i) {
            EOJoin join = (EOJoin)this._joins.objectAtIndex(i);
            EOAttribute destAttr = join.destinationAttribute();
            if (destAttr == null) continue;
            destinationAttributes.addObject((Object)destAttr);
        }
        return destinationAttributes;
    }

    public String valueForSQLExpression(EOSQLExpression context) {
        return this._name;
    }

    public NSDictionary userInfo() {
        return this._userInfo;
    }

    public NSDictionary _internalInfo() {
        return this._internalInfo;
    }

    public boolean referencesProperty(Object property) {
        int joinCount;
        if (this.isFlattened()) {
            return this._definitionArray.referencesObject(property);
        }
        int n = joinCount = this._joins == null ? 0 : this._joins.count();
        if (joinCount == 0) {
            return false;
        }
        for (int i = 0; i < joinCount; ++i) {
            EOJoin join = (EOJoin)this._joins.objectAtIndex(i);
            if (join.sourceAttribute() != property && join.destinationAttribute() != property) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "<" + _NSUtilities.shortClassName((Object)this) + " " + this.name() + " " + System.identityHashCode(this) + ">";
    }

    public NSArray joins() {
        return this._joins != null ? this._joins : NSArray.EmptyArray;
    }

    public int joinSemantic() {
        return this._joinSemantic;
    }

    boolean isReciprocalToRelationship(EORelationship otherRelationship) {
        if (this.entity() != otherRelationship.destinationEntity()) {
            return false;
        }
        if (this.isFlattened()) {
            if (!otherRelationship.isFlattened()) {
                return false;
            }
            NSArray ourComponents = this.componentRelationships();
            NSArray otherComponents = otherRelationship.componentRelationships();
            int count = ourComponents.count();
            if (count != otherComponents.count()) {
                return false;
            }
            int i = count;
            while (i-- != 0) {
                EORelationship otherRelComp;
                EORelationship ourRelComp = (EORelationship)ourComponents.objectAtIndex(i);
                if (ourRelComp.isReciprocalToRelationship(otherRelComp = (EORelationship)otherComponents.objectAtIndex(count - i - 1))) continue;
                return false;
            }
            return true;
        }
        NSArray ourJoins = this.joins();
        NSArray otherJoins = otherRelationship.joins();
        int count = ourJoins.count();
        if (count != otherJoins.count()) {
            return false;
        }
        int i = count;
        while (i-- != 0) {
            EOJoin join = (EOJoin)ourJoins.objectAtIndex(i);
            int j = count;
            boolean found = false;
            while (j-- != 0) {
                EOJoin otherJoin = (EOJoin)otherJoins.objectAtIndex(j);
                if (!join.isReciprocalToJoin(otherJoin)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EORelationship inverseRelationship() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._inverseRelationship == null) {
                EORelationship inverseRel = this._inverseRelationship;
                NSArray destinationRelationships = this.destinationEntity().relationships();
                int i = destinationRelationships.count();
                while (i-- != 0) {
                    EORelationship otherRel = (EORelationship)destinationRelationships.objectAtIndex(i);
                    if (!this.isReciprocalToRelationship(otherRel)) continue;
                    inverseRel = otherRel;
                    break;
                }
                if (inverseRel == null) {
                    inverseRel = this;
                }
                this._inverseRelationship = inverseRel;
            }
        }
        EORelationship ir = this._inverseRelationship;
        return ir == this ? null : ir;
    }

    public EORelationship _makeFlattenedInverseRelationship() {
        EORelationship rel;
        String def = null;
        for (int i = this._definitionArray.count() - 1; i >= 0; --i) {
            rel = ((EORelationship)this._definitionArray.objectAtIndex(i)).anyInverseRelationship();
            def = def == null ? rel.name() : _NSStringUtilities.dotifyPath((String)def, (String)rel.name());
        }
        rel = new EORelationship();
        rel.setEntity(this.destinationEntity());
        rel.setName(_NSStringUtilities.concat((String)_InverseRelationshipPrefix, (String)this._entity.name(), (String)"_", (String)this._name));
        rel.setDefinition(def);
        this.destinationEntity()._hiddenRelationships().addObject((Object)rel);
        rel._inverseRelationship = this;
        return rel;
    }

    public EORelationship _makeInverseRelationship() {
        EOEntity dest = this.destinationEntity();
        EORelationship rel = new EORelationship();
        rel.setEntity(dest);
        rel.setName(_InverseRelationshipPrefix + this._entity.name() + "_" + this._name);
        NSArray joins = this.joins();
        for (int i = joins.count() - 1; i >= 0; --i) {
            EOJoin join = (EOJoin)joins.objectAtIndex(i);
            EOJoin invJoin = new EOJoin(join.destinationAttribute(), join.sourceAttribute());
            rel.addJoin(invJoin);
        }
        dest._hiddenRelationships().addObject((Object)rel);
        rel._inverseRelationship = this;
        return rel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EORelationship hiddenInverseRelationship() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._hiddenInverseRelationship == null) {
                this._hiddenInverseRelationship = this.isFlattened() ? this._makeFlattenedInverseRelationship() : this._makeInverseRelationship();
            }
        }
        return this._hiddenInverseRelationship;
    }

    public EORelationship anyInverseRelationship() {
        EORelationship invRel = this.inverseRelationship();
        if (invRel == null) {
            invRel = this.hiddenInverseRelationship();
        }
        return invRel;
    }

    public int numberOfToManyFaultsToBatchFetch() {
        if (this._flags_useBatchFaulting) {
            return this._batchCount;
        }
        return 0;
    }

    public boolean ownsDestination() {
        return this._flags_ownsDestination;
    }

    public int deleteRule() {
        return this._deleteRule;
    }

    public boolean isMandatory() {
        return this._flags_isMandatory;
    }

    public boolean propagatesPrimaryKey() {
        return this._flags_propagatesPrimaryKey;
    }

    public EORelationship(NSDictionary plist, EOEntity owner) {
        this._entity = owner;
        this._name = (String)plist.objectForKey((Object)"name");
        String string = (String)plist.objectForKey((Object)"destination");
        if (string != null) {
            EOModel destModel = this._entity.model();
            this._destination = destModel.entityNamed(string);
            if (this._destination == null) {
                EOModelGroup modelGroup = destModel.modelGroup();
                EOEntity eOEntity = this._destination = modelGroup != null ? modelGroup.entityNamed(string) : null;
                if (this._destination == null) {
                    _NSDelegate delegate;
                    _NSDelegate _NSDelegate2 = delegate = modelGroup != null ? modelGroup._delegate : null;
                    if (delegate != null && modelGroup._delegateRespondsTo_relationshipFailedToLookupDestinationWithName) {
                        this._destination = (EOEntity)delegate.perform("relationshipFailedToLookupDestinationWithName", new Object[]{this, string});
                    } else {
                        throw new IllegalArgumentException("EORelationship(): cannot find entity named " + string + " for destination of relationship " + this._name + " in entity " + this._entity.name() + ".");
                    }
                }
            }
        }
        this.setToMany((string = (String)plist.objectForKey((Object)"isToMany")) != null && string.equals("Y"));
        string = (String)plist.objectForKey((Object)"isMandatory");
        this.setIsMandatory(string != null && string.equals("Y"));
        string = (String)plist.objectForKey((Object)"ownsDestination");
        this.setOwnsDestination(string != null && string.equals("Y"));
        string = (String)plist.objectForKey((Object)"propagatesPrimaryKey");
        this.setPropagatesPrimaryKey(string != null && string.equals("Y"));
        NSDictionary val = (NSDictionary)plist.objectForKey((Object)"userInfo");
        if (val == null) {
            val = (NSDictionary)plist.objectForKey((Object)"userDictionary");
        }
        this.setUserInfo(val);
        val = (NSDictionary)plist.objectForKey((Object)"internalInfo");
        this._setInternalInfo(val);
        this._batchCount = _NSStringUtilities.integerFromPlist((NSDictionary)plist, (String)"numberOfToManyFaultsToBatchFetch", (int)0);
        if (this._batchCount != 0) {
            this._flags_useBatchFaulting = true;
        }
        if ((string = (String)plist.objectForKey((Object)"deleteRule")) != null) {
            this.setDeleteRule(this._deleteRuleFromString(string));
        }
        if ((string = (String)plist.objectForKey((Object)"qualifier")) != null && string.length() != 0) {
            this.setAuxiliaryQualifier(EOQualifier.qualifierWithQualifierFormat((String)string, null));
        }
        if ((string = (String)plist.objectForKey((Object)"joinSemantic")) != null && string.length() != 0) {
            this.setJoinSemantic(this._joinSemanticForName(string));
        }
    }

    public void encodeIntoPropertyList(NSMutableDictionary result) {
        int count;
        String d;
        String plist;
        if (this._name != null) {
            plist = this._name;
            result.setObjectForKey((Object)plist, (Object)"name");
        }
        if (this.isFlattened()) {
            d = this.definition();
            result.setObjectForKey((Object)d, (Object)"definition");
        } else {
            result.setObjectForKey((Object)(this.isToMany() ? "Y" : "N"), (Object)"isToMany");
            plist = this.destinationEntity() != null && this.destinationEntity().name() != null ? this.destinationEntity().name() : null;
            if (plist != null) {
                result.setObjectForKey((Object)plist, (Object)"destination");
            }
            result.setObjectForKey((Object)(this.isToMany() ? "Y" : "N"), (Object)"isToMany");
        }
        if (this._userInfo != null) {
            result.setObjectForKey((Object)this._userInfo, (Object)"userInfo");
        }
        if (this._internalInfo != null) {
            result.setObjectForKey((Object)this._internalInfo, (Object)"internalInfo");
        }
        if (this._flags_useBatchFaulting) {
            result.setObjectForKey((Object)_NSUtilities.IntegerForInt((int)this._batchCount), (Object)"numberOfToManyFaultsToBatchFetch");
        }
        if (this.isMandatory()) {
            result.setObjectForKey((Object)"Y", (Object)"isMandatory");
        }
        if (this.ownsDestination()) {
            result.setObjectForKey((Object)"Y", (Object)"ownsDestination");
        }
        if (this.propagatesPrimaryKey()) {
            result.setObjectForKey((Object)"Y", (Object)"propagatesPrimaryKey");
        }
        if (this._deleteRule != 0) {
            result.setObjectForKey((Object)this._stringFromDeleteRule(this.deleteRule()), (Object)"deleteRule");
        }
        if (this._qualifier != null) {
            result.setObjectForKey((Object)this._qualifier.toString(), (Object)"qualifier");
        }
        if (this._joins != null && (count = this._joins.count()) > 0) {
            NSMutableArray array = new NSMutableArray(count);
            for (int i = 0; i < count; ++i) {
                d = new NSMutableDictionary();
                EOJoin join = (EOJoin)this._joins.objectAtIndex(i);
                d.setObjectForKey((Object)join.sourceAttribute().name(), (Object)"sourceAttribute");
                d.setObjectForKey((Object)join.destinationAttribute().name(), (Object)"destinationAttribute");
                array.addObject((Object)d);
            }
            result.setObjectForKey((Object)array, (Object)"joins");
        }
        result.setObjectForKey((Object)this._nameForJoinSemantic(this._joinSemantic), (Object)"joinSemantic");
    }

    public void awakeWithPropertyList(NSDictionary plist) {
        String definition = (String)plist.objectForKey((Object)"definition");
        if (definition != null || (definition = (String)plist.objectForKey((Object)"dataPath")) != null) {
            this.setDefinition(definition);
            return;
        }
        NSArray array = (NSArray)plist.objectForKey((Object)"joins");
        if (array != null) {
            int arrayCount = array.count();
            for (int i = 0; i < arrayCount; ++i) {
                NSDictionary encoding = (NSDictionary)array.objectAtIndex(i);
                if (encoding.objectForKey((Object)"joinSemantic") != null) {
                    this._joinSemantic = this._joinSemanticForName((String)encoding.objectForKey((Object)"joinSemantic"));
                }
                String sourceName = (String)encoding.objectForKey((Object)"sourceAttribute");
                String destName = (String)encoding.objectForKey((Object)"destinationAttribute");
                EOAttribute sourceAttr = this._entity.attributeNamed(sourceName);
                EOAttribute destAttr = this.destinationEntity().attributeNamed(destName);
                EOJoin join = new EOJoin(sourceAttr, destAttr);
                this.addJoin(join);
            }
        }
    }

    public EOQualifier qualifierWithSourceRow(NSDictionary sourceRow) {
        EOQualifier qualifier = this.qualifierOmittingAuxiliaryQualifierWithSourceRow(sourceRow);
        EOQualifier relQualifier = this.auxiliaryQualifier();
        if (relQualifier != null) {
            qualifier = new EOAndQualifier(new NSArray(new Object[]{qualifier, relQualifier}));
        }
        return qualifier;
    }

    public NSDictionary _leftSideKeyMap() {
        String path = null;
        if (!this.isToManyToOne()) {
            return null;
        }
        int iCount = this._definitionArray.count();
        for (int i = 0; i < iCount; ++i) {
            EORelationship rel = (EORelationship)this._definitionArray.objectAtIndex(i);
            path = path == null ? rel.name() : _NSStringUtilities.dotifyPath((String)path, (String)rel.name());
            if (rel.isToMany()) break;
        }
        return this.entity()._keyMapForIdenticalKeyRelationshipPath(path);
    }

    public NSDictionary _rightSideKeyMap() {
        EOEntity startEntity = null;
        String path = null;
        int state = 0;
        if (!this.isToManyToOne()) {
            return null;
        }
        int iCount = this._definitionArray.count();
        block4: for (int i = 0; i < iCount; ++i) {
            EORelationship rel = (EORelationship)this._definitionArray.objectAtIndex(i);
            switch (state) {
                case 0: {
                    if (!rel.isToMany()) continue block4;
                    state = 1;
                    startEntity = rel.destinationEntity();
                    continue block4;
                }
                case 1: {
                    path = path == null ? rel.name() : _NSStringUtilities.dotifyPath((String)path, (String)rel.name());
                }
            }
        }
        return startEntity._keyMapForIdenticalKeyRelationshipPath(path);
    }

    protected EORelationship _substitutionRelationshipForRow(NSDictionary row) {
        EOEntity entity = this.entity();
        EOModelGroup modelGroup = entity.model().modelGroup();
        EORelationship rel = this;
        if (modelGroup != null && modelGroup._delegateRespondsTo_relationshipForRow) {
            rel = (EORelationship)modelGroup._delegate.perform("relationshipForRow", (Object)entity, (Object)row, (Object)this);
        }
        return rel;
    }

    public int _deleteRuleFromString(String string) {
        if (string.equals(DeleteRuleNullifyString)) {
            return 0;
        }
        if (string.equals(DeleteRuleCascadeString)) {
            return 1;
        }
        if (string.equals(DeleteRuleDenyString)) {
            return 2;
        }
        if (string.equals(DeleteRuleNoActionString)) {
            return 3;
        }
        throw new IllegalArgumentException("Invalid delete rule string:'" + string + "' on entity with name:'" + this.name() + "'");
    }

    public String _stringFromDeleteRule(int deleteRule) {
        switch (deleteRule) {
            case 0: {
                return DeleteRuleNullifyString;
            }
            case 1: {
                return DeleteRuleCascadeString;
            }
            case 2: {
                return DeleteRuleDenyString;
            }
            case 3: {
                return DeleteRuleNoActionString;
            }
        }
        throw new IllegalArgumentException("Invalid delete rule value:" + deleteRule);
    }

    public _EOExpressionArray _definitionArray() {
        return this._definitionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _flushCache() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            EORelationship rel = this._inverseRelationship;
            this._sourceRowToForeignKeyMapping = null;
            this._inverseRelationship = null;
            if (rel != null) {
                rel._flushCache();
            }
            if (this._hiddenInverseRelationship != null) {
                this.destinationEntity()._hiddenRelationships().removeIdenticalObject((Object)this._hiddenInverseRelationship);
                this._hiddenInverseRelationship = null;
            }
            this._toManyToOneCache = 0;
        }
    }

    private EOJoin joinForAttribute(EOAttribute attribute) {
        int joinCount = this._joins == null ? 0 : this._joins.count();
        for (int i = 0; i < joinCount; ++i) {
            EOJoin j = (EOJoin)this._joins.objectAtIndex(i);
            if (!j.sourceAttribute().equals(attribute) && !j.destinationAttribute().equals(attribute)) continue;
            return j;
        }
        return null;
    }

    public NSArray _sourceAttributeNames() {
        EORelationship sourceRelationship = this.isFlattened() ? (EORelationship)this._definitionArray().objectAtIndex(0) : this;
        NSArray joins = sourceRelationship.joins();
        int count = joins.count();
        NSMutableArray results = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            EOJoin join = (EOJoin)joins.objectAtIndex(i);
            results.addObject((Object)join.sourceAttribute().name());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _EOMutableKnownKeyDictionary.SubsetMapping _sourceRowToForeignKeyMapping() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._sourceRowToForeignKeyMapping == null) {
                NSDictionary mapping = this._sourceToDestinationKeyMap();
                NSMutableArray sourceKeys = (NSMutableArray)mapping.objectForKey((Object)"sourceKeys");
                NSMutableArray destKeys = (NSMutableArray)mapping.objectForKey((Object)"destinationKeys");
                _EOMutableKnownKeyDictionary.Initializer destInitializer = this.destinationEntity()._primaryKeyDictionaryInitializer();
                this._sourceRowToForeignKeyMapping = destInitializer.subsetMappingForInitializer(this._entity._adaptorDictionaryInitializer(), (NSArray)sourceKeys, (NSArray)destKeys);
                if (this._sourceRowToForeignKeyMapping == null) {
                    throw new IllegalArgumentException("Unable to map destination " + this.destinationEntity().name() + " for relationship " + this.name() + " in entity " + this.entity().name() + ".  To one relationships must be joined on the primary key of the destination.");
                }
            }
        }
        return this._sourceRowToForeignKeyMapping;
    }

    public NSMutableDictionary _foreignKeyForSourceRow(NSDictionary row) {
        return new _EOMutableKnownKeyDictionary(row, this._sourceRowToForeignKeyMapping());
    }

    public String _nameForJoinSemantic(int semantic) {
        switch (semantic) {
            case 0: {
                return "EOInnerJoin";
            }
            case 1: {
                return "EOFullOuterJoin";
            }
            case 2: {
                return "EOLeftOuterJoin";
            }
            case 3: {
                return "EORightOuterJoin";
            }
        }
        throw new IllegalArgumentException("_nameForJoinSemantic: unknown join semantic: " + semantic);
    }

    protected int _joinSemanticForName(String name) {
        Number value;
        if (dictionary == null) {
            dictionary = new NSMutableDictionary(4);
            value = _NSUtilities.IntegerForInt((int)0);
            dictionary.setObjectForKey((Object)value, (Object)"EOInnerJoin");
            value = _NSUtilities.IntegerForInt((int)1);
            dictionary.setObjectForKey((Object)value, (Object)"EOFullOuterJoin");
            value = _NSUtilities.IntegerForInt((int)2);
            dictionary.setObjectForKey((Object)value, (Object)"EOLeftOuterJoin");
            value = _NSUtilities.IntegerForInt((int)3);
            dictionary.setObjectForKey((Object)value, (Object)"EORightOuterJoin");
        }
        if ((value = (Number)dictionary.objectForKey((Object)name)) == null) {
            throw new IllegalArgumentException("_semanticForName: unknown join semantic: " + name);
        }
        return value.intValue();
    }

    private void setAuxiliaryQualifier(EOQualifier qualifier) {
        this._qualifier = qualifier == null ? null : (EOQualifier)qualifier.clone();
    }

    EOQualifier auxiliaryQualifier() {
        return this._qualifier;
    }

    private EOQualifier qualifierOmittingAuxiliaryQualifierWithSourceRow(NSDictionary sourceRow) {
        return this.qualifierForDBSnapshot(sourceRow);
    }

    boolean isPropagatesPrimaryKeyPossible() {
        NSSet destAttrNames;
        NSSet sourceAttrNames;
        NSArray joins = this.joins();
        NSMutableArray sourceAttrs = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)joins, (NSSelector)_selSourceAttribute);
        NSMutableArray destAttrs = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)joins, (NSSelector)_selDesAttribute);
        try {
            sourceAttrNames = new NSSet(_NSArrayUtilities.resultsOfPerformingSelector((NSArray)sourceAttrs, (NSSelector)_NSArrayUtilities._nameSelector).sortedArrayUsingComparator((NSComparator)EOAttributeNameComparator._attributeComparator));
            destAttrNames = new NSSet(_NSArrayUtilities.resultsOfPerformingSelector((NSArray)destAttrs, (NSSelector)_NSArrayUtilities._nameSelector).sortedArrayUsingComparator((NSComparator)EOAttributeNameComparator._attributeComparator));
        }
        catch (NSComparator.ComparisonException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        EORelationship inverse = this.inverseRelationship();
        if (!sourceAttrNames.isSubsetOfSet(new NSSet(this.entity().primaryKeyAttributeNames()))) {
            return false;
        }
        if (!destAttrNames.isSubsetOfSet(new NSSet(this.destinationEntity().primaryKeyAttributeNames()))) {
            return false;
        }
        return !inverse.propagatesPrimaryKey();
    }

    public void setName(String name) {
        EOModelGroup group;
        EOModel model;
        if (this._name != null && name.equals(this._name)) {
            return;
        }
        if (this._entity != null && this._name != null && this._name.length() != 0 && (model = this._entity.model()) != null && (group = model.modelGroup()) != null) {
            group.loadAllModelObjects();
        }
        this._name = name;
        if (this._entity != null) {
            this._entity._setIsEdited();
        }
    }

    public void setDefinition(String definition) {
        if (this._entity != null) {
            _EOExpressionArray exprArray;
            this._flushCache();
            this._definitionArray = exprArray = this._entity._parseRelationshipPath(definition);
            this._entity._setIsEdited();
        }
    }

    public void setEntity(EOEntity entity) {
        if (this._entity == entity) {
            return;
        }
        this._flushCache();
        if (this._entity != null && this == this._entity.relationshipNamed(this.name())) {
            this._entity.removeRelationship(this);
        }
        this._entity = entity;
    }

    public void setToMany(boolean bool) {
        if (this.isFlattened() && bool != this.isToMany()) {
            throw new IllegalArgumentException("Unable to change from to-many to to one a flattened relationship");
        }
        if (this._flags_isToMany != bool) {
            this._flags_isToMany = bool;
            if (this._entity != null) {
                this._entity._setIsEdited();
            }
        }
    }

    public void setJoinSemantic(int semantic) {
        this._joinSemantic = semantic;
    }

    public void addJoin(EOJoin join) {
        if (this.isFlattened()) {
            throw new IllegalArgumentException("Unable to add a join to a flattened relationship");
        }
        EOEntity destEntity = this.destinationEntity();
        if (join.sourceAttribute().isFlattened() || join.destinationAttribute().isFlattened()) {
            throw new IllegalArgumentException("unable to add join " + join + " to relationship " + this.name() + " in entity " + this.entity().name() + " because either the source attribute or destination attribute is a flattened attribute.");
        }
        if (join.sourceAttribute().entity() != this._entity) {
            throw new IllegalArgumentException("unable to add join " + join + " to relationship " + this.name() + " in entity " + this.entity().name() + " because the sourceAttribute's entity (" + join.sourceAttribute().entity().name() + ") doesn't match this relationship's entity");
        }
        if (destEntity != null && join.destinationAttribute().entity() != destEntity) {
            throw new IllegalArgumentException("unable to add join " + join + " to relationship " + this.name() + " in entity " + this.entity().name() + " because the destinationAttribute's entity (" + destEntity.name() + ") doesn't match this relationship's destinationEntity");
        }
        this._flushCache();
        if (this._joins != null) {
            this._joins.addObject((Object)join);
        } else {
            this._joins = new NSMutableArray((Object)join);
        }
        this._joinsChanged();
        this._entity._setIsEdited();
    }

    public void removeJoin(EOJoin join) {
        if (this._joins == null) {
            return;
        }
        this._flushCache();
        this._joins.removeObject((Object)join);
        this._joinsChanged();
        this._entity._setIsEdited();
    }

    public void setUserInfo(NSDictionary dictionary) {
        this._userInfo = dictionary != null && dictionary.count() > 0 ? new NSDictionary(dictionary) : null;
        this._entity._setIsEdited();
    }

    protected void _setInternalInfo(NSDictionary dictionary) {
        this._internalInfo = dictionary != null && dictionary.count() > 0 ? new NSDictionary(dictionary) : null;
        this._entity._setIsEdited();
    }

    public void beautifyName() {
        this.setName(_EOStringUtil.nameForExternalNameSeparatorStringInitialCaps(this.name(), "_", false));
    }

    public void setNumberOfToManyFaultsToBatchFetch(int size) {
        this._flags_useBatchFaulting = true;
        this._batchCount = size;
    }

    public void setDeleteRule(int deleteRule) {
        this._deleteRule = deleteRule;
    }

    public void setIsMandatory(boolean isMandatory) {
        if (this._flags_isMandatory != isMandatory) {
            this._flags_isMandatory = isMandatory;
        }
    }

    public void setOwnsDestination(boolean bool) {
        if (this._flags_ownsDestination != bool) {
            this._flags_ownsDestination = bool;
        }
    }

    public void setPropagatesPrimaryKey(boolean bool) {
        if (this._flags_propagatesPrimaryKey != bool) {
            this._flags_propagatesPrimaryKey = bool;
        }
    }

    NSDictionary primaryKeyForTargetRowFromSourceDBSnapshot(NSDictionary dbSnapshot) {
        NSDictionary keyMap = this._sourceToDestinationKeyMap();
        NSArray keys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
        NSMutableDictionary pkDict = _NSDictionaryUtilities.mutableValuesForKeys((NSDictionary)dbSnapshot, (NSArray)keys);
        _NSDictionaryUtilities.translateFromKeysToKeys((NSMutableDictionary)pkDict, (NSArray)keys, (NSArray)((NSArray)keyMap.objectForKey((Object)"destinationKeys")));
        return pkDict;
    }

    EOQualifier qualifierForDBSnapshot(NSDictionary dbSnapshot) {
        EORelationship rel = this;
        Object qualifier = null;
        NSMutableArray qualifiers = null;
        boolean inverted = false;
        String keyPath = null;
        if (this.isFlattened() && this.isToMany()) {
            EORelationship invRel = this.anyInverseRelationship();
            keyPath = invRel.relationshipPath();
            inverted = true;
            rel = this.firstRelationship();
        } else if (this.isFlattened()) {
            rel = this.lastRelationship();
        }
        NSArray joins = rel.joins();
        NSDictionary keyMap = this._sourceToDestinationKeyMap();
        NSArray srcKeys = (NSArray)keyMap.objectForKey((Object)"sourceKeys");
        NSArray destKeys = (NSArray)keyMap.objectForKey((Object)"destinationKeys");
        int iCount = joins.count();
        for (int i = 0; i < iCount; ++i) {
            String key;
            String srcKey;
            String destKey;
            EOJoin join = (EOJoin)joins.objectAtIndex(i);
            if (inverted) {
                srcKey = destKey = join.sourceAttribute().name();
                key = _NSStringUtilities.dotifyPath((String)keyPath, (String)destKey);
            } else {
                destKey = join.destinationAttribute().name();
                srcKey = (String)srcKeys.objectAtIndex(destKeys.indexOfObject((Object)destKey));
                key = destKey;
            }
            Object value = dbSnapshot.objectForKey((Object)srcKey);
            if (value == null) continue;
            qualifier = new EOKeyValueQualifier(key, EOQualifier.QualifierOperatorEqual, value);
            if (qualifiers == null) {
                qualifiers = new NSMutableArray();
            }
            qualifiers.addObject(qualifier);
        }
        if (qualifiers == null || qualifiers.count() == 0) {
            return null;
        }
        qualifier = qualifiers.count() > 1 ? new EOAndQualifier(qualifiers) : (EOQualifier)qualifiers.objectAtIndex(0);
        return qualifier;
    }

    public void _setSourceToDestinationKeyMap(NSDictionary mapping) {
        this._sourceToDestinationKeyMap = mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSDictionary _sourceToDestinationKeyMap() {
        NSRecursiveLock nSRecursiveLock = EOModel._EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._sourceToDestinationKeyMap == null) {
                this._sourceToDestinationKeyMap = this._entity._keyMapForRelationshipPath(this.relationshipPath());
            }
        }
        return this._sourceToDestinationKeyMap;
    }

    boolean isMultiHop() {
        return this.isFlattened();
    }

    public String relationshipPath() {
        String relPath = null;
        if (!this.isFlattened()) {
            return this._name;
        }
        int iCount = this._definitionArray.count();
        for (int i = 0; i < iCount; ++i) {
            EORelationship rel = (EORelationship)this._definitionArray.objectAtIndex(i);
            relPath = relPath == null ? rel.name() : _NSStringUtilities.dotifyPath((String)relPath, (String)rel.name());
        }
        return relPath;
    }

    boolean foreignKeyInDestination() {
        if (this.isToMany()) {
            return true;
        }
        NSArray sourceAtts = this.sourceAttributes();
        NSArray primaryKeyAtts = this._entity.primaryKeyAttributes();
        int count = sourceAtts.count();
        if (count != primaryKeyAtts.count()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            EOAttribute att = (EOAttribute)sourceAtts.objectAtIndex(i);
            if (primaryKeyAtts.indexOfIdenticalObject((Object)att) != -1) continue;
            return false;
        }
        return true;
    }

    boolean isToManyToOne() {
        if (this._toManyToOneCache == -1) {
            return false;
        }
        if (this._toManyToOneCache == 1) {
            return true;
        }
        boolean bool = this._calculateIsToManyToOne();
        this._toManyToOneCache = (byte)(bool ? 1 : -1);
        return bool;
    }

    boolean _calculateIsToManyToOne() {
        int state = 0;
        if (!this.isFlattened()) {
            return false;
        }
        int relCount = this._definitionArray.count();
        state = 0;
        int iCount = relCount;
        block5: for (int i = 0; i < iCount; ++i) {
            EORelationship rel = (EORelationship)this._definitionArray.objectAtIndex(i);
            switch (state) {
                case 0: {
                    if (rel.isToMany()) {
                        state = 1;
                        continue block5;
                    }
                    if (rel.isParentRelationship()) continue block5;
                    return false;
                }
                case 1: {
                    if (rel.isToMany() || rel.anyInverseRelationship().isParentRelationship()) {
                        return false;
                    }
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (!rel.isToMany() && rel.anyInverseRelationship().isParentRelationship()) continue block5;
                    return false;
                }
            }
        }
        return state == 2;
    }

    EOEntity intermediateEntity() {
        if (this.isToManyToOne()) {
            for (int i = this._definitionArray.count() - 1; i >= 0; --i) {
                EORelationship rel = (EORelationship)this._definitionArray.objectAtIndex(i);
                if (!rel.isToMany()) continue;
                return rel.destinationEntity();
            }
        }
        return null;
    }

    EORelationship firstRelationship() {
        if (!this.isFlattened()) {
            return this;
        }
        return (EORelationship)this._definitionArray.objectAtIndex(0);
    }

    EORelationship lastRelationship() {
        if (!this.isFlattened()) {
            return this;
        }
        return (EORelationship)this._definitionArray.lastObject();
    }

    public NSArray _intermediateAttributes() {
        int i;
        NSArray joinsFirst = this.firstRelationship().joins();
        NSArray joinsLast = this.lastRelationship().joins();
        int cntFirst = joinsFirst.count();
        int cntLast = joinsLast.count();
        NSMutableArray attrs = new NSMutableArray(cntFirst + cntLast);
        for (i = 0; i < cntFirst; ++i) {
            attrs.addObject((Object)((EOJoin)joinsFirst.objectAtIndex(i)).destinationAttribute());
        }
        for (i = 0; i < cntLast; ++i) {
            attrs.addObject((Object)((EOJoin)joinsLast.objectAtIndex(i)).sourceAttribute());
        }
        return attrs;
    }

    public Object validateValue(Object valueP) throws NSValidation.ValidationException {
        if (this.isMandatory()) {
            if (!this.isToMany() && valueP == null) {
                throw new NSValidation.ValidationException("The " + this.name() + " property of " + this.entity().name() + " must have a " + this.destinationEntity().name() + " assigned", (Object)this, this.name());
            }
            if (this.isToMany() && ((NSArray)valueP).count() == 0) {
                throw new NSValidation.ValidationException("The " + this.name() + " property of " + this.entity().name() + " must have at least one " + this.destinationEntity().name(), (Object)this, this.name());
            }
        }
        return valueP;
    }

    protected Object _deferredFault() {
        _EOCheapCopyMutableArray value;
        if (this._deferredFault == NSKeyValueCoding.NullValue) {
            return null;
        }
        if (this._deferredFault != null) {
            return this._deferredFault;
        }
        EOEntity dest = this.destinationEntity();
        if (this._flags_isToMany && this.numberOfToManyFaultsToBatchFetch() > 1 || !this._flags_isToMany && dest != null && dest.maxNumberOfInstancesToBatchFetch() > 1) {
            if (EODatabaseContext._lazyFaultDebugLevel > 0) {
                int batchCount;
                String entityRelName = this._flags_isToMany ? _NSStringUtilities.concat((String)this._entity.name(), (String)"->>", (String)this._name) : _NSStringUtilities.concat((String)this._entity.name(), (String)"->", (String)this._name);
                _EOStringUtil.debugInfoPrintln("Could not create deferred fault " + entityRelName + " because...");
                if (this._flags_isToMany && (batchCount = this.numberOfToManyFaultsToBatchFetch()) > 1) {
                    _EOStringUtil.debugInfoPrintln("...the relationship " + this._name + " has a batch count of " + batchCount);
                } else {
                    batchCount = dest.maxNumberOfInstancesToBatchFetch();
                    if (batchCount > 1) {
                        _EOStringUtil.debugInfoPrintln("...the destination entity " + dest.name() + " has a batch count of " + batchCount);
                    }
                }
            }
            this._deferredFault = NSKeyValueCoding.NullValue;
            return null;
        }
        if (!this.isToMany()) {
            if (EODatabaseContext._lazyFaultDebugLevel > 0) {
                _EOStringUtil.debugInfoPrintln("Creating deferred fault: " + this._entity.name() + "->" + this._name);
            }
            value = dest.classDescriptionForInstances().createInstanceWithEditingContext(null, null);
        } else {
            if (EODatabaseContext._lazyFaultDebugLevel > 0) {
                _EOStringUtil.debugInfoPrintln("Creating deferred fault: " + this._entity.name() + "->>" + this._name);
            }
            value = new _EOCheapCopyMutableArray();
        }
        EOAccessDeferredFaultHandler handler = new EOAccessDeferredFaultHandler(this);
        EOFaultHandler.makeObjectIntoFault((Object)value, (EOFaultHandler)handler);
        this._deferredFault = value;
        return this._deferredFault;
    }

    public EORelationship() {
    }
}

