/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess._EOExpressionArray;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eoaccess._EOStringUtil;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import java.util.Enumeration;

public abstract class EOSQLExpression {
    private static final int _DefaultPathLength = 128;
    private static final int _DefaultListStringLength = 256;
    private static final int _DefaultOrderByStringLength = 128;
    private static final int _DefaultTableListLength = 128;
    private static final int _DefaultFormatSQLStringLength = 64;
    private static final int _ValueLengthLimit = 40;
    protected static final char[] _NibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static NSTimestampFormatter _defaultDateFormatter;
    protected NSMutableDictionary _aliasesByRelationshipPath;
    protected EOEntity _entity;
    protected StringBuffer _listString;
    protected StringBuffer _valueListString;
    protected String _whereClauseString;
    protected String _joinClauseString;
    protected StringBuffer _orderByString;
    protected NSMutableArray _bindings;
    protected NSMutableArray _contextStack;
    protected String _statement;
    protected boolean _useAliases;
    protected String _upperFunctionName = "UPPER";
    public static final String BindVariableNameKey = "BindVariableName";
    public static final String BindVariableAttributeKey = "BindVariableAttribute";
    public static final String BindVariableValueKey = "BindVariableValue";
    public static final String BindVariablePlaceHolderKey = "BindVariablePlaceholder";
    public static final String BindVariableColumnKey = "BindVariableColumn";
    private static int UseBindings;

    protected EOEntity _entityForRelationshipPathOrigin(String path, EOEntity entity) {
        EORelationship relationship = entity.relationshipForPath(path);
        return relationship.destinationEntity();
    }

    public String _aliasForRelatedAttributeRelationshipPath(EOAttribute attribute, String relationshipPath) {
        String alias = this._aliasForRelationshipPath(relationshipPath);
        String columnName = attribute.columnName();
        if (!this._useAliases) {
            return columnName;
        }
        return _NSStringUtilities.concat((String)alias, (String)".", (String)this.sqlStringForSchemaObjectName(columnName));
    }

    public String _sqlStringForJoinSemanticMatchSemantic(int semantic, int matchSemantic) {
        if (semantic == 1 || matchSemantic == semantic) {
            return "*";
        }
        return "";
    }

    protected String _flattenRelPathEntity(String relPath, EOEntity entity) {
        NSArray pieces = NSArray.componentsSeparatedByString((String)relPath, (String)".");
        String rPath = null;
        int count = pieces.count();
        for (int i = 0; i < count; ++i) {
            EORelationship rel = entity.anyRelationshipNamed((String)pieces.objectAtIndex(i));
            if (rel == null) {
                NSArray relArray = entity.relationships();
                EOEntity destinationEntity = null;
                EORelationship newRel = null;
                int j = 0;
                int relCount = relArray.count();
                while (rel == null & j < relCount) {
                    newRel = (EORelationship)relArray.objectAtIndex(j);
                    destinationEntity = newRel.destinationEntity();
                    rel = destinationEntity.relationshipForPath(relPath);
                    ++j;
                }
                rPath = rPath == null ? newRel.name() : _NSStringUtilities.dotifyPath((String)rPath, (String)newRel.name());
                entity = destinationEntity;
            }
            String nextComponent = rel.isFlattened() ? this._flattenRelPathEntity(rel.definition(), entity) : rel.name();
            rPath = rPath == null ? nextComponent : _NSStringUtilities.dotifyPath((String)rPath, (String)nextComponent);
            entity = rel.destinationEntity();
        }
        return rPath;
    }

    public String _aliasForRelationshipPath(String relPath) {
        String alias;
        if (relPath.length() > 0) {
            relPath = this._flattenRelPathEntity(relPath, this._entity);
        }
        if ((alias = (String)this._aliasesByRelationshipPath.objectForKey((Object)relPath)) == null) {
            StringBuffer rPath = new StringBuffer(128);
            NSArray pieces = NSArray.componentsSeparatedByString((String)relPath, (String)".");
            int iCount = pieces.count();
            for (int i = 0; i < iCount; ++i) {
                rPath.append((String)pieces.objectAtIndex(i));
                if (this._aliasesByRelationshipPath.objectForKey((Object)new String(rPath)) == null) {
                    alias = "T".concat(String.valueOf(this._aliasesByRelationshipPath.count()));
                    this._aliasesByRelationshipPath.setObjectForKey((Object)alias, (Object)new String(rPath));
                }
                rPath.append('.');
            }
            Object var3_3 = null;
        }
        return alias;
    }

    public EOEntity _rootEntityForExpression() {
        String relPath = "";
        if (this._useAliases) {
            return this._entity;
        }
        int count = this._aliasesByRelationshipPath.count();
        if (count == 1) {
            return this._entity;
        }
        Enumeration enumerator = this._aliasesByRelationshipPath.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String tmpRelPath = (String)enumerator.nextElement();
            if (tmpRelPath.length() <= relPath.length()) continue;
            relPath = tmpRelPath;
        }
        EOEntity entity = this._entity.relationshipForPath(relPath).destinationEntity();
        return entity;
    }

    private EOSQLExpression() {
    }

    public EOSQLExpression(EOEntity entity) {
        this._contextStack = new NSMutableArray((Object)"");
        this._aliasesByRelationshipPath = new NSMutableDictionary(16);
        this._aliasesByRelationshipPath.setObjectForKey((Object)"t0", (Object)"");
        this._entity = entity;
    }

    public String toString() {
        NSArray bindings = this.bindVariableDictionaries();
        int count = bindings == null ? 0 : bindings.count();
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(this.getClass().getName());
        result.append(": \"");
        result.append(this.statement());
        result.append("\"");
        if (count > 0) {
            boolean detailed = NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)65536L);
            result.append(" withBindings: ");
            for (int i = 0; i < count; ++i) {
                NSDictionary curr = (NSDictionary)bindings.objectAtIndex(i);
                Object value = curr.valueForKey(BindVariableValueKey);
                if (value instanceof String) {
                    value = EOSQLExpression._truncatedString((String)value, !detailed, 40);
                } else if (value instanceof NSData) {
                    value = EOSQLExpression._truncatedStringForData((NSData)value, !detailed, 40);
                } else if (value instanceof NSTimestamp) {
                    value = this._stringForDate((NSTimestamp)value);
                }
                if (i != 0) {
                    result.append(", ");
                }
                result.append(i + 1);
                result.append(":");
                result.append(value);
                result.append("(");
                result.append(curr.valueForKey(BindVariableNameKey));
                result.append(")");
            }
        }
        result.append(">");
        return new String(result);
    }

    protected static String _truncatedString(String value, boolean truncate, int limit) {
        int len = value.length();
        truncate = truncate && len > limit;
        int radius = limit / 2;
        StringBuffer result = new StringBuffer();
        result.append("\"");
        if (truncate) {
            result.append(value.substring(0, radius));
            result.append("...");
            result.append(value.substring(len - radius));
        } else {
            result.append(value);
        }
        result.append("\"");
        return new String(result);
    }

    protected static String _truncatedStringForData(NSData value, boolean truncate, int limit) {
        int i;
        int len = value.length();
        truncate = truncate && len > limit;
        int radius = limit / 2;
        NSMutableRange range = new NSMutableRange();
        byte[] bytes = value.bytesNoCopy(range);
        int location = range.location();
        int maxRange = range.maxRange();
        int firstEnd = truncate ? location + radius : len;
        int secondStart = truncate ? maxRange - radius : firstEnd;
        StringBuffer result = new StringBuffer();
        result.append("<NSData: length=");
        result.append(len);
        result.append(", data=");
        for (i = location; i < firstEnd; ++i) {
            result.append(_NibbleToHex[bytes[i] >> 4 & 0xF]);
            result.append(_NibbleToHex[bytes[i] & 0xF]);
        }
        if (truncate) {
            result.append("...");
        }
        for (i = secondStart; i < maxRange; ++i) {
            result.append(_NibbleToHex[bytes[i] >> 4 & 0xF]);
            result.append(_NibbleToHex[bytes[i] & 0xF]);
        }
        result.append(">");
        return new String(result);
    }

    protected String _stringForDate(NSTimestamp value) {
        return this._defaultDateFormatter().format((Object)value);
    }

    protected NSTimestampFormatter _defaultDateFormatter() {
        if (_defaultDateFormatter == null) {
            _defaultDateFormatter = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S");
        }
        return _defaultDateFormatter;
    }

    public NSMutableDictionary aliasesByRelationshipPath() {
        if (this._aliasesByRelationshipPath == null) {
            this._aliasesByRelationshipPath = new NSMutableDictionary();
            this._aliasesByRelationshipPath.setObjectForKey((Object)"t0", (Object)"");
        }
        return this._aliasesByRelationshipPath;
    }

    public EOEntity entity() {
        return this._entity;
    }

    public void _setEntity(EOEntity entity) {
        this._entity = entity;
    }

    public String listString() {
        return new String(this._listString());
    }

    protected StringBuffer _listString() {
        if (this._listString == null) {
            this._listString = new StringBuffer(256);
        }
        return this._listString;
    }

    public String valueList() {
        return new String(this._valueList());
    }

    protected StringBuffer _valueList() {
        if (this._valueListString == null) {
            this._valueListString = new StringBuffer(256);
        }
        return this._valueListString;
    }

    public String whereClauseString() {
        return this._whereClauseString;
    }

    void setWhereClauseString(String whereClauseString) {
        this._whereClauseString = whereClauseString;
    }

    public String joinClauseString() {
        if (this._joinClauseString == null) {
            this._joinClauseString = "";
        }
        return this._joinClauseString;
    }

    protected StringBuffer _orderByString() {
        if (this._orderByString == null) {
            this._orderByString = new StringBuffer(128);
        }
        return this._orderByString;
    }

    public String orderByString() {
        return new String(this._orderByString());
    }

    public String statement() {
        return this._statement;
    }

    public void setStatement(String statement) {
        this._statement = statement;
    }

    public String lockClause() {
        return "HOLDLOCK";
    }

    public String tableListWithRootEntity(EOEntity entity) {
        if (!this.useAliases()) {
            return entity.externalName();
        }
        StringBuffer string = new StringBuffer(128);
        Enumeration enumerator = this._aliasesByRelationshipPath.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            EOEntity entityForTableName = key.length() == 0 ? entity : entity.relationshipForPath(key).destinationEntity();
            String tableName = entityForTableName.valueForSQLExpression(this);
            if (string.length() != 0) {
                string.append(',');
                string.append(' ');
            }
            string.append(tableName);
            string.append(' ');
            string.append((String)this._aliasesByRelationshipPath.objectForKey((Object)key));
        }
        return new String(string);
    }

    public void prepareInsertExpressionWithRow(NSDictionary row) {
        Enumeration enumerator = row.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            EOAttribute att = this._entity.anyAttributeNamed(key);
            if (att == null) {
                throw new IllegalStateException("prepareInsertExpressionWithRow: row argument contains key '" + key + "' which does not have corresponding attribute on entity '" + this._entity.name() + "'");
            }
            Object value = row.objectForKey((Object)key);
            this.addInsertListAttribute(att, value);
        }
        String tableList = this.tableListWithRootEntity(this._rootEntityForExpression());
        this._statement = this.assembleInsertStatementWithRow(row, tableList, new String(this._listString), new String(this._valueListString));
    }

    public void prepareUpdateExpressionWithRow(NSDictionary row, EOQualifier qualifier) {
        Enumeration enumerator = row.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            EOAttribute att = this._entity.anyAttributeNamed(key);
            if (att == null) {
                throw new IllegalStateException("prepareUpdateExpressionWithRow: row argument contains key '" + key + "' which does not have corresponding attribute on entity '" + this._entity.name() + "'");
            }
            Object value = row.objectForKey((Object)key);
            this.addUpdateListAttribute(att, value);
        }
        this._whereClauseString = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(qualifier, this);
        String tableList = this.tableListWithRootEntity(this._rootEntityForExpression());
        this._statement = this.assembleUpdateStatementWithRow(row, qualifier, tableList, new String(this._listString), this._whereClauseString);
    }

    public void prepareDeleteExpressionForQualifier(EOQualifier qualifier) {
        this._whereClauseString = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(qualifier, this);
        String tableList = this.tableListWithRootEntity(this._rootEntityForExpression());
        this._statement = this.assembleDeleteStatementWithQualifier(qualifier, tableList, this._whereClauseString);
    }

    public void prepareSelectExpressionWithAttributes(NSArray attributes, boolean lock, EOFetchSpecification fetchSpec) {
        NSArray sortOrderings;
        EOAttribute att;
        int i;
        String whereClause = "";
        String joinClause = "";
        String orderByClause = "";
        String lockClause = "";
        String relPath = null;
        this._useAliases = false;
        for (i = attributes.count() - 1; i >= 0; --i) {
            att = (EOAttribute)attributes.objectAtIndex(i);
            if (!att.isFlattened()) {
                this._useAliases = true;
                break;
            }
            if (relPath == null) {
                relPath = att.relationshipPath();
                continue;
            }
            if (relPath.equals(att.relationshipPath())) continue;
            this._useAliases = true;
            break;
        }
        int iCount = attributes.count();
        for (i = 0; i < iCount; ++i) {
            att = (EOAttribute)attributes.objectAtIndex(i);
            this.addSelectListAttribute(att);
        }
        EOQualifier localQualifier = fetchSpec.qualifier();
        EOQualifier qualifier = fetchSpec.isDeep() && this._entity._isSingleTableEntity() ? this._entity._singleTableRestrictingQualifier() : this._entity.restrictingQualifier();
        if (qualifier != null) {
            if (localQualifier != null) {
                qualifier = new EOAndQualifier(new NSArray(new Object[]{qualifier, localQualifier}));
            }
        } else {
            qualifier = localQualifier;
        }
        if (qualifier != null) {
            this._whereClauseString = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(qualifier, this);
        }
        iCount = (sortOrderings = fetchSpec.sortOrderings()) != null ? sortOrderings.count() : 0;
        for (i = 0; i < iCount; ++i) {
            EOSortOrdering sortOrdering = (EOSortOrdering)sortOrderings.objectAtIndex(i);
            this.addOrderByAttributeOrdering(sortOrdering);
        }
        this.joinExpression();
        String tableList = this.tableListWithRootEntity(this._rootEntityForExpression());
        String selectString = fetchSpec.usesDistinct() ? "SELECT DISTINCT " : "SELECT ";
        if (this._whereClauseString != null) {
            whereClause = this._whereClauseString;
        }
        if (this._joinClauseString != null) {
            joinClause = this._joinClauseString;
        }
        if (this._orderByString != null) {
            orderByClause = new String(this._orderByString);
        }
        if (lock) {
            lockClause = this.lockClause();
        }
        this._statement = this.assembleSelectStatementWithAttributes(attributes, lock, qualifier, sortOrderings, selectString, new String(this._listString), tableList, whereClause, joinClause, orderByClause, lockClause);
    }

    public String assembleJoinClause(String leftName, String rightName, int semantic) {
        String operatorString = "=";
        String leftOuterJoinString = this._sqlStringForJoinSemanticMatchSemantic(semantic, 2);
        String rightOuterJoinString = this._sqlStringForJoinSemanticMatchSemantic(semantic, 3);
        return _NSStringUtilities.concat((String)leftName, (String)" ", (String)leftOuterJoinString, (String)operatorString, (String)rightOuterJoinString, (String)" ", (String)rightName);
    }

    public void addJoinClause(String leftName, String rightName, int semantic) {
        String string = this.assembleJoinClause(leftName, rightName, semantic);
        this._joinClauseString = this._joinClauseString != null ? _NSStringUtilities.concat((String)this._joinClauseString, (String)" AND ", (String)string) : string;
    }

    public void joinExpression() {
        Object auxQual;
        NSMutableArray auxQuals = null;
        if (this._aliasesByRelationshipPath == null || this._aliasesByRelationshipPath.count() <= 1) {
            return;
        }
        EOEntity entity = this.entity();
        Enumeration enumerator = this._aliasesByRelationshipPath.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            EORelationship relationship;
            String destPath = (String)enumerator.nextElement();
            if (destPath.length() == 0) continue;
            String sourcePath = _EOStringUtil.relationshipPathByDeletingLastComponent(destPath);
            if (sourcePath == null) {
                sourcePath = "";
            }
            if ((auxQual = (relationship = entity.relationshipForPath(destPath)).auxiliaryQualifier()) != null) {
                if (auxQuals == null) {
                    auxQuals = new NSMutableArray();
                }
                auxQuals.addObject((Object)EOQualifierSQLGeneration.Support._qualifierMigratedFromEntityRelationshipPath(auxQual, entity, destPath));
            }
            NSArray joins = relationship.joins();
            int count = joins.count();
            for (int i = 0; i < count; ++i) {
                EOJoin join = (EOJoin)joins.objectAtIndex(i);
                EOAttribute sourceAttr = join.sourceAttribute();
                EOAttribute destAttr = join.destinationAttribute();
                String sourceName = this._aliasForRelatedAttributeRelationshipPath(sourceAttr, sourcePath);
                String destName = this._aliasForRelatedAttributeRelationshipPath(destAttr, destPath);
                this.addJoinClause(sourceName, destName, relationship.joinSemantic());
            }
        }
        if (auxQuals != null) {
            auxQual = auxQuals.count() == 1 ? (EOQualifier)auxQuals.objectAtIndex(0) : new EOAndQualifier(auxQuals);
            String wcString = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(auxQual, this);
            this._whereClauseString = this._whereClauseString != null ? _NSStringUtilities.concat((String)this._whereClauseString, (String)" AND ", (String)wcString) : wcString;
        }
    }

    public String assembleInsertStatementWithRow(NSDictionary row, String tableList, String columnList, String valueList) {
        if (columnList != null) {
            return _NSStringUtilities.concat((String)"INSERT INTO ", (String)tableList, (String)"(", (String)columnList, (String)")", (String)" VALUES ", (String)"(", (String)valueList, (String)")");
        }
        return _NSStringUtilities.concat((String)"INSERT INTO ", (String)tableList, (String)" VALUES ", (String)"(", (String)valueList, (String)")");
    }

    public String assembleUpdateStatementWithRow(NSDictionary row, EOQualifier qualifier, String tableList, String updateList, String whereClause) {
        return _NSStringUtilities.concat((String)"UPDATE ", (String)tableList, (String)" SET ", (String)updateList, (String)" WHERE ", (String)whereClause);
    }

    public String assembleDeleteStatementWithQualifier(EOQualifier qualifier, String tableList, String whereClause) {
        if (whereClause != null) {
            return _NSStringUtilities.concat((String)"DELETE FROM ", (String)tableList, (String)" WHERE ", (String)whereClause);
        }
        return _NSStringUtilities.concat((String)"DELETE FROM ", (String)tableList);
    }

    public String assembleSelectStatementWithAttributes(NSArray attributes, boolean lock, EOQualifier qualifier, NSArray fetchOrder, String selectString, String columnList, String tableList, String whereClause, String joinClause, String orderByClause, String lockClause) {
        int size = selectString.length() + columnList.length() + tableList.length() + 7;
        if (lockClause != null && lockClause.length() != 0) {
            size += lockClause.length() + 1;
        }
        if (whereClause != null && whereClause.length() != 0) {
            size += whereClause.length() + 7;
        }
        if (joinClause != null && joinClause.length() != 0) {
            size += joinClause.length() + 7;
        }
        if (orderByClause != null && orderByClause.length() != 0) {
            size += orderByClause.length() + 10;
        }
        StringBuffer buffer = new StringBuffer(size);
        buffer.append(selectString);
        buffer.append(columnList);
        buffer.append(" FROM ");
        buffer.append(tableList);
        if (whereClause != null && whereClause.length() != 0) {
            buffer.append(" WHERE ");
            buffer.append(whereClause);
        }
        if (joinClause != null && joinClause.length() != 0) {
            if (whereClause != null && whereClause.length() != 0) {
                buffer.append(" AND ");
            } else {
                buffer.append(" WHERE ");
            }
            buffer.append(joinClause);
        }
        if (orderByClause != null && orderByClause.length() != 0) {
            buffer.append(" ORDER BY ");
            buffer.append(orderByClause);
        }
        if (lockClause != null && lockClause.length() != 0) {
            buffer.append(' ');
            buffer.append(lockClause);
        }
        return new String(buffer);
    }

    public void addSelectListAttribute(EOAttribute attribute) {
        String sqlString = this.sqlStringForAttribute(attribute);
        sqlString = this.formatSQLString(sqlString, attribute.readFormat());
        this.appendItemToListString(sqlString, this._listString());
    }

    public void addInsertListAttribute(EOAttribute attribute, Object value) {
        this.appendItemToListString(this.sqlStringForAttribute(attribute), this._listString());
        String valueSQL = this.sqlStringForValue(value, attribute.name());
        valueSQL = this.formatSQLString(valueSQL, attribute.writeFormat());
        this.appendItemToListString(valueSQL, this._valueList());
    }

    public void addUpdateListAttribute(EOAttribute attribute, Object value) {
        String sqlString = this.sqlStringForAttribute(attribute);
        String valueSQL = this.sqlStringForValue(value, attribute.name());
        valueSQL = this.formatSQLString(valueSQL, attribute.writeFormat());
        this.appendItemToListString(_NSStringUtilities.concat((String)sqlString, (String)" = ", (String)valueSQL), this._listString());
    }

    public String formatStringValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatStringValue: string value cannot be null");
        }
        StringBuffer quotedString = new StringBuffer(string.length() + 2);
        quotedString.append('\'');
        int index = string.indexOf(39);
        if (index >= 0) {
            int offset = 0;
            char[] chars = string.toCharArray();
            do {
                quotedString.append(chars, offset, index - offset);
                quotedString.append('\'');
                quotedString.append('\'');
            } while ((index = string.indexOf(39, offset = index + 1)) >= 0);
            quotedString.append(chars, offset, string.length() - offset);
        } else {
            quotedString.append(string);
        }
        quotedString.append('\'');
        return new String(quotedString);
    }

    public String formatValueForAttribute(Object value, EOAttribute attribute) {
        if (value == NSKeyValueCoding.NullValue) {
            return "NULL";
        }
        return value.toString();
    }

    public String formatSQLString(String sqlString, String format) {
        int index;
        if (format == null || _NSStringUtilities.containsOnlyWhiteSpace((String)format)) {
            return sqlString;
        }
        StringBuffer formattedValue = new StringBuffer(64);
        int offset = 0;
        int formatLength = format.length();
        char[] formatChars = format.toCharArray();
        while ((index = format.indexOf(37, offset)) >= 0) {
            formattedValue.append(formatChars, offset, index - offset);
            if (index + 1 >= formatLength) {
                formattedValue.append('%');
                offset = index + 1;
                break;
            }
            char ch = format.charAt(index + 1);
            if (ch == '%') {
                formattedValue.append('%');
                offset = index + 2;
                continue;
            }
            if (ch == 'V' || ch == 'P') {
                formattedValue.append(sqlString);
                offset = index + 2;
                continue;
            }
            throw new IllegalArgumentException("formatStringValue: invalid conversion specification: " + format.substring(index, 2));
        }
        if (offset < formatLength) {
            formattedValue.append(formatChars, offset, formatLength - offset);
        }
        return new String(formattedValue);
    }

    String sqlStringForArrayOfQualifiers(NSArray qualifiers, String op) {
        StringBuffer resultString = null;
        int iCount = qualifiers.count();
        boolean addParens = false;
        if (iCount == 0) {
            return "(1 = 1)";
        }
        for (int i = 0; i < iCount; ++i) {
            String string;
            EOQualifier qual = (EOQualifier)qualifiers.objectAtIndex(i);
            if (qual._isEmpty() || (string = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(qual, this)) == null || _NSStringUtilities.containsOnlyWhiteSpace((String)string)) continue;
            if (resultString != null) {
                resultString.append(op);
                resultString.append(string);
                addParens = true;
                continue;
            }
            resultString = new StringBuffer(string);
        }
        if (resultString == null || resultString.length() < 1) {
            return "(1 = 1)";
        }
        if (addParens) {
            resultString.insert(0, '(');
            resultString.append(')');
        }
        return new String(resultString);
    }

    public String sqlStringForConjoinedQualifiers(NSArray qualifiers) {
        return this.sqlStringForArrayOfQualifiers(qualifiers, " AND ");
    }

    public String sqlStringForDisjoinedQualifiers(NSArray qualifiers) {
        return this.sqlStringForArrayOfQualifiers(qualifiers, " OR ");
    }

    public String sqlStringForNegatedQualifier(EOQualifier qualifier) {
        String resultString = null;
        String string = EOQualifierSQLGeneration.Support._sqlStringForSQLExpression(qualifier, this);
        if (string != null || !_NSStringUtilities.containsOnlyWhiteSpace((String)string)) {
            resultString = _NSStringUtilities.concat((String)"not (", (String)string, (String)")");
        }
        return resultString;
    }

    public String sqlStringForCaseInsensitiveLike(String valueString, String keyString) {
        return _NSStringUtilities.concat((String)this._upperFunctionName, (String)"(", (String)keyString, (String)") LIKE ", (String)this._upperFunctionName, (String)"(", (String)valueString, (String)")");
    }

    public String sqlStringForKeyValueQualifier(EOKeyValueQualifier qualifier) {
        char escapeChar;
        String string;
        String key = qualifier.key();
        String keyString = this.sqlStringForAttributeNamed(key);
        if (keyString == null) {
            throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + qualifier.getClass().getName() + " " + qualifier + " failed because attribute identified by key '" + key + "' was not reachable from from entity '" + this._entity.name() + "'");
        }
        Object qualifierValue = qualifier.value();
        if (qualifierValue instanceof EOQualifierVariable) {
            throw new IllegalStateException("sqlStringForKeyValueQualifier: attempt to generate SQL for " + qualifier.getClass().getName() + " " + qualifier + " failed because the qualifier variable '$" + ((EOQualifierVariable)qualifierValue).key() + "' is unbound.");
        }
        keyString = this.formatSQLString(keyString, this._entity.attributeForPath(key).readFormat());
        NSSelector qualifierSelector = qualifier.selector();
        boolean isLike = qualifierSelector.equals((Object)EOQualifier.QualifierOperatorLike) || qualifierSelector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike);
        Object value = isLike ? this.sqlPatternFromShellPattern((String)qualifierValue) : qualifierValue;
        if (qualifierSelector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike)) {
            String valueString = this.sqlStringForValue(value, key);
            String operatorString = this.sqlStringForSelector(qualifierSelector, value);
            string = this.sqlStringForCaseInsensitiveLike(valueString, keyString);
        } else {
            String valueString = this.sqlStringForValue(value, key);
            String operatorString = this.sqlStringForSelector(qualifierSelector, value);
            string = _NSStringUtilities.concat((String)keyString, (String)" ", (String)operatorString, (String)" ", (String)valueString);
        }
        if (isLike && (escapeChar = this.sqlEscapeChar()) != '\u0000') {
            string = _NSStringUtilities.concat((String)string, (String)(" ESCAPE '" + escapeChar + "'"));
        }
        return string;
    }

    public String sqlStringForKeyComparisonQualifier(EOKeyComparisonQualifier qualifier) {
        String leftKey = qualifier.leftKey();
        String rightKey = qualifier.rightKey();
        if (leftKey != null && leftKey.equals(rightKey)) {
            return "(1=1)";
        }
        EOAttribute att = this._entity.attributeForPath(leftKey);
        String leftKeyString = this.sqlStringForAttributeNamed(leftKey);
        if (leftKeyString == null) {
            throw new IllegalStateException("sqlStringForKeyComparisonQualifier: attempt to generate SQL for " + qualifier.getClass().getName() + " " + qualifier + " failed because attribute identified by key '" + leftKey + "' was not reachable from from entity '" + this._entity.name() + "'");
        }
        leftKeyString = this.formatSQLString(leftKeyString, att.readFormat());
        att = this._entity.attributeForPath(rightKey);
        String rightKeyString = this.sqlStringForAttributeNamed(rightKey);
        if (rightKeyString == null) {
            throw new IllegalStateException("sqlStringForKeyComparisonQualifier: attempt to generate SQL for " + qualifier.getClass().getName() + " " + qualifier + " failed because attribute identified by key '" + rightKey + "' was not reachable from from entity '" + this._entity.name() + "'");
        }
        rightKeyString = this.formatSQLString(rightKeyString, att.readFormat());
        String operatorString = this.sqlStringForSelector(qualifier.selector(), null);
        return _NSStringUtilities.concat((String)leftKeyString, (String)" ", (String)operatorString, (String)" ", (String)rightKeyString);
    }

    public void addOrderByAttributeOrdering(EOSortOrdering sortOrdering) {
        NSSelector selector = sortOrdering.selector();
        String attPath = sortOrdering.key();
        String sqlString1 = this.sqlStringForAttributeNamed(attPath);
        if (sqlString1 == null) {
            throw new IllegalStateException("addOrderByAttributeOrdering: attempt to generate SQL for " + sortOrdering.getClass().getName() + " " + sortOrdering + " failed because attribute identified by key '" + sortOrdering.key() + "' was not reachable from from entity '" + this._entity.name() + "'");
        }
        String format = selector == EOSortOrdering.CompareCaseInsensitiveAscending ? (this.entity().attributeForPath(attPath).adaptorValueType() == 1 ? _NSStringUtilities.concat((String)this._upperFunctionName, (String)"(", (String)sqlString1, (String)") ASC") : _NSStringUtilities.concat((String)sqlString1, (String)" ASC")) : (selector == EOSortOrdering.CompareCaseInsensitiveDescending ? (this.entity().attributeForPath(attPath).adaptorValueType() == 1 ? _NSStringUtilities.concat((String)this._upperFunctionName, (String)"(", (String)sqlString1, (String)") DESC") : _NSStringUtilities.concat((String)sqlString1, (String)" DESC")) : (selector == EOSortOrdering.CompareAscending ? _NSStringUtilities.concat((String)sqlString1, (String)" ASC") : (selector == EOSortOrdering.CompareDescending ? _NSStringUtilities.concat((String)sqlString1, (String)" DESC") : _NSStringUtilities.concat((String)"(", (String)sqlString1, (String)")"))));
        this.appendItemToListString(format, this._orderByString());
    }

    public void setUseAliases(boolean useAliases) {
        this._useAliases = useAliases;
    }

    public boolean useAliases() {
        return this._useAliases;
    }

    public String sqlStringForSchemaObjectName(String name) {
        String quoteChar = this.externalNameQuoteCharacter();
        if (quoteChar == "") {
            return name;
        }
        NSMutableArray components = NSArray._mutableComponentsSeparatedByString((String)name, (String)".");
        int count = components.count();
        for (int i = 0; i < count; ++i) {
            components.replaceObjectAtIndex((Object)_NSStringUtilities.concat((String)quoteChar, (String)((String)components.objectAtIndex(i)), (String)quoteChar), i);
        }
        String resultString = components.componentsJoinedByString(".");
        components = null;
        return resultString;
    }

    public String sqlStringForAttributeNamed(String name) {
        NSArray pieces = NSArray.componentsSeparatedByString((String)name, (String)".");
        EOEntity entity = this._entity;
        int iCount = pieces.count();
        if (iCount == 1) {
            EOAttribute att = entity.anyAttributeNamed(name);
            if (att == null) {
                return null;
            }
            return this.sqlStringForAttribute(att);
        }
        NSMutableArray path = new NSMutableArray(iCount);
        for (int i = 0; i < iCount - 1; ++i) {
            EORelationship rel = entity.anyRelationshipNamed((String)pieces.objectAtIndex(i));
            if (rel == null) {
                return null;
            }
            path.addObject((Object)rel);
            entity = rel.destinationEntity();
        }
        EOAttribute att = entity.anyAttributeNamed((String)pieces.lastObject());
        if (att == null) {
            return null;
        }
        path.addObject((Object)att);
        return this.sqlStringForAttributePath((NSArray)path);
    }

    public String sqlStringForSelector(NSSelector selector, Object value) {
        if (selector.equals((Object)EOQualifier.QualifierOperatorEqual) || selector.equals((Object)EOQualifier.QualifierOperatorContains)) {
            if (value == NSKeyValueCoding.NullValue) {
                return "is";
            }
            return "=";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorNotEqual)) {
            if (value == NSKeyValueCoding.NullValue) {
                return "is not";
            }
            return "<>";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorLessThan)) {
            return "<";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorGreaterThan)) {
            return ">";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorLessThanOrEqualTo)) {
            return "<=";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorGreaterThanOrEqualTo)) {
            return ">=";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorLike)) {
            return "like";
        }
        if (selector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike)) {
            return "like";
        }
        throw new IllegalStateException("sqlStringForSelector:  Unknown operator:" + selector);
    }

    public String sqlStringForValue(Object value, String keyPath) {
        EOAttribute att = this._entity.attributeForPath(keyPath);
        if (value != NSKeyValueCoding.NullValue && (this.useBindVariables() && this.shouldUseBindVariableForAttribute(att) || this.mustUseBindVariableForAttribute(att))) {
            NSMutableDictionary binding = this.bindVariableDictionaryForAttribute(att, value);
            this.addBindVariableDictionary((NSDictionary)binding);
            return (String)binding.objectForKey((Object)BindVariablePlaceHolderKey);
        }
        return this.formatValueForAttribute(value, att);
    }

    public String sqlStringForAttribute(EOAttribute attribute) {
        String value;
        _EOExpressionArray definitionArray = attribute._definitionArray();
        if (definitionArray != null && definitionArray.count() > 1) {
            value = definitionArray.valueForSQLExpression(this);
        } else {
            String columnName = attribute.columnName();
            if (columnName == null) {
                throw new IllegalStateException("sqlStringForAttribute: attempt to generate SQL for attribute '" + attribute.name() + "' on entity '" + attribute.entity().name() + "' with undefined column name. You must define a column name for this attribute before attempting a database operation.");
            }
            value = !this.useAliases() ? columnName : "t0.".concat(this.sqlStringForSchemaObjectName(columnName));
        }
        return value;
    }

    public String sqlStringForAttributePath(NSArray path) {
        int count = path.count();
        this._contextStack.addObject((Object)((String)this._contextStack.lastObject()));
        StringBuffer buffer = new StringBuffer(128);
        buffer.append((String)this._contextStack.lastObject());
        for (int i = 0; i < count - 1; ++i) {
            if (buffer.length() != 0) {
                buffer.append('.');
            }
            buffer.append(((EORelationship)path.objectAtIndex(i)).name());
        }
        String relPath = new String(buffer);
        EOAttribute attr = (EOAttribute)path.lastObject();
        String value = attr._definitionArray() != null ? this.sqlStringForAttribute(attr) : this._aliasForRelatedAttributeRelationshipPath(attr, relPath);
        this._contextStack.removeLastObject();
        return value;
    }

    public void appendItemToListString(String itemString, StringBuffer listString) {
        if (listString.length() > 0) {
            listString.append(',');
            listString.append(' ');
            listString.append(itemString);
        } else {
            listString.append(itemString);
        }
    }

    public String sqlPatternFromShellPatternWithEscapeCharacter(String pattern, char escapeCharacter) {
        boolean inBrackets = false;
        int i = 0;
        char[] sqlPat = pattern.length() > 400 ? new char[pattern.length() * 3] : new char[1024];
        char[] pBuf = pattern.toCharArray();
        int length = pBuf.length;
        for (int pos = 0; pos < length; ++pos) {
            boolean isMagic;
            char ch = pBuf[pos];
            if (ch == escapeCharacter) {
                sqlPat[i++] = escapeCharacter;
                isMagic = false;
            } else {
                boolean bl = isMagic = ch == '*' || ch == '?' || ch == '[' || ch == ']';
            }
            if (isMagic) {
                if (ch == '*') {
                    char c = sqlPat[i++] = !inBrackets ? (char)'%' : ch;
                }
                if (ch == '?') {
                    char c = sqlPat[i++] = !inBrackets ? (char)'_' : ch;
                }
                if (ch == '[') {
                    sqlPat[i++] = 91;
                    boolean bl = inBrackets = escapeCharacter == '\u0000';
                }
                if (ch != 93) continue;
                sqlPat[i++] = 93;
                inBrackets = false;
                continue;
            }
            if (!(inBrackets || ch != '%' && ch != '_')) {
                if (escapeCharacter != '\u0000') {
                    sqlPat[i++] = escapeCharacter;
                    sqlPat[i++] = ch;
                    continue;
                }
                sqlPat[i++] = 91;
                sqlPat[i++] = ch;
                sqlPat[i++] = 93;
                continue;
            }
            sqlPat[i++] = ch;
        }
        return new String(sqlPat, 0, i);
    }

    public char sqlEscapeChar() {
        return '\\';
    }

    public String sqlPatternFromShellPattern(String pattern) {
        return this.sqlPatternFromShellPatternWithEscapeCharacter(pattern, this.sqlEscapeChar());
    }

    public abstract NSMutableDictionary bindVariableDictionaryForAttribute(EOAttribute var1, Object var2);

    public boolean shouldUseBindVariableForAttribute(EOAttribute attribute) {
        return false;
    }

    public boolean mustUseBindVariableForAttribute(EOAttribute attribute) {
        return false;
    }

    public static boolean useQuotedExternalNames() {
        return false;
    }

    public static void setUseQuotedExternalNames(boolean bool) {
    }

    public String externalNameQuoteCharacter() {
        return "";
    }

    public boolean useBindVariables() {
        if (UseBindings == -1) {
            UseBindings = NSProperties.getProperty((String)"EOAdaptorUseBindVariables") == null ? 1 : (NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)"EOAdaptorUseBindVariables")) ? 1 : 0);
        }
        return UseBindings == 1;
    }

    public void setUseBindVariables(boolean flag) {
        UseBindings = flag ? 1 : 0;
    }

    public NSArray bindVariableDictionaries() {
        if (this._bindings == null) {
            return NSArray.EmptyArray;
        }
        return this._bindings;
    }

    public void addBindVariableDictionary(NSDictionary binding) {
        if (this._bindings == null) {
            this._bindings = new NSMutableArray();
        }
        this._bindings.addObject((Object)binding);
    }

    public void addCreateClauseForAttribute(EOAttribute attribute) {
        String str = _NSStringUtilities.concat((String)attribute.columnName(), (String)" ", (String)this.columnTypeStringForAttribute(attribute), (String)" ", (String)this.allowsNullClauseForConstraint(attribute.allowsNull()));
        this.appendItemToListString(str, this._listString());
    }

    public void prepareConstraintStatementForRelationship(EORelationship relationship, NSArray sourceColumns, NSArray destinationColumns) {
        EOModel destModel;
        EOEntity entity = relationship.entity();
        String tableName = entity.externalName();
        int lastDot = tableName.lastIndexOf(46);
        if (lastDot >= 0) {
            tableName = tableName.substring(lastDot + 1);
        }
        String constraintName = _NSStringUtilities.concat((String)tableName, (String)"_", (String)relationship.name(), (String)"_FK");
        String sourceKeyList = sourceColumns.componentsJoinedByString(", ");
        String destinationKeyList = destinationColumns.componentsJoinedByString(", ");
        EOModel sourceModel = entity.model();
        if (sourceModel != (destModel = relationship.destinationEntity().model()) && !sourceModel.connectionDictionary().equals((Object)destModel.connectionDictionary())) {
            throw new IllegalArgumentException("prepareConstraintStatementForRelationship unable to create a constraint for " + relationship.name() + " because the source and destination entities reside in different databases");
        }
        this.setStatement("ALTER TABLE " + entity.externalName() + " ADD CONSTRAINT " + constraintName + " FOREIGN KEY (" + sourceKeyList + ") REFERENCES " + relationship.destinationEntity().externalName() + " (" + destinationKeyList + ")");
    }

    public String columnTypeStringForAttribute(EOAttribute attribute) {
        if (attribute.precision() != 0) {
            String precision = String.valueOf(attribute.precision());
            String scale = String.valueOf(attribute.scale());
            return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)precision, (String)",", (String)scale, (String)")");
        }
        if (attribute.width() != 0) {
            String width = String.valueOf(attribute.width());
            return _NSStringUtilities.concat((String)attribute.externalType(), (String)"(", (String)width, (String)")");
        }
        return attribute.externalType();
    }

    public String allowsNullClauseForConstraint(boolean flag) {
        return flag ? "" : "NOT NULL";
    }

    public static String sqlStringForString(String string) {
        return string;
    }

    public static String sqlStringForNumber(Number number) {
        return number.toString();
    }

    public String sqlStringForQualifier(EOQualifierSQLGeneration qualifier) {
        return qualifier.sqlStringForSQLExpression(this);
    }

    public String sqlStringForData(NSData data) {
        return data._hexString();
    }

    static {
        Class clazz = _EOPrivate.class;
        UseBindings = -1;
    }

    public static interface SQLValue {
        public String valueForSQLExpression(EOSQLExpression var1);
    }
}

