/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSUtilities;

public class EOSQLExpressionFactory {
    protected EOAdaptor _adaptor;
    protected Class _expressionClass;
    private static final Class[] expressionParameterTypes = new Class[]{EOEntity.class};

    public EOSQLExpressionFactory(EOAdaptor adaptor) {
        this._adaptor = adaptor;
        this._expressionClass = adaptor.expressionClass();
    }

    private EOSQLExpressionFactory() {
    }

    public EOAdaptor adaptor() {
        return this._adaptor;
    }

    public Class expressionClass() {
        return this._expressionClass;
    }

    public EOSQLExpression createExpression(EOEntity entity) {
        return (EOSQLExpression)_NSUtilities.instantiateObject((Class)this.expressionClass(), (Class[])expressionParameterTypes, (Object[])new Object[]{entity}, (boolean)true, (boolean)false);
    }

    public EOSQLExpression expressionForString(String string) {
        EOSQLExpression expr = this.createExpression(null);
        expr.setStatement(string);
        return expr;
    }

    public EOSQLExpression expressionForEntity(EOEntity entity) {
        return this.createExpression(entity);
    }

    public EOSQLExpression insertStatementForRow(NSDictionary row, EOEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("insertStatementForRow: entity may not be null");
        }
        EOSQLExpression newExpression = this.expressionForEntity(entity);
        newExpression.setUseAliases(false);
        newExpression.prepareInsertExpressionWithRow(row);
        return newExpression;
    }

    public EOSQLExpression updateStatementForRow(NSDictionary row, EOQualifier qualifier, EOEntity entity) {
        if (row.count() == 0) {
            throw new IllegalArgumentException("updateStatementForRow: nothing to update");
        }
        if (entity == null) {
            throw new IllegalArgumentException("updateStatementForRow: entity may not be null");
        }
        if (qualifier == null) {
            throw new IllegalArgumentException("updateStatementForRow: qualifier may not be null");
        }
        EOSQLExpression newExpression = this.expressionForEntity(entity);
        newExpression.setUseAliases(false);
        newExpression.prepareUpdateExpressionWithRow(row, qualifier);
        return newExpression;
    }

    public EOSQLExpression deleteStatementWithQualifier(EOQualifier qualifier, EOEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("deleteStatementWithQualifier: entity may not be null");
        }
        if (qualifier == null) {
            throw new IllegalArgumentException("deleteStatementWithQualifier: qualifier may not be null");
        }
        EOSQLExpression newExpression = this.expressionForEntity(entity);
        newExpression.setUseAliases(false);
        newExpression.prepareDeleteExpressionForQualifier(qualifier);
        return newExpression;
    }

    public EOSQLExpression selectStatementForAttributes(NSArray attributes, boolean yn, EOFetchSpecification fetchSpec, EOEntity entity) {
        if (attributes.count() == 0) {
            throw new IllegalArgumentException("selectStatementForAttributes: nothing to select");
        }
        if (fetchSpec == null) {
            throw new IllegalArgumentException("selectStatementForAttributes: fetchSpecification is null");
        }
        if (entity == null) {
            throw new IllegalArgumentException("selectStatementForAttributes: invalid (null) entity");
        }
        EOSQLExpression newExpression = this.expressionForEntity(entity);
        newExpression.setUseAliases(true);
        newExpression.prepareSelectExpressionWithAttributes(attributes, yn, fetchSpec);
        return newExpression;
    }
}

