/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eoaccess._EOPrivate;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;

public class EOUtilities {
    private EOUtilities() {
    }

    public static NSArray objectsForEntityNamed(EOEditingContext ec, String name) {
        EOFetchSpecification fetchSpec = new EOFetchSpecification(name, null, null);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        return results;
    }

    public static NSArray objectsOfClass(EOEditingContext ec, Class aClass) {
        EOEntity entity = EOUtilities.entityForClass(ec, aClass);
        NSArray results = EOUtilities.objectsForEntityNamed(ec, entity.name());
        return results;
    }

    public static NSArray objectsWithFetchSpecificationAndBindings(EOEditingContext ec, String entityName, String fetchSpecName, NSDictionary bindings) {
        EOModelGroup modelGroup = EOUtilities.modelGroup(ec);
        EOFetchSpecification unboundFetchSpec = modelGroup.fetchSpecificationNamed(fetchSpecName, entityName);
        if (unboundFetchSpec == null) {
            throw new EOObjectNotAvailableException("objectsWithFetchSpecificationNamedEntityNamedBindings: Fetch specification '" + fetchSpecName + "' not found in entity named '" + entityName + "'");
        }
        EOFetchSpecification boundFetchSpec = unboundFetchSpec.fetchSpecificationWithQualifierBindings(bindings);
        NSArray results = ec.objectsWithFetchSpecification(boundFetchSpec);
        return results;
    }

    public static NSArray objectsWithQualifierFormat(EOEditingContext ec, String entityName, String format, NSArray args) {
        EOQualifier qualifier = EOQualifier.qualifierWithQualifierFormat((String)format, (NSArray)args);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(entityName, qualifier, null);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        return results;
    }

    public static NSArray objectsMatchingKeyAndValue(EOEditingContext ec, String entityName, String key, Object value) {
        NSDictionary dict = new NSDictionary(value, (Object)key);
        NSArray results = EOUtilities.objectsMatchingValues(ec, entityName, dict);
        return results;
    }

    public static NSArray objectsMatchingValues(EOEditingContext ec, String name, NSDictionary values) {
        EOQualifier qualifier = EOQualifier.qualifierToMatchAllValues((NSDictionary)values);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(name, qualifier, null);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        return results;
    }

    public static EOEnterpriseObject objectWithFetchSpecificationAndBindings(EOEditingContext ec, String entityName, String fetchSpecName, NSDictionary bindings) {
        NSArray results = EOUtilities.objectsWithFetchSpecificationAndBindings(ec, entityName, fetchSpecName, bindings);
        switch (results.count()) {
            case 0: {
                throw new EOObjectNotAvailableException("objectWithFetchSpecificationNamedEntityNamedBindings: No item selected for fetch specification " + fetchSpecName + " in entity " + entityName + " with bindings " + bindings);
            }
            case 1: {
                return (EOEnterpriseObject)results.objectAtIndex(0);
            }
        }
        throw new MoreThanOneException("objectWithFetchSpecificationNamedEntityNamedBindings: Selected more than one item for fetch specification " + fetchSpecName + " in entity " + entityName + " with bindings " + bindings);
    }

    public static EOEnterpriseObject objectWithQualifierFormat(EOEditingContext ec, String name, String format, NSArray args) {
        EOQualifier qualifier = EOQualifier.qualifierWithQualifierFormat((String)format, (NSArray)args);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(name, qualifier, null);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        switch (results.count()) {
            case 0: {
                throw new EOObjectNotAvailableException("objectWithQualifierFormat: No item selected for entity " + name + " qualified by " + qualifier);
            }
            case 1: {
                return (EOEnterpriseObject)results.objectAtIndex(0);
            }
        }
        throw new MoreThanOneException("objectWithQualifierFormat: Selected more than one item for entity " + name + " qualified by " + qualifier);
    }

    public static EOEnterpriseObject objectMatchingKeyAndValue(EOEditingContext ec, String name, String key, Object value) {
        NSArray results = EOUtilities.objectsMatchingKeyAndValue(ec, name, key, value);
        int count = results.count();
        if (count == 0) {
            throw new EOObjectNotAvailableException("objectMatchingValueForKeyEntityNamed: No " + name + " found with key " + key + " matching " + value);
        }
        if (count > 1) {
            throw new MoreThanOneException("objectMatchingValueForKeyEntityNamed: Selected more than one " + name + " with key " + key + " matching " + value);
        }
        return (EOEnterpriseObject)results.objectAtIndex(0);
    }

    public static EOEnterpriseObject objectMatchingValues(EOEditingContext ec, String name, NSDictionary values) {
        NSArray results = EOUtilities.objectsMatchingValues(ec, name, values);
        int count = results.count();
        if (count == 0) {
            throw new EOObjectNotAvailableException("objectMatchingValuesEntityNamed: No " + name + " found matching " + values);
        }
        if (count > 1) {
            throw new MoreThanOneException("objectMatchingValuesEntityNamed: Selected more than one " + name + " matching " + values);
        }
        return (EOEnterpriseObject)results.objectAtIndex(0);
    }

    private static NSDictionary _primaryKeyDictionary(EOEditingContext ec, String entityName, Object value) {
        EOEntity entity = EOUtilities.entityNamed(ec, entityName);
        if (entity == null) {
            throw new IllegalArgumentException("Could not find an entity named " + entityName);
        }
        NSArray primaryKeyAttributes = entity.primaryKeyAttributes();
        if (primaryKeyAttributes.count() != 1) {
            throw new IllegalArgumentException("The entity " + entityName + " requires a compond primary key.");
        }
        return new NSDictionary(value, (Object)((EOAttribute)primaryKeyAttributes.objectAtIndex(0)).name());
    }

    public static EOEnterpriseObject faultWithPrimaryKeyValue(EOEditingContext ec, String entityName, Object value) {
        NSDictionary primaryKey = EOUtilities._primaryKeyDictionary(ec, entityName, value);
        return EOUtilities.faultWithPrimaryKey(ec, entityName, primaryKey);
    }

    public static EOEnterpriseObject faultWithPrimaryKey(EOEditingContext ec, String entityName, NSDictionary pkDict) {
        EOEntity entity = EOUtilities.entityNamed(ec, entityName);
        EOGlobalID globalID = entity.globalIDForRow(pkDict);
        EOEnterpriseObject result = ec.faultForGlobalID(globalID, ec);
        return result;
    }

    public static EOEnterpriseObject objectWithPrimaryKeyValue(EOEditingContext ec, String entityName, Object value) {
        NSDictionary primaryKey = EOUtilities._primaryKeyDictionary(ec, entityName, value);
        return EOUtilities.objectWithPrimaryKey(ec, entityName, primaryKey);
    }

    public static EOEnterpriseObject objectWithPrimaryKey(EOEditingContext ec, String entityName, NSDictionary pkDict) {
        NSArray results;
        EOEntity entity = EOUtilities.entityNamed(ec, entityName);
        EOQualifier qual = entity.qualifierForPrimaryKey(pkDict);
        if (qual != null) {
            EOFetchSpecification fetchSpec = new EOFetchSpecification(entityName, qual, null);
            results = ec.objectsWithFetchSpecification(fetchSpec);
        } else {
            results = NSArray.EmptyArray;
        }
        switch (results.count()) {
            case 0: {
                throw new EOObjectNotAvailableException("No item selected for primary key " + pkDict + " in entity " + entityName + ".");
            }
            case 1: {
                return (EOEnterpriseObject)results.objectAtIndex(0);
            }
        }
        throw new MoreThanOneException("Selected more than one item for primary key " + pkDict + " in entity " + entityName + ".");
    }

    public static NSArray rawRowsWithQualifierFormat(EOEditingContext ec, String name, String format, NSArray args) {
        EOQualifier qualifier = EOQualifier.qualifierWithQualifierFormat((String)format, (NSArray)args);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(name, qualifier, null);
        fetchSpec.setFetchesRawRows(true);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        return results;
    }

    public static NSArray rawRowsMatchingKeyAndValue(EOEditingContext ec, String name, String key, Object value) {
        NSDictionary valueDict = new NSDictionary(value, (Object)key);
        NSArray results = EOUtilities.rawRowsMatchingValues(ec, name, valueDict);
        return results;
    }

    public static NSArray rawRowsMatchingValues(EOEditingContext ec, String name, NSDictionary values) {
        EOQualifier qualifier = EOQualifier.qualifierToMatchAllValues((NSDictionary)values);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(name, qualifier, null);
        fetchSpec.setFetchesRawRows(true);
        NSArray results = ec.objectsWithFetchSpecification(fetchSpec);
        return results;
    }

    public static NSArray rawRowsForSQL(EOEditingContext ec, String modelName, String sqlString) {
        return EOUtilities.rawRowsForSQL(ec, modelName, sqlString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray rawRowsForSQL(EOEditingContext ec, String modelName, String sqlString, NSArray keys) {
        NSArray results = NSArray.EmptyArray;
        if (keys == null) {
            keys = NSArray.EmptyArray;
        }
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed(ec, modelName);
        databaseContext.lock();
        try {
            results = EOUtilities._rawRowsForSQL(databaseContext, ec, sqlString, keys);
        }
        catch (Exception localException) {
            if (databaseContext._delegateHandledDatabaseException(localException)) {
                results = EOUtilities._rawRowsForSQL(databaseContext, ec, sqlString, keys);
            } else if (databaseContext._isDroppedConnectionException(localException)) {
                try {
                    databaseContext.database().handleDroppedConnection();
                    results = EOUtilities._rawRowsForSQL(databaseContext, ec, sqlString, keys);
                }
                catch (Exception ex) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
            } else {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
        finally {
            databaseContext.unlock();
        }
        return results;
    }

    private static NSArray _rawRowsForSQL(EODatabaseContext databaseContext, EOEditingContext ec, String sqlString, NSArray keys) {
        NSMutableArray results = null;
        EODatabaseChannel databaseChannel = databaseContext.availableChannel();
        EOAdaptorChannel adaptorChannel = databaseChannel.adaptorChannel();
        if (!adaptorChannel.isOpen()) {
            adaptorChannel.openChannel();
        }
        adaptorChannel.evaluateExpression(adaptorChannel.adaptorContext().adaptor().expressionFactory().expressionForString(sqlString));
        try {
            NSMutableDictionary row;
            NSArray descResults = adaptorChannel.describeResults();
            int resCount = descResults.count();
            int keyCount = keys.count();
            if (keyCount > resCount) {
                keyCount = resCount;
            }
            for (int i = 0; i < keyCount; ++i) {
                EOAttribute attr = (EOAttribute)descResults.objectAtIndex(i);
                attr.setName((String)keys.objectAtIndex(i));
            }
            adaptorChannel.setAttributesToFetch(descResults);
            results = new NSMutableArray();
            while ((row = adaptorChannel.fetchRow()) != null) {
                results.addObject((Object)row);
            }
        }
        catch (EOGeneralAdaptorException e) {
            adaptorChannel.cancelFetch();
            throw e;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray rawRowsForStoredProcedureNamed(EOEditingContext ec, String name, NSDictionary args) {
        NSArray results = NSArray.EmptyArray;
        EOStoredProcedure storedProcedure = EOUtilities.modelGroup(ec).storedProcedureNamed(name);
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed(ec, storedProcedure.model().name());
        databaseContext.lock();
        try {
            results = EOUtilities._rawRowsForStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
        }
        catch (Exception localException) {
            if (databaseContext._delegateHandledDatabaseException(localException)) {
                results = EOUtilities._rawRowsForStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
            } else if (databaseContext._isDroppedConnectionException(localException)) {
                try {
                    databaseContext.database().handleDroppedConnection();
                    results = EOUtilities._rawRowsForStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
                }
                catch (Exception ex) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
            } else {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
        finally {
            databaseContext.unlock();
        }
        return results;
    }

    private static NSArray _rawRowsForStoredProcedureNamed(EODatabaseContext databaseContext, EOEditingContext ec, EOStoredProcedure storedProcedure, NSDictionary args) {
        NSMutableArray results = null;
        EODatabaseChannel databaseChannel = databaseContext.availableChannel();
        EOAdaptorChannel adaptorChannel = databaseChannel.adaptorChannel();
        if (!adaptorChannel.isOpen()) {
            adaptorChannel.openChannel();
        }
        adaptorChannel.executeStoredProcedure(storedProcedure, args);
        try {
            NSMutableDictionary row;
            adaptorChannel.setAttributesToFetch(adaptorChannel.describeResults());
            results = new NSMutableArray();
            while ((row = adaptorChannel.fetchRow()) != null) {
                results.addObject((Object)row);
            }
        }
        catch (EOGeneralAdaptorException e) {
            adaptorChannel.cancelFetch();
            throw e;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDictionary executeStoredProcedureNamed(EOEditingContext ec, String name, NSDictionary args) {
        NSDictionary results = NSDictionary.EmptyDictionary;
        EOStoredProcedure storedProcedure = EOUtilities.modelGroup(ec).storedProcedureNamed(name);
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed(ec, storedProcedure.model().name());
        databaseContext.lock();
        try {
            results = EOUtilities._executeStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
        }
        catch (Exception localException) {
            if (databaseContext._delegateHandledDatabaseException(localException)) {
                results = EOUtilities._executeStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
            } else if (databaseContext._isDroppedConnectionException(localException)) {
                try {
                    databaseContext.database().handleDroppedConnection();
                    results = EOUtilities._executeStoredProcedureNamed(databaseContext, ec, storedProcedure, args);
                }
                catch (Exception ex) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
            } else {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
            }
            NSLog._conditionallyLogPrivateException((Throwable)localException);
        }
        finally {
            databaseContext.unlock();
        }
        return results;
    }

    private static NSDictionary _executeStoredProcedureNamed(EODatabaseContext databaseContext, EOEditingContext ec, EOStoredProcedure storedProcedure, NSDictionary args) {
        NSDictionary returnValues = null;
        EODatabaseChannel databaseChannel = databaseContext.availableChannel();
        EOAdaptorChannel adaptorChannel = databaseChannel.adaptorChannel();
        if (!adaptorChannel.isOpen()) {
            adaptorChannel.openChannel();
        }
        adaptorChannel.executeStoredProcedure(storedProcedure, args);
        returnValues = adaptorChannel.returnValuesForLastStoredProcedureInvocation();
        return returnValues;
    }

    public static EOEnterpriseObject objectFromRawRow(EOEditingContext ec, String name, NSDictionary row) {
        return ec.faultForRawRow(row, name);
    }

    public static EODatabaseContext databaseContextForModelNamed(EOEditingContext ec, String name) {
        EOModelGroup modelGroup = EOUtilities.modelGroup(ec);
        EOModel model = modelGroup.modelNamed(name);
        if (model == null) {
            throw new EOObjectNotAvailableException("databaseContextForModelNamed: cannot find model named " + name + " associated with this EOEditingContext");
        }
        EODatabaseContext databaseContext = EODatabaseContext.registeredDatabaseContextForModel(model, ec);
        return databaseContext;
    }

    public static void connectWithModelNamed(EOEditingContext ec, String name, NSDictionary overrides) {
        EOModel model = EOUtilities.modelGroup(ec).modelNamed(name);
        if (model == null) {
            throw new EOObjectNotAvailableException("connectWithModelNamedConnectionDictionaryOverrides: cannot find model named " + name + " associated with this EOEditingContext");
        }
        EODatabaseContext.forceConnectionWithModel(model, overrides, ec);
    }

    public static EOEnterpriseObject createAndInsertInstance(EOEditingContext ec, String entityName) {
        EOClassDescription classDescription = EOClassDescription.classDescriptionForEntityName((String)entityName);
        if (classDescription == null) {
            throw new IllegalArgumentException("Could not find EOClassDescription for entity name '" + entityName + "' !");
        }
        EOEnterpriseObject object = classDescription.createInstanceWithEditingContext(ec, null);
        ec.insertObject(object);
        return object;
    }

    public static NSDictionary primaryKeyForObject(EOEditingContext ec, EOEnterpriseObject object) {
        EOEntity entity = EOUtilities.entityForObject(ec, object);
        EOGlobalID globalID = ec.globalIDForObject(object);
        if (globalID == null || entity == null) {
            return null;
        }
        return entity.primaryKeyForGlobalID(globalID);
    }

    public static EOQualifier qualifierForEnterpriseObject(EOEditingContext ec, EOEnterpriseObject object) {
        NSDictionary pk = EOUtilities.primaryKeyForObject(ec, object);
        if (pk == null) {
            throw new IllegalArgumentException("Cannot determine the primary key for :" + object);
        }
        EOEntity entity = EOUtilities.entityForObject(ec, object);
        return entity.qualifierForPrimaryKey(pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDictionary destinationKeyForSourceObject(EOEditingContext ec, EOEnterpriseObject object, String name) {
        NSMutableDictionary result = null;
        EOEntity sourceEntity = EOUtilities.entityForObject(ec, object);
        EORelationship relationship = sourceEntity.relationshipNamed(name);
        if (relationship == null) {
            throw new EOObjectNotAvailableException("destinationKeyForSourceObjectRelationshipNamed: entity " + sourceEntity.name() + " does not have relationship named " + name);
        }
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed(ec, sourceEntity.model().name());
        databaseContext.lock();
        try {
            EODatabase database = databaseContext.database();
            NSDictionary snapshot = database.snapshotForGlobalID(ec.globalIDForObject(object));
            NSArray joins = relationship.joins();
            int count = joins.count();
            result = new NSMutableDictionary(count);
            for (int i = 0; i < count; ++i) {
                EOJoin join = (EOJoin)joins.objectAtIndex(i);
                String sourceAttributeName = join.sourceAttribute().name();
                String destinationAttributeName = join.destinationAttribute().name();
                result.setObjectForKey(snapshot.objectForKey((Object)sourceAttributeName), (Object)destinationAttributeName);
            }
        }
        finally {
            databaseContext.unlock();
        }
        return result;
    }

    public static EOEnterpriseObject localInstanceOfObject(EOEditingContext ec, EOEnterpriseObject object) {
        if (object != null && ec != null) {
            EOEditingContext otherEditingContext = object.editingContext();
            if (otherEditingContext == null) {
                throw new IllegalArgumentException("The EOEnterpriseObject " + object + " is not in an EOEditingContext.");
            }
            EOGlobalID globalID = otherEditingContext.globalIDForObject(object);
            return ec.faultForGlobalID(globalID, ec);
        }
        return null;
    }

    public static NSArray localInstancesOfObjects(EOEditingContext ec, NSArray objects) {
        if (objects == null) {
            return NSArray.EmptyArray;
        }
        int count = objects.count();
        NSMutableArray results = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            EOEnterpriseObject localInstance = EOUtilities.localInstanceOfObject(ec, (EOEnterpriseObject)objects.objectAtIndex(i));
            if (localInstance == null) {
                throw new IllegalArgumentException("Unable to create a local instance of the EO at index " + i + " in the destination EOEditingContext.");
            }
            results.addObject((Object)localInstance);
        }
        return results;
    }

    public static EOModelGroup modelGroup(EOEditingContext ec) {
        EOObjectStore rootObjectStore = ec.rootObjectStore();
        if (!(rootObjectStore instanceof EOObjectStoreCoordinator)) {
            throw new IllegalArgumentException("modelGroup: an EOEditingContext's root object store must be an EOObjectStoreCoordinator for this method to function.");
        }
        EOObjectStoreCoordinator objectStoreCoordinator = (EOObjectStoreCoordinator)rootObjectStore;
        EOModelGroup modelGroup = EOModelGroup.modelGroupForObjectStoreCoordinator(objectStoreCoordinator);
        return modelGroup;
    }

    public static EOEntity entityNamed(EOEditingContext ec, String name) {
        EOModelGroup modelGroup = EOUtilities.modelGroup(ec);
        EOEntity entity = modelGroup.entityNamed(name);
        if (entity == null) {
            throw new EOObjectNotAvailableException("entityNamed: could not find entity named:" + name);
        }
        return entity;
    }

    public static EOEntity entityForClass(EOEditingContext ec, Class theClass) {
        EOEntity result = null;
        String className = theClass.getName();
        EOModelGroup modelGroup = EOUtilities.modelGroup(ec);
        NSArray models = modelGroup.models();
        int modelCount = models.count();
        for (int i = 0; i < modelCount; ++i) {
            EOModel model = (EOModel)models.objectAtIndex(i);
            NSArray entities = model.entities();
            int entityCount = entities.count();
            for (int j = 0; j < entityCount; ++j) {
                EOEntity entity = (EOEntity)entities.objectAtIndex(j);
                String entityClassName = entity.className();
                boolean matchesClassName = className.equals(entityClassName);
                if (!matchesClassName) continue;
                if (result != null) {
                    throw new MoreThanOneException("entityForClass found more than one entity for class named " + className);
                }
                result = entity;
            }
        }
        if (result == null) {
            throw new EOObjectNotAvailableException("entityForClass could not find entity for class named " + className);
        }
        return result;
    }

    public static EOEntity entityForObject(EOEditingContext ec, EOEnterpriseObject obj) {
        EOClassDescription classDescription = obj.classDescription();
        if (!(classDescription instanceof EOEntityClassDescription)) {
            throw new IllegalArgumentException("entityForObject:" + obj + ": the object's class description must be an EOEntityClassDescription for this method to function.");
        }
        EOEntityClassDescription entityClassDescription = (EOEntityClassDescription)classDescription;
        EOEntity entity = entityClassDescription.entity();
        return entity;
    }

    static {
        Class clazz = _EOPrivate.class;
    }

    public static class MoreThanOneException
    extends RuntimeException {
        public MoreThanOneException(String message) {
            super(message);
        }
    }
}

