/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EODelayedObserver;
import com.webobjects.foundation.NSDelayedCallbackCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;

public class EODelayedObserverQueue {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EODelayedObserverQueue");
    public static final int FlushDelayedObserversRunLoopOrdering = 400000;
    private static final EODelayedObserverQueue _defaultQueue = new EODelayedObserverQueue();
    private static NSSelector _endOfEventSelector = new NSSelector("_processEndOfEventObservers", _NSUtilities._ObjectClassArray);
    private EODelayedObserver[] _queue = new EODelayedObserver[8];
    private int _highestNonEmptyQueue = 8;
    private boolean _haveEntryInNotificationQueue = false;

    public static EODelayedObserverQueue defaultObserverQueue() {
        return _defaultQueue;
    }

    public synchronized void _processEndOfEventObservers(Object arg) {
        this.notifyObserversUpToPriority(6);
        this._haveEntryInNotificationQueue = false;
    }

    public synchronized void enqueueObserver(EODelayedObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("enqueueObserver() passed null argument");
        }
        if (observer._next != null) {
            return;
        }
        int priority = observer.priority();
        if (priority == 0) {
            observer.subjectChanged();
            return;
        }
        EODelayedObserver tail = this._queue[priority];
        if (tail == null) {
            this._queue[priority] = observer;
            observer._next = observer;
        } else {
            observer._next = tail._next;
            tail._next = observer;
        }
        if (priority < this._highestNonEmptyQueue) {
            this._highestNonEmptyQueue = priority;
        }
        if (!this._haveEntryInNotificationQueue) {
            NSDelayedCallbackCenter.defaultCenter().performSelector(_endOfEventSelector, (Object)this, null, 400000);
            this._haveEntryInNotificationQueue = true;
        }
    }

    public synchronized void dequeueObserver(EODelayedObserver observer) {
        if (observer == null || observer._next == null) {
            return;
        }
        int priority = observer.priority();
        if (this._queue[priority] == observer) {
            EODelayedObserver tail = observer._next;
            if (tail == observer) {
                this._queue[priority] = null;
            } else {
                while (tail._next != observer) {
                    tail = tail._next;
                }
                tail._next = observer._next;
                this._queue[priority] = observer._next;
            }
            observer._next = null;
        } else {
            EODelayedObserver tail = observer;
            while (tail != null) {
                if (tail._next == observer) {
                    tail._next = observer._next;
                    observer._next = null;
                    return;
                }
                tail = tail._next;
            }
        }
    }

    public synchronized void notifyObserversUpToPriority(int lastPriority) {
        while (this._highestNonEmptyQueue <= lastPriority) {
            EODelayedObserver tail = this._queue[this._highestNonEmptyQueue];
            if (tail != null) {
                EODelayedObserver head;
                if (tail._next == tail) {
                    head = tail;
                    this._queue[this._highestNonEmptyQueue] = null;
                    ++this._highestNonEmptyQueue;
                } else {
                    head = tail._next;
                    tail._next = head._next;
                }
                head.subjectChanged();
                head._next = null;
                continue;
            }
            ++this._highestNonEmptyQueue;
        }
    }
}

