/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierVariable;
import com.webobjects.eocontrol.EOQualifierVisitor;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;

public class EOKeyValueQualifier
extends EOQualifier
implements NSCoding,
EOKeyValueArchiving {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOKeyValueQualifier");
    static final long serialVersionUID = -4655390252823524124L;
    private static final String SerializationKeyFieldKey = "key";
    private static final String SerializationSelectorNameFieldKey = "selectorName";
    private static final String SerializationValueFieldKey = "value";
    protected NSSelector _selector;
    protected String _key;
    protected Object _value;
    protected transient String _lowercaseCache;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("key", _NSUtilities._StringClass), new ObjectStreamField("selectorName", _NSUtilities._StringClass), new ObjectStreamField("value", _NSUtilities._ObjectClass)};

    public EOKeyValueQualifier(String key, NSSelector selector, Object value) {
        this._key = key;
        this._selector = selector;
        this._value = value == null ? NSKeyValueCoding.NullValue : value;
    }

    public boolean equals(Object other) {
        if (other instanceof EOKeyValueQualifier) {
            EOKeyValueQualifier kvq = (EOKeyValueQualifier)other;
            return this._key.equals(kvq._key) && this._value.equals(kvq._value) && this._selector.equals((Object)kvq._selector);
        }
        return false;
    }

    public boolean evaluateWithObject(Object object) {
        Object objectValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)this._key);
        if (this._value instanceof EOQualifierVariable) {
            throw new IllegalStateException("Error evaluating qualifier with key " + this._key + ", selector " + this._selector + ", value " + this._value + " - value must be substitued for variable before evaluating");
        }
        if (this._selector.equals((Object)EOQualifier.QualifierOperatorCaseInsensitiveLike)) {
            if (this._lowercaseCache == null) {
                this._lowercaseCache = this._value != NSKeyValueCoding.NullValue ? this._value.toString().toLowerCase() : "";
            }
            return _NSStringUtilities.stringMatchesPattern((String)(objectValue != null && objectValue != NSKeyValueCoding.NullValue ? objectValue.toString() : ""), (String)this._lowercaseCache, (boolean)true);
        }
        return EOQualifier.ComparisonSupport.compareValues(objectValue != null ? objectValue : NSKeyValueCoding.NullValue, this._value, this._selector);
    }

    public String key() {
        return this._key;
    }

    public Object value() {
        return this._value;
    }

    public NSSelector selector() {
        return this._selector;
    }

    public String toString() {
        String valueString = this._value == NSKeyValueCoding.NullValue ? "null" : (this._value instanceof String ? "'" + (String)this._value + "'" : (this._value instanceof Number && !(this._value instanceof BigDecimal) ? this._value.toString() : (this._value instanceof EOQualifierVariable ? "$" + ((EOQualifierVariable)this._value).key() : "(" + (this._value != null ? this._value.getClass().getName() : "null") + ")" + _NSStringUtilities.quotedStringWithQuote((String)(this._value != null ? this._value.toString() : "null"), (char)'\''))));
        return "(" + this._key + " " + EOKeyValueQualifier.stringForOperatorSelector(this._selector) + " " + valueString + ")";
    }

    public void validateKeysWithRootClassDescription(EOClassDescription classDesc) {
        EOQualifier._validateKeyWithRootClassDescription(classDesc, this._key);
    }

    public EOQualifier qualifierWithBindings(NSDictionary bindings, boolean requiresAll) {
        if (this._value instanceof EOQualifierVariable) {
            Object realValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)bindings, (String)((EOQualifierVariable)this._value).key());
            if (realValue != null) {
                return new EOKeyValueQualifier(this._key, this._selector, realValue);
            }
            if (requiresAll) {
                throw new EOQualifier.QualifierVariableSubstitutionException("Error in variable substitution: value for variable " + this._value + " not found");
            }
            return null;
        }
        return this;
    }

    void _addBindingsToDictionary(NSMutableDictionary dict) {
        if (this._value instanceof EOQualifierVariable) {
            dict.setObjectForKey((Object)this._key, (Object)((EOQualifierVariable)this._value).key());
        }
    }

    public void addQualifierKeysToSet(NSMutableSet qualKeys) {
        if (this._key != null) {
            qualKeys.addObject((Object)this._key);
        }
    }

    public Class classForCoder() {
        return this.getClass();
    }

    public static Object decodeObject(NSCoder coder) {
        String key = (String)coder.decodeObject();
        NSSelector selector = EOQualifier.operatorSelectorForString((String)coder.decodeObject());
        Object value = coder.decodeObject();
        return new EOKeyValueQualifier(key, selector, value);
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObject((Object)this._key);
        coder.encodeObject((Object)this._selector.name());
        coder.encodeObject(this._value);
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
        archiver.encodeObject(this._key, SerializationKeyFieldKey);
        archiver.encodeObject(this._selector.name(), SerializationSelectorNameFieldKey);
        archiver.encodeObject(this._value, SerializationValueFieldKey);
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        return new EOKeyValueQualifier((String)unarchiver.decodeObjectForKey(SerializationKeyFieldKey), EOQualifier.operatorSelectorForSelectorNamed((String)unarchiver.decodeObjectForKey(SerializationSelectorNameFieldKey)), unarchiver.decodeObjectForKey(SerializationValueFieldKey));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationKeyFieldKey, this._key);
        if (this._selector != null) {
            fields.put(SerializationSelectorNameFieldKey, this._selector.name());
        }
        if (this._value != null && this._value != NSKeyValueCoding.NullValue) {
            fields.put(SerializationValueFieldKey, this._value);
        }
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._key = (String)fields.get(SerializationKeyFieldKey, null);
        String name = (String)fields.get(SerializationSelectorNameFieldKey, null);
        if (name == null || name.length() < 1) {
            throw new StreamCorruptedException("While unarchiving a \"" + this.getClass().getName() + "\" a valid selector name was missing from the stream.");
        }
        this._selector = EOQualifier.operatorSelectorForSelectorNamed(name);
        this._value = fields.get(SerializationValueFieldKey, NSKeyValueCoding.NullValue);
        this._value = this._value == null ? NSKeyValueCoding.NullValue : this._value;
    }

    public void _accept(EOQualifierVisitor visitor, boolean isPostOrder) {
        visitor.visitKeyValueQualifier(this);
    }
}

