/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;

public class EOObjectStoreCoordinator
extends EOObjectStore {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOObjectStoreCoordinator");
    public static final String CooperatingObjectStoreWasAddedNotification = "EOCooperatingObjectStoreWasAddedNotification";
    public static final String CooperatingObjectStoreWasRemovedNotification = "EOCooperatingObjectStoreWasRemovedNotification";
    public static final String CooperatingObjectStoreNeededNotification = "EOCooperatingObjectStoreNeededNotification";
    public static final String GlobalIDKey = "globalID";
    public static final String FetchSpecificationKey = "fetchSpecification";
    public static final String ObjectKey = "object";
    private static final NSSelector _objectsChangedInSubStoreSelector = new NSSelector("_objectsChangedInSubStore", _NSUtilities._NotificationClassArray);
    private static final NSSelector _invalidatedAllObjectsInSubStoreSelector = new NSSelector("_invalidatedAllObjectsInSubStore", _NSUtilities._NotificationClassArray);
    private static final NSSelector _globalIDsChangedInSubStoreSelector = new NSSelector("_globalIDsChangedInSubStore", _NSUtilities._NotificationClassArray);
    private static EOObjectStoreCoordinator _defaultCoordinator;
    private NSMutableArray _sources = new NSMutableArray();
    private transient NSArray _sourcesImmutableClone;
    private volatile NSDictionary _userInfo;
    private transient int _lockCount;
    private transient NSRecursiveLock _lock = new NSRecursiveLock();

    public static synchronized EOObjectStoreCoordinator defaultCoordinator() {
        if (_defaultCoordinator == null) {
            EOObjectStoreCoordinator.setDefaultCoordinator(new EOObjectStoreCoordinator());
        }
        return _defaultCoordinator;
    }

    public static synchronized void setDefaultCoordinator(EOObjectStoreCoordinator coordinator) {
        if (coordinator == null) {
            coordinator = new EOObjectStoreCoordinator();
        }
        _defaultCoordinator = coordinator;
    }

    public void dispose() {
        super.dispose();
        NSArray sources = this._sources();
        int count = sources.count();
        for (int i = 0; i < count; ++i) {
            this.removeCooperatingObjectStore((EOCooperatingObjectStore)sources.objectAtIndex(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NSArray _sources() {
        NSArray sources = null;
        NSMutableArray nSMutableArray = this._sources;
        synchronized (nSMutableArray) {
            if (this._sourcesImmutableClone == null) {
                this._sourcesImmutableClone = this._sources.immutableClone();
            }
            sources = this._sourcesImmutableClone;
        }
        return sources;
    }

    public NSArray cooperatingObjectStores() {
        return this._sources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCooperatingObjectStore(EOCooperatingObjectStore objectStore) {
        boolean objectStoreAdded = false;
        boolean shouldUnlock = true;
        objectStore.lock();
        try {
            EOObjectStoreCoordinator eOObjectStoreCoordinator = this;
            synchronized (eOObjectStoreCoordinator) {
                if (this._sources.indexOfIdenticalObject((Object)objectStore) < 0) {
                    if (objectStore.coordinator() != null) {
                        throw new IllegalStateException("Cannot add " + objectStore + " to this EOObjectStoreCoordinator because it already has another.");
                    }
                    this._sources.addObject((Object)objectStore);
                    this._sourcesImmutableClone = null;
                    objectStore.setCoordinator(this);
                    objectStoreAdded = true;
                    if (this._lockCount > 0) {
                        shouldUnlock = false;
                    }
                }
            }
        }
        finally {
            if (shouldUnlock) {
                objectStore.unlock();
            }
        }
        if (objectStoreAdded) {
            NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
            notificationCenter.postNotification(CooperatingObjectStoreWasAddedNotification, (Object)this);
            notificationCenter.addObserver((Object)this, _objectsChangedInSubStoreSelector, "EOObjectsChangedInStoreNotification", (Object)objectStore);
            notificationCenter.addObserver((Object)this, _invalidatedAllObjectsInSubStoreSelector, "EOInvalidatedAllObjectsInStoreNotification", (Object)objectStore);
            notificationCenter.addObserver((Object)this, _globalIDsChangedInSubStoreSelector, "EOGlobalIDChangedNotification", (Object)objectStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCooperatingObjectStore(EOCooperatingObjectStore objectStore) {
        boolean objectStoreRemoved = false;
        objectStore.lock();
        try {
            EOObjectStoreCoordinator eOObjectStoreCoordinator = this;
            synchronized (eOObjectStoreCoordinator) {
                int index = this._sources.indexOfIdenticalObject((Object)objectStore);
                if (index >= 0) {
                    this._sources.removeObjectAtIndex(index);
                    this._sourcesImmutableClone = null;
                    objectStoreRemoved = true;
                    if (this._lockCount > 0) {
                        objectStore.unlock();
                    }
                    objectStore.setCoordinator(null);
                }
            }
        }
        finally {
            objectStore.unlock();
        }
        if (objectStoreRemoved) {
            NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
            notificationCenter.postNotification(CooperatingObjectStoreWasRemovedNotification, (Object)this);
            notificationCenter.removeObserver((Object)this, "EOObjectsChangedInStoreNotification", (Object)objectStore);
            notificationCenter.removeObserver((Object)this, "EOInvalidatedAllObjectsInStoreNotification", (Object)objectStore);
            notificationCenter.removeObserver((Object)this, "EOGlobalIDChangedNotification", (Object)objectStore);
        }
    }

    private void requestStore(EOGlobalID gid, EOFetchSpecification fetchSpecification, EOEnterpriseObject object) {
        NSMutableDictionary userInfo = new NSMutableDictionary(3);
        if (gid != null) {
            userInfo.setObjectForKey((Object)gid, (Object)GlobalIDKey);
        }
        if (fetchSpecification != null) {
            userInfo.setObjectForKey((Object)fetchSpecification, (Object)FetchSpecificationKey);
        }
        if (object != null) {
            userInfo.setObjectForKey((Object)object, (Object)ObjectKey);
        }
        NSNotificationCenter.defaultCenter().postNotification(CooperatingObjectStoreNeededNotification, (Object)this, (NSDictionary)userInfo);
    }

    public EOCooperatingObjectStore objectStoreForGlobalID(EOGlobalID gid) {
        int tries = 2;
        while (tries-- > 0) {
            NSArray sources = this._sources();
            int count = sources.count();
            for (int i = 0; i < count; ++i) {
                EOCooperatingObjectStore source = (EOCooperatingObjectStore)sources.objectAtIndex(i);
                if (!source.ownsGlobalID(gid)) continue;
                return source;
            }
            this.requestStore(gid, null, null);
        }
        return null;
    }

    public EOCooperatingObjectStore objectStoreForObject(EOEnterpriseObject object) {
        int tries = 2;
        while (tries-- > 0) {
            NSArray sources = this._sources();
            int count = sources.count();
            for (int i = 0; i < count; ++i) {
                EOCooperatingObjectStore source = (EOCooperatingObjectStore)sources.objectAtIndex(i);
                if (!source.ownsObject(object)) continue;
                return source;
            }
            this.requestStore(null, null, object);
        }
        return null;
    }

    public EOCooperatingObjectStore objectStoreForFetchSpecification(EOFetchSpecification fetchSpecification) {
        int tries = 2;
        while (tries-- > 0) {
            NSArray sources = this._sources();
            int count = sources.count();
            for (int i = 0; i < count; ++i) {
                EOCooperatingObjectStore source = (EOCooperatingObjectStore)sources.objectAtIndex(i);
                if (!source.handlesFetchSpecification(fetchSpecification)) continue;
                return source;
            }
            this.requestStore(null, fetchSpecification, null);
        }
        return null;
    }

    EOCooperatingObjectStore objectStoreForEntityNamed(String entityName) {
        return this.objectStoreForFetchSpecification(new EOFetchSpecification(entityName, null, null, false, false, null));
    }

    public void forwardUpdateForObject(EOEnterpriseObject object, NSDictionary changes) {
        EOCooperatingObjectStore source = this.objectStoreForObject(object);
        if (source != null) {
            source.recordUpdateForObject(object, changes);
        }
    }

    public NSDictionary valuesForKeys(NSArray keys, EOEnterpriseObject object) {
        EOCooperatingObjectStore source = this.objectStoreForObject(object);
        return source != null ? source.valuesForKeys(keys, object) : NSDictionary.EmptyDictionary;
    }

    public void saveChangesInEditingContext(EOEditingContext context) {
        NSArray insertedObjects = context.insertedObjects();
        int i = insertedObjects.count();
        while (i-- > 0) {
            this.objectStoreForObject((EOEnterpriseObject)insertedObjects.objectAtIndex(i));
        }
        NSArray sources = this._sources();
        int count = sources.count();
        RuntimeException exception = null;
        try {
            for (i = 0; i < count; ++i) {
                ((EOCooperatingObjectStore)sources.objectAtIndex(i))._willPrepareForSave();
            }
            for (i = 0; i < count; ++i) {
                ((EOCooperatingObjectStore)sources.objectAtIndex(i)).prepareForSaveWithCoordinator(this, context);
            }
            for (i = 0; i < count; ++i) {
                ((EOCooperatingObjectStore)sources.objectAtIndex(i)).recordChangesInEditingContext();
            }
            for (i = 0; i < count; ++i) {
                ((EOCooperatingObjectStore)sources.objectAtIndex(i)).performChanges();
            }
        }
        catch (RuntimeException localException) {
            NSLog._conditionallyLogPrivateException(exception);
            exception = localException;
        }
        for (i = 0; i < count; ++i) {
            if (exception == null) {
                try {
                    ((EOCooperatingObjectStore)sources.objectAtIndex(i)).commitChanges();
                }
                catch (RuntimeException localException) {
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)65536L)) {
                        NSLog.debug.appendln((Object)("Commit failed on data source of type " + sources.objectAtIndex(i).getClass()));
                        NSLog.debug.appendln((Throwable)localException);
                    }
                    exception = localException;
                }
                continue;
            }
            try {
                ((EOCooperatingObjectStore)sources.objectAtIndex(i)).rollbackChanges();
                continue;
            }
            catch (Exception localException) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)65536L)) continue;
                NSLog.debug.appendln((Object)("Rollback failed on data source of type " + sources.objectAtIndex(i).getClass()));
                NSLog.debug.appendln((Throwable)localException);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        this._lock.lock();
        EOObjectStoreCoordinator eOObjectStoreCoordinator = this;
        synchronized (eOObjectStoreCoordinator) {
            ++this._lockCount;
            if (this._lockCount > 1) {
                return;
            }
        }
        NSArray stores = this.cooperatingObjectStores();
        int c = stores.count();
        for (int i = 0; i < c; ++i) {
            ((EOCooperatingObjectStore)stores.objectAtIndex(i)).lock();
        }
    }

    public NSRecursiveLock _lock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        EOObjectStoreCoordinator eOObjectStoreCoordinator = this;
        synchronized (eOObjectStoreCoordinator) {
            --this._lockCount;
            if (this._lockCount > 0) {
                this._lock.unlock();
                return;
            }
        }
        try {
            NSArray stores = this.cooperatingObjectStores();
            for (int i = stores.count(); i > 0; --i) {
                ((EOCooperatingObjectStore)stores.objectAtIndex(i - 1)).unlock();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public NSArray objectsWithFetchSpecification(EOFetchSpecification fetchSpecification, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForFetchSpecification(fetchSpecification);
        if (source == null) {
            if (fetchSpecification.entityName() == null || fetchSpecification.entityName().length() == 0) {
                throw new IllegalArgumentException("Cannot fetch objects for fetch specification " + fetchSpecification + " because it does not contain an entity name.");
            }
            throw new IllegalArgumentException("An object store for the entity \"" + fetchSpecification.entityName() + "\" could not be found. Verify that the entity is defined in an EOModel, and that the model is installed properly. To see what models are loaded, you can try printing the return value of EOModelGroup.defaultGroup() in your application.");
        }
        return source.objectsWithFetchSpecification(fetchSpecification, editingContext);
    }

    public boolean isObjectLockedWithGlobalID(EOGlobalID gid, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        return source != null ? source.isObjectLockedWithGlobalID(gid, editingContext) : false;
    }

    public void lockObjectWithGlobalID(EOGlobalID gid, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        if (source != null) {
            source.lockObjectWithGlobalID(gid, editingContext);
        }
    }

    public EOEnterpriseObject faultForGlobalID(EOGlobalID gid, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        return source != null ? source.faultForGlobalID(gid, editingContext) : null;
    }

    public EOEnterpriseObject faultForRawRow(NSDictionary row, String entityName, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForEntityNamed(entityName);
        return source != null ? source.faultForRawRow(row, entityName, editingContext) : null;
    }

    public NSArray arrayFaultWithSourceGlobalID(EOGlobalID gid, String relationshipName, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        return source != null ? source.arrayFaultWithSourceGlobalID(gid, relationshipName, editingContext) : null;
    }

    public void initializeObject(EOEnterpriseObject object, EOGlobalID gid, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        if (source != null) {
            source.initializeObject(object, gid, editingContext);
        }
    }

    public void editingContextDidForgetObjectWithGlobalID(EOEditingContext editingContext, EOGlobalID gid) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        if (source != null) {
            source.editingContextDidForgetObjectWithGlobalID(editingContext, gid);
        }
    }

    public NSArray objectsForSourceGlobalID(EOGlobalID gid, String relationshipName, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        return source != null ? source.objectsForSourceGlobalID(gid, relationshipName, editingContext) : NSArray.EmptyArray;
    }

    public void refaultObject(EOEnterpriseObject object, EOGlobalID gid, EOEditingContext editingContext) {
        EOCooperatingObjectStore source = this.objectStoreForGlobalID(gid);
        if (source != null) {
            source.refaultObject(object, gid, editingContext);
        }
    }

    public void invalidateObjectsWithGlobalIDs(NSArray gids) {
        NSArray sources = this._sources();
        int count = sources.count();
        for (int i = 0; i < count; ++i) {
            EOCooperatingObjectStore source = (EOCooperatingObjectStore)sources.objectAtIndex(i);
            source.invalidateObjectsWithGlobalIDs(gids);
        }
    }

    public void invalidateAllObjects() {
        NSArray sources = this._sources();
        int count = sources.count();
        for (int i = 0; i < count; ++i) {
            EOCooperatingObjectStore source = (EOCooperatingObjectStore)sources.objectAtIndex(i);
            source.invalidateAllObjects();
        }
        if (count > 1) {
            NSNotificationCenter.defaultCenter().postNotification("EOInvalidatedAllObjectsInStoreNotification", (Object)this, null);
        }
    }

    public void _objectsChangedInSubStore(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this, notification.userInfo());
    }

    public void _globalIDsChangedInSubStore(NSNotification notification) {
        NSNotificationCenter.defaultCenter().postNotification("EOGlobalIDChangedNotification", (Object)this, notification.userInfo());
    }

    public void _invalidatedAllObjectsInSubStore(NSNotification notification) {
        NSArray sources = this._sources();
        if (sources.count() == 1) {
            NSNotificationCenter.defaultCenter().postNotification("EOInvalidatedAllObjectsInStoreNotification", (Object)this, null);
        }
    }

    public void setUserInfo(NSDictionary userInfo) {
        this._userInfo = userInfo;
    }

    public NSDictionary userInfo() {
        NSDictionary userinfo = this._userInfo;
        return userinfo != null ? userinfo : NSDictionary.EmptyDictionary;
    }
}

