/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObserving;
import com.webobjects.eocontrol._EOPrivateMemento;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSReadReentrantReaderWriterLock;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableArray;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class EOObserverCenter {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOObserverCenter");
    private static final WeakHashMap _observersBySubject = new WeakHashMap(256);
    private static volatile _EOObserverArray _omniscientObservers = null;
    private static final WeakHashMap _threadInfos = new WeakHashMap(8);
    private static WeakReference _lastThread = null;
    private static _ThreadInfo _lastThreadInfo = null;
    private static final _NSReadReentrantReaderWriterLock _lock = new _NSReadReentrantReaderWriterLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static _ThreadInfo _threadInfo() {
        Thread currentThread = Thread.currentThread();
        WeakHashMap weakHashMap = _threadInfos;
        synchronized (weakHashMap) {
            Thread last;
            Thread thread = last = _lastThread != null ? (Thread)_lastThread.get() : null;
            if (last != currentThread) {
                _ThreadInfo threadInfo = (_ThreadInfo)_threadInfos.get(currentThread);
                if (threadInfo == null) {
                    threadInfo = new _ThreadInfo();
                    _threadInfos.put(currentThread, threadInfo);
                }
                _lastThread = new WeakReference<Thread>(currentThread);
                _lastThreadInfo = threadInfo;
            }
            return _lastThreadInfo;
        }
    }

    public static void suppressObserverNotification() {
        _ThreadInfo threadInfo = EOObserverCenter._threadInfo();
        ++threadInfo._notificationSuppressCount;
    }

    public static void enableObserverNotification() {
        _ThreadInfo threadInfo = EOObserverCenter._threadInfo();
        if (threadInfo._notificationSuppressCount == 0) {
            throw new IllegalStateException("EOObserverCenter unbalanced enableObserverNotification");
        }
        --threadInfo._notificationSuppressCount;
    }

    public static int observerNotificationSuppressCount() {
        _ThreadInfo threadInfo = EOObserverCenter._threadInfo();
        return threadInfo._notificationSuppressCount;
    }

    private static void _startReading() {
        _lock.startReading();
    }

    private static void _endReading() {
        _lock.endReading();
    }

    private static void _startWriting() {
        _lock.startWriting();
    }

    private static void _endWriting() {
        _lock.endWriting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addObserver(EOObserving observer, Object eo) {
        if (eo instanceof EOEnterpriseObject) {
            EOEnterpriseObject co = (EOEnterpriseObject)eo;
            if (observer instanceof EOEditingContext) {
                if (observer != co.editingContext()) {
                    throw new IllegalArgumentException("An EOEnterpriseObject may only be in (or observed by) a single EOEditingContext.");
                }
                return;
            }
            ((_EOPrivateMemento)co.opaqueState()).__setAuxillaryObservers(true);
        }
        EOObserverCenter._startWriting();
        try {
            _EOObserverArray observers = (_EOObserverArray)((Object)_observersBySubject.get(eo));
            if (observers == null) {
                observers = new _EOObserverArray();
                _observersBySubject.put(eo, observers);
                observers.addObject(observer);
            } else if (!observers.containsObject(observer)) {
                observers.addObject(observer);
            }
        }
        finally {
            EOObserverCenter._endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObserver(EOObserving observer, Object eo) {
        EOEnterpriseObject co = null;
        if (eo instanceof EOEnterpriseObject) {
            co = (EOEnterpriseObject)eo;
            if (observer instanceof EOEditingContext) {
                return;
            }
        }
        EOObserverCenter._startWriting();
        try {
            _EOObserverArray observers = (_EOObserverArray)((Object)_observersBySubject.get(eo));
            if (observers != null) {
                observers.removeObject(observer);
                if (observers.count() == 0) {
                    _observersBySubject.remove(eo);
                    if (co != null) {
                        ((_EOPrivateMemento)co.opaqueState()).__setAuxillaryObservers(false);
                    }
                }
            }
        }
        finally {
            EOObserverCenter._endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray observersForObject(Object eo) {
        EOEnterpriseObject co;
        EOEditingContext ec;
        NSArray result = NSArray.EmptyArray;
        EOObserverCenter._startReading();
        try {
            _EOObserverArray observers = (_EOObserverArray)((Object)_observersBySubject.get(eo));
            if (observers != null) {
                result = observers.allObjects();
            }
        }
        finally {
            EOObserverCenter._endReading();
        }
        if (eo instanceof EOEnterpriseObject && (ec = (co = (EOEnterpriseObject)eo).editingContext()) != null) {
            result = result.arrayByAddingObject((Object)ec);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOObserving observerForObject(Object eo, Class aClass) {
        if (eo instanceof EOEnterpriseObject) {
            EOEnterpriseObject co = (EOEnterpriseObject)eo;
            if (EOEditingContext._CLASS.isAssignableFrom(aClass)) {
                return co.editingContext();
            }
            if (!((_EOPrivateMemento)co.opaqueState()).__hasAuxillaryObservers()) {
                return null;
            }
        }
        EOObserverCenter._startReading();
        try {
            _EOObserverArray observers = (_EOObserverArray)((Object)_observersBySubject.get(eo));
            EOObserving eOObserving = observers != null ? (EOObserving)observers.objectOfClass(aClass) : null;
            return eOObserving;
        }
        finally {
            EOObserverCenter._endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOmniscientObserver(EOObserving observer) {
        EOObserverCenter._startWriting();
        try {
            if (_omniscientObservers == null) {
                _omniscientObservers = new _EOObserverArray();
                _omniscientObservers.addObject(observer);
            } else if (!_omniscientObservers.containsObject(observer)) {
                _omniscientObservers.addObject(observer);
            }
        }
        finally {
            EOObserverCenter._endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOmniscientObserver(EOObserving observer) {
        EOObserverCenter._startWriting();
        try {
            if (_omniscientObservers != null) {
                _omniscientObservers.removeObject(observer);
                if (_omniscientObservers.count() == 0) {
                    _omniscientObservers = null;
                }
            }
        }
        finally {
            EOObserverCenter._endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyObserversObjectWillChange(Object eo) {
        Object[] observers;
        _ThreadInfo threadInfo = EOObserverCenter._threadInfo();
        if (eo == threadInfo._lastWillChangeObject || threadInfo._notificationSuppressCount > 0) {
            return;
        }
        threadInfo._lastWillChangeObject = eo;
        if (eo == null) {
            return;
        }
        EOObserving singleObserverToNotify = null;
        NSMutableSet multipleObserversToNotify = null;
        if (eo instanceof EOEnterpriseObject) {
            EOEnterpriseObject co = (EOEnterpriseObject)eo;
            EOEditingContext ec = co.editingContext();
            if (ec != null) {
                ec.objectWillChange(eo);
            }
            if (!((_EOPrivateMemento)co.opaqueState()).__hasAuxillaryObservers() && _omniscientObservers == null) {
                return;
            }
        }
        EOObserverCenter._startReading();
        try {
            int count;
            observers = (Object[])_observersBySubject.get(eo);
            int n = count = observers == null ? 0 : observers.count();
            if (count <= 1 && _omniscientObservers == null) {
                if (count > 0) {
                    singleObserverToNotify = (EOObserving)observers.firstObjectNoCopy();
                }
            } else {
                if (_omniscientObservers != null) {
                    count += _omniscientObservers.count();
                }
                multipleObserversToNotify = new NSMutableSet(count);
                observers.addObjectsToSet(multipleObserversToNotify);
                if (_omniscientObservers != null) {
                    _omniscientObservers.addObjectsToSet(multipleObserversToNotify);
                }
            }
        }
        finally {
            EOObserverCenter._endReading();
        }
        if (singleObserverToNotify != null) {
            singleObserverToNotify.objectWillChange(eo);
        } else if (multipleObserversToNotify != null) {
            observers = multipleObserversToNotify._allObjects();
            for (int i = 0; i < observers.length; ++i) {
                ((EOObserving)observers[i]).objectWillChange(eo);
            }
        }
    }

    private static class _ThreadInfo {
        int _notificationSuppressCount = 0;
        Object _lastWillChangeObject = null;

        _ThreadInfo() {
        }
    }

    private static class _EOObserverArray
    extends _NSWeakMutableArray {
        static final long serialVersionUID = 2149990178881952174L;

        public Object firstObjectNoCopy() {
            Object[] observers = this.allReferencesNoCopy();
            return observers.length == 0 ? null : ((WeakReference)observers[0]).get();
        }

        public void addObjectsToSet(NSMutableSet set) {
            Object[] observers = this.allReferencesNoCopy();
            int count = observers.length;
            for (int i = 0; i < count; ++i) {
                Object observer = ((WeakReference)observers[i]).get();
                if (observer == null) continue;
                set.addObject(observer);
            }
        }

        public Object objectOfClass(Class aClass) {
            int count = this.count();
            if (count > 0) {
                Object[] observers = this.allReferencesNoCopy();
                count = observers.length;
                for (int i = 0; i < count; ++i) {
                    EOObserving observer = (EOObserving)((WeakReference)observers[i]).get();
                    if (!aClass.isInstance(observer)) continue;
                    return observer;
                }
            }
            return null;
        }

        public boolean containsObject(Object eo) {
            return this.indexOfObject(eo) >= 0;
        }
    }
}

