/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOQualifierVisitor;
import com.webobjects.eocontrol._EOKnownSelector;
import com.webobjects.eocontrol._private._EOQualifierParser;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;

public abstract class EOQualifier
implements Serializable,
EOQualifierEvaluation {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOQualifier");
    private static final String _QualifierOperatorEqualKey = "isEqualTo";
    private static final String _QualifierOperatorNotEqualKey = "isNotEqualTo";
    private static final String _QualifierOperatorLessThanKey = "isLessThan";
    private static final String _QualifierOperatorGreaterThanKey = "isGreaterThan";
    private static final String _QualifierOperatorLessThanOrEqualToKey = "isLessThanOrEqualTo";
    private static final String _QualifierOperatorGreaterThanOrEqualToKey = "isGreaterThanOrEqualTo";
    private static final String _QualifierOperatorContainsKey = "doesContain";
    private static final String _QualifierOperatorLikeKey = "isLike";
    private static final String _QualifierOperatorCaseInsensitiveLikeKey = "isCaseInsensitiveLike";
    public static final NSSelector QualifierOperatorEqual = new _EOKnownSelector("isEqualTo", _NSUtilities._ObjectClassArray, 1);
    public static final NSSelector QualifierOperatorNotEqual = new _EOKnownSelector("isNotEqualTo", _NSUtilities._ObjectClassArray, 2);
    public static final NSSelector QualifierOperatorLessThan = new _EOKnownSelector("isLessThan", _NSUtilities._ObjectClassArray, 3);
    public static final NSSelector QualifierOperatorGreaterThan = new _EOKnownSelector("isGreaterThan", _NSUtilities._ObjectClassArray, 4);
    public static final NSSelector QualifierOperatorLessThanOrEqualTo = new _EOKnownSelector("isLessThanOrEqualTo", _NSUtilities._ObjectClassArray, 5);
    public static final NSSelector QualifierOperatorGreaterThanOrEqualTo = new _EOKnownSelector("isGreaterThanOrEqualTo", _NSUtilities._ObjectClassArray, 6);
    public static final NSSelector QualifierOperatorContains = new _EOKnownSelector("doesContain", _NSUtilities._ObjectClassArray, 7);
    public static final NSSelector QualifierOperatorLike = new _EOKnownSelector("isLike", _NSUtilities._ObjectClassArray, 8);
    public static final NSSelector QualifierOperatorCaseInsensitiveLike = new _EOKnownSelector("isCaseInsensitiveLike", _NSUtilities._ObjectClassArray, 9);
    private static final Object[] _relationalOperators = new Object[]{"=", "<>", "<", ">", "<=", ">="};
    private static final Object[] _operators = new Object[]{"=", "<>", "<", ">", "<=", ">=", "contains", "like", "caseinsensitivelike"};
    private static final String[] _selectorKeys = new String[]{"isEqualTo", "isNotEqualTo", "isLessThan", "isGreaterThan", "isLessThanOrEqualTo", "isGreaterThanOrEqualTo", "doesContain", "isLike", "isCaseInsensitiveLike"};
    private static final Object[] _selectors = new Object[]{QualifierOperatorEqual, QualifierOperatorNotEqual, QualifierOperatorLessThan, QualifierOperatorGreaterThan, QualifierOperatorLessThanOrEqualTo, QualifierOperatorGreaterThanOrEqualTo, QualifierOperatorContains, QualifierOperatorLike, QualifierOperatorCaseInsensitiveLike};
    private static final int _ComparisonNone = 2;
    private static _EOQualifierParser _qualifierParser = null;
    private static final NSArray _allRelationalOperators = new NSArray(_relationalOperators);
    private static final NSArray _allOperators = new NSArray(_operators);
    private static final NSDictionary _operatorsBySelector = new NSDictionary(_operators, _selectors);
    private static final NSDictionary _selectorsBySelectorKey = new NSDictionary(_selectors, (Object[])_selectorKeys);
    private static final NSDictionary _selectorsByOperator = new NSDictionary(_selectors, _operators);
    private static final NSSelector JavaQualifierOperatorContains = new _EOKnownSelector("contains", _NSUtilities._ObjectClassArray, 7);

    public static NSArray allQualifierOperators() {
        return _allOperators;
    }

    public static NSArray relationalQualifierOperators() {
        return _allRelationalOperators;
    }

    public boolean _isEmpty() {
        return false;
    }

    public static String stringForOperatorSelector(NSSelector selector) {
        String string = (String)_operatorsBySelector.objectForKey((Object)selector);
        return string != null ? string : selector.name();
    }

    public static NSSelector operatorSelectorForString(String string) {
        NSSelector result;
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("EOQualifier.operatorSelectorForString() : the input string must not be null nor empty");
        }
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((result = (NSSelector)_selectorsByOperator.objectForKey((Object)string.toLowerCase())) == null) {
            result = new NSSelector(string, _NSUtilities._ObjectClassArray);
        }
        return result;
    }

    public static NSArray filteredArrayWithQualifier(NSArray array, EOQualifier qualifier) {
        if (array == null) {
            return NSArray.EmptyArray;
        }
        if (qualifier == null || qualifier._isEmpty()) {
            return array;
        }
        int count = array.count();
        NSMutableArray filteredArray = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            Object object = array.objectAtIndex(i);
            if (!qualifier.evaluateWithObject(object)) continue;
            filteredArray.addObject(object);
        }
        return filteredArray;
    }

    public static void filterArrayWithQualifier(NSMutableArray array, EOQualifier qualifier) {
        array.setArray(EOQualifier.filteredArrayWithQualifier((NSArray)array, qualifier));
    }

    static void _andOrQualifierAddBindingsToDictionary(EOQualifier qualifier, NSArray originalQualifiers, NSMutableDictionary dictionary) {
        for (int i = originalQualifiers.count() - 1; i >= 0; --i) {
            ((EOQualifier)originalQualifiers.objectAtIndex(i))._addBindingsToDictionary(dictionary);
        }
    }

    static EOQualifier _andOrQualifierWithBindingsAndOptions(EOQualifier qualifier, NSArray originalQualifiers, NSDictionary bindings, boolean requiresAll) {
        int count = originalQualifiers.count();
        NSMutableArray qualifiers = new NSMutableArray(count);
        for (int i = 0; i < count; ++i) {
            EOQualifier qualifierCopy = ((EOQualifier)originalQualifiers.objectAtIndex(i)).qualifierWithBindings(bindings, requiresAll);
            if (qualifierCopy == null) continue;
            qualifiers.addObject((Object)qualifierCopy);
        }
        if (qualifiers.equals((Object)originalQualifiers)) {
            return qualifier;
        }
        if (qualifiers.count() > 1) {
            if (qualifier instanceof EOAndQualifier) {
                return new EOAndQualifier((NSArray)qualifiers);
            }
            return new EOOrQualifier((NSArray)qualifiers);
        }
        if (qualifiers.count() == 1) {
            return (EOQualifier)qualifiers.objectAtIndex(0);
        }
        return null;
    }

    public abstract EOQualifier qualifierWithBindings(NSDictionary var1, boolean var2);

    void _addBindingsToDictionary(NSMutableDictionary dictionary) {
    }

    public NSArray bindingKeys() {
        NSMutableDictionary dictionary = new NSMutableDictionary();
        this._addBindingsToDictionary(dictionary);
        return dictionary.allKeys();
    }

    public String keyPathForBindingKey(String key) {
        NSMutableDictionary dictionary = new NSMutableDictionary();
        this._addBindingsToDictionary(dictionary);
        return (String)dictionary.objectForKey((Object)key);
    }

    public boolean evaluateWithObject(Object object) {
        throw new IllegalStateException("evaluateWithObject() not supported by a qualifier of class " + this.getClass().getName());
    }

    static NSArray _qualifierArrayFromDictionary(NSDictionary dictionary) {
        NSArray keys = dictionary.allKeys();
        int count = keys.count();
        NSMutableArray qualifiers = new NSMutableArray(count);
        for (int i = count - 1; i >= 0; --i) {
            String key = keys.objectAtIndex(i).toString();
            EOKeyValueQualifier qualifier = new EOKeyValueQualifier(key, QualifierOperatorEqual, dictionary.objectForKey((Object)key));
            qualifiers.addObject((Object)qualifier);
        }
        return qualifiers;
    }

    public static EOQualifier qualifierToMatchAllValues(NSDictionary values) {
        return new EOAndQualifier(EOQualifier._qualifierArrayFromDictionary(values));
    }

    public static EOQualifier qualifierToMatchAnyValue(NSDictionary values) {
        return new EOOrQualifier(EOQualifier._qualifierArrayFromDictionary(values));
    }

    static void _validateKeyWithRootClassDescription(EOClassDescription classDescription, String key) {
        if (key == null) {
            throw new IllegalStateException("Null-valued key found");
        }
        boolean error = false;
        NSArray components = NSArray.componentsSeparatedByString((String)key, (String)".");
        int count = components.count();
        for (int i = 0; i < count && !error; ++i) {
            String component = (String)components.objectAtIndex(i);
            NSArray keys = classDescription.attributeKeys();
            if (keys.containsObject((Object)component)) {
                if (i == count - 1) continue;
                error = true;
                continue;
            }
            if ((classDescription = classDescription.classDescriptionForDestinationKey(component)) != null) continue;
            error = true;
        }
        if (error) {
            throw new IllegalStateException("Invalid key '" + key + "' found");
        }
    }

    public abstract void validateKeysWithRootClassDescription(EOClassDescription var1);

    public abstract void addQualifierKeysToSet(NSMutableSet var1);

    public NSSet allQualifierKeys() {
        NSMutableSet qualKeys = new NSMutableSet();
        this.addQualifierKeysToSet(qualKeys);
        return qualKeys;
    }

    public Object clone() {
        return this;
    }

    protected static NSSelector operatorSelectorForSelectorNamed(String string) {
        NSSelector result;
        if (string != null && string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((result = (NSSelector)_selectorsBySelectorKey.objectForKey((Object)string)) == null) {
            result = new NSSelector(string, _NSUtilities._ObjectClassArray);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOQualifier qualifierWithQualifierFormat(String format, NSArray arguments) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Class clazz = _CLASS;
        synchronized (clazz) {
            if (_qualifierParser == null) {
                _qualifierParser = new _EOQualifierParser(new StringReader(format));
            }
        }
        EOQualifier qualifier = null;
        _EOQualifierParser _EOQualifierParser2 = _qualifierParser;
        synchronized (_EOQualifierParser2) {
            _qualifierParser.ReInit(new StringReader(format));
            _qualifierParser.setArguments(arguments);
            try {
                qualifier = _qualifierParser.parseLogicalExpression();
            }
            catch (Throwable exception) {
                RuntimeException ex = NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)2048L)) {
                    NSLog.err.appendln((Object)("qualifierWithQualifierFormat failed to parse \"" + format + "\" with arguments :" + arguments));
                    if (NSLog.allowedDebugLevel() > 1) {
                        NSLog.debug.appendln(exception);
                    }
                }
                throw ex;
            }
        }
        return qualifier;
    }

    public void _accept(EOQualifierVisitor visitor, boolean isPostOrder) {
        visitor.visitUnknownQualifier(this);
    }

    public static class ComparisonSupport {
        private static final int kNeitherNull = 42;
        private static final int kComparisonNone = 190;
        private static final String defaultStringTimestampFormat = "%Y-%m-%d %H:%M:%S %Z";
        private static final NSTimestampFormatter defaultStringTimestampFormatter = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S %Z");
        private static final Class[] _comparatorArgumentTypes = new Class[]{_NSUtilities._ObjectClass, _NSUtilities._ObjectClass};
        private static _NSThreadsafeMutableDictionary _supportByClass = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(16));
        private static final ComparisonSupport defaultComparisonSupport = new ComparisonSupport();

        public static ComparisonSupport supportForClass(Class aClass) {
            ComparisonSupport result = null;
            Class currentClass = aClass;
            if (_supportByClass.count() == 0 || aClass == null) {
                return defaultComparisonSupport;
            }
            while (result == null && currentClass != null) {
                result = (ComparisonSupport)_supportByClass.objectForKey((Object)currentClass);
                if (result == null) {
                    currentClass = currentClass.getSuperclass();
                    continue;
                }
                if (currentClass == aClass || result == defaultComparisonSupport) continue;
                ComparisonSupport.setSupportForClass(result, aClass);
            }
            return result == null ? defaultComparisonSupport : result;
        }

        public static void setSupportForClass(ComparisonSupport supportClass, Class aClass) {
            _supportByClass.setObjectForKey((Object)supportClass, (Object)aClass);
        }

        public static boolean compareValues(Object left, Object right, NSSelector selector) {
            ComparisonSupport qualifierComparator = _supportByClass.count() == 0 ? defaultComparisonSupport : ComparisonSupport.supportForClass(left.getClass());
            if (selector instanceof _EOKnownSelector) {
                switch (((_EOKnownSelector)selector)._uniqueIndex) {
                    case 1: {
                        return qualifierComparator.isEqualTo(left, right);
                    }
                    case 2: {
                        return qualifierComparator.isNotEqualTo(left, right);
                    }
                    case 3: {
                        return qualifierComparator.isLessThan(left, right);
                    }
                    case 4: {
                        return qualifierComparator.isGreaterThan(left, right);
                    }
                    case 5: {
                        return qualifierComparator.isLessThanOrEqualTo(left, right);
                    }
                    case 6: {
                        return qualifierComparator.isGreaterThanOrEqualTo(left, right);
                    }
                    case 7: {
                        return qualifierComparator.doesContain(left, right);
                    }
                    case 8: {
                        return qualifierComparator.isLike(left, right);
                    }
                    case 9: {
                        return qualifierComparator.isCaseInsensitiveLike(left, right);
                    }
                }
            }
            return qualifierComparator._compareWithArbitrarySelector(left, right, selector);
        }

        public boolean _compareWithArbitrarySelector(Object left, Object right, NSSelector selector) {
            Object result;
            if (left == null || left == NSKeyValueCoding.NullValue) {
                return false;
            }
            if (right == NSKeyValueCoding.NullValue) {
                right = null;
            }
            try {
                result = selector.invoke(left, right);
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return false;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return false;
        }

        private static int _handleNulls(Object left, Object right) {
            if (left == null || left == NSKeyValueCoding.NullValue || right == null || right == NSKeyValueCoding.NullValue) {
                return 190;
            }
            return 42;
        }

        private static Number _coerceToCorrectNumberClass(Object value, Class targetClass) {
            Number result = null;
            if (value instanceof Number) {
                result = (Number)value;
            } else if (value instanceof String) {
                try {
                    result = new BigDecimal((String)value);
                }
                catch (Throwable t) {
                    NSLog._conditionallyLogPrivateException((Throwable)t);
                    return null;
                }
            } else if (value instanceof Boolean) {
                result = (Boolean)value != false ? _NSUtilities.IntegerForInt((int)1) : _NSUtilities.IntegerForInt((int)0);
            }
            return _NSUtilities.convertNumberIntoCompatibleValue((Number)result, (Class)targetClass);
        }

        private static Boolean _coerceToBooleanClass(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return _NSUtilities.convertNumberIntoBooleanValue((Number)((Number)value));
            }
            if (value instanceof String) {
                String temp = (String)value;
                if (temp.equalsIgnoreCase("true") || temp.equalsIgnoreCase("yes") || temp.equals("1")) {
                    return Boolean.TRUE;
                }
                if (temp.equalsIgnoreCase("false") || temp.equalsIgnoreCase("no") || temp.equals("0")) {
                    return Boolean.FALSE;
                }
            }
            return null;
        }

        private static NSTimestamp _coerceToTimestampClass(Object value) {
            if (value instanceof NSTimestamp) {
                return (NSTimestamp)value;
            }
            if (value instanceof Date) {
                return new NSTimestamp(((Date)value).getTime());
            }
            if (value instanceof Number) {
                return new NSTimestamp(((Number)value).longValue());
            }
            if (value instanceof String) {
                try {
                    return (NSTimestamp)defaultStringTimestampFormatter.parseObject((String)value);
                }
                catch (Throwable t) {
                    NSLog._conditionallyLogPrivateException((Throwable)t);
                }
            }
            return null;
        }

        public boolean isEqualTo(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != 42) {
                if (left == NSKeyValueCoding.NullValue) {
                    left = null;
                }
                if (right == NSKeyValueCoding.NullValue) {
                    right = null;
                }
                return left == right;
            }
            Class<?> LHSClass = left.getClass();
            if (LHSClass == _NSUtilities._StringClass) {
                right = right.toString();
            } else if (left instanceof Number) {
                right = ComparisonSupport._coerceToCorrectNumberClass(right, LHSClass);
            } else if (LHSClass == _NSUtilities._BooleanClass) {
                right = ComparisonSupport._coerceToBooleanClass(right);
            } else if (left instanceof Date) {
                if (LHSClass != NSTimestamp._CLASS) {
                    left = ComparisonSupport._coerceToTimestampClass(left);
                }
                right = ComparisonSupport._coerceToTimestampClass(right);
            }
            return right != null ? left.equals(right) : false;
        }

        public boolean isNotEqualTo(Object left, Object right) {
            return !this.isEqualTo(left, right);
        }

        protected int _genericCompareTo(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != 42) {
                return nullCheck;
            }
            Class<?> LHSClass = left.getClass();
            if (LHSClass == _NSUtilities._StringClass) {
                return left.toString().compareTo(right.toString());
            }
            if (left instanceof Number) {
                right = ComparisonSupport._coerceToCorrectNumberClass(right, LHSClass);
            } else if (left instanceof Date) {
                if (LHSClass != NSTimestamp._CLASS) {
                    left = ComparisonSupport._coerceToTimestampClass(left);
                }
                right = ComparisonSupport._coerceToTimestampClass(right);
            }
            if (left instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
            return left.toString().compareTo(right.toString());
        }

        public boolean isLessThan(Object left, Object right) {
            try {
                int result = this._genericCompareTo(left, right);
                if (result != 190) {
                    return result < 0;
                }
                return false;
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return false;
            }
        }

        public boolean isGreaterThan(Object left, Object right) {
            try {
                int result = this._genericCompareTo(left, right);
                if (result != 190) {
                    return result > 0;
                }
                return false;
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return false;
            }
        }

        public boolean isLessThanOrEqualTo(Object left, Object right) {
            try {
                int result = this._genericCompareTo(left, right);
                if (result != 190) {
                    return result <= 0;
                }
                return false;
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return false;
            }
        }

        public boolean isGreaterThanOrEqualTo(Object left, Object right) {
            try {
                int result = this._genericCompareTo(left, right);
                if (result != 190) {
                    return result >= 0;
                }
                return false;
            }
            catch (Throwable t) {
                NSLog._conditionallyLogPrivateException((Throwable)t);
                return false;
            }
        }

        public boolean doesContain(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != 42 && (left == null || left == NSKeyValueCoding.NullValue)) {
                return false;
            }
            if (_NSUtilities._ObjectArrayClass.isInstance(left)) {
                Object[] javaArray = (Object[])left;
                int c = javaArray.length;
                for (int i = 0; i < c; ++i) {
                    if (!javaArray[i].equals(right)) continue;
                    return true;
                }
                return false;
            }
            if (left instanceof NSArray) {
                return ((NSArray)left).containsObject(right);
            }
            if (left instanceof NSDictionary) {
                return ((NSDictionary)left).objectForKey(right) != null;
            }
            if (left instanceof NSSet) {
                return ((NSSet)left).containsObject(right);
            }
            if (left instanceof Collection) {
                return ((Collection)left).contains(right);
            }
            if (left instanceof String) {
                return ((String)left).indexOf(right.toString()) >= 0;
            }
            return this._compareWithArbitrarySelector(left, right, JavaQualifierOperatorContains);
        }

        public boolean isLike(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != 42) {
                return false;
            }
            return _NSStringUtilities.stringMatchesPattern((String)left.toString(), (String)right.toString(), (boolean)false);
        }

        public boolean isCaseInsensitiveLike(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != 42) {
                return false;
            }
            return _NSStringUtilities.stringMatchesPattern((String)left.toString().toLowerCase(), (String)right.toString(), (boolean)true);
        }
    }

    public class QualifierVariableSubstitutionException
    extends RuntimeException {
        public QualifierVariableSubstitutionException(String message) {
            super(message);
        }
    }

    public static interface Comparison {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOQualifier$Comparison");

        public boolean isEqualTo(Object var1);

        public boolean isNotEqualTo(Object var1);

        public boolean isLessThan(Object var1);

        public boolean isGreaterThan(Object var1);

        public boolean isLessThanOrEqualTo(Object var1);

        public boolean isGreaterThanOrEqualTo(Object var1);

        public boolean doesContain(Object var1);

        public boolean isLike(Object var1);

        public boolean isCaseInsensitiveLike(Object var1);
    }
}

