/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol._EOKnownSelector;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Date;

public class EOSortOrdering
implements Serializable,
NSCoding,
EOKeyValueArchiving {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOSortOrdering");
    static final long serialVersionUID = -3371749436590792222L;
    private static final String SerializationKeyFieldKey = "key";
    private static final String SerializationSelectorNameFieldKey = "selectorName";
    public static final NSSelector CompareAscending = new _EOKnownSelector("compareAscending", _NSUtilities._ObjectClassArray, 10);
    public static final NSSelector CompareDescending = new _EOKnownSelector("compareDescending", _NSUtilities._ObjectClassArray, 11);
    public static final NSSelector CompareCaseInsensitiveAscending = new _EOKnownSelector("compareCaseInsensitiveAscending", _NSUtilities._ObjectClassArray, 12);
    public static final NSSelector CompareCaseInsensitiveDescending = new _EOKnownSelector("compareCaseInsensitiveDescending", _NSUtilities._ObjectClassArray, 13);
    private static final NSDictionary _selectorsByOperator = new NSDictionary((Object[])new NSSelector[]{CompareAscending, CompareDescending, CompareCaseInsensitiveAscending, CompareCaseInsensitiveDescending}, (Object[])new String[]{"compareascending", "comparedescending", "comparecaseinsensitiveascending", "comparecaseinsensitivedescending"});
    private String _key;
    private NSSelector _selector;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("key", _NSUtilities._StringClass), new ObjectStreamField("selectorName", _NSUtilities._StringClass)};

    public EOSortOrdering(String key, NSSelector selector) {
        this._key = key;
        this._selector = selector;
    }

    public static NSSelector _operatorSelectorForString(String string) {
        NSSelector result;
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("EOSortOrdering.operatorSelectorForString() : the input string must not be null nor empty");
        }
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((result = (NSSelector)_selectorsByOperator.objectForKey((Object)string.toLowerCase())) == null) {
            result = new NSSelector(string, _NSUtilities._ObjectClassArray);
        }
        return result;
    }

    public static EOSortOrdering sortOrderingWithKey(String key, NSSelector selector) {
        return new EOSortOrdering(key, selector);
    }

    private static NSArray _sortUsingKeyOrderArray(NSArray array, NSArray sortOrderings, NSMutableArray sortedArray) {
        if (array == null) {
            return null;
        }
        if (sortOrderings == null) {
            return array;
        }
        int count = array.count();
        int numberOfSortOrderings = sortOrderings.count();
        if (count > 1 && numberOfSortOrderings > 0) {
            NSComparator comparator;
            int i;
            Object[] valueHolders = new Object[count];
            if (numberOfSortOrderings == 1) {
                EOSortOrdering sortOrdering = (EOSortOrdering)sortOrderings.objectAtIndex(0);
                String key = sortOrdering.key();
                for (i = 0; i < count; ++i) {
                    valueHolders[i] = new _SingleSortValueHolder(array.objectAtIndex(i), key);
                }
                comparator = new _SingleValueComparator(sortOrdering.selector());
            } else {
                String[] keys = new String[numberOfSortOrderings];
                NSSelector[] selectors = new NSSelector[numberOfSortOrderings];
                for (i = 0; i < numberOfSortOrderings; ++i) {
                    EOSortOrdering sortOrdering = (EOSortOrdering)sortOrderings.objectAtIndex(i);
                    keys[i] = sortOrdering.key();
                    selectors[i] = sortOrdering.selector();
                }
                for (i = 0; i < count; ++i) {
                    valueHolders[i] = new _MultipleSortValueHolder(array.objectAtIndex(i), keys);
                }
                comparator = new _MultipleValueComparator(selectors);
            }
            try {
                _NSCollectionPrimitives.K2SortArray((Object[])valueHolders, (int)count, (NSComparator)comparator);
            }
            catch (NSComparator.ComparisonException e) {
                throw new IllegalStateException("Invalid comparison in " + sortOrderings);
            }
            for (i = 0; i < count; ++i) {
                valueHolders[i] = ((_SortValueHolder)valueHolders[i])._object;
            }
            if (sortedArray != null) {
                sortedArray.removeAllObjects();
            } else {
                sortedArray = new NSMutableArray(count);
            }
            sortedArray.addObjects(valueHolders);
        }
        if (sortedArray == null) {
            sortedArray = new NSMutableArray(array);
        }
        return sortedArray;
    }

    public static NSArray sortedArrayUsingKeyOrderArray(NSArray array, NSArray sortOrderings) {
        return EOSortOrdering._sortUsingKeyOrderArray(array, sortOrderings, null);
    }

    public static void sortArrayUsingKeyOrderArray(NSMutableArray array, NSArray sortOrderings) {
        EOSortOrdering._sortUsingKeyOrderArray((NSArray)array, sortOrderings, array);
    }

    public String key() {
        return this._key;
    }

    public NSSelector selector() {
        return this._selector;
    }

    public String toString() {
        return "<" + this.getClass().toString() + "(" + this._key + " " + this._selector.name() + ")>";
    }

    public Class classForCoder() {
        return this.getClass();
    }

    public static Object decodeObject(NSCoder coder) {
        String key = (String)coder.decodeObject();
        NSSelector selector = EOSortOrdering._operatorSelectorForString((String)coder.decodeObject());
        return new EOSortOrdering(key, selector);
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObject((Object)this._key);
        coder.encodeObject((Object)this._selector.name());
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
        archiver.encodeObject(this._key, SerializationKeyFieldKey);
        archiver.encodeObject(this._selector.name(), SerializationSelectorNameFieldKey);
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        String key = (String)unarchiver.decodeObjectForKey(SerializationKeyFieldKey);
        String string = (String)unarchiver.decodeObjectForKey(SerializationSelectorNameFieldKey);
        if (string != null && string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return new EOSortOrdering(key, EOSortOrdering._operatorSelectorForString(string));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationKeyFieldKey, this._key);
        if (this._selector != null) {
            fields.put(SerializationSelectorNameFieldKey, this._selector.name());
        }
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._key = (String)fields.get(SerializationKeyFieldKey, null);
        String name = (String)fields.get(SerializationSelectorNameFieldKey, null);
        if (name == null || name.length() < 1) {
            throw new StreamCorruptedException("While unarchiving a \"" + this.getClass().getName() + "\" a valid selector name was missing from the stream.");
        }
        this._selector = EOSortOrdering._operatorSelectorForString(name);
    }

    public static class ComparisonSupport {
        private static final int kNeitherNull = -42;
        private static final String defaultStringTimestampFormat = "%Y-%m-%d %H:%M:%S %Z";
        private static final NSTimestampFormatter defaultStringTimestampFormatter = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S %Z");
        private static final Class[] _comparatorArgumentTypes = new Class[]{_NSUtilities._ObjectClass, _NSUtilities._ObjectClass};
        private static _NSThreadsafeMutableDictionary _supportByClass = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(16));
        private static final ComparisonSupport defaultComparisonSupport = new ComparisonSupport();

        public static ComparisonSupport supportForClass(Class aClass) {
            ComparisonSupport result = null;
            Class currentClass = aClass;
            if (_supportByClass.count() == 0 || aClass == null) {
                return defaultComparisonSupport;
            }
            while (result == null && currentClass != null) {
                result = (ComparisonSupport)_supportByClass.objectForKey((Object)currentClass);
                if (result == null) {
                    currentClass = currentClass.getSuperclass();
                    continue;
                }
                if (currentClass == aClass || result == defaultComparisonSupport) continue;
                ComparisonSupport.setSupportForClass(result, aClass);
            }
            return result == null ? defaultComparisonSupport : result;
        }

        public static void setSupportForClass(ComparisonSupport support, Class aClass) {
            _supportByClass.setObjectForKey((Object)support, (Object)aClass);
        }

        public static int compareValues(Object left, Object right, NSSelector selector) {
            ComparisonSupport sortingComparator = _supportByClass.count() == 0 ? defaultComparisonSupport : ComparisonSupport.supportForClass(left.getClass());
            if (selector instanceof _EOKnownSelector) {
                switch (((_EOKnownSelector)selector)._uniqueIndex) {
                    case 10: {
                        return sortingComparator.compareAscending(left, right);
                    }
                    case 11: {
                        return sortingComparator.compareDescending(left, right);
                    }
                    case 12: {
                        return sortingComparator.compareCaseInsensitiveAscending(left, right);
                    }
                    case 13: {
                        return sortingComparator.compareCaseInsensitiveDescending(left, right);
                    }
                }
            }
            return sortingComparator._compareWithArbitrarySelector(left, right, selector);
        }

        public int _compareWithArbitrarySelector(Object left, Object right, NSSelector selector) {
            Object result;
            try {
                result = selector.invoke(left, right);
            }
            catch (Throwable ex) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
            }
            if (result instanceof Number) {
                return ((Number)result).intValue();
            }
            throw new IllegalStateException("The selector named \"" + selector.name() + "\" did not return an integer value");
        }

        private static int _handleNulls(Object left, Object right) {
            if (left == null || left == NSKeyValueCoding.NullValue) {
                if (right == null || right == NSKeyValueCoding.NullValue) {
                    return 0;
                }
                return -1;
            }
            if (right == null || right == NSKeyValueCoding.NullValue) {
                return 1;
            }
            return -42;
        }

        private static NSTimestamp _coerceToTimestampClass(Object value) {
            if (value instanceof NSTimestamp) {
                return (NSTimestamp)value;
            }
            if (value instanceof Date) {
                return new NSTimestamp(((Date)value).getTime());
            }
            if (value instanceof Number) {
                return new NSTimestamp(((Number)value).longValue());
            }
            if (value instanceof String) {
                try {
                    return (NSTimestamp)defaultStringTimestampFormatter.parseObject((String)value);
                }
                catch (Throwable t) {
                    NSLog._conditionallyLogPrivateException((Throwable)t);
                }
            }
            return null;
        }

        protected int _genericCompareTo(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != -42) {
                return nullCheck;
            }
            Class<?> LHSClass = left.getClass();
            if (LHSClass == _NSUtilities._StringClass) {
                return left.toString().compareTo(right.toString());
            }
            if (left instanceof Number || LHSClass == _NSUtilities._BooleanClass) {
                return _NSUtilities.compareNumbersOrBooleans((Object)left, (Object)right);
            }
            if (left instanceof Date) {
                if (LHSClass != NSTimestamp._CLASS) {
                    left = ComparisonSupport._coerceToTimestampClass(left);
                }
                right = ComparisonSupport._coerceToTimestampClass(right);
            }
            if (left instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
            return left.toString().compareTo(right.toString());
        }

        protected int _genericCaseInsensitiveCompareTo(Object left, Object right) {
            int nullCheck = ComparisonSupport._handleNulls(left, right);
            if (nullCheck != -42) {
                return nullCheck;
            }
            Class<?> LHSClass = left.getClass();
            if (LHSClass == _NSUtilities._StringClass) {
                return left.toString().compareToIgnoreCase(right.toString());
            }
            if (left instanceof Number || LHSClass == _NSUtilities._BooleanClass) {
                return _NSUtilities.compareNumbersOrBooleans((Object)left, (Object)right);
            }
            if (left instanceof Date) {
                if (LHSClass != NSTimestamp._CLASS) {
                    left = ComparisonSupport._coerceToTimestampClass(left);
                }
                right = ComparisonSupport._coerceToTimestampClass(right);
                return ((Comparable)left).compareTo(right);
            }
            return left.toString().compareToIgnoreCase(right.toString());
        }

        public int compareAscending(Object left, Object right) {
            int result = this._genericCompareTo(left, right);
            if (result == 0) {
                return 0;
            }
            return result < 0 ? -1 : 1;
        }

        public int compareDescending(Object left, Object right) {
            int result = this._genericCompareTo(left, right);
            if (result == 0) {
                return 0;
            }
            return result > 0 ? -1 : 1;
        }

        public int compareCaseInsensitiveAscending(Object left, Object right) {
            int result = this._genericCaseInsensitiveCompareTo(left, right);
            if (result == 0) {
                return 0;
            }
            return result < 0 ? -1 : 1;
        }

        public int compareCaseInsensitiveDescending(Object left, Object right) {
            int result = this._genericCaseInsensitiveCompareTo(left, right);
            if (result == 0) {
                return 0;
            }
            return result > 0 ? -1 : 1;
        }
    }

    public static class _MultipleSortValueHolder
    extends _SortValueHolder {
        private String[] _keys;
        private Object[] _values;
        private int _valuesAvailableIndex;

        public _MultipleSortValueHolder(Object object, String[] keys) {
            super(object);
            this._keys = keys;
            this._values = new Object[this._keys.length];
            this._values[0] = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this._object, (String)this._keys[0]);
            if (this._values[0] == null) {
                this._values[0] = NSKeyValueCoding.NullValue;
            }
            this._valuesAvailableIndex = 0;
        }

        public Object valueAtIndex(int index) {
            while (this._valuesAvailableIndex < index) {
                ++this._valuesAvailableIndex;
                this._values[this._valuesAvailableIndex] = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this._object, (String)this._keys[this._valuesAvailableIndex]);
                if (this._values[this._valuesAvailableIndex] != null) continue;
                this._values[this._valuesAvailableIndex] = NSKeyValueCoding.NullValue;
            }
            return this._values[index];
        }
    }

    public static class _SingleSortValueHolder
    extends _SortValueHolder {
        Object _value;

        public _SingleSortValueHolder(Object object, String key) {
            super(object);
            this._value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)key);
            if (this._value == null) {
                this._value = NSKeyValueCoding.NullValue;
            }
        }

        public Object value() {
            return this._value;
        }
    }

    public static class _SortValueHolder {
        Object _object;

        public _SortValueHolder(Object object) {
            this._object = object;
        }

        public Object object() {
            return this._object;
        }
    }

    public static class _MultipleValueComparator
    extends NSComparator {
        private NSSelector[] _selectors;

        public _MultipleValueComparator(NSSelector[] selectors) {
            this._selectors = selectors;
        }

        public int compare(Object left, Object right) throws NSComparator.ComparisonException {
            for (int i = 0; i < this._selectors.length; ++i) {
                int comparison = ComparisonSupport.compareValues(((_MultipleSortValueHolder)left).valueAtIndex(i), ((_MultipleSortValueHolder)right).valueAtIndex(i), this._selectors[i]);
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    public static class _SingleValueComparator
    extends NSComparator {
        private NSSelector _selector;

        public _SingleValueComparator(NSSelector selector) {
            this._selector = selector;
        }

        public int compare(Object left, Object right) throws NSComparator.ComparisonException {
            return ComparisonSupport.compareValues(((_SingleSortValueHolder)left)._value, ((_SingleSortValueHolder)right)._value, this._selector);
        }
    }

    public static interface Comparison {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOSortOrdering$Comparison");

        public int compareAscending(Object var1);

        public int compareDescending(Object var1);

        public int compareCaseInsensitiveAscending(Object var1);

        public int compareCaseInsensitiveDescending(Object var1);
    }
}

