/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;

public class EOTemporaryGlobalID
extends EOGlobalID
implements NSCoding {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOTemporaryGlobalID");
    static final long serialVersionUID = 1644555110511958227L;
    private static final String SerializationBytesFieldKey = "gid";
    private static final byte[] _NoByteArray = new byte[0];
    private static final int _MinimumHostIdentificationBytesLength = 4;
    private static final int _HostIdentificationBytesLength = 6;
    private static final int _ProcessIdentificationBytesLength = 4;
    private static final int _CounterBytesLength = 2;
    private static final int _TimestampBytesLength = 8;
    private static final int _RandomBytesLength = 4;
    private static final int _HostIdentificationStartIndex = 0;
    private static final int _ProcessIdentificationStartIndex = 6;
    private static final int _CounterStartIndex = 10;
    private static final int _TimestampStartIndex = 12;
    private static final int _RandomStartIndex = 20;
    public static final int UniqueBinaryKeyLength = 24;
    private static byte[] _hostIdentificationBytes;
    private static byte[] _processIdentificationBytes;
    private static final byte[] _counterBytes;
    private static byte[] _timestampBytes;
    private static final byte[] _randomBytes;
    private static byte[] _combinedUniqueBytesWithoutCounterInserted;
    private static long _timestamp;
    private byte[] _bytes;
    private transient int _hashCode;
    private static final ObjectStreamField[] serialPersistentFields;

    public static synchronized void _setHostIdentificationBytes(byte[] bytes) {
        if (bytes == null || bytes.length != 4 && bytes.length != 6) {
            throw new IllegalArgumentException("InetAddress bytes need to have 4 (or better) 6 bytes");
        }
        _hostIdentificationBytes = new byte[6];
        System.arraycopy(bytes, 0, _hostIdentificationBytes, 6 - bytes.length, bytes.length);
        _combinedUniqueBytesWithoutCounterInserted = null;
    }

    public static synchronized byte[] _hostIdentificationBytes() {
        if (_hostIdentificationBytes == null) {
            try {
                EOTemporaryGlobalID._setHostIdentificationBytes(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException exception) {
                NSLog._conditionallyLogPrivateException((Throwable)exception);
            }
            if (_hostIdentificationBytes == null) {
                throw new IllegalStateException("Cannot guarantee unique global ID generation: InetAddress for local host not accessible");
            }
        }
        return _hostIdentificationBytes;
    }

    public static void _setProcessIdentificationBytesFromInt(int processIdentification) {
        byte[] processIdentificationBytes = new byte[4];
        _NSCollectionPrimitives.copyIntoBuffer((byte[])processIdentificationBytes, (int)0, (int)processIdentification);
        EOTemporaryGlobalID._setProcessIdentificationBytes(processIdentificationBytes);
    }

    public static synchronized void _setProcessIdentificationBytes(byte[] bytes) {
        if (bytes == null || bytes.length != 4) {
            throw new IllegalArgumentException("ProcessIdentification bytes need to have 4 bytes");
        }
        _processIdentificationBytes = new byte[4];
        System.arraycopy(bytes, 0, _processIdentificationBytes, 0, bytes.length);
        _combinedUniqueBytesWithoutCounterInserted = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized byte[] _processIdentificationBytes() {
        ServerSocket socket = null;
        if (_processIdentificationBytes == null) {
            try {
                socket = new ServerSocket(0);
                EOTemporaryGlobalID._setProcessIdentificationBytesFromInt(socket.getLocalPort());
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException exception) {
                    NSLog._conditionallyLogPrivateException((Throwable)exception);
                }
            }
            catch (IOException exception) {
                NSLog._conditionallyLogPrivateException((Throwable)exception);
                byte[] processIdentificationBytes = new byte[4];
                _NSCollectionPrimitives.copyIntoBuffer((byte[])processIdentificationBytes, (int)0, (long)System.currentTimeMillis());
                EOTemporaryGlobalID._setProcessIdentificationBytes(processIdentificationBytes);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException exception) {
                        NSLog._conditionallyLogPrivateException((Throwable)exception);
                    }
                }
            }
        }
        return _processIdentificationBytes;
    }

    private static int _hashCodeForGloballyUniqueBytes(byte[] bytes) {
        int hashCode = bytes[10] + (bytes[11] << 8) + (bytes[18] << 16) + (bytes[23] << 24);
        return hashCode > 0 ? hashCode : -hashCode;
    }

    public static synchronized void assignGloballyUniqueBytes(byte[] uniqueBytes) {
        int index;
        if (uniqueBytes.length < 24) {
            throw new IllegalArgumentException("Length of Unique bytes array needs to be at least 24");
        }
        if (_timestampBytes == null) {
            _timestamp = System.currentTimeMillis();
            _timestampBytes = new byte[8];
            _NSCollectionPrimitives.copyIntoBuffer((byte[])_timestampBytes, (int)0, (long)_timestamp);
            _combinedUniqueBytesWithoutCounterInserted = null;
        }
        for (index = 0; index < 2; ++index) {
            int n = index;
            _counterBytes[n] = (byte)(_counterBytes[n] + 1);
            if (_counterBytes[index] != 0) break;
        }
        if (index == 2) {
            long timestamp = System.currentTimeMillis();
            boolean waitForTimeToChange = true;
            while (waitForTimeToChange) {
                if (timestamp < _timestamp + 3L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException exception) {
                        NSLog._conditionallyLogPrivateException((Throwable)exception);
                    }
                    continue;
                }
                _timestamp = timestamp;
                waitForTimeToChange = false;
            }
            _NSCollectionPrimitives.copyIntoBuffer((byte[])_timestampBytes, (int)0, (long)_timestamp);
            _combinedUniqueBytesWithoutCounterInserted = null;
        }
        if (_combinedUniqueBytesWithoutCounterInserted == null) {
            byte[] hostIdentificationBytes = EOTemporaryGlobalID._hostIdentificationBytes();
            byte[] processIdentificationBytes = EOTemporaryGlobalID._processIdentificationBytes();
            _combinedUniqueBytesWithoutCounterInserted = new byte[24];
            System.arraycopy(hostIdentificationBytes, 0, _combinedUniqueBytesWithoutCounterInserted, 0, 6);
            System.arraycopy(processIdentificationBytes, 0, _combinedUniqueBytesWithoutCounterInserted, 6, 4);
            System.arraycopy(_timestampBytes, 0, _combinedUniqueBytesWithoutCounterInserted, 12, 8);
            System.arraycopy(_randomBytes, 0, _combinedUniqueBytesWithoutCounterInserted, 20, 4);
        }
        System.arraycopy(_combinedUniqueBytesWithoutCounterInserted, 0, uniqueBytes, 0, 24);
        System.arraycopy(_counterBytes, 0, uniqueBytes, 10, 2);
    }

    public EOTemporaryGlobalID() {
        this._bytes = new byte[24];
        EOTemporaryGlobalID.assignGloballyUniqueBytes(this._bytes);
        this._hashCode = EOTemporaryGlobalID._hashCodeForGloballyUniqueBytes(this._bytes);
    }

    protected EOTemporaryGlobalID(byte[] globallyUniqueBytes) {
        this._bytes = globallyUniqueBytes;
        this._hashCode = EOTemporaryGlobalID._hashCodeForGloballyUniqueBytes(this._bytes);
    }

    public byte[] _rawBytes() {
        return this._bytes;
    }

    public static EOTemporaryGlobalID _gidForRawBytes(byte[] globallyUniqueBytes) {
        return new EOTemporaryGlobalID(globallyUniqueBytes);
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EOTemporaryGlobalID) {
            EOTemporaryGlobalID temporaryGlobalID = (EOTemporaryGlobalID)object;
            if (this._hashCode != temporaryGlobalID._hashCode) {
                return false;
            }
            byte[] otherBytes = temporaryGlobalID._bytes;
            for (int i = 0; i < 24; ++i) {
                if (this._bytes[i] == otherBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public Class classForCoder() {
        return this.getClass();
    }

    public static Object decodeObject(NSCoder coder) {
        return new EOTemporaryGlobalID(coder.decodeBytes());
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeBytes(this._bytes);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationBytesFieldKey, this._bytes);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._bytes = (byte[])fields.get(SerializationBytesFieldKey, null);
        if (this._bytes == null) {
            throw new IllegalStateException("EOTemporaryGlobalID deserialization failed - gid is a null reference.");
        }
        if (this._bytes.length < 24) {
            throw new IllegalStateException("EOTemporaryGlobalID deserialization failed - gid is invalid.");
        }
        this._hashCode = EOTemporaryGlobalID._hashCodeForGloballyUniqueBytes(this._bytes);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("<");
        buffer.append(_NSUtilities.shortClassName((Object)this));
        buffer.append(": ");
        for (int i = 0; i < 24; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this._bytes[i]);
        }
        buffer.append(">");
        return new String(buffer);
    }

    static {
        try {
            _hostIdentificationBytes = null;
            _processIdentificationBytes = null;
            _randomBytes = new byte[4];
            _NSCollectionPrimitives.copyIntoBuffer((byte[])_randomBytes, (int)0, (int)new Random(System.currentTimeMillis()).nextInt());
            _timestampBytes = null;
            _counterBytes = new byte[2];
            _combinedUniqueBytesWithoutCounterInserted = null;
        }
        catch (Throwable throwable) {
            NSLog.debug.appendln(throwable);
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)throwable);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationBytesFieldKey, _NoByteArray.getClass())};
    }
}

