/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOMailDelivery;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor._private.String_Extensions;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class MInstance
extends MObject {
    static NSTimestampFormatter dateFormatter = new NSTimestampFormatter("%m/%d/%Y %H:%M:%S %Z");
    static NSTimestampFormatter shutdownFormatter = new NSTimestampFormatter("%a @ %H:00");
    MHost _host;
    MApplication _application;
    NSTimestamp _lastRegistration = NSTimestamp.DistantPast;
    NSMutableArray _deaths = new NSMutableArray();
    private boolean isRefusingNewSessions = false;
    public int state = MObject.DEAD;
    NSMutableDictionary _statistics = new NSMutableDictionary();
    private String _statisticsError = null;
    public static long TIME_FOR_STARTUP = 30L;
    NSTimestamp _finishStartingByDate = new NSTimestamp();
    private int _connectFailureCount = 0;
    private boolean _shouldDie = false;
    NSTimestamp _nextScheduledShutdown = NSTimestamp.DistantPast;
    String _nextScheduledShutdownString = "-";
    public boolean isActivelyBeingScheduled = false;
    private Timer _taskTimer;
    private TimerTask _forceQuitTask;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._application == null ? 0 : this._application.hashCode());
        result = 31 * result + (this.id() == null ? 0 : this.id().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MInstance other = (MInstance)obj;
        if (this._application == null ? other._application != null : !this._application.equals(other._application)) {
            return false;
        }
        return !(this.id() == null ? other.id() != null : !this.id().equals(other.id()));
    }

    public String hostName() {
        return (String)this.values.valueForKey("hostName");
    }

    public void setHostName(String value) {
        this.values.takeValueForKey((Object)value, "hostName");
        this._siteConfig.dataHasChanged();
    }

    public Integer id() {
        return (Integer)this.values.valueForKey("id");
    }

    public void setId(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "id");
        this._siteConfig.dataHasChanged();
    }

    public Integer port() {
        return (Integer)this.values.valueForKey("port");
    }

    public void setPort(Integer value) {
        Integer valVal = MObject.validatedInteger(value);
        if (!valVal.equals(this.port())) {
            this.setOldport(this.port());
            this.values.takeValueForKey((Object)valVal, "port");
            this._siteConfig.dataHasChanged();
        }
    }

    public String applicationName() {
        return (String)this.values.valueForKey("applicationName");
    }

    public void setApplicationName(String value) {
        this.values.takeValueForKey((Object)value, "applicationName");
        this._siteConfig.dataHasChanged();
    }

    public Boolean autoRecover() {
        return (Boolean)this.values.valueForKey("autoRecover");
    }

    public void setAutoRecover(Boolean value) {
        this.values.takeValueForKey((Object)value, "autoRecover");
        this._siteConfig.dataHasChanged();
    }

    public Integer minimumActiveSessionsCount() {
        return (Integer)this.values.valueForKey("minimumActiveSessionsCount");
    }

    public void setMinimumActiveSessionsCount(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "minimumActiveSessionsCount");
        this._siteConfig.dataHasChanged();
    }

    public String path() {
        return (String)this.values.valueForKey("path");
    }

    public void setPath(String value) {
        this.values.takeValueForKey((Object)value, "path");
        this._siteConfig.dataHasChanged();
    }

    public Boolean cachingEnabled() {
        return (Boolean)this.values.valueForKey("cachingEnabled");
    }

    public void setCachingEnabled(Boolean value) {
        this.values.takeValueForKey((Object)value, "cachingEnabled");
        this._siteConfig.dataHasChanged();
    }

    public Boolean debuggingEnabled() {
        return (Boolean)this.values.valueForKey("debuggingEnabled");
    }

    public void setDebuggingEnabled(Boolean value) {
        this.values.takeValueForKey((Object)value, "debuggingEnabled");
        this._siteConfig.dataHasChanged();
    }

    public String outputPath() {
        return (String)this.values.valueForKey("outputPath");
    }

    public void setOutputPath(String value) {
        this.values.takeValueForKey((Object)MObject.validatedOutputPath(value), "outputPath");
        this._siteConfig.dataHasChanged();
    }

    public Boolean autoOpenInBrowser() {
        return (Boolean)this.values.valueForKey("autoOpenInBrowser");
    }

    public void setAutoOpenInBrowser(Boolean value) {
        this.values.takeValueForKey((Object)value, "autoOpenInBrowser");
        this._siteConfig.dataHasChanged();
    }

    public Integer lifebeatInterval() {
        return (Integer)this.values.valueForKey("lifebeatInterval");
    }

    public void setLifebeatInterval(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedLifebeatInterval(value), "lifebeatInterval");
        this._siteConfig.dataHasChanged();
    }

    public String additionalArgs() {
        return (String)this.values.valueForKey("additionalArgs");
    }

    public void setAdditionalArgs(String value) {
        this.values.takeValueForKey((Object)value, "additionalArgs");
        this._siteConfig.dataHasChanged();
    }

    public Boolean schedulingEnabled() {
        return (Boolean)this.values.valueForKey("schedulingEnabled");
    }

    public void setSchedulingEnabled(Boolean value) {
        this.values.takeValueForKey((Object)value, "schedulingEnabled");
        this._siteConfig.dataHasChanged();
    }

    public String schedulingType() {
        return (String)this.values.valueForKey("schedulingType");
    }

    public void setSchedulingType(String value) {
        this.values.takeValueForKey((Object)MObject.validatedSchedulingType(value), "schedulingType");
        this._siteConfig.dataHasChanged();
    }

    public Integer schedulingHourlyStartTime() {
        return (Integer)this.values.valueForKey("schedulingHourlyStartTime");
    }

    public void setSchedulingHourlyStartTime(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedSchedulingStartTime(value), "schedulingHourlyStartTime");
        this._siteConfig.dataHasChanged();
    }

    public Integer schedulingDailyStartTime() {
        return (Integer)this.values.valueForKey("schedulingDailyStartTime");
    }

    public void setSchedulingDailyStartTime(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedSchedulingStartTime(value), "schedulingDailyStartTime");
        this._siteConfig.dataHasChanged();
    }

    public Integer schedulingWeeklyStartTime() {
        return (Integer)this.values.valueForKey("schedulingWeeklyStartTime");
    }

    public void setSchedulingWeeklyStartTime(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedSchedulingStartTime(value), "schedulingWeeklyStartTime");
        this._siteConfig.dataHasChanged();
    }

    public Integer schedulingStartDay() {
        return (Integer)this.values.valueForKey("schedulingStartDay");
    }

    public void setSchedulingStartDay(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedSchedulingStartDay(value), "schedulingStartDay");
        this._siteConfig.dataHasChanged();
    }

    public Integer schedulingInterval() {
        return (Integer)this.values.valueForKey("schedulingInterval");
    }

    public void setSchedulingInterval(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "schedulingInterval");
        this._siteConfig.dataHasChanged();
    }

    public Boolean gracefulScheduling() {
        return (Boolean)this.values.valueForKey("gracefulScheduling");
    }

    public void setGracefulScheduling(Boolean value) {
        this.values.takeValueForKey((Object)value, "gracefulScheduling");
        this._siteConfig.dataHasChanged();
    }

    public Integer sendTimeout() {
        return (Integer)this.values.valueForKey("sendTimeout");
    }

    public void setSendTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "sendTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer recvTimeout() {
        return (Integer)this.values.valueForKey("recvTimeout");
    }

    public void setRecvTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "recvTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer cnctTimeout() {
        return (Integer)this.values.valueForKey("cnctTimeout");
    }

    public void setCnctTimeout(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "cnctTimeout");
        this._siteConfig.dataHasChanged();
    }

    public Integer sendBufSize() {
        return (Integer)this.values.valueForKey("sendBufSize");
    }

    public void setSendBufSize(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "sendBufSize");
        this._siteConfig.dataHasChanged();
    }

    public Integer recvBufSize() {
        return (Integer)this.values.valueForKey("recvBufSize");
    }

    public void setRecvBufSize(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "recvBufSize");
        this._siteConfig.dataHasChanged();
    }

    public Integer oldport() {
        return (Integer)this.values.valueForKey("oldport");
    }

    public void setOldport(Integer value) {
        this.values.takeValueForKey((Object)MObject.validatedInteger(value), "oldport");
        this._siteConfig.dataHasChanged();
    }

    public MHost host() {
        return this._host;
    }

    public MApplication application() {
        return this._application;
    }

    public MInstance(MHost aHost, MApplication anApplication, Integer anID, MSiteConfig aConfig) {
        shutdownFormatter.setDefaultFormatTimeZone(NSTimeZone.timeZoneWithName((String)"UTC", (boolean)true));
        this.values = new NSMutableDictionary();
        this._host = aHost;
        this._application = anApplication;
        this._siteConfig = aConfig;
        this.setApplicationName(this._application.name());
        this.setHostName(this._host.name());
        this.setId(anID);
        this.takeValuesFromApplication();
        this.setSchedulingEnabled(Boolean.FALSE);
        this.setSchedulingType("DAILY");
        this.setSchedulingHourlyStartTime(new Integer(3));
        this.setSchedulingDailyStartTime(new Integer(3));
        this.setSchedulingWeeklyStartTime(new Integer(3));
        this.setSchedulingStartDay(new Integer(1));
        this.setSchedulingInterval(new Integer(12));
        this.setGracefulScheduling(Boolean.TRUE);
    }

    public MInstance(NSDictionary aDict, MSiteConfig aConfig) {
        shutdownFormatter.setDefaultFormatTimeZone(NSTimeZone.timeZoneWithName((String)"UTC", (boolean)true));
        this.values = new NSMutableDictionary(aDict);
        this._host = aConfig.hostWithName(this.hostName());
        this._application = aConfig.applicationWithName(this.applicationName());
        this._siteConfig = aConfig;
        this.calculateNextScheduledShutdown();
    }

    public void _takeNameFromApplication() {
        this.setApplicationName(this._application.name());
    }

    public void _takePortFromApplication() {
        NSMutableDictionary appValues = this._application.values;
        MHost aHost = this._host;
        Integer appPort = (Integer)appValues.valueForKey("startingPort");
        if (this.port() == null || this.port() != null && this.port() < appPort) {
            this.setPort(aHost.nextAvailablePort(appPort));
        }
    }

    public void _takePathFromApplication() {
        NSMutableDictionary appValues = this._application.values;
        MHost aHost = this._host;
        if (aHost.osType().equals("UNIX")) {
            this.values.takeValueForKey(appValues.valueForKey("unixPath"), "path");
        } else if (aHost.osType().equals("WINDOWS")) {
            this.values.takeValueForKey(appValues.valueForKey("winPath"), "path");
        } else if (aHost.osType().equals("MACOSX")) {
            this.values.takeValueForKey(appValues.valueForKey("macPath"), "path");
        }
    }

    public void _takeOutputPathFromApplication() {
        NSMutableDictionary appValues = this._application.values;
        MHost aHost = this._host;
        if (aHost.osType().equals("UNIX")) {
            this.values.takeValueForKey((Object)this.generateOutputPath((String)appValues.valueForKey("unixOutputPath")), "outputPath");
        } else if (aHost.osType().equals("WINDOWS")) {
            this.values.takeValueForKey((Object)this.generateOutputPath((String)appValues.valueForKey("winOutputPath")), "outputPath");
        } else if (aHost.osType().equals("MACOSX")) {
            this.values.takeValueForKey((Object)this.generateOutputPath((String)appValues.valueForKey("macOutputPath")), "outputPath");
        }
    }

    public void _takeValueFromApplication(String valueName) {
        NSMutableDictionary appValues = this._application.values;
        this.values.takeValueForKey(appValues.valueForKey(valueName), valueName);
    }

    public void takeValuesFromApplication() {
        this._takeNameFromApplication();
        this._takePortFromApplication();
        this._takeValueFromApplication("autoRecover");
        this._takeValueFromApplication("minimumActiveSessionsCount");
        this._takePathFromApplication();
        this._takeOutputPathFromApplication();
        this._takeValueFromApplication("cachingEnabled");
        this._takeValueFromApplication("debuggingEnabled");
        this._takeValueFromApplication("autoOpenInBrowser");
        this._takeValueFromApplication("lifebeatInterval");
        this._takeValueFromApplication("additionalArgs");
    }

    public String generateOutputPath(String pathEndingWithSeperator) {
        if (pathEndingWithSeperator != null) {
            return NSPathUtilities._standardizedPath((String)NSPathUtilities.stringByAppendingPathComponent((String)pathEndingWithSeperator, (String)this.displayName()));
        }
        return null;
    }

    public NSDictionary dictionaryForArchive() {
        return this.values;
    }

    public String toString() {
        return "MInstance@" + this.applicationName() + "-" + this.id();
    }

    public void extractAdaptorValuesFromApplication() {
        this.adaptorValues.takeValueForKey(this.values.valueForKey("sendTimeout"), "sendTimeout");
        this.adaptorValues.takeValueForKey(this.values.valueForKey("recvTimeout"), "recvTimeout");
        this.adaptorValues.takeValueForKey(this.values.valueForKey("cnctTimeout"), "cnctTimeout");
        this.adaptorValues.takeValueForKey(this.values.valueForKey("sendBufSize"), "sendBufSize");
        this.adaptorValues.takeValueForKey(this.values.valueForKey("recvBufSize"), "recvBufSize");
        if (this.adaptorValues.valueForKey("sendTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._application.values.valueForKey("sendTimeout"), "sendTimeout");
        }
        if (this.adaptorValues.valueForKey("recvTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._application.values.valueForKey("recvTimeout"), "recvTimeout");
        }
        if (this.adaptorValues.valueForKey("cnctTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._application.values.valueForKey("cnctTimeout"), "cnctTimeout");
        }
        if (this.adaptorValues.valueForKey("sendBufSize") == null) {
            this.adaptorValues.takeValueForKey(this._application.values.valueForKey("sendBufSize"), "sendBufSize");
        }
        if (this.adaptorValues.valueForKey("recvBufSize") == null) {
            this.adaptorValues.takeValueForKey(this._application.values.valueForKey("recvBufSize"), "recvBufSize");
        }
        if (this.adaptorValues.valueForKey("sendTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._siteConfig.values.valueForKey("sendTimeout"), "sendTimeout");
        }
        if (this.adaptorValues.valueForKey("recvTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._siteConfig.values.valueForKey("recvTimeout"), "recvTimeout");
        }
        if (this.adaptorValues.valueForKey("cnctTimeout") == null) {
            this.adaptorValues.takeValueForKey(this._siteConfig.values.valueForKey("cnctTimeout"), "cnctTimeout");
        }
        if (this.adaptorValues.valueForKey("sendBufSize") == null) {
            this.adaptorValues.takeValueForKey(this._siteConfig.values.valueForKey("sendBufSize"), "sendBufSize");
        }
        if (this.adaptorValues.valueForKey("recvBufSize") == null) {
            this.adaptorValues.takeValueForKey(this._siteConfig.values.valueForKey("recvBufSize"), "recvBufSize");
        }
    }

    public String displayName() {
        return this.applicationName() + "-" + this.id();
    }

    public String displayHostAndPort() {
        return this.hostName() + ":" + this.port();
    }

    public NSDictionary statistics() {
        return this._statistics;
    }

    public void setStatistics(NSDictionary newStatistics) {
        this._statistics.takeValueForKey((Object)MObject.validatedStats((String)newStatistics.valueForKey("transactions")), "transactions");
        this._statistics.takeValueForKey((Object)MObject.validatedStats((String)newStatistics.valueForKey("activeSessions")), "activeSessions");
        this._statistics.takeValueForKey((Object)MObject.validatedStats((String)newStatistics.valueForKey("avgTransactionTime")), "avgTransactionTime");
        this._statistics.takeValueForKey((Object)MObject.validatedStats((String)newStatistics.valueForKey("averageIdlePeriod")), "averageIdlePeriod");
        this._statistics.takeValueForKey((Object)MObject.validatedStats((String)newStatistics.valueForKey("startedAt")), "startedAt");
    }

    public String transactions() {
        Object _value;
        if (this._statistics != null && (_value = this._statistics.valueForKey("transactions")) != null) {
            return _value.toString();
        }
        return "-";
    }

    public String activeSessions() {
        Object _value;
        if (this._statistics != null && (_value = this._statistics.valueForKey("activeSessions")) != null) {
            return _value.toString();
        }
        return "-";
    }

    public String avgTransactionTime() {
        Object _value;
        if (this._statistics != null && (_value = this._statistics.valueForKey("avgTransactionTime")) != null) {
            return _value.toString();
        }
        return "-";
    }

    public String averageIdlePeriod() {
        Object _value;
        if (this._statistics != null && (_value = this._statistics.valueForKey("averageIdlePeriod")) != null) {
            return _value.toString();
        }
        return "-";
    }

    public void setStatisticsError(String errorString) {
        this._statisticsError = errorString;
    }

    public String statisticsError() {
        return this._statisticsError;
    }

    public void resetStatisticsError() {
        this._statisticsError = null;
    }

    public void willAttemptToStart() {
        this.state = MObject.STARTING;
        Integer tfs = this._application.timeForStartup();
        long timeForStartup = tfs != null ? (long)tfs.intValue() : TIME_FOR_STARTUP;
        this._finishStartingByDate = new NSTimestamp(new NSTimestamp().getTime() + timeForStartup * 1000L);
    }

    public void failedToConnect() {
        ++this._connectFailureCount;
        if (this._connectFailureCount > 2) {
            this.state = MObject.DEAD;
            this._lastRegistration = NSTimestamp.DistantPast;
        }
    }

    public void succeededInConnection() {
        this._connectFailureCount = 0;
    }

    public boolean isRunning_M() {
        return this.state == MObject.ALIVE;
    }

    public int lifebeatCheckInterval() {
        Integer lb = this.lifebeatInterval();
        if (lb == null) {
            return 30 * this._siteConfig._appIsDeadMultiplier;
        }
        return lb * this._siteConfig._appIsDeadMultiplier;
    }

    public boolean isRunning_W() {
        long currentTime = new NSTimestamp().getTime();
        long cutOffTime = this._lastRegistration.getTime() + (long)this.lifebeatCheckInterval();
        long finishStartingByTime = this._finishStartingByDate.getTime();
        if (this.state == MObject.STARTING) {
            if (currentTime < finishStartingByTime) {
                if (currentTime > cutOffTime) {
                    return false;
                }
                this.state = MObject.ALIVE;
                return true;
            }
            if (currentTime > cutOffTime) {
                this.addDeath();
                this.sendDeathNotificationEmail();
                this.setShouldDie(false);
                this.state = MObject.DEAD;
                return false;
            }
            this.state = MObject.ALIVE;
            return true;
        }
        if (this.state == MObject.ALIVE) {
            if (currentTime > cutOffTime) {
                this.addDeath();
                this.sendDeathNotificationEmail();
                this.setShouldDie(false);
                this.state = MObject.DEAD;
                return false;
            }
            return true;
        }
        if (this.state == MObject.CRASHING) {
            this.addDeath();
            this.sendDeathNotificationEmail();
            this.state = MObject.DEAD;
            return false;
        }
        if (currentTime > cutOffTime) {
            this.state = MObject.DEAD;
            return false;
        }
        this.state = MObject.ALIVE;
        return true;
    }

    public boolean isAutoRecovering() {
        Boolean aBool = this.autoRecover();
        if (aBool != null) {
            return aBool;
        }
        return false;
    }

    public boolean isLocal_W() {
        return this.host() == this._siteConfig.localHost();
    }

    public void setShouldDie(boolean b) {
        this._shouldDie = b;
    }

    public boolean shouldDie() {
        return this._shouldDie;
    }

    public boolean shouldDieAndReset() {
        boolean b = this._shouldDie;
        this._shouldDie = false;
        return b;
    }

    public NSTimestamp lastRegistration() {
        return this._lastRegistration;
    }

    public void startRegistration(NSTimestamp registrationDate) {
        this.updateRegistration(registrationDate);
    }

    public void updateRegistration(NSTimestamp registrationDate) {
        this.succeededInConnection();
        this._lastRegistration = registrationDate;
    }

    public void registerStop(NSTimestamp registrationDate) {
        this.succeededInConnection();
        this._lastRegistration = NSTimestamp.DistantPast;
        this.state = MObject.DEAD;
    }

    public void registerCrash(NSTimestamp registrationDate) {
        this.succeededInConnection();
        this._lastRegistration = NSTimestamp.DistantPast;
        this.state = MObject.CRASHING;
    }

    public void sendDeathNotificationEmail() {
        boolean shouldEmail = false;
        Boolean aBool = this._application.notificationEmailEnabled();
        if (aBool != null) {
            shouldEmail = aBool;
        }
        if (shouldEmail) {
            try {
                WOMailDelivery mailer = WOMailDelivery.sharedInstance();
                String currentDate = new NSTimestamp().toString();
                String fromAddress = this.siteConfig().emailReturnAddr();
                NSArray toAddress = null;
                String subject = new String("App stopped running: " + this.displayName());
                String bodyText = new String("The application " + this.displayName() + " listening on port " + this.port() + " on host " + this._host.name() + " stopped running at " + currentDate + ".  This may be the result of a crash or an intentional shutdown from outside of wotaskd");
                if (fromAddress != null) {
                    fromAddress = new String("root@" + this._host.name());
                }
                if (this._application.notificationEmailAddr() != null) {
                    toAddress = NSArray.componentsSeparatedByString((String)this._application.notificationEmailAddr(), (String)",");
                }
                if (mailer != null && toAddress != null && toAddress.count() > 0) {
                    mailer.composePlainTextEmail(fromAddress, toAddress, null, subject, bodyText, true);
                }
            }
            catch (Throwable localException) {
                NSLog.err.appendln((Object)("Error attempting to send email: " + localException));
            }
        }
    }

    public NSMutableArray deaths() {
        return this._deaths;
    }

    public void setDeaths(NSMutableArray values) {
        this._deaths = values;
    }

    public int deathCount() {
        return this._deaths.count();
    }

    public void addDeath() {
        this._deaths.addObject((Object)dateFormatter.format((Object)new NSTimestamp()));
    }

    public void removeAllDeaths() {
        this._deaths = new NSMutableArray();
    }

    public NSArray additionalArgumentsAsArray() {
        return NSArray.componentsSeparatedByString((String)this.additionalArgs(), (String)" ");
    }

    private String toNullOrString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public NSArray commandLineArgumentsAsArray() {
        String appNameString;
        String statisticsPasswordString;
        String sessionTimeOutString;
        String projectSearchPathString;
        String adaptorThreadsMaxString;
        String adaptorThreadsMinString;
        String listenQueueSizeString;
        String adaptorThreadsString;
        NSMutableArray anArray = new NSMutableArray(17);
        if (!WOApplication.application()._unsetHost) {
            anArray.addObject((Object)"-WOHost");
            anArray.addObject((Object)WOApplication.application().host());
        }
        anArray.addObject((Object)"-WOPort");
        anArray.addObject((Object)this.port().toString());
        anArray.addObject((Object)"-WOCachingEnabled");
        anArray.addObject((Object)String_Extensions.booleanAsYNString(this.cachingEnabled()));
        anArray.addObject((Object)"-WODebuggingEnabled");
        anArray.addObject((Object)String_Extensions.booleanAsYNString(this.debuggingEnabled()));
        anArray.addObject((Object)"-WOOutputPath");
        anArray.addObject((Object)MObject.validatedOutputPath(this.outputPath()));
        anArray.addObject((Object)"-WOAutoOpenInBrowser");
        anArray.addObject((Object)String_Extensions.booleanAsYNString(this.autoOpenInBrowser()));
        anArray.addObject((Object)"-WOAutoOpenClientApplication");
        anArray.addObject((Object)String_Extensions.booleanAsYNString(this.autoOpenInBrowser()));
        anArray.addObject((Object)"-WOLifebeatInterval");
        anArray.addObject((Object)this.lifebeatInterval().toString());
        anArray.addObject((Object)"-WOLifebeatEnabled");
        anArray.addObject((Object)"YES");
        anArray.addObject((Object)"-WOLifebeatDestinationPort");
        anArray.addObject((Object)new String(WOApplication.application().lifebeatDestinationPort() + ""));
        String adaptorString = this.toNullOrString(this._application.adaptor());
        if (adaptorString != null && adaptorString.length() > 0) {
            anArray.addObject((Object)"-WOAdaptor");
            anArray.addObject((Object)adaptorString);
        }
        if ((adaptorThreadsString = this.toNullOrString(this._application.adaptorThreads())) != null && adaptorThreadsString.length() > 0) {
            anArray.addObject((Object)"-WOWorkerThreadCount");
            anArray.addObject((Object)adaptorThreadsString);
        }
        if ((listenQueueSizeString = this.toNullOrString(this._application.listenQueueSize())) != null && listenQueueSizeString.length() > 0) {
            anArray.addObject((Object)"-WOListenQueueSize");
            anArray.addObject((Object)listenQueueSizeString);
        }
        if ((adaptorThreadsMinString = this.toNullOrString(this._application.adaptorThreadsMin())) != null && adaptorThreadsMinString.length() > 0) {
            anArray.addObject((Object)"-WOWorkerThreadCountMin");
            anArray.addObject((Object)adaptorThreadsMinString);
        }
        if ((adaptorThreadsMaxString = this.toNullOrString(this._application.adaptorThreadsMax())) != null && adaptorThreadsMaxString.length() > 0) {
            anArray.addObject((Object)"-WOWorkerThreadCountMax");
            anArray.addObject((Object)adaptorThreadsMaxString);
        }
        if ((projectSearchPathString = this.toNullOrString(this._application.projectSearchPath())) != null && projectSearchPathString.length() > 0) {
            anArray.addObject((Object)"-NSProjectSearchPath");
            anArray.addObject((Object)projectSearchPathString);
        }
        if ((sessionTimeOutString = this.toNullOrString(this._application.sessionTimeOut())) != null && sessionTimeOutString.length() > 0) {
            anArray.addObject((Object)"-WOSessionTimeOut");
            anArray.addObject((Object)sessionTimeOutString);
        }
        if ((statisticsPasswordString = this.toNullOrString(this._application.statisticsPassword())) != null && statisticsPasswordString.length() > 0) {
            anArray.addObject((Object)"-WOStatisticsPassword");
            anArray.addObject((Object)statisticsPasswordString);
        }
        if ((appNameString = this.toNullOrString(this._application.name())) != null && appNameString.length() > 0) {
            anArray.addObject((Object)"-WOApplicationName");
            anArray.addObject((Object)appNameString);
        }
        anArray.addObject((Object)"-WOMonitorEnabled");
        anArray.addObject((Object)"YES");
        anArray.addObject((Object)"-WONoPause");
        anArray.addObject((Object)"YES");
        String additionalArgsString = this.toNullOrString(this.additionalArgs());
        if (additionalArgsString != null && additionalArgsString.length() > 0) {
            anArray.addObjectsFromArray(this.additionalArgumentsAsArray());
        }
        return anArray;
    }

    public String commandLineArguments() {
        return this.commandLineArgumentsAsArray().componentsJoinedByString(" ").replace('\n', ' ').replace('\r', ' ');
    }

    public void setValues(NSMutableDictionary newValues) {
        super.setValues(newValues);
        if (this.isScheduled()) {
            this.calculateNextScheduledShutdown();
        }
    }

    public void updateValues(NSDictionary aDict) {
        super.updateValues(aDict);
        if (this.isScheduled()) {
            this.calculateNextScheduledShutdown();
        }
    }

    public boolean isScheduled() {
        Boolean aBool = this.schedulingEnabled();
        if (aBool != null) {
            return aBool;
        }
        return false;
    }

    public boolean isGracefullyScheduled() {
        Boolean aBool = this.gracefulScheduling();
        if (aBool != null) {
            return aBool;
        }
        return true;
    }

    public NSTimestamp nextScheduledShutdown() {
        return this._nextScheduledShutdown;
    }

    public void setNextScheduledShutdown(NSTimestamp newtime) {
        this._nextScheduledShutdown = newtime;
        this._nextScheduledShutdownString = shutdownFormatter.format((Object)this._nextScheduledShutdown);
    }

    public String nextScheduledShutdownString() {
        return this._nextScheduledShutdownString;
    }

    public void setNextScheduledShutdownString_M(String newtime) {
        this._nextScheduledShutdownString = newtime;
    }

    public boolean nearNextScheduledShutdown(NSTimestamp rightNow) {
        long temp = Math.abs(this._nextScheduledShutdown.timeIntervalSinceTimestamp(rightNow));
        if (temp < halfHourAsSeconds) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
                NSLog.debug.appendln((Object)"nearNextScheduledShutdown TRUE");
            }
            return true;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"nearNextScheduledShutdown FALSE");
        }
        return false;
    }

    public void calculateNextScheduledShutdown() {
        if (!this.isScheduled()) {
            return;
        }
        NSTimestamp currentTime = new NSTimestamp(System.currentTimeMillis(), TimeZone.getDefault());
        NSTimeZone currentTimeZone = currentTime.timeZone();
        int currentYear = currentTime.yearOfCommonEra();
        int currentMonth = currentTime.monthOfYear();
        int currentDayOfMonth = currentTime.dayOfMonth();
        int currentHourOfDay = currentTime.hourOfDay();
        int currentDayOfWeek = currentTime.dayOfWeek();
        String type = this.schedulingType();
        if (type.equals("HOURLY")) {
            int startTime;
            int interval;
            Integer intervalTemp = this.schedulingInterval();
            int n = interval = intervalTemp != null ? intervalTemp : -1;
            if (startTime == -1 || interval == -1) {
                return;
            }
            for (startTime = (startTimeTemp = this.schedulingHourlyStartTime()) != null ? startTimeTemp : -1; startTime <= currentHourOfDay; startTime += interval) {
            }
            this.setNextScheduledShutdown(new NSTimestamp(currentYear, currentMonth, currentDayOfMonth, startTime, 0, 0, (TimeZone)currentTimeZone));
        } else if (type.equals("DAILY")) {
            int startTime;
            Integer startTimeTemp = this.schedulingDailyStartTime();
            int n = startTime = startTimeTemp != null ? startTimeTemp : -1;
            if (startTime == -1) {
                return;
            }
            if (startTime <= currentHourOfDay) {
                ++currentDayOfMonth;
            }
            this.setNextScheduledShutdown(new NSTimestamp(currentYear, currentMonth, currentDayOfMonth, startTime, 0, 0, (TimeZone)currentTimeZone));
        } else if (type.equals("WEEKLY")) {
            int startDay;
            Integer startTimeTemp = this.schedulingWeeklyStartTime();
            int startTime = startTimeTemp != null ? startTimeTemp : -1;
            Integer startDayTemp = this.schedulingStartDay();
            int n = startDay = startDayTemp != null ? startDayTemp : -1;
            if (startTime == -1 || startDay == -1) {
                return;
            }
            int temp = startDay - currentDayOfWeek;
            currentDayOfMonth += temp < 0 ? 7 + temp : temp;
            if (temp == 0 && startTime <= currentHourOfDay) {
                currentDayOfMonth += 7;
            }
            this.setNextScheduledShutdown(new NSTimestamp(currentYear, currentMonth, currentDayOfMonth, startTime, 0, 0, (TimeZone)currentTimeZone));
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)("calculateNextScheduledShutdown: " + this._nextScheduledShutdown));
        }
    }

    public void setRefusingNewSessions(boolean isRefusingNewSessions) {
        if (isRefusingNewSessions) {
            // empty if block
        }
        this.isRefusingNewSessions = isRefusingNewSessions;
    }

    public boolean isRefusingNewSessions() {
        return this.isRefusingNewSessions;
    }

    protected int intStatisticsValueForKey(String key, int defaultValue) {
        NSDictionary aStatsDict = this.statistics();
        if (aStatsDict != null) {
            try {
                String aValue = (String)aStatsDict.valueForKey(key);
                if (aValue != null) {
                    return new Integer(aValue);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected float floatStatisticsValueForKey(String key, float defaultValue) {
        NSDictionary aStatsDict = this.statistics();
        if (aStatsDict != null) {
            try {
                String aValue = (String)aStatsDict.valueForKey(key);
                if (aValue != null) {
                    return new Float(aValue).floatValue();
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int transactionsValue() {
        return this.intStatisticsValueForKey("transactions", 0);
    }

    public int activeSessionsValue() {
        return this.intStatisticsValueForKey("activeSessions", 0);
    }

    public float avgIdleTimeValue() {
        return this.floatStatisticsValueForKey("averageIdlePeriod", 0.0f);
    }

    public float avgTransactionTimeValue() {
        return this.floatStatisticsValueForKey("avgTransactionTime", 0.0f);
    }

    public Timer taskTimer() {
        if (this._taskTimer == null) {
            this._taskTimer = new Timer();
        }
        return this._taskTimer;
    }

    public void cancelForceQuitTask() {
        if (this._taskTimer != null) {
            this._taskTimer.cancel();
            this._forceQuitTask = null;
            this._taskTimer = null;
        }
    }

    public void setForceQuitTask(TimerTask task) {
        this._forceQuitTask = task;
    }

    public TimerTask forceQuitTask() {
        return this._forceQuitTask;
    }

    public void scheduleForceQuit(TimerTask task, int delay) {
        if (this._forceQuitTask == null) {
            this._forceQuitTask = task;
            this.taskTimer().schedule(this._forceQuitTask, delay);
        }
    }

    public void scheduleRefuseTask(TimerTask task, int delay, int period) {
        if (this._forceQuitTask == null) {
            this._forceQuitTask = task;
            this.taskTimer().schedule(this._forceQuitTask, delay, (long)period);
        }
    }
}

