/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.monitor._private.MSiteConfig;

public class MObject
implements NSKeyValueCoding {
    public static NSArray loadSchedulerArray = new NSArray(new Object[]{"Default", "Round Robin", "Random", "Load Average", "Custom"});
    public static NSArray loadSchedulerArrayValues = new NSArray(new Object[]{"DEFAULT", "ROUNDROBIN", "RANDOM", "LOADAVERAGE", "CUSTOM"});
    public static NSArray hostTypeArray = new NSArray(new Object[]{"MacOSX", "Windows", "Unix"});
    public static NSArray urlVersionArray = new NSArray(new Object[]{new Integer(4), new Integer(3)});
    protected static String[] weekNames = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    public static NSArray weekArray = new NSArray((Object[])weekNames);
    public static String[] timesOfDay = new String[]{"0000", "0100", "0200", "0300", "0400", "0500", "0600", "0700", "0800", "0900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000", "2100", "2200", "2300"};
    public static NSArray timeOfDayArray = new NSArray((Object[])timesOfDay);
    protected static Integer[] schedulingIntervals = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(6), new Integer(8), new Integer(12)};
    public static NSArray schedulingIntervalArray = new NSArray((Object[])schedulingIntervals);
    public static NSArray schedulingTypeArray = new NSArray(new Object[]{"HOURLY", "DAILY", "WEEKLY"});
    public static long halfHourAsSeconds = 1800L;
    public static String _POST = "POST";
    public static String _GET = "GET";
    public static String _HTTP1 = "HTTP/1.0";
    public static String[] stateArray = new String[]{"UNKNOWN", "STARTING", "ALIVE", "STOPPING", "DEAD", "CRASHING"};
    public static int UNKNOWN = 0;
    public static int STARTING = 1;
    public static int ALIVE = 2;
    public static int STOPPING = 3;
    public static int DEAD = 4;
    public static int CRASHING = 5;
    public static String _emptyString = new String("");
    public static Integer _zeroInteger = new Integer(0);
    public static String directActionString = "/cgi-bin/WebObjects/wotaskd.woa/wa/monitorRequest";
    public static String adminActionStringPrefix = "/cgi-bin/WebObjects/";
    public static String adminActionStringPostfix = ".woa/womp/instanceRequest";
    MSiteConfig _siteConfig;
    protected NSMutableDictionary values;
    protected _NSThreadsafeMutableDictionary adaptorValues = new _NSThreadsafeMutableDictionary(new NSMutableDictionary());

    public MSiteConfig siteConfig() {
        return this._siteConfig;
    }

    public NSMutableDictionary values() {
        return this.values;
    }

    public void setValues(NSMutableDictionary newValues) {
        this.values = newValues;
        this._siteConfig.dataHasChanged();
    }

    public void updateValues(NSDictionary aDict) {
        this.values = new NSMutableDictionary(aDict);
        this._siteConfig.dataHasChanged();
    }

    public static Integer validatedInteger(Integer value) {
        if (value == null) {
            return value;
        }
        return new Integer(Math.abs(value));
    }

    public static Integer validatedUrlVersion(Integer version) {
        int intVal;
        if (version != null && (intVal = version.intValue()) != 3 && intVal != 4) {
            return new Integer(4);
        }
        return version;
    }

    public static String validatedHostType(String value) {
        if (value != null && (value.equals("UNIX") || value.equals("WINDOWS") || value.equals("MACOSX"))) {
            return value;
        }
        return null;
    }

    public static String validatedOutputPath(String value) {
        if (value == null || value.length() == 0) {
            return "/dev/null";
        }
        return value;
    }

    public static Integer validatedLifebeatInterval(Integer value) {
        int intVal = 0;
        try {
            intVal = value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (intVal < 1) {
            return new Integer(30);
        }
        return value;
    }

    public static String validatedSchedulingType(String value) {
        if (value != null && (value.equals("HOURLY") || value.equals("DAILY") || value.equals("WEEKLY"))) {
            return value;
        }
        return null;
    }

    public static Integer validatedSchedulingStartTime(Integer value) {
        int intVal;
        if (value != null && (intVal = value.intValue()) >= 1 && intVal <= 24) {
            return value;
        }
        return null;
    }

    public static Integer morphedSchedulingStartTime(String value) {
        int i = timeOfDayArray.indexOfObject((Object)value);
        if (i != -1) {
            return new Integer(i);
        }
        return null;
    }

    public static String morphedSchedulingStartTime(Integer value) {
        Object aString;
        if (value != null && (aString = timeOfDayArray.objectAtIndex(value.intValue())) != null) {
            return aString.toString();
        }
        return null;
    }

    public static Integer validatedSchedulingStartDay(Integer value) {
        int intVal;
        if (value != null && (intVal = value.intValue()) >= 0 && intVal <= 6) {
            return value;
        }
        return null;
    }

    public static Integer morphedSchedulingStartDay(String value) {
        int i = weekArray.indexOfObject((Object)value);
        if (i != -1) {
            return new Integer(i);
        }
        return null;
    }

    public static String morphedSchedulingStartDay(Integer value) {
        Object aString;
        if (value != null && (aString = weekArray.objectAtIndex(value.intValue())) != null) {
            return aString.toString();
        }
        return null;
    }

    public static String validatedStats(String value) {
        if (value == null) {
            return "0";
        }
        int i = value.indexOf(46);
        int sLen = value.length() - 1;
        if (i == -1) {
            return value;
        }
        if (i + 3 > sLen) {
            return value;
        }
        return value.substring(0, i + 4);
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String key) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)key);
    }

    public void takeValueForKey(Object value, String key) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)value, (String)key);
    }

    public Object handleQueryWithUnboundKey(String key) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)key);
    }

    public void handleTakeValueForUnboundKey(Object value, String key) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)value, (String)key);
    }

    public void unableToSetNullForKey(String key) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)key);
    }

    public Object valueForKeyPath(String keyPath) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)keyPath);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)value, (String)keyPath);
    }
}

