/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MInstance;
import java.text.ParseException;

public class StatsUtilities {
    public static NSTimestampFormatter dateFormatter = new NSTimestampFormatter("%Y:%m:%d:%H:%M:%S %Z");

    public static Integer totalTransactionsForApplication(MApplication anApp) {
        int aTotalTrans = 0;
        NSArray<MInstance> anInstArray = anApp.instanceArray();
        int anInstArrayCount = anInstArray.count();
        for (int i = 0; i < anInstArrayCount; ++i) {
            MInstance anInstance = (MInstance)anInstArray.objectAtIndex(i);
            NSDictionary aStatsDict = anInstance.statistics();
            if (aStatsDict == null) continue;
            try {
                String aValue = (String)aStatsDict.valueForKey("transactions");
                aTotalTrans += new Integer(aValue).intValue();
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return new Integer(aTotalTrans);
    }

    public static Integer totalActiveSessionsForApplication(MApplication anApp) {
        NSArray<MInstance> anInstArray = anApp.instanceArray();
        int aTotalActiveSessions = 0;
        int anInstArrayCount = anInstArray.count();
        for (int i = 0; i < anInstArrayCount; ++i) {
            MInstance anInstance = (MInstance)anInstArray.objectAtIndex(i);
            NSDictionary aStatsDict = anInstance.statistics();
            if (aStatsDict == null) continue;
            try {
                String aValue = (String)aStatsDict.valueForKey("activeSessions");
                aTotalActiveSessions += new Integer(aValue).intValue();
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return new Integer(aTotalActiveSessions);
    }

    public static Float totalAverageTransactionForApplication(MApplication anApp) {
        NSArray<MInstance> anInstArray = anApp.instanceArray();
        float aTotalTime = 0.0f;
        int aTotalTrans = 0;
        float aTotalAvg = 0.0f;
        int anInstArrayCount = anInstArray.count();
        for (int i = 0; i < anInstArrayCount; ++i) {
            MInstance anInstance = (MInstance)anInstArray.objectAtIndex(i);
            NSDictionary aStatsDict = anInstance.statistics();
            if (aStatsDict == null) continue;
            try {
                String aValue = (String)aStatsDict.valueForKey("transactions");
                Integer aTrans = new Integer(aValue);
                if (aTrans <= 0) continue;
                aValue = (String)aStatsDict.valueForKey("avgTransactionTime");
                Float aTime = new Float(aValue);
                aTotalTime += (float)aTrans.intValue() * aTime.floatValue();
                aTotalTrans += aTrans.intValue();
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (aTotalTrans > 0) {
            aTotalAvg = aTotalTime / (float)aTotalTrans;
        }
        return new Float(aTotalAvg);
    }

    public static Float totalAverageIdleTimeForApplication(MApplication anApp) {
        NSArray<MInstance> anInstArray = anApp.instanceArray();
        float aTotalTime = 0.0f;
        int aTotalTrans = 0;
        float aTotalAvg = 0.0f;
        int instArrayCount = anInstArray.count();
        for (int i = 0; i < instArrayCount; ++i) {
            MInstance anInstance = (MInstance)anInstArray.objectAtIndex(i);
            NSDictionary aStatsDict = anInstance.statistics();
            if (aStatsDict == null) continue;
            try {
                String aValue = (String)aStatsDict.valueForKey("transactions");
                Integer aTrans = new Integer(aValue);
                if (aTrans <= 0) continue;
                String idleString = (String)aStatsDict.valueForKey("averageIdlePeriod");
                Float aTime = new Float(idleString);
                aTotalTime += (float)aTrans.intValue() * aTime.floatValue();
                aTotalTrans += aTrans.intValue();
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (aTotalTrans > 0) {
            aTotalAvg = aTotalTime / (float)aTotalTrans;
        }
        return new Float(aTotalAvg);
    }

    public static Float actualTransactionsPerSecondForApplication(MApplication anApp) {
        float anOverallRate = 0.0f;
        NSArray<MInstance> anInstArray = anApp.instanceArray();
        int anInstArrayCount = anInstArray.count();
        for (int i = 0; i < anInstArrayCount; ++i) {
            MInstance anInstance = (MInstance)anInstArray.objectAtIndex(i);
            NSDictionary aStatsDict = anInstance.statistics();
            String aStartDate = "";
            float anInstRate = 0.0f;
            if (aStatsDict != null) {
                Integer aTrans;
                aStartDate = (String)aStatsDict.valueForKey("startedAt");
                try {
                    aTrans = new Integer((String)aStatsDict.valueForKey("transactions"));
                }
                catch (Throwable ex) {
                    aTrans = null;
                }
                if (aTrans != null && aTrans > 0) {
                    float aRunningTime;
                    try {
                        NSTimestamp aDate = (NSTimestamp)dateFormatter.parseObject(aStartDate);
                        aRunningTime = aDate.timeIntervalSinceTimestamp(new NSTimestamp());
                    }
                    catch (ParseException ex) {
                        aRunningTime = 0.0f;
                        NSLog.err.appendln((Object)("Format error in StatsUtilities: " + aStartDate));
                        NSLog.err.appendln(ex.getErrorOffset());
                        NSLog.err.appendln((Object)"Actual Transactions Per Second rate is inaccurate.");
                    }
                    if ((double)aRunningTime > 0.0) {
                        anInstRate = aTrans.floatValue() / aRunningTime;
                    }
                }
            }
            anOverallRate += anInstRate;
        }
        return new Float(anOverallRate);
    }
}

