/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor._private;

import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class _NSObjectUtilities {
    private _NSObjectUtilities() {
    }

    public static String dumpObjectAsString(Object o, boolean showInterfaces, boolean showConstructors, boolean showFields, boolean getFields, boolean showMethods, boolean getMethodsJava, boolean getMethodsNext) throws IOException {
        int i;
        StringWriter outputWriter = new StringWriter();
        String CR = new Character('\n').toString();
        outputWriter.write(CR);
        outputWriter.write("This object's hashCode is = " + o.hashCode() + CR);
        Class<?> us = o.getClass();
        String ourName = us.getName();
        outputWriter.write("This object is of Class = ");
        boolean areWeAnArray = us.isArray();
        if (areWeAnArray) {
            Class<?> ourComponentType = us.getComponentType();
            outputWriter.write("Array with Component Type = " + ourComponentType.getName());
            int ourLength = -1;
            try {
                ourLength = Array.getLength(o);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            outputWriter.write(" and size " + ourLength + CR);
        } else {
            outputWriter.write(ourName + CR);
        }
        Class<?> ourSuper = us.getSuperclass();
        String ourSuperName = null;
        if (ourSuper != null) {
            ourSuperName = ourSuper.getName();
            outputWriter.write("The Superclass is of Class = " + ourSuperName + CR);
        } else {
            outputWriter.write("This object has no Superclass" + CR);
        }
        if (showInterfaces) {
            Class<?>[] ourInterfaces = us.getInterfaces();
            if (ourInterfaces.length == 0) {
                outputWriter.write("This object implements no interfaces" + CR);
            } else {
                outputWriter.write("Interfaces: " + CR);
                for (int i2 = 0; i2 < ourInterfaces.length; ++i2) {
                    outputWriter.write("\t" + ourInterfaces[i2].getName() + CR);
                }
            }
        }
        if (showConstructors) {
            Object[] ourConstructors = new Constructor[]{};
            Object[] ourDeclaredConstructors = new Constructor[]{};
            try {
                ourConstructors = us.getConstructors();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                ourDeclaredConstructors = us.getDeclaredConstructors();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            NSMutableSet mergeConstructors = new NSMutableSet(ourConstructors);
            mergeConstructors.unionSet(new NSSet(ourDeclaredConstructors));
            Object[] allOurConstructors = mergeConstructors._allObjects();
            if (allOurConstructors.length != 0) {
                outputWriter.write("Constructors: " + CR);
                for (i = 0; i < allOurConstructors.length; ++i) {
                    outputWriter.write("\t" + allOurConstructors[i] + CR);
                }
            } else {
                outputWriter.write("No Visible Constructors" + CR);
            }
        }
        if (showFields) {
            Object[] ourFields = new Field[]{};
            Object[] ourDeclaredFields = new Field[]{};
            try {
                ourFields = us.getFields();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                ourDeclaredFields = us.getDeclaredFields();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            NSMutableSet mergeFields = new NSMutableSet(ourFields);
            mergeFields.unionSet(new NSSet(ourDeclaredFields));
            Object[] allOurFields = mergeFields._allObjects();
            if (allOurFields.length != 0) {
                outputWriter.write("Fields: " + CR);
                for (i = 0; i < allOurFields.length; ++i) {
                    outputWriter.write("\t" + allOurFields[i]);
                    if (getFields) {
                        try {
                            Object got = ((Field)allOurFields[i]).get(o);
                            outputWriter.write(" = " + got + CR);
                        }
                        catch (Exception f1) {
                            outputWriter.write(CR);
                        }
                        continue;
                    }
                    outputWriter.write(CR);
                }
            } else {
                outputWriter.write("No Visible Fields" + CR);
            }
        }
        if (showMethods) {
            Object[] ourMethods = new Method[]{};
            Object[] ourDeclaredMethods = new Method[]{};
            try {
                ourMethods = us.getMethods();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                ourDeclaredMethods = us.getDeclaredMethods();
            }
            catch (SecurityException e) {
                // empty catch block
            }
            NSMutableSet mergeMethods = new NSMutableSet(ourMethods);
            mergeMethods.unionSet(new NSSet(ourDeclaredMethods));
            Object[] allOurMethods = mergeMethods._allObjects();
            if (allOurMethods.length != 0) {
                boolean alreadyInvoked = false;
                outputWriter.write("Methods: " + CR);
                for (int i3 = 0; i3 < allOurMethods.length; ++i3) {
                    alreadyInvoked = false;
                    Method aMethod = (Method)allOurMethods[i3];
                    outputWriter.write("\t" + aMethod);
                    if (getMethodsJava && aMethod.getName().startsWith("get")) {
                        try {
                            Object returnVal = aMethod.invoke(o, new Object[0]);
                            outputWriter.write(" = " + returnVal + CR);
                            alreadyInvoked = true;
                        }
                        catch (Exception m1) {
                            outputWriter.write(CR);
                            alreadyInvoked = true;
                        }
                    }
                    if (getMethodsNext && !alreadyInvoked) {
                        String methodName = aMethod.getName();
                        try {
                            us.getField(methodName);
                        }
                        catch (Exception e1) {
                            try {
                                us.getDeclaredField(methodName);
                            }
                            catch (Exception e2) {
                                try {
                                    us.getField("_" + methodName);
                                }
                                catch (Exception e3) {
                                    try {
                                        us.getDeclaredField("_" + methodName);
                                    }
                                    catch (Exception e4) {
                                        outputWriter.write(CR);
                                        alreadyInvoked = true;
                                    }
                                }
                            }
                        }
                        if (!alreadyInvoked) {
                            try {
                                Object returnVal2 = aMethod.invoke(o, new Object[0]);
                                outputWriter.write(" = " + returnVal2 + CR);
                                alreadyInvoked = true;
                            }
                            catch (Exception m2) {
                                outputWriter.write(CR);
                                alreadyInvoked = true;
                            }
                        }
                    }
                    if (alreadyInvoked) continue;
                    outputWriter.write(CR);
                }
            } else {
                outputWriter.write("No Visible Methods" + CR);
            }
            outputWriter.write(CR);
        }
        String retVal = outputWriter.toString();
        outputWriter.close();
        outputWriter = null;
        return retVal;
    }
}

